/**************************************************************************/
/* read_hmatrix.c                                               /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/

#include <stdio.h>
#include "read_hmatrix.h"

#include "matrix.h"
#include "datastruct.h"



void read_hmatrix(FILE *matfilep)
{
        int nr;

        for (nr = 1; ; nr++)
        {
                int r, c;

                for (r=0; r<HOMO_DEG; r++)
                        for (c=0; c<HOMO_DEG; c++)
                        {
                                float x;

                                if (fscanf(matfilep, "%f", &x) != 1)
                                {
                                        if (c==0 && r==0)
                                        {
                                                c = r = 10;
                                                break;
                                        }
                                        else
                                                fprintf(stderr,
                                        "error in matrix %d[%d,%d]\n",nr,r,c);
                                }
                                homogen[nr][r*HOMO_DEG+c] = x;
                        }
                if (c >= 10 && r >= 10) break;
        }

	fclose(matfilep);
}
