void main(int argc, char *argv[])
{
  /*
   * Initialise forward kinematics.
   */
  init_forwardkinematics(DHfile);

  /*
   * The order of first starting the robot and next
   * the camera must correspond with the order in
   * the neural network simulator.
   */
  open_robot_communication(socket_name);
  open_camera_communication(socket_name);
  open_bemmel_communication(BEMMEL_SOCKET_NAME, bemmels_connected);

  /*
   * Initially, there is no move to make.  So, set target time to 0
   * to prevent motion.
   */
  moving = wait = 0;

  while (1)
  {
	/*
	 * This is rather essential: move the robot.  If this
	 * is not done here, it is possible that the simulator
	 * is continuously interrupted, such that the trajectory
	 * is never followed.
	 *
	 * Meanwhile, communication channels are checked for
	 * new incoming data.  There are two calls, since the
	 * second one is allowed to be blocking, but the first
	 * one isn't.  Thus we assure that, when this program
	 * may be dormant, it'll sleep in the select_receive_
	 * _next_command() function; but when the robot is still
	 * in motion, it will only check the incoming channels for
	 * data and read if there is data available.
	 */
	if (moving && !wait)
	{
		moving = move(new_q, new_dq, ddq);
		command = select_receive_next_command(&type,&buffer,&length,0);
	}
	else
		command = select_receive_next_command(&type,&buffer,&length,1);

	switch(command)
	{
	case ROBOT:
		switch(type)
		{
		case NEWPOS:
			if (decode_joints(buffer, length, new_q, new_dq, ddq))
				break;
			if (ddq[2] < 0.0 && ddq[3] < 0.0) steps++;
			else steps = 0;
			moving = 1;
			break;

		case SEND_JOINTS:
			send_joints(q, dq, ddq);
			break;

		case HALT:
			for (i=1; i<=NR_LINKS; i++)
				new_dq[i] = dq[i] = ddq[i] = 0.0;
			accept_halt();
			break;

		case WAIT:
			/*
			 * Make sure the robot doesn't move for
			 * a while.  Should always be followed
			 * by a CONTINUE.
			 */
			wait = 1;
			break;

		case CONTINUE:
			/*
			 * Undo a WAIT.
			 */
			wait = 0;
			break;

		}
		break;


	case CAMERA:
		/*
		 * Got a message for the camera.
		 */

		switch(type)
		{
			/*
			 * There are four sets of values sent from
			 * the camera:
			 *	1. the position of the end-effector
			 *	   and object as seen by fixed camera 1;
			 *	2. the position of the end-effector
			 *	   and object as seen by camera 2;
			 *	3. the position of the object
			 *	   RELATIVE to the robot's fingers;
			 *	4. the area of the object
			 *	   RELATIVE to the camera's CCD.
			 *	   This CCD is mounted above the
			 *	   fingers, at a height CCD_FINGERS_DISTANCE.
			 */
		case CAMERA_1:
			/*
			 * If the robot is not moving, the
			 * object may have moved all the same.
			 * An update of the homogeneous matrices
			 * is required.
			 */
			if (!wait) moving = move(new_q, new_dq, ddq);
			send_camera(CAMERA_1, cam_1_eef, cam_1_obj);
			break;
		case CAMERA_2:
			if (!wait) moving = move(new_q, new_dq, ddq);
			send_camera(CAMERA_2, cam_2_eef, cam_2_obj);
			break;
		case HAND_CAMERA:
			if (!wait) moving = move(new_q, new_dq, ddq);
			send_camera(HAND_CAMERA, hand_camera, area);
			break;
			
		case SEND_END_EFFECTOR:
			send_end_effector(effector);
			break;
			
		case OBJECT_POSITION:
			decode_camera(buffer, length, object_position);
			display_robot();
			break;
		}
		break;
	}
  }
}
