/**************************************************************************/
/* vector.c                                                     /\/\      */
/* Version 2.2.1 --  August  1991                               \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/
#include <math.h>
#include "vector.h"
#include "matrix.h"
#include "setup.h"



void copy_joints(joint_values destination, joint_values source)
{
  unsigned short i;
  for (i=1; i<=NR_LINKS; i++)
	destination[i] = source[i];
}


void init_joints(joint_values destination)
{
  unsigned short i;
  for (i=1; i<=NR_LINKS; i++)
	destination[i] = 0.0;
}



void add_joints(joint_values destination, joint_values source1,
						joint_values source2)
{
  unsigned short i;
  for (i=1; i<=NR_LINKS; i++)
	destination[i] = source1[i] + source2[i];
}


void sub_joints(joint_values destination, joint_values source1,
						joint_values source2)
{
  unsigned short i;
  for (i=1; i<=NR_LINKS; i++)
	destination[i] = source1[i] - source2[i];
}



REAL vector_length(vector image)
{
  return (REAL) sqrt(Msqr(image[0]) + Msqr(image[1]) + Msqr(image[2]));
}


void copy_vector(vector destination, vector source)
{
  unsigned short i;
  for (i=0; i<HOMO_DEG; i++)
	destination[i] = source[i];
}



void sub_vector(vector destination, vector source1, vector source2)
{
  unsigned short i;
  for (i=0; i<HOMO_DEG-1; i++)
	destination[i] = source1[i] - source2[i];
  destination[HOMO_DEG-1] = 1.0;
}


void add_vector(vector destination, vector source1, vector source2)
{
  unsigned short i;
  for (i=0; i<HOMO_DEG-1; i++)
	destination[i] = source1[i] + source2[i];
  destination[HOMO_DEG-1] = 1.0;
}



void init_vector(vector v)
{
  v[0] = 0.0; v[1] = 0.0; v[2] = 0.0; v[3] = 1.0;
}




void homo_vec_mul(vector result, homo H, vector vec)
{
  result[0] = H[0]*vec[0] + H[1]*vec[1] + H[2]*vec[2] + H[3]*vec[3];
  result[1] = H[4]*vec[0] + H[5]*vec[1] + H[6]*vec[2] + H[7]*vec[3];
  result[2] = H[8]*vec[0] + H[9]*vec[1] + H[10]*vec[2] + H[11]*vec[3];
  result[3] = 1.0;
}




void cross_product(vector result, vector source1, vector source2)
{
  result[0] = source1[1]*source2[2] - source1[2]*source2[1];
  result[1] = source1[2]*source2[0] - source1[0]*source2[2];
  result[2] = source1[0]*source2[1] - source1[1]*source2[0];
  result[3] = 1.0;
}
