/* 
 * surfaces.c -- functions for generating surface objects
 * 
 */

#include <stdio.h>
#include <math.h>

#include "constants.h"
#include "structures.h"
#include "parameters.h"
#include "constructs.h"
#include "display.h"

/* find max dist from straight-line segment */

float				/* return distance between points */
pt_dist(float x1, float y1, float x2, float y2)
{
/*  printf("%f %f %f %f\n",x1,y1,x2,y2); */
  x1 = (float)sqrt(((x1-x2)*(x1-x2) + (y1-y2)*(y1-y2)));
/*  printf("%f\n",x1); */
  return(x1);
}


int
max_sl_dist(float *xarr,float *yarr,int i,int j)
{
  int ii, r;
  float m, f, n, x, y, dx, dy;

  x = xarr[i];  y = yarr[i];
  m = j - i;
  dx =(xarr[j] - x) / m;
  dy =(yarr[j] - y) / m;
  m = 0.0;  ii = 0;

  for (; i++ < j;)		/* find the points */
    {
      x += dx;  y += dy;
      f = xarr[i] - x;
      if (f > 0.0) {n = f;} else {n = - f;}
      f = yarr[i] - y;
      if (f > 0.0) {n += f;} else {n -= f;}
      if (n > m) {m = n; ii = i - 1;}
    }
  r = m;
  return(ii + (r*1000));
}





sobj sobj_buf[SOBJ_MAX];	/* surface object buffer */
int sobj_freep;			/* free pointer */

void				/* initialize sobj buffer */
init_sobjs()
{
  int i;
  sobj *s;
  for (i=0; i<SOBJ_MAX; i++)
    {
      s = &sobj_buf[i];
      s->tag = i;		/* this index */
      if (i+1 < SOBJ_MAX)
	s->right = i+1;		/* next free one */
      else 
	s->right = -1;
      s->used = 0;
    }
  sobj_freep = 0;		/* index of first one */
}

sobj *
get_sobj()			/* get next sobj from freelist */
{
  sobj *s;
  if (sobj_freep < 0)
    return(NULL);
  else
    {
      s = &sobj_buf[sobj_freep];
      sobj_freep = s->right;
      s->used = 1;
      return(s);
    }
}

void
free_sobj(sobj *s)		/* free it up */
{
  s->right = sobj_freep;
  sobj_freep = s->tag;
  s->used = 0;
}

void
free_sobj_list(sobj_list *ss)	/* free it up */
{
  int i; sobj **s;
  s = ss->s;
  for (i=0;i<ss->n;i++) free_sobj(*s++);
}



/*
 * Side buffer interpretation routines 
 *
 */


sobj * sobj_rres[10];		/* holds list of newly-minted sobj's */
sobj * sobj_lres[10];		/* holds list of newly-minted sobj's */
sobj_list sobj_r = { 0, sobj_rres };
sobj_list sobj_l = { 0, sobj_lres };

float *xbuf, *ybuf;	/* use these instead of passing args */
sobj ** sobj_res;
int * sobj_n;




sobj *				/* forms and returns a surface object */
form_one_sobj(int i1, int t1, int i2, int t2)
{
  sobj *s; surf *ss;
  s = get_sobj();
  if (s == NULL) return(NULL);
  ss = &(s->surface);
  ss->x1 = xbuf[i1];
  ss->y1 = ybuf[i1];
  ss->x2 = xbuf[i2];
  ss->y2 = ybuf[i2];
  ss->cx = (ss->x2 + ss->x1) * 0.5;
  ss->cy = (ss->y2 + ss->y1) * 0.5;
  ss->d  = pt_dist(ss->x1,ss->y1,ss->x2,ss->y2);
  s->t1  = t1;
  s->t2  = t2;
  s->right = -1;
  s->left  = -1;
  return(s);
}

void				/* forms and returns a surface object */
form_sobj(int i1, int t1, int i2, int t2)
{
  int d;
  sobj * s;
  if (*sobj_n < 10) 
    {
      d = max_sl_dist(xbuf,ybuf,i1,i2);
				/* ignore straight-line deviations for now... */
      s = form_one_sobj(i1,t1,i2,t2);
      if (s != NULL) sobj_res[(*sobj_n)++] = s;
    }
}

int left_side_edge =    0;
int right_side_edge = 128;

void				/* sets up a list of surface objects */
interp_buf(dbuf *dbuf,side lr)
{
  unsigned char *arr;
  int *edge; 
  int n; 
  int i = 0, g = 0, curv = 0, curi = 0, curt = 0;

  arr = dbuf->buf;
  edge = dbuf->edge;
  n = dbuf->num;
  xbuf = dbuf->xbuf; ybuf = dbuf->ybuf;

  if (lr == RIGHT) { sobj_res = sobj_rres; sobj_n = &(sobj_r.n); }
  else { sobj_res = sobj_lres; sobj_n = &(sobj_l.n); }

  *sobj_n = 0;

  while (i < n)
    {
      g = edge[i];
      if (g == 1)		/* have a segment start */
	{
	  if (curt > 0) curt = SL_DEPTH_BRK;
	  else if (i < left_side_edge) curt = SL_VIEW_BRK;
	  else curt = SL_DEPTH_BRK;
	  curi = i;
	  curv = arr[i];
	}
      else if (g == 2)		/* round object detection */
	{
	  curt = SL_ROUND_BRK;
	  curi = i;
	  curv = arr[i];
	}
      else if (g == -1)		/* at the end */
	{
	  form_sobj(curi,curt,i,SL_DEPTH_BRK);
	  if (i > right_side_edge) curt = SL_VIEW_BRK;
	  else curt = SL_DEPTH_BRK;
	}
      else if (! g == 0)
	{
	  form_sobj(curi,curt,i,SL_GRAD_BRK);
	  curt = SL_GRAD_BRK;
	  curi = i;
	  curv = arr[i];
	}
      i++;
    }
  if (*sobj_n > 0)
    (sobj_res[(*sobj_n)-1])->t2 = curt;
}


void
draw_seg(sobj *s,int w)		/* draw the segment on display */
{				/* w is 0 for normal width, 1 for thick */
  draw_surf(&s->surface,w);
}

void
draw_surf(surf *ss,int w)	/* draw the segment on display */
{				/* w is 0 for normal width, 1 for thick */
  if (w) set_vector_buffer(w);
  draw_rw_vec(ss->x1,ss->y1,ss->x2,ss->y2);
  if (w) set_vector_buffer(0);
}

void
draw_segs(sobj_list *segl,int w) /* draw a set of segments */
{
  int i;
  sobj **s = segl->s;
  for (i=0; i<segl->n; i++) draw_seg(*s++,w);
}

void
side_segment_proc(boolean reset)
{
  if (reset) {
    init_sobjs();
    init_side_interps();
  }
  else {
    free_sobj_list(&sobj_r);
    free_sobj_list(&sobj_l);
    conv_ss_buf(&right_side,RIGHT);
    interp_buf(&right_side,RIGHT);
    conv_ss_buf(&left_side,LEFT);
    interp_buf(&left_side,LEFT);
  }
}


draw_segments()
{
  draw_segs(&sobj_l,0);
  draw_segs(&sobj_r,0);
}

  
