/* 
 * Foreign C functions to do convolutions
 *
 */

#include <stdio.h>

#include "constants.h"
#include "structures.h"
#include "parameters.h"
#include "dispall.h"


int lap_conv_arr[7] = { 4, 15, -2, -34, -2, 15, 4 };
int lap_conv_arr_n = 7;

/* convolution here */

void
conv(int *arr,int m,unsigned char *inarr,int *outarr,int n)
     /* convolve inarr (n) and arr (m) to outarr */
{ register int i,j,k,res;
  int norm;
  norm = 0;
  for (i=0; i<m; i++)		/* sum to get the norm */
    { norm += arr[i]; }
  k = m>>1;
  n -= k;
  for (i=k; i < n; i++)
    { 
      res = 0;
      for (j=0; j<m; j++)
	res += arr[j] * inarr[i+j];
      if (norm == 0) {outarr[i+k] = res;}
      else outarr[i+k] = res / norm;
    }
}


/*
 * Median-value filtering.  Checks for gaps, fills them in.  Reuses argument.
 */

void
medval(unsigned char *arr,int n,int gap,float slope,int null)
     /* gap is length to bridge, null is null value */
     /* slope is abs max value of slope to accept */
{
  register int i,l,pi;
  float inc,v,pv;
  pi = -100;
  for (i = 0; i < n; i++)
    {
      v = arr[i];
      if (v != null)		/* have a reading */
	{ 
	  l = i - pi;
	  if (l > 1 && l <= gap) /* fill it in */
	    {
	      inc = ((v - pv) / (float)l);
/*	      fprintf(stderr," %f %f %f\n",pv,v,ABS(inc));  */
	      if (ABS(inc) <= slope) /* check slope */
		{ while (++pi < i)
		    { pv += inc; arr[pi] = pv; }
		}
	    }
	  pi = i;  pv = v;
	}
    }
}


/*
 * Zero-crossing and max detection.  Sets everything to else zero.
 *   Thresholds for small crossings.
 *   Thins competing crossings nearby.
 *   Gap is the distance over which we look for strong crossings.
 *   Returns strength and sign; adds 100,000 to max detections.
 */

zerocross(arr,n,th,gap)
     int arr[];
{
  register int i, v, m, mi, g;
  arr[0] = 0;
  m  = 0;
  mi = 0;
  g  = 0;
  for (i = 1; i < n; i++)
    {
      v = arr[i];
      arr[i] = 0;
      
      if (v > th)
	{ if (m < 0) { arr[i] = v - m; };
	  if (v > m) { m = v; mi = i; g =  0; }
	  else g++;
	}
      else if (v < (- th))
	{ if (m > 0) { arr[i] = v - m; }
	  if (v < m) { m = v; mi = i; g = 0; }
	  else g++;
	}
      else if (m != 0)		/* have a maximum, check it */
	{ g++;
	  if (g > gap)
	    { if (arr[mi - 1] == 0) arr[mi] = m + 100000; 
	      m = 0; 
	    }
	}
    }
}



/*
 * Isolates and interpolation filtering.
 * Stolen from code in INTERP.LISP.
 */

fltr_isolate1(arr,i,n,gap,brk)	
     int *arr;
     int i,n,gap,brk;
{
  int left, right, support, cur;
  int j, v, k;
  left = -1000; right = 1000; support = 0;
  i += gap;
  cur = arr[i];
  for (j =  max(0,i - gap); j < i; j++)	/* check left support and occlusion */
    { v = arr[j];
      if (v < (cur - brk)) left = j;
      else if ((v <= (cur + brk)) && (v != BUF_NULL)) support = 1;
    }

  k = min(n - 1, i + gap);
  for (j = k; j > i; j--)	/* right support and occlusion */
    { v = arr[j];
      if (v < (cur - brk)) right = j;
      else if ((v <= (cur + brk)) && (v != BUF_NULL)) support = 1;
    }
  if ((gap > (right - left)) || (support != 1)) arr[i] = BUF_NULL;
				/* check local jitter */
  if ((i - 1 > 0) && (i + 1 < n) && (arr[i-1] < cur) && (arr[i+1] < cur))
    arr[i] = BUF_NULL;
}




fltr_bridge1(arr,i,n,gap,brk)	/* median-value filter */
     int *arr;
     int i,n,gap,brk;
{
  int cur;
  int j, v, k, m;
  double l, inc;
  cur = arr[i];
  k = min(gap + i, n - 1);
  for (j = i + 1; j <= k; j++)
    { v = arr[j];
      if (v != BUF_NULL)
	{ if ((v < (cur + brk)) && (v > (cur - brk)))
	    { l = j - i;
	      inc = .5 + ((v - cur) / l);
	      for (m = i + 1; m < j; m++) 
		{ cur += inc;
		  arr[m] = cur;
		}
	    }
	  break;
	}
    }
}


/*
 * gap interpolation, using gradient
 * I don't trust this code...
 */

      

void
interpolate_gaps(unsigned char *arr, int n, int gap, int brk)
{
  int i, v, vm, vmm, vp, vpp, d;
  vm = arr[0];
  vmm = SLBUF_NULL;
  v = arr[1];
  vp = arr[2];
  vpp = arr[3];

  for(i=1; i<n; i++)
    {
      if (v == SLBUF_NULL)
	{			/* check left/right bridge */
	  if ((!vm==SLBUF_NULL) && (!vmm==SLBUF_NULL))
	    {
	      d = vm - vmm;
	      if (ABS((vm+d+d)-vp) <= brk ||
		  ABS((vm+d+d+d)-vpp) <= brk )
		{
		  v = vm + d;
		  arr[i] = v;
		  if (vp == SLBUF_NULL)
		    {
		      vp = v + d;
		      arr[i+1] = vp;
		    }
		  goto grad_done;
		}
	    }
	  if ((!vp==SLBUF_NULL) && (!vpp==SLBUF_NULL))
	    {
	      d = vp - vpp;
	      if (ABS((vp+d+d)-vp) <= gap ||
		  ABS((vp+d+d+d)-vpp) <= gap )
		{
		  v = vp + d;
		  arr[i] = v;
		  if (vm == SLBUF_NULL)
		    {
		      vm = v + d;
		      arr[i-1] = vm;
		    }
		}
	    }
	}

    grad_done:
      vmm = vm;
      vm = v;
      v = vp;
      vp = vpp;
      if (i < (n - 3)) vpp = arr[i+3];
      else vpp = SLBUF_NULL;
    }
}


	
/*
 * Break finding
 *
 */

void
find_breaks(unsigned char *arr,int *outarr,int n,int gap,int num)
{
  int i, start, prev, v, c;
  start = -1;
  prev = SLBUF_NULL;
  c = 1;
  for(i=0; i<n; i++)
    {
      outarr[i] = 0;
      v = arr[i];
      if (start >= 0)		/* have a break, look for end */
	{
	  if (v == SLBUF_NULL || ABS(v-prev) > gap)
	    {
	      outarr[i-1] = -1;
	      start = -1;
	    }
	}
      if (start < 0)	/* check for beginning of break */
	{
	  if (v == SLBUF_NULL || prev == SLBUF_NULL || ABS(v-prev) > gap)
	    {
	      c = 1;
	    }
	  else if (c >= num)
	    {
	      start = i - c;
	      outarr[start] = 1;
	      c = 1;
	    }
	  else c++;
	}
      prev = v;
    }
}


/*
 * Find inflections
 *
 */

void
find_inflections(int *edge, int *lap, int n, int th)
{
  int half, i, g, c;

  while (i < n)
    {
      if (edge[i] > 0)		/* have a start */
	{
	  while (edge[i+half-1] >= 0  && i < n)
	    {
	      c = half;
	      if (c > 0) c--;
	      else if ((g=ABS(lap[i]) > th) && g > ABS(lap[i+1]))
		{
		  edge[i] = lap[i];
		  c = 2;
		}
	      i++;
	    }
	}
      i++;
    }
}


