#include <stdio.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/param.h>
#include <sgtty.h>
#include <sys/stat.h>
#include <sys/resource.h>
/* #include <sys/ttycom.h> */

#include "structures.h"
#include "constants.h"


int server_loop_flag = 1;

/*
 * Connect to a socket by service name or port number.
 * If port is 0, service will be used.
 * Returns a file descriptor for the socket.
 */

#define HOST_LEN 100		/* max length of host name string */
#define True 1
#define False 0
#define TTY_SPEED B9600

char myhost[HOST_LEN];

int
connect_to_socket(hostname, service, proto, port)
char	*hostname;
char	*service;
u_int	port;
int     proto;

{
    struct sockaddr_in	remote_addr;	/* remote inet socket address	*/
    struct servent	*serv;		/* returned by getservbyname()	*/
    struct hostent	*host;		/* returned by gethostbyname()	*/
    int			sock;


    if (strlen(service) <= 0)
	service = NULL;

    if (proto == TCP || proto == TCPB)  /* make a stream socket */
      { 
	printf("\ngetting TCP socket");
	if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0) 
	  { perror("stream socket");
	    return (-1);
	  }
      }
    else			/* make a datagram socket */
      { if ((sock = socket(AF_INET, SOCK_DGRAM, 0)) < 0) 
	  { perror("dgram socket");
	    return (-1);
	  }
      }

    printf("\nsocket fd: %d",sock);

    if (service != NULL) {
	if ((serv = getservbyname(service, NULL)) == NULL) {
	    if (port <= 0) {
		printf("\nUnknown serv %s/tcp. No default port given",
		    service
		);
		return(-1);
	    }
	    remote_addr.sin_port = htons((u_short) port);
	}
	else
	    remote_addr.sin_port = serv->s_port;
    }
    else
	remote_addr.sin_port = htons((u_short) port);

    printf("\nport number: %d\n",ntohs(remote_addr.sin_port));

				/*  Now we bind the socket to the right port */
    if (proto == UDP || proto == TCPB)
      { remote_addr.sin_addr.s_addr = INADDR_ANY;
	if (bind(sock, &remote_addr, sizeof(remote_addr)) < 0)  
	  { perror("bind");
	    return (-1);}
      }

    if (proto == TCPB)		/* don't connect, we are listening for clients */
      { listen(sock,1);		/* just one connection */
	return(sock); }

    if ((host = gethostbyname(hostname)) == NULL) {
	perror("gethostbyname");
	return (-1);
    }

    remote_addr.sin_family = host->h_addrtype;
    bcopy(host->h_addr, &remote_addr.sin_addr, host->h_length);

    printf("\nhost addr: %d.%d.%d.%d", (host->h_addr)[0],
       (host->h_addr)[1],
       (host->h_addr)[2],
       (host->h_addr)[3]);

    printf("\nport: %d",remote_addr.sin_port);
       
    if (connect(sock, &remote_addr, sizeof(remote_addr)) < 0)  
	  { perror("connect");
	    return (-1);}

    return(sock);
}


/* Just open a server from the simulator */

open_tcp_port()

{  
return(connect_to_socket("","trobot",TCPB,8101));
 }


/*
 * call to open tty channel
 *	Exit:	0 returned if no errors
 */

static struct sgttyb tty_data;
static struct sgttyb old_tty_data;

int
open_tty_port(char *tty)
{	
  int n = 200, i = 0;
  int tty_fd;
  FILE *tty_f;
  /* open an input channel from the tty */
  if ((tty_fd = open(tty,O_RDONLY | O_NDELAY)) < 0)
    {
      fprintf(stdout, "Couldn't open tty for input.\n"); fflush(stdout);
      return(-1);
    }
  ioctl(tty_fd,TIOCGSOFTCAR,&n); /* get soft carrier flag */
  i = 1;
  ioctl(tty_fd,TIOCSSOFTCAR,&i); /* get soft carrier flag */
  ioctl(tty_fd,TIOCGSOFTCAR,&n); /* get soft carrier flag */
	/* open an output channel to the tty */
  if ((tty_fd = open(tty,O_RDWR)) < 0)
    {	
      fprintf(stdout, "Couldn't open tty for output.\n"); fflush(stdout);
      return(-1);
    }
  /* set the tty baud, buffering and modes */
  tty_f = fdopen(tty_fd,"w+");
  setbuf(tty_f, NULL);			/* no stdio buffering */
  
  ioctl (tty_fd, TIOCGETP, &old_tty_data);/* save tty conf */
  ioctl (tty_fd, TIOCGETP, &tty_data);/* get tty conf to change */
  tty_data.sg_flags = RAW;		/* set tty to raw mode */
  tty_data.sg_ispeed = TTY_SPEED;		/* set input baud */
  tty_data.sg_ospeed = TTY_SPEED;		/* set output baud */
  ioctl (tty_fd, TIOCSETP, &tty_data);/* write new tty conf */
  return(tty_fd);
}


open_udp_port(host)
     char *host;
{  
  return(connect_to_socket(host,"urobot",UDP,0));
 }


/* Accept client connections */

accept_tcp_conn(fd)
int fd;
{
  int sock;
  fd_set ready;
  struct timeval to;

  sock = 0;
  FD_ZERO(&ready);
  FD_SET(fd, &ready);
  to.tv_sec = 0;
  to.tv_usec = 0;
  if (select(fd+1, &ready, NULL, NULL, &to) < 0)
    {perror("select");
     return(-1);}
  if (FD_ISSET(fd, &ready))
    { sock = accept(fd, (struct sockaddr *)0, (int *)0);
      if (sock == -1)
	{ perror("accept");
	  return(-1); }
    }
  return(sock);
}

  
/* close a file descriptor */
close_fd(fd)
int fd;
{ close(fd); }


close_sock(fd)
int fd;
{ shutdown(fd,2);
  close(fd); }


int erratic_tcp_fd = -1;	/* file descriptor for tcp socket */
int erratic_client_fd = -1;	/* file descriptor for client connection */

open_tcp_line()
{
  if ((erratic_tcp_fd = open_tcp_port()) < 0) /* opened? */
    { printf("\nCouldn't open ERRATIC tcp service"); }
}

int erratic_tty_fd = -1;	/* file descriptor for tty port */




int
open_tty_line(char *tty)
{
  int fd;
  fd = open_tty_port(tty);
  if (fd > 0)
    {
      erratic_tty_fd = fd;
      server_loop_flag = 1;
      input_comm_line(fd);
      output_comm_line(fd);
    }
  else
    {
      server_loop_flag = 0;
      printf("\nCouldn't open TTY port %s",tty);
      fflush(stdout);
    }
}  


int
accept_client(int prot, char *port) /* accepts a connection */
{
  int fd;
  if (prot == TCP)		/* check the tcp accept */
    {
      if (erratic_tcp_fd > 0)
	{
	  if ((fd = accept_tcp_conn(erratic_tcp_fd)) < 0)
	    { printf("\nCouldn't accept ERRATIC client connection");
	      return(0);
	    }
	  else if (fd == 0) return(0);  /* no client waiting */
	  else
	    {
	      erratic_client_fd = fd;
	      input_comm_line(fd);	/* set up comm streams */
	      output_comm_line(fd);
	      return(1);
	    }
	}
    }
  else if (prot == TTYPORT)	/* check for bytes waiting on tty port */
    {
      if (erratic_tty_fd > 0)
	{
	  if (client_data_waiting()) /* have something... */
	    return(1);
	}
      return(0);
    }
  else return(0);
}


shutdown_client()		/* close out the current tcp connection */
{
  if (erratic_client_fd > 0)
    close(erratic_client_fd);
  erratic_client_fd = -1;
}


shutdown_erratic_server()	/* close current TCP connection */
{
  if (erratic_tcp_fd > 0)
    {
      close_sock(erratic_tcp_fd);
      erratic_tcp_fd = -1;
    }
}

void process_events();
void disconnect_state();

startup_erratic_server(prot,ttyport)	/* start up comm connection */
     int prot;			/* protocol type */
     char *ttyport;		/* tty device, if applicable */
{
  shutdown_erratic_server();

  if (prot == TCP)
    open_tcp_line();
  else if (prot == TTYPORT)
    open_tty_line(ttyport);

  while(server_loop_flag)
    {
      disconnect_state(False);
      myhost[0] = 0;
      strcat(myhost,"Listening");
      if (prot == TCP)
	strcat(myhost," on TCP port");
      else if (prot == TTYPORT)
	{
	  strcat(myhost," on TTY port ");
	  strcat(myhost,ttyport);
	}
      connect_message(myhost);
      while (! accept_client(prot,ttyport)) /* loop until client connected */
	{ 
	  process_events();
	  ms_pause(200); 
	}
      connect_message("Starting connection...");
      process_events();
      if (sync_client()==0)	/* synchronize with client */
	{
	  myhost[0] = 0;
	  strcat(myhost,"Connected");
	  if (prot == TCP)
	    strcat(myhost," on TCP port");
	  else if (prot == TTYPORT)
	    {
	      strcat(myhost," on TTY port ");
	      strcat(myhost,ttyport);
	    }
	  connect_message(myhost);
	  disconnect_state(True);
	  update_and_comm_loop();	/* run the robot */
	}
      else connect_message("unsuccessful!");
      process_events();
      shutdown_client();	/* close out this client */
      ms_pause(2000);
    }
  disconnect_state(False);
  shutdown_erratic_server();
}



