#include <stdio.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/param.h>

/*
 * Connect to a socket by service name or port number.
 * If port is 0, service will be used.
 * Returns a file descriptor for the socket.
 */

#define TCP 0			/* protocol number */
#define UDP 1			/* protocol number */
#define TCPB 2			/* protocol number */
#define HOST_LEN 100		/* max length of host name string */

char myhost[HOST_LEN];

int
connect_to_socket(hostname, service, proto, port)
char	*hostname;
char	*service;
u_int	port;
int     proto;

{
    struct sockaddr_in	remote_addr;	/* remote inet socket address	*/
    struct servent	*serv;		/* returned by getservbyname()	*/
    struct hostent	*host;		/* returned by gethostbyname()	*/
    int			sock;


    if (strlen(service) <= 0)
	service = NULL;

    if (proto == TCP || proto == TCPB)  /* make a stream socket */
      { 
fprintf(stderr,"getting TCP socket\n");
    if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0) 
	  { perror("stream socket");
	    return (-1);
	  }
      }
    else			/* make a datagram socket */
      { if ((sock = socket(AF_INET, SOCK_DGRAM, 0)) < 0) 
	  { perror("dgram socket");
	    return (-1);
	  }
      }

fprintf(stderr,"socket fd: %d\n",sock);

    if (service != NULL) {
	if ((serv = getservbyname(service, NULL)) == NULL) {
	    if (port <= 0) {
		fprintf(
		    stderr,
		    "Unknown serv %s/tcp. No default port given\n",
		    service
		);
		return(-1);
	    }
	    remote_addr.sin_port = htons((u_short) port);
	}
	else
	    remote_addr.sin_port = serv->s_port;
    }
    else
	remote_addr.sin_port = htons((u_short) port);

fprintf(stderr,"port number: %d\n",ntohs(remote_addr.sin_port));

				/*  Now we bind the socket to the right port */
    if (proto == UDP || proto == TCPB)
      { remote_addr.sin_addr.s_addr = INADDR_ANY;
	if (bind(sock, &remote_addr, sizeof(remote_addr)) < 0)  
	  { perror("bind");
	    return (-1);}
      }

    if (proto == TCPB)		/* don't connect, we are listening for clients */
      { listen(sock,1);		/* just one connection */
	return(sock); }

    if ((host = gethostbyname(hostname)) == NULL) {
	perror("gethostbyname");
	return (-1);
    }

    remote_addr.sin_family = host->h_addrtype;
    bcopy(host->h_addr, &remote_addr.sin_addr, host->h_length);

fprintf(stderr,"host addr: %d.%d.%d.%d\n", (host->h_addr)[0],
       (host->h_addr)[1],
       (host->h_addr)[2],
       (host->h_addr)[3]);

fprintf(stderr,"port: %d\n",remote_addr.sin_port);
       
    if (connect(sock, &remote_addr, sizeof(remote_addr)) < 0)  
	  { perror("connect");
	    return (-1);}

    return(sock);
}


/* Just open a server from the simulator */

open_tcp_port()

{  
return(connect_to_socket("","trobot",TCPB,8101));
 }


/* Send back packets */

open_udp_port(host)
     char *host;
{  
  return(connect_to_socket(host,"urobot",UDP,0));
 }


/* Accept client connections */

accept_tcp_conn(fd)
int fd;
{
  int sock;
  fd_set ready;
  struct timeval to;

  sock = 0;
  FD_ZERO(&ready);
  FD_SET(fd, &ready);
  to.tv_sec = 0;
  to.tv_usec = 0;
  if (select(fd+1, &ready, NULL, NULL, &to) < 0)
    {perror("select");
     return(-1);}
  if (FD_ISSET(fd, &ready))
    { sock = accept(fd, (struct sockaddr *)0, (int *)0);
      if (sock == -1)
	{ perror("accept");
	  return(-1); }
    }
  return(sock);
}

  
/* close a file descriptor */
close_fd(fd)
int fd;
{ close(fd); }


close_sock(fd)
int fd;
{ shutdown(fd,2);
  close(fd); }
