function zoomyout(gf,callback)
%ZOOMYOUT	Zoom out the Y-axis.
%       ZOOMYOUT(H) where H is the figure ZOOMTOOL is active in.
%
%       ZOOMYOUT(H,'CALLBACK') evaluates 'CALLBACK' after
%       zoom action.
%
%       Note: ZOOMYOUT is called after a "< >" push button event.
%
%       See also ZOOMCLR ZOOMDOWN ZOOMLEFT ZOOMMENU ZOOMMOVE
%       	ZOOMPKLF ZOOMPKRT ZOOMRGHT ZOOMSET ZOOMTGGL ZOOMTOOL
%       	ZOOMUP ZOOMXFUL ZOOMXIN ZOOMXOUT ZOOMYFUL ZOOMYIN
%       	ZOOMYOUT

%       Dennis W. Brown 1-10-94
%       Copyright (c) 1994 by Dennis W. Brown
%       May be freely distributed.
%       Not for use in commercial products.

handles = get(finduitx(gf,'zoomtool'),'UserData');
ga = handles(40);

% get zoomyout stack
zout = handles(5);
stack = get(zout,'UserData');

% check for empty stack
if isempty(stack), return; end;

% pop last from stack
[m,n] = size(stack);
v1 = stack(m,1);
v2 = stack(m,2);
stack = stack(1:m-1,:);
set(zout,'UserData',stack);

% set new y limits
set(ga,'YLim',[v1 v2]);

% adjust vertical cursor lengths
set(handles(24),'YData',[v1 v2]);
set(handles(26),'YData',[v1 v2]);

if nargin == 2,
	eval(callback);
end;
