function edit(cmdname)
%EDIT	Edit function M-file or MEX source.
%	EDIT FUNCTION opens a text editor containing the
%	m-file for FUNCTION.  If function is a built-in
%	function, a variable or not found, the appropriate
%	error message is produced.  If FUNCTION is a MEX
%	file, the C or FORTRAN source is opened if it resides
%	in the same directory as the MEX file.

%       Dennis W. Brown 5-17-94
%       Naval Postgraduate School, Monterey, CA
%       May be freely distributed.
%       Not for use in commercial products.

% find pathname to function
f = which(cmdname);

% check to see if it's built in or whatever
if f == 5,

	% seems WHICH returns codes 5 == built-in
	disp(['edit: ' cmdname ' built-in function.']);

elseif f == 0,

	% seems WHICH returns codes 0 == not found or variable.
	disp(['edit: ' cmdname ' is a variable or was not found.']);

else,

	% check for mex-file
	if strcmp(computer,'SUN4'),
		ext = '.mex4';
	else,
		ext = '.mex';
	end;
	c1 = length(f)-length(ext)+1;
	c2 = length(f);
	if strcmp(f(c1:c2),ext),

		msg = ['edit: ' cmdname ' is a mex-file'];

		if exist([f(1:c1) 'c']) == 2,

			% try looking for C code first

			% assume it's in the same directory
			f = [f(1:c1) 'c'];
			msg = [msg ', opening C source.'];

		elseif exist([f(1:c1) 'for']) == 2,

			% try looking for FORTRAN code second

			% assume it's in the same directory
			f = [f(1:c1) 'for'];
			msg = [msg ', opening FORTRAN source.'];

		else
			f = [];
			msg = [msg ', aborted.'];
		end;

		disp(msg);

	end;

	if ~isempty(f),

		% form the command
		if strcmp(computer,'SUN4'),
			cmd = ['!textedit -Wt cour.r.14 ' f ' &'];
		else,
			cmd = ['!deskedit ' f ' &'];
		end;

		% do it
		eval(cmd);
	end;
end;
