function gff = newarma(signal,fs)
%SIGMODEL	Signal modeling tool.
%	[H]=SIGMODEL(X) opens the Signal Modeling Tool providing
%	an interactive environment in which to develop various
%	signal models.
%
%	[H]=SIGMODEL(X,FS) sets the sampling frequency to fs.
%	Default sampling frequency is fs = 8192 Hz.
%
%	SIGMODEL('FILENAME') and SIGMODEL('FILENAME',BITS) open the
%	file specified by 'FILENAME' and loads the signal stored
%	within directly into the tool.  File formats with the
%	extensions *.au, *.voc, *.wav, and *.tim can be specified
%	by the 'FILENAME' option only (be sure to include the
%	extension).  Flat integer formatted file require the BITS
%	argument where BITS is either 8, 16, or 32.  Integer formats
%	must be stored as signed integers to be read correctly.
%	Multi-byte integers (16 and 32) are assumed to be compatible
%	with the format used by the workstation in use ("Little Endian"
%	and "Big Endian" files are not compatible).  Pathnames are
%	required when the file is not in the current directory.
%	The sampling frequency is set to that store in the file
%	for *.voc and *.wav formats.  All others default to 1 Hz.
%
%	See also SIGEDIT, VOICEDIT,SIGFILT,  SPECT2D, SPECT3D

%       Dennis W. Brown 2-3-93, DWB 6-12-94
%       Copyright (c) 1994 by Dennis W. Brown
%       May be freely distributed.
%       Not for use in commercial products.

% must have at least 1 args or variable SPC_COMMON in global workspace
sigfile = '';
if nargin < 1
        signal = randn(512,1);
	fs = 8192;
elseif isstr(signal),
	sigfile = signal;
	if nargin == 2,
		bits = fs;
		[signal,fs] = readsig(sigfile,bits);
		sigfile = [sigfile '#' int2str(bits)];
	elseif ~isempty(find(sigfile == '.')),
		[signal,fs] = readsig(sigfile);
	else,
		error(['sigmodel: Filename must have an extension' ...
			' or bits must be specified.']);
	end;
elseif nargin == 1,
	fs = 8192;
end;

% figure out if we have a vector
if min(size(signal)) ~= 1,
	error('sigmodel: Input arg "signal" must be a 1xN or Nx1 vector.');
end;

% work with Nx1 vectors
signal = signal(:);

% -----------------------------------------------------------------------------
spcolors;
global SPC_WINDOW SPC_SM_POS SPC_COLOR_ORDER
s = get(0,'ScreenSize');
if exist('SPC_SM_POS'),
    ar_pos = SPC_SM_POS;
elseif s(3) < 800,
    ar_pos = [0 .1 .9 .9];
elseif s(3) >= 800 & s(3) < 1024,
    ar_pos = [0 .2 .8 .8];
elseif s(3) == 1024,
    ar_pos = [0 .3 .7 .7];
else
    ar_pos = [0 .4 .6 .6];
end;
gf = figure('Units','normal','Position',ar_pos,'color',SPC_WINDOW,...
        'Name','Signal Modeling Tool by D.W. Brown',...
        'NumberTitle','off','BackingStore','on');

% following line is bug workaround for version 4.1 and below
set(gf,'BackingStore','off','BackingStore','on');

if strcmp(computer,'PCWIN'),
	set(gf,'MenuBar','none');
end;

% -----------------------------------------------------------------------------
% local constants
% local variables
nbrcols = 5;
b_hite = .05; 	b_int = .015;
b_end = .05;	b_frame = .005;
b_width = (1 - (nbrcols-1)*b_int - 2*b_end)/nbrcols;
b_qtr = b_width/4;
columns = (0:nbrcols) .* (b_width + b_int) + .05;
rows = (0:8) .* (b_hite + b_int) + .05;

closecall = ['dog_h = get(findmenu(gcf,''Workspace'',''Quit''),''Userdata'');'...
	'dog_kids = get(0,''Children'');'...
	'for dog_k=1:length(dog_h); '...
	'if ~isempty(find(dog_kids == dog_h(dog_k))),'...
	'close(dog_h(dog_k)); end; '...
	'end; clear dog_h dog_k dog_kids; close(gcf);'];

if isempty(sigfile),
	workmenu(gf,signal,'sigmocal(''restore'')','sigmocal(''common'')', ...
		'sigmold; sigmocal(''fs'');','sigmosav',closecall);
else,
	workmenu(gf,sigfile,'sigmocal(''restore'')','sigmocal(''common'')', ...
		'sigmold; sigmocal(''fs'');','sigmosav',closecall);
end;
% -------------------------------------------------------------------------

hh = uicontrol(gf,'Style','frame',...
	'Units','normal',...
	'Position',[columns(1)-b_frame rows(1)-b_frame ...
		2*b_width+2*b_frame+1*b_int 4*b_hite+3*b_int+2*b_frame]);

% get the frame's color so we can set our text background the same
bcolor = get(hh,'BackGroundColor');

% if on a PC, set a special color for edit boxes so that they are
% visible. otherwise, make same as frame cause that looks better on
% Sun workstation ***Mathworks!***
if strcmp(computer,'PCWIN'),
	beditcolor = [1 1 1] * 0.7;
else,
	beditcolor = bcolor;
end;

% print generate label
uicontrol(gf,'Style','text',...
	'Units','normal',...
	'Horiz','center',...
	'Position',[columns(1) rows(4) 2*b_width+b_int b_hite],...
	'String','Plots');

% draw desired checkbox
uicontrol(gf,'Style','check',...
	'Units','normal',...
	'Horiz','center',...
	'BackGroundColor',beditcolor,...
	'Position',[columns(1) rows(3) b_width b_hite],...
	'String','Desired','Value',0);

% draw model checkbox
uicontrol(gf,'Style','check',...
	'Units','normal',...
	'Horiz','center',...
	'BackGroundColor',beditcolor,...
	'Position',[columns(1) rows(2) b_width b_hite],...
	'String','Model','Value',0);

% draw include error checkbox
uicontrol(gf,'Style','check',...
	'Units','normal',...
	'Horiz','center',...
	'BackGroundColor',beditcolor,...
	'Position',[columns(1) rows(1) b_width b_hite],...
	'String','Error','Value',1);

% draw overlay checkbox
uicontrol(gf,'Style','check',...
	'Units','normal',...
	'Horiz','center',...
	'BackGroundColor',beditcolor,...
	'Position',[columns(2) rows(3) b_width b_hite],...
	'String','Overlay','Value',1);

% draw polar checkbox
uicontrol(gf,'Style','check',...
	'Units','normal',...
	'Horiz','center',...
	'BackGroundColor',beditcolor,...
	'Position',[columns(2) rows(2) b_width b_hite],'String',...
	'Polar','Value',0);

% draw spectrum checkbox
uicontrol(gf,'Style','check',...
	'Units','normal',...
	'Horiz','center',...
	'BackGroundColor',beditcolor,...
	'Position',[columns(2) rows(1) b_width b_hite],...
	'String','Spectrum','Value',0);

% -------------------------------------------------------------------------

% -------------------------------------------------------------------------

uicontrol(gf,'Style','frame',...
	'Units','normal',...
	'Position',[columns(3)-b_frame rows(1)-b_frame ...
		b_width+2*b_frame 4*b_hite+3*b_int+2*b_frame]);

% print model mark label
uicontrol(gf,'Style','text',...
	'Units','normal',...
	'Horiz','center',...
	'Position',[columns(3) rows(4) b_width b_hite],...
	'String','Model Data');

% draw model begin text
uicontrol(gf,'Style','text',...
	'Units','normal',...
	'Horiz','center',...
	'Position',[columns(3) rows(3) b_qtr b_hite],...
	'String','MB');

% draw model begin pushbutton
uicontrol(gf,'Style','edit',...
	'Units','normal',...
	'Horiz','left',...
	'BackGroundColor',beditcolor,...
	'Position',[columns(3)+b_qtr rows(3) 3*b_qtr b_hite],...
	'UserData','MB','CallBack','armacrsr(gca,1,1);');

% draw model end text
uicontrol(gf,'Style','text',...
	'Units','normal',...
	'Horiz','center',...
	'Position',[columns(3) rows(2) b_qtr b_hite],...
	'String','ME');

% draw model end edit
uicontrol(gf,'Style','edit',...
	'Units','normal',...<	'Horiz','left',...
	'BackGroundColor',beditcolor,...
	'Position',[columns(3)+b_qtr rows(2) 3*b_qtr b_hite],...
	'UserData','ME','CallBack','armacrsr(gca,1,2);');

% draw model delta text
uicontrol(gf,'Style','text',...
	'Units','normal',...
	'Horiz','center',...
	'Position',[columns(3) rows(1) b_qtr b_hite],...
	'String','MD');

% draw model delta edit
uicontrol(gf,'Style','edit',...
	'Units','normal',...
	'Horiz','left',...
	'BackGroundColor',beditcolor,...
	'Position',[columns(3)+b_qtr rows(1) 3*b_qtr b_hite],...
	'UserData','MD','CallBack','armacrsr(gca,1,3);');

% -------------------------------------------------------------------------

% -------------------------------------------------------------------------

uicontrol(gf,'Style','frame',...
	'Units','normal',...
	'Position',[columns(4)-b_frame rows(1)-b_frame ...
		b_width+2*b_frame 4*b_hite+3*b_int+2*b_frame]);

% print model mark label
uicontrol(gf,'Style','text',...
	'Units','normal',...
	'Horiz','center',...
	'Position',[columns(4) rows(4) b_width b_hite],...
	'String','Period');

% draw period begin text
uicontrol(gf,'Style','text',...
	'Units','normal',...
	'Horiz','center',...
	'Position',[columns(4) rows(3) b_qtr b_hite],...
	'String','PB');

% draw period begin pushbutton
uicontrol(gf,'Style','edit',...
	'Units','normal',...
	'Horiz','left',...
	'BackGroundColor',beditcolor,...
	'Position',[columns(4)+b_qtr rows(3) 3*b_qtr b_hite],...
	'UserData','PB','CallBack','armacrsr(gca,2,1);');

% draw period end text
uicontrol(gf,'Style','text',...
	'Units','normal',...
	'Horiz','center',...
	'Position',[columns(4) rows(2) b_qtr b_hite],...
	'String','PE');

% draw period end edit
uicontrol(gf,'Style','edit',...
	'Units','normal',...
	'Horiz','left',...
	'BackGroundColor',beditcolor,...
	'Position',[columns(4)+b_qtr rows(2) 3*b_qtr b_hite],...
	'UserData','PE','CallBack','armacrsr(gca,2,2);');

% draw period delta text
uicontrol(gf,'Style','text',...
	'Units','normal',...
	'Horiz','center',...
	'Position',[columns(4) rows(1) b_qtr b_hite],...
	'String','PD');

% draw period delta edit
uicontrol(gf,'Style','edit',...
	'Units','normal',...
	'Horiz','left',...
	'BackGroundColor',beditcolor,...
	'Position',[columns(4)+b_qtr rows(1) 3*b_qtr b_hite],...
	'UserData','PD','CallBack','armacrsr(gca,2,3);');

% -------------------------------------------------------------------------
% -------------------------------------------------------------------------

% draw include error checkbox
uicontrol(gf,'Style','check',...
	'Units','normal',...
	'Horiz','center',...
	'BackGroundColor',beditcolor,...
	'Position',[columns(5) rows(4) b_width b_hite],...
	'String','Lock MB-PB','Value',1,...
	'CallBack','armacrsr(gca,1,1);');

% allow user to set freq from command line
freqs = [1 2000 4000 8000 8192 11025 22050 44100];

% user supplied fs in list already?
ind = find(freqs == fs);

if isempty(ind),

	% nope, add it
	freqs = sort([freqs(:) ; fs])';
	ind = find(freqs == fs);

end;

uicontrol(gf,'Style','frame',...
	'Units','normal',...
	'Position',[columns(5)-b_frame rows(1)-b_frame ...
		b_width+2*b_frame 2*b_hite+1*b_int+2*b_frame]);
		
% finally, draw the popupmenu
popunbrs(gf,[columns(5) rows(1) b_width b_hite],...
	freqs,'Sampling Freq',...
	'LabelPosition',[columns(5) rows(2) b_width b_hite],...
	'BackGroundColor',bcolor,'ForeGroundColor','black',...
	'Range',[1 Inf],'Integer','on',...
    	'CallBack','sigmocal(''fs'');'...
    );
set(findpopu(gf,'Sampling Freq'),'Value',ind);	% default 8192 Hz

% -------------------------------------------------------------------------
% -------------------------------------------------------------------------
% make the axis
AR_AXIS = axes('Position',[.1 .4 .85 .5],...
	'DrawMode','fast','UserData','zoomtool');


sigmocal('plottime',signal);

if nargout == 1,
	gff = gf;
end;

