#ifndef _SPEECH_H
#define _SPEECH_H

/*
 * speech.h
 *
 * $Id: speech.h,v 1.49 1993/05/24 16:13:36 johans Exp johans $
 *
 */

/*
 * Data types for DFT and FFT
 */

struct complex {
	float c_real;
	float c_imag;
};

typedef struct complex Complex;


/*
 * Data type for ASCII header structure
 */
struct asciihdr {
	char *ah_key;
	int ah_vlen;
	char **ah_value;
};

typedef struct asciihdr AsciiHdr;

/*
 * Data type for segment (lola) files
 */

struct segmentlist {
	char *sl_label;				/* lola label */
	int sl_begin;				/* begin frame index */
	int sl_end;				/* end frame index */
	struct segmentlist *sl_forward;		/* forward pointer */
	struct segmentlist *sl_backward;	/* backward pointer */
};

typedef struct segmentlist SegmentList;

/*
 * Data type for neural networks
 */

struct neuralnet {
	int nn_iter;		/* iteration count */
	int nn_nlayers;		/* number of layers */
	float *nn_w;		/* array of weights */
	float **nn_act;		/* 2 dimensional array of activation levels */
	int *nn_sz;		/* array of dimensions (sizes) of each layer */
	int *nn_layeridx;	/* array of starting indexs for the layers */
};

typedef struct neuralnet NeuralNet;

extern char *ErrorString;

/* Procedure and Functions header declarations */

/* tdat.c */
int TdatRead( char *file, char ***data, AsciiHdr **header);
int TdatWrite( char *file, char **data, AsciiHdr *header);
int fTdatRead( FILE *fp, char ***data, AsciiHdr **header); 
int fTdatWrite( FILE *fp, char **data, AsciiHdr *header);


/* asciihdr.c */
AsciiHdr *ReadHeader( FILE *fp );
int      WriteHeader( FILE *fp, AsciiHdr *hdr );
void     FreeHeader( AsciiHdr *hdr );
char *FindHeaderVal( AsciiHdr *hdr, char *key);
char **GetValueArray( AsciiHdr *hdr, char *key, int *len);


/* filt.c */
int FiltByName (char *filtername, short *adc, int numadc, short **adcfilt);
int FiltCoefficents ( char *filtername, float **coeff, int *numcoeff);
int Filt (float *filter, int numfilt, short *adc, int numadc, short **adcfilt);


/* adc.c */
int AdcRead (char *file, short **samples, int *rate);
int AdcWrite (char *filename, short *samples, int len, int rate);


/* littleindian.c */
int LittleIndian();


/* allocspace.c */
char **Alloc2d (int dim1, int dim2, int size);
int  Free2d( char **mat);
char ***Alloc3d( int dim1, int dim2, int dim3, int size);
int  Free3d (char ***mat);


/* strarry.c */
int   *StrArray2IntArray( char **sa, int len );
float *StrArray2FloatArray( char **sa, int len );
char  **IntArray2StrArray( int *ia, int len );
char  **FloatArray2StrArray( float *fa, int len );
char  **Str2StrArray( char *str );
void  FreeStrArray( char **sa, int len );


/* windows.c */
int HammingWindow( float *data, int num );
int HanningWindow( float *data, int num );


/* dft.c */
short **ComputeDFT (short *wav, int wavlen, int offset, int winsize, int inc,
		    int coeffs, double alpha, int *numframes_p);
int FloatFFT (float *x, Complex *y, int m);
int TrigRecombFFT (Complex *cx, Complex *y, int m);
int FFT( Complex *x, int m );


/* plp.c */
int ComputePLP(short *idata, int num_idata, int Win_offset, int Win_size, 
	       int Step_size, double Sf, double Expon, int M, int Np, 
	       int Gain, float ***plpout_p, int *numframes_p);


/* preemphasis.c */
void Preemphasis( float alpha, float start, float *wav, int len );


/* rasta.c */
int ComputeRastaPLP(short *idata, int num_idata, int Win_offset, int Win_size,
		    int Step_size, float Sf, float Rst, float Expon, 
		    int M, int Np, int Gain, float pole, float ***plpout_p, 
		    int *numframes_p);


/* segmentlist.c */
int  ReadSegmentList( char *file, SegmentList **seg, float *ms );
int  ReadSegmentListAndHeader( char *file, SegmentList **seg, AsciiHdr **hdr );
int  WriteSegmentList( char *file, SegmentList *seg, float ms );
int  WriteSegmentListAndHeader( char *file, SegmentList *seg, AsciiHdr *hdr );
void FreeSegmentList( SegmentList *seg );
int  AddSegment( SegmentList *seg, int begin, int end, char *label );
void DeleteSegment( SegmentList *seg );
int  LabelSegment( SegmentList *seg, char *label );
static void InsertSegment( SegmentList *slot, SegmentList *seg );
static void FreeSegment( SegmentList *seg );
static SegmentList *NewSegment();
SegmentList *FindLastSegment( SegmentList *seg );
SegmentList *NewSegmentList();
SegmentList *SegmentListHead( SegmentList *seg );
SegmentList *FindSegment( SegmentList *seg, int begin );
SegmentList *FindNearestSegment( SegmentList *seg, int frame );


/* shortpack_io.c */
int WriteShortpackedData (short *array, int num_elements, FILE *fp);
int ReadShortpackedData(short *array, int num_elements, FILE *fp);
int WriteShortpackReadingFromFile (FILE *ifp, FILE *ofp, int swap);
int ReadShortpackWritingToFile(FILE *ifp, FILE *ofp, int swap);


/* speechread.c */
int SpeechRead (char *filename, short **samples_p, float *sample_rate_p);


/* nnet.c */
int  NNLayer ( NeuralNet *nn, int layer, float *ivec, float *ovec );
void NNClassifyVector(NeuralNet *nn, float *ivec, float *ovec);
int  NNClassify (float *fvec, NeuralNet *nn);
int  NNReadASCII (FILE *inp, NeuralNet *nn);
int  NNRead (FILE *fileptr, NeuralNet *nn);
int  NNWrite (FILE *fp, NeuralNet *nn );
int  NNLoad (char *filename, NeuralNet *nn);
int  NNFree (NeuralNet *nn);


/* wav.c */
static byte_swap(char *buf, int len);
int    WavRead(char *filename, short **samples_p, int *rate_p );
int    WavWrite(char *wavfile, short *samples, int len, int sample_rate, 
		int compress_flag);


/* lpc.c */
int LPC_Analyses(short *speech, int length, float window, float step, 
		 float fSamp, float ***Ri, float ***Ai, float ***RFi,
		 float ***Ci, float ***DelCi, int m, int n, int p);

/* melcep.c */
int MelCepstrum(short *speech, int length, float window, float step,
		float fSamp, int Nfilter, float ***MelCep, int n);

#endif _SPEECH_H


