/********************************************/
/** NIST Speech Header Resources (SPHERE)  **/
/** Release 1.7 (beta)                     **/
/** Stan Janet (stan@jaguar.ncsl.nist.gov) **/
/** June 1991                              **/
/********************************************/

/* LINTLIBRARY */

/* File: spmalloc.c */


#include <sys/types.h>
#include "sysparam.h"


static int dealloc = 1;

char *spx_malloc(u_int bytes)
{
  extern char *malloc();
  
  if (bytes == 0)
    bytes = 1;
  return malloc(bytes);
}


spx_free(char *p)
{
  if (dealloc)
    (void) free(p);
}


FUNCTION sp_set_dealloc(int n)
{
  dealloc = n;
}

FUNCTION int sp_get_dealloc()
{
  return dealloc;
}
