/*
 *  $Id: wav2adc.c,v 1.8 1993/06/10 17:26:57 johans Exp $
 *
 * wav2adc.c
 *
 */

/* Standard C libary include file directives */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Speech Libary include file directives */
#include <speech.h>

/* global variable declarations */
char InFileName[200]="-";                 /* Input file name / stdin      */
char OutFileName[200]="-";                /* Output file name / stdout    */

FILE *outfile;


/*
 * usage()
 *
 * display usage paramters on screen
 *
 */

void usage() 
{
  fprintf(stderr, "Usage: <stdin> | wav2adc [options] | <stdout>\n");
  fprintf(stderr, "\n");
  fprintf(stderr, "Where options can be any of the following:\n");
  fprintf(stderr, "-f input file name [stdin]\n");
  fprintf(stderr, "-o output file name [stdout]\n");
  fprintf(stderr, "-h This help message\n");
  exit(1);
}


/*
 * get_comline(int argc, char **argv)
 *
 * read and interpret command line
 *
 */

void get_comline(int argc, char **argv)
{
  int c;
  extern int optind;
  extern char *optarg;

  while( (c = getopt( argc, argv, "f:o:h")) != -1 )
    {
        switch( c )
        {
            case 'f':  /* input file */
                strcpy(InFileName, optarg);
                break;

            case 'o':  /* output file */
		strcpy(OutFileName, optarg);
		break;

	    case 'h': /* help */
            default:
		usage();
                break;
        }
    }
}


main(int argc, char *argv[])
{
  short *samples;
  int len;
  float rate;

  get_comline(argc, argv);

  len = SpeechRead(InFileName, &samples, &rate );

  if( len <= 0 ) {
    fprintf( stderr, "wav2adc: %s: %s\n", argv[1], ErrorString );
    exit( 1 );
  }

  if( AdcWrite(OutFileName, samples, len, (int) rate ) < 0 ) {
    fprintf( stderr, "wav2adc: %s: %s\n", argv[2], ErrorString );
    exit( 1 );
  }

  exit(0);
}

