/*
 * $Id: printspec.c,v 1.1 1993/05/13 20:53:35 johans Exp $
 *
 * printspec.c
 *
 */

/* Standard C libary include file directives */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>


/* Speech library include file directives */
#include <speech.h>

#define COEFF_PER_LINE		(18)

/* Local module header declarations */
static void PrintUsage();
static void PrintSpec(short **dft, AsciiHdr *hdr);

main(int argc, char *argv[]) 
{
	AsciiHdr *header;
	short **dft;
	

	if( argc != 2 ) {
		PrintUsage();
		exit( 1 );
	}


	if( TdatRead( argv[1], (char ***) &dft, &header ) < 0) {
		fprintf( stderr, "printspec: %s: %s\n", argv[1], ErrorString );
		exit( 1 );
	}

	PrintSpec( dft, header );
}


static void PrintUsage()
{
	fprintf( stderr, "usage: printspec file\n" );
}


static void PrintSpec(short **dft, AsciiHdr *hdr )
{
	char *tmp;
	int rows;
	int cols;
	double rate;
	int i, j, k;


	tmp = FindHeaderVal( hdr, "Rows" );
	if( tmp == NULL ) {
		fprintf( stderr, "printspec: could not find Row value\n" );
		exit( 1 );
	}
	rows = atoi( tmp );

	tmp = FindHeaderVal( hdr, "Columns" );
	if( tmp == NULL ) {
		fprintf( stderr, "printspec: could not find Column value\n" );
		exit( 1 );
	}
	cols = atoi( tmp );

	tmp = FindHeaderVal( hdr, "SamplesPerSecond" );
	if( tmp == NULL ) {
	  fprintf(stderr,"printspec: could not find SamplesPerSecond value\n");
	  exit( 1 );

	}
	rate = atof( tmp );

	for( i = 0; i < cols; i += COEFF_PER_LINE ) {

		printf( "     " );
		for( k = i; k < i + COEFF_PER_LINE; k++ ) {
			printf( "%4d", k );
		}
		printf( "\n" );

		printf( "     " );
		for( k = i; k < i + COEFF_PER_LINE; k++ ) {
			printf( "----" );
		}
		printf( "\n" );

		for( j = rows - 1; j >= 0; j-- ) {

			printf( "%4d:", (j * (((int)rate)/2) / (rows-1)) );

			for( k = i; k < i + COEFF_PER_LINE && k < cols; k++ ) {
				printf( "%4d", dft[k][j] );
			}

			printf( "\n" );
		}

		printf( "\n" );
	}
}



