/*
 * $Id: speech2wav.c,v 2.3 1993/06/10 17:25:13 johans Exp johans $
 */

/* standard C library include file directives */
#include <sys/types.h>
#include <sys/stat.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Speech library include file directives */
#include <speech.h>

char adcfile[200]="-";                    /* Input file name / stdin      */
char wavfile[200]="-";                    /* Output file name / stdout    */
int  docompress = 0;
int  doloworder = 0;

FILE *outfile;


/*
 * usage()
 *
 * display usage paramters on screen
 *
 */

void usage() 
{
  fprintf(stderr, "Usage: <stdin> | speech2wav [options] | <stdout>\n");
  fprintf(stderr, "\n");
  fprintf(stderr, "Where options can be any of the following:\n");
  fprintf(stderr, "-f input file name [stdin]\n");
  fprintf(stderr, "-o output file name [stdout]\n");
  fprintf(stderr, "-c means compress\n");
  fprintf(stderr, "-l means remove low-order (2 bit) zero padding\n");
  fprintf(stderr, "   this option is for the gradient recordings\n");
  fprintf(stderr, "   which have all samples multiplied by 4.  It\n");
  fprintf(stderr, "   will only be applied if all lower 2 bits are 0.\n");
  fprintf(stderr, "-h This help message\n");
  exit(1);
}


/*
 * get_comline(int argc, char **argv)
 *
 * read and interpret command line
 *
 */

void get_comline(int argc, char **argv)
{
  int c;
  extern int optind;
  extern char *optarg;

  while( (c = getopt( argc, argv, "f:o:clh")) != -1 )
    {
        switch( c )
        {
            case 'f':  /* input file */
                strcpy(adcfile, optarg);
                break;

            case 'o':  /* output file */
		strcpy(wavfile, optarg);
		break;

            case 'c':
		docompress = 1;
		break;
            case 'l':
		doloworder = 1;
		break;

	    case 'h': /* help */
            default:
		usage();
                break;
        }
    }
}


main(int argc, char *argv[])
{
  float frate;                        /* sampling rate of speech  */
  short *samples, *sp;                /* buffer for speech signal */
  int   i,len,c;                      /* loop counter variables   */

  get_comline(argc, argv);

  if((len = SpeechRead(adcfile,&samples,&frate)) < 0)
    {
      fprintf(stderr,"cannot read %s: %s\n",adcfile,ErrorString);
      exit(1);
    }

  if(doloworder)
    {
      for(sp = samples;sp < samples + len;sp++)
	{
	  if(*sp & 3) break;
	}
      if(sp == (samples + len))
	{
	  fprintf(stderr,"dividing every sample by 4\n");
	  for(sp = samples;sp < samples + len;sp++)
	    {
	      *sp = *sp >> 2;
	    }
	}
      else
	fprintf(stderr,"low-order bytes not removed\n");
    }
  
  if( WavWrite(wavfile, samples, len, (int)frate, docompress) < 0)
    {
      fprintf( stderr, "cannot write %s: %s\n", wavfile, ErrorString );
      exit( 1 );
    }
  
  exit( 0 );
}

