static char *rcsident = "$Header: /projects/cslu/speech/work/src/bin/nopt/noptest/RCS/noptest.c,v 1.25 1993/05/11 22:29:52 fanty Exp $";

/**************************************************************************
 *
 * noptest.c -  
 *
 **************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <ctype.h>
#include <math.h>
#include <speech.h>

#include "version.h"

#define EMAX 50
#define EMIN -50

float f (float s);
void eerror (char *where);
void up_act (int iin);

float **delt, **inact;
int nlayers, nin, *clas;
NeuralNet nn;
FILE *inp, *outp, *datp;

void noptest_print_usage()
{

	fprintf( stderr, "\nNOPTEST - Neural-Net classifier test program\n\n");
	fprintf( stderr, "usage: noptest [-v] weightfile vectorfile outputfile\n");
	fprintf( stderr, "description:\n\n");
	fprintf( stderr, "weightfile : the binary weight file produced by opt\n");
	fprintf( stderr, "vectorfile : the input vectors for testing with optest\n");
	fprintf( stderr, "outputfile : the ASCII output file of optest results\n\n");
	fprintf( stderr, "-v : run in verbose mode\n\n");
}


/*************************************************************************/

float f (float s)
{
	float  x;

	x = s;
	if (x > EMAX)
		x = EMAX;
	else if (x < EMIN)
		x = EMIN;
	return (float) 1. / (1. + exp (-(float) x));
}

/*************************************************************************/

void eerror (char *where)
{
	perror (where);
	exit (1);
}

/*************************************************************************
 *
 * Calculate output of net for input # iin
 *
 *************************************************************************/

void up_act (int iin)
{
	int    i1, i2, il, ct;
	float  s, *w;

	w = nn.nn_w + nn.nn_layeridx[0];

	for (i2 = 0; i2 < nn.nn_sz[1]; i2++)
	{
		s = 0.;
		for (i1 = 0; i1 < nn.nn_sz[0]; i1++)
			s += *w++ * inact[iin][i1];
		nn.nn_act[1][i2] = f(s);

	}

	for (il = 1; il < nlayers - 1; il++)

		w = nn.nn_w + nn.nn_layeridx[il];

		for (i2 = 0; i2 < nn.nn_sz[il + 1]; i2++)
		{
			s = 0.;
			for (i1 = 0; i1 < nn.nn_sz[il]; i1++)
				s += *w++ * nn.nn_act[il][i1];
			nn.nn_act[il + 1][i2] = f(s);
		}
}

/*************************************************************************/

main (int argc,char **argv)
{
	float	temp, fmax, fmin, amax;
	int	iin, iit, il, i, i1, i2, szmax;
	int	finsz, cl, **confn, cmax, j, nl1;

	char	name[100];

	int              c;
	extern char     *optarg;
	extern int       optind;

	int     oflag = 0;
	int     wflag = 0;
	int     vflag = 0;
	int     tflag = 0;
	int     errflag = 0;
	int     data_set = 0;
	int     test_set = 0;

	char    *test_file, *weight_file, *output_file;


	while( (c = getopt(argc, argv, "v")) != EOF ) {

		switch (c) {

                	case 'v':
		     		vflag++;
                     		break;
                	case '?':
				noptest_print_usage();
				exit( 2 );
			default:
				noptest_print_usage();
				exit( 2 );
		}

	}

	if( (argc - optind) != 3 ) {
		noptest_print_usage();
		exit( 2 );
	}

	weight_file = argv[optind];
	test_file = argv[optind+1];
	output_file = argv[optind+2];


	if (vflag) {

		printf("\nNOPTEST - A neural-net classifier tester\n\n");
		printf("         Version:       %s \n", opt_version);
		printf("         Weight file:   %s \n", weight_file);
		printf("         Vector file:   %s \n", test_file);
		printf("         Output file:   %s \n\n", output_file);
	}

	if( (inp = fopen( weight_file, "r")) == NULL ) {
		eerror( "Error opening input file for weights" );
	}

	if( (outp = fopen( output_file, "w")) == NULL ) {
		eerror( "Error opening output file for results" );
	}

	if( (datp = fopen( test_file, "r")) == NULL ) {
		eerror( "Error opening input file for test vectors" );
	}

	if( NNRead( inp, &nn ) < 0 ) {
		fprintf( stderr, "noptest: %s: %s\n", weight_file, ErrorString);
		exit( 1 );
	}

	nl1 = nn.nn_nlayers - 1;

	szmax = 0;
	for (il = 0; il < nn.nn_nlayers; il++)
		if (nn.nn_sz[il] > szmax)
			szmax = nn.nn_sz[il];

	fscanf (datp, " %d", &nin);

	if( nin < 2 ) {
		eerror("Suspicious value for number of input vectors");
	}

/* confn contains confusion matrix; for other definitions see opt.c */

	if (!(confn = (int **) Alloc2d (nn.nn_sz[nl1], nn.nn_sz[nl1], sizeof (int))))
		eerror ("confn Alloc2d error");

	if (!(clas = (int *) malloc (nin * sizeof (int))))
		eerror ("clas malloc error");

	if (!(inact = (float **) Alloc2d (nin, nn.nn_sz[0], sizeof (float))))
		eerror ("inact Alloc2d error");

	if (!(delt = (float **) Alloc2d (nn.nn_nlayers, szmax, sizeof (float))))
		eerror ("delt Alloc2d error");

	if (vflag)
		printf("\nNOPTEST - Beginning test vector check\n\n");

	for (iin = 0; iin < nin; iin++)
	{
		fscanf (datp, "%d", &clas[iin]);
		if (clas[iin] > nn.nn_sz[nl1])
			eerror ("More classes than output neurons");

		for (i1 = 0; i1 < nn.nn_sz[0] - 1; i1++)

			if (fscanf (datp, "%f", &inact[iin][i1]) == EOF)

				eerror ("Insufficient data");

		inact[iin][nn.nn_sz[0] - 1] = 1.;
	}

	finsz = nn.nn_sz[nl1];

	for (iin = 0; iin < nin; iin++)
	{
		up_act (iin);
		cl = clas[iin] - 1;

		/* find most active output neuron */

		amax = nn.nn_act[nn.nn_nlayers - 1][0];
		cmax = 0;

		for (i = 1; i < finsz; i++)
			if (nn.nn_act[nn.nn_nlayers - 1][i] > amax)
			{
				amax = nn.nn_act[nn.nn_nlayers - 1][i];
				cmax = i;
			}

/* increment appropriate counter in confusion matrix */

		confn[cl][cmax]++;
	}

	if (vflag)
		printf("NOPTEST - Writing confusion matrix\n\n");

/* compute total # correctly classified */

	amax = 0;
	for (i = 0; i < finsz; i++)
		amax += confn[i][i];

	fprintf (outp, " # of its.: %d; %% correct= %5.2f\n", nn.nn_iter, 100. *
		 amax / nin);

	fprintf (outp, "label");
	for (i = 0; i < finsz; i++)
		fprintf (outp, " %4d", i + 1);
	fprintf (outp, "\n");
	fprintf (outp, "-----");
	for (i = 0; i < finsz; i++)
		fprintf (outp, " ----");
	fprintf (outp, "\n");

	for (i = 0; i < finsz; i++)
	{
		fprintf (outp, "%4d:", i + 1);
		for (j = 0; j < finsz; j++)
			fprintf (outp, " %4d", confn[i][j]);
		fprintf (outp, "\n");
	}

	if (vflag)
		printf("NOPTEST - Execution completed\n\n");

}
