/*
 * $Id: makeplp.c,v 2.2 1993/06/10 17:15:32 johans Exp $
 *
 */

/* standard C libary include file directives */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

/* Speech Library include file directives */
#include <speech.h>


/* for command line */
static char Fname[200]="-";         /* input file name def = stdin   */
static char OFname[200]="-";        /* output file name def = stdout */
static int Win_size = 10;          /* analysis window in msecs      */
static int Step_size = 3;	   /* step size in msecs            */
static float Start_time = 0;       /* start time in msecs           */
static float Expon = 0.6;          /* peak enhancemnt factor        */
static int M = 5;                  /* model order                   */
static int Np = 6;                 /* number of parameters          */
static int Gain = 1;               /* gain flag                     */


void usage()
{
  fprintf(stderr,"usage: <stdin> | makeplp [options] | <stdout>\n\n");
  fprintf(stderr,"Where options can be any of the following:\n");
  fprintf(stderr,"-f input file name [stdin]\n");
  fprintf(stderr,"-o output file name [stdout]\n");
  fprintf(stderr,"-w analysis window size (in milliseconds) [%d]\n", Win_size);
  fprintf(stderr,"-i window step size (in milliseconds) [%d]\n", Step_size);
  fprintf(stderr,"-s start time (in milliseconds) [0]\n");
  fprintf(stderr,"-e peak enhancment factor [%f]\n", Expon);
  fprintf(stderr,"-m model order [%d]\n",M);
  fprintf(stderr,"-n number of output parameters [%d]\n",Np);
  fprintf(stderr,"-g (if you don't want gain computed)[compute gain]\n");
  fprintf(stderr,"-h This help message\n");
  exit( 0 );
}


/*
 * read and interpret command line
 */

void get_comline(int argc, char **argv)
{
    int c;
    extern int optind;
    extern char *optarg;

    while( (c = getopt( argc, argv, "f:o:w:i:s:S:e:m:n:g")) != -1 ) {
      switch( c ) {
        case 'f':/* output file */
	  strcpy (Fname, optarg);
	  break;
	  
	case 'o':/* output file */
	  strcpy (OFname, optarg);
	  break;
	  
	case 'w':/* analysis window in msecs */
	  Win_size = atoi(optarg);
	  break;

	case 'i':/* step size in msecs */
	  Step_size = atoi(optarg);
	  break;

	case 's':/* start time in msecs */
	  Start_time = atof(optarg);
	  break;

	case 'e':/* peak enhancement factor */
	  Expon = atof(optarg);
	  break;

	case 'm':/* model order */
	  M = atoi(optarg);
	  break;

	case 'n':/* number of parameters */
	  Np = atoi(optarg);
	  break;

	case 'g':/* don't include gain */
	  Gain = 0;
	  break;
			
	case '?':
	case 'h':
	default:
	  usage();
	  break;
        }
    }
}


main(int argc, char **argv)
{
    short *idata;
    int num_idata, start_sample;
    float **plpout;
    int numframes,i;
    FILE *fp;
    float Sf;			/* sampling frequency */
    AsciiHdr header[100];
    
    get_comline(argc,argv);
    
    if(strcmp(OFname,"-"))
      {
	fp = fopen(OFname,"w");
	if(fp == NULL)
	  {
	    fprintf(stderr,"cannot open %s\n",OFname);
	    exit(1);
	  }
      }
    else
      fp = stdout;

    /* 	read in all data */
    if((num_idata = SpeechRead(Fname, &idata, &Sf)) < 0) {
      fprintf(stderr,"%s\n",ErrorString);
      exit(1);
    }

    if(ComputePLP(idata,num_idata,
		  (int)((Start_time * Sf)/1000.0),
		  (int)((Win_size * Sf)/1000.0),
		  (int)((Step_size * Sf)/1000.0),
		  Sf,
		  Expon, M, Np, Gain,&plpout,&numframes) >= 0)
      {
	int rl[100];

	for(i = 0;i < Np;i++)
	  rl[i] = i;		/* for simple row labels */

	i = 0;
	header[i].ah_key = "Rows";
	header[i].ah_vlen = 1;
	header[i++].ah_value = IntArray2StrArray(&Np,1);

	header[i].ah_key = "Columns";
	header[i].ah_vlen = 1;
	header[i++].ah_value = IntArray2StrArray(&numframes,1);

	header[i].ah_key = "Type";
	header[i].ah_vlen = 1;
	header[i++].ah_value = Str2StrArray("float");

	header[i].ah_key = "RowLabels";
	header[i].ah_vlen = Np;
	header[i++].ah_value = IntArray2StrArray(rl,Np);

        header[i].ah_key = "SamplesPerSecond";
        header[i].ah_vlen = 1;
        header[i++].ah_value = FloatArray2StrArray( &Sf, 1 );

        header[i].ah_key = "Increment";
        header[i].ah_vlen = 1;
        header[i++].ah_value = IntArray2StrArray( &Step_size, 1 );

        header[i].ah_key = "WindowWidth";
        header[i].ah_vlen = 1;
        header[i++].ah_value = IntArray2StrArray( &Win_size, 1 );

        header[i].ah_key = "StartTime";
        header[i].ah_vlen = 1;
        header[i++].ah_value = FloatArray2StrArray( &Start_time, 1 );

        header[i].ah_key = NULL;
        header[i].ah_vlen = 0;
        header[i++].ah_value = NULL;

	if( fTdatWrite( fp,(char **) plpout, header ) < 0 ) {
	  fprintf( stderr, "makeplp: fTdatWrite: %s\n", ErrorString );
	  exit( 1 );
	}
    
	if(fp != stdout)
	  fclose(fp);
      }
    else
      {
	fprintf(stderr,"ComputePLP error: %s\n",ErrorString);
	exit(1);
      }
}


