/* Standard C library include file directives */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define swap_4(a) ( ((a) << 24) | \
                      (((a) << 8) & 0x00ff0000) | \
                      (((a) >> 8) & 0x0000ff00) | \
        ((unsigned int)(a) >>24) )

#define swap_2(a) ( ((a) << 8) | \
        ((unsigned short)(a) >>8) )


/* global variable declarations */
char InFileName[200]="-";                 /* Input file name / stdin      */
char OutFileName[200]="-";                /* Output file name / stdout    */
int  doint = 0;                          /* swap integers (4 bytes)      */

FILE *infile, *outfile;


/*
 * usage()
 *
 * display usage paramters on screen
 *
 */

void usage() 
{
  fprintf(stderr, "Usage: <stdin> | byteswap [options] | <stdout>\n");
  fprintf(stderr, "\n");
  fprintf(stderr, "Where options can be any of the following:\n");
  fprintf(stderr, "-f input file name [stdin]\n");
  fprintf(stderr, "-o output file name [stdout]\n");
  fprintf(stderr, "-4 Swap the order of 4 consequtive bytes\n");
  fprintf(stderr, "-h This help message\n");
  exit(1);
}


/*
 * get_comline(int argc, char **argv)
 *
 * read and interpret command line
 *
 */

void get_comline(int argc, char **argv)
{
  int c;
  extern int optind;
  extern char *optarg;

  while( (c = getopt( argc, argv, "f:o:4h")) != -1 )
    {
        switch( c )
        {
            case 'f':  /* input file */
                strcpy(InFileName, optarg);
                break;

            case 'o':  /* output file */
		strcpy(OutFileName, optarg);
		break;
		
	    case '4': /* swap integers (4 bytes) */
		doint = 1;
		break;

	    case 'h': /* help */
            default:
		usage();
                break;
        }
    }
}


main(int argc, char **argv)
{
  int   lbuf[1024];
  short sbuf[1024];
  int   size,i;
  
  get_comline(argc, argv);
 
  if (strcmp(InFileName, "-") == 0)
    infile = stdin;
  else {
    if (!(infile = fopen(InFileName, "r"))) {
      fprintf(stderr, "Error opening file: %s\n", InFileName);
      exit(1);
    }
  }

  if (strcmp(OutFileName, "-") == 0)
    outfile = stdout;
  else {
    if (!(outfile = fopen(OutFileName, "r"))) {
      fprintf(stderr, "Error opening file: %s\n", OutFileName);
      exit(1);
    }
  }
      
  if(doint)  {
      while((size = fread(lbuf,sizeof(int),1024, infile)) > 0) {
	for(i = 0;i < size;i++)
	  lbuf[i] = swap_4(lbuf[i]);
	fwrite(lbuf,sizeof(int),size, outfile);
      }
    }
  else {
    while((size = fread(sbuf,sizeof(short),1024, infile)) > 0) {
      for(i = 0;i < size;i++)
	sbuf[i] = swap_2(sbuf[i]);
      fwrite(sbuf,sizeof(short),size, outfile);
    }
  }

  fclose(infile);
  fclose(outfile);
}
