/*
 * $Id: bhdwav.c,v 1.8 1993/06/10 17:00:00 johans Exp $
 *
 * bhdwav.c
 *
 */

/* standard C library include file directives */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Speech library include file directives */
#include <speech.h>

/* global variable declarations */
char InFileName[200]="-";                 /* Input file name / stdin      */
char OutFileName[200]="-";                /* Output file name / stdout    */


/*
 * usage()
 *
 * display usage paramters on screen
 *
 */

void usage() 
{
  fprintf(stderr, "Usage: <stdin> | bhdwav [options] | <stdout>\n");
  fprintf(stderr, "\n");
  fprintf(stderr, "Where options can be any of the following:\n");
  fprintf(stderr, "-f input file name [stdin]\n");
  fprintf(stderr, "-o output file name [stdout]\n");
  fprintf(stderr, "-h This help message\n");
  exit(1);
}


/*
 * get_comline(int argc, char **argv)
 *
 * read and interpret command line
 *
 */

void get_comline(int argc, char **argv)
{
  int c;
  extern int optind;
  extern char *optarg;

  while( (c = getopt( argc, argv, "f:o:h")) != -1 )
    {
        switch( c )
        {
            case 'f':  /* input file */
                strcpy(InFileName, optarg);
                break;

            case 'o':  /* output file */
		strcpy(OutFileName, optarg);
		break;

	    case 'h': /* help */
            default:
		usage();
                break;
        }
    }
}


main(int argc, char **argv)
{
  short *wav;
  int len;
  float rate;
  FILE *ofp;

  get_comline(argc, argv);

  if (strcmp(OutFileName, "-") == 0)
    ofp = stdout;
  else {
    ofp = fopen(OutFileName, "w" );
    if( ofp == NULL ) {
      fprintf(stderr,"bhdwav: %s: ", OutFileName);
      perror( NULL );
      exit( 1 );
    }
  }

  if( ( len = SpeechRead( InFileName, &wav, &rate ) ) < 0 ) {
    fprintf( stderr, "bhdwav: %s: %s\n", InFileName, ErrorString );
    exit( 1 );
  }

  if( fwrite( (char *)wav, 2, len, ofp) != len ) {
    perror( "bhdwav" );
    exit( 1 );
  }
  
  exit( 0 );
}

