static char *rcsident = "$Header: /projects/cslu/speech/work/src/bin/auto_lyre/RCS/frame2adata.c,v 4.1 1993/05/07 18:17:20 johans Exp $";

/*
 * FRAME2ADATA.C - convert a sync struct to an adata struct
 *------------------------------------------------------------*
 */

/* Standard C library include file directives */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

/* Lyre include file directives */
#include <adata.h>
#include <syncstruct.h>


/*
 * frame2adata (adata, offsetsP, frame, nframe)
 *
 * Convert a sync structure to an adata structure
 *
 * adata (in/out): Pointer to an adata_t which will be initialized
 * offset(in/out): Pointer to a Pointer for the offeset vector which is
 *                 allocated by this subroutine
 * frame     (in): Input SYNC data
 * nframe    (in): Number of input SYNC structures
 *
 */

frame2adata (adata_t *adata, int **offsetsP, SYNC **frame, int nframe)
{
    register int        fr, cf;
    register short     *sp0;
    register char      *cp0;
    register           *offsets;

    offsets = *offsetsP = (int *) malloc (sizeof (int) * nframe);
    /*
     * Set ns_per_col to 0 if the file format doesn't tel us the correct value.
     * It will be up to someone else to fill this in.
     */
    adata->ns_per_col = 0;
    adata->bsize = 1;
    adata->rows = frame[0]->framesize;
    adata->cols = nframe;
    adata->count = adata->rows * adata->cols;
    adata->col_time = offsets;
    adata->ptr = (float *) malloc (sizeof (char) * adata->count);

    cp0 = (char *) adata->ptr;
    for (fr = 0; fr < nframe; fr++) {
	offsets[fr] = frame[fr]->ref;
	sp0 = frame[fr]->frame;
	cf = adata->rows;
	do {
	    *cp0++ = *sp0++;
	} while (--cf);
    }
}

