/* 
 * color.c - color helper routines
 * 
 * CMY and HSV routines removed 1/12/91 (see RCS file to recover)
 *
 * Author:	Christopher A. Kent
 * 		Western Research Laboratory
 * 		Digital Equipment Corporation
 * Date:	Sun Dec 13 1987
 * Copyright (c) 1987 Christopher A. Kent
 */

/* 
 * See David F. Rogers, "Procedural Elements for Computer Graphics",
 * McGraw-Hill, for the theory behind these routines.
 */


static char rcs_ident[] = "$Header: /projects/cslu/speech/work/src/bin/auto_lyre/RCS/color.c,v 4.1 1993/05/07 18:17:20 johans Exp $";

#include <X11/Xlib.h>
#include "color.h"

#define	MAX_INTENSITY	65535			    /* for X11 */

#define	MIN(a, b)   ((a)<(b)?(a):(b))
#define	MAX(a, b)   ((a)>(b)?(a):(b))

RGB	RGBWhite = { MAX_INTENSITY, MAX_INTENSITY, MAX_INTENSITY };
RGB	RGBBlack = { 0, 0, 0 };


/*
 * void MixRGB(r, alpha, s, beta, t)
 *
 * Mix two RGBs, with scale factors alpha and beta, in RGB space.
 */

void MixRGB(RGB *r, float alpha, RGB *s, float beta, RGB *t)
{
	t->r = MAX(0, MIN(MAX_INTENSITY, (int)(alpha*(r->r) + beta*(s->r))));
	t->g = MAX(0, MIN(MAX_INTENSITY, (int)(alpha*(r->g) + beta*(s->g))));
	t->b = MAX(0, MIN(MAX_INTENSITY, (int)(alpha*(r->b) + beta*(s->b))));
}


/*
 * void RGBToXColor(r, x)
 *
 * Load an XColor with an RGB.
 *
 */

void RGBToXColor(RGB *r, XColor *x)
{
	x->red = r->r;
	x->green = r->g;
	x->blue = r->b;
	x->flags = DoRed | DoGreen | DoBlue;
}


/*
 * void XColorToRGB(x,r)
 *
 * Load an RGB with an XColor
 *
 */

void XColorToRGB(XColor *x, RGB *r)
{
	r->r = x->red ;
	r->g = x->green ;
	r->b = x->blue  ;
}
