/* ScaleP.h - Private Scale Widget Defs
 *------------------------------------------------------------*
 * Copyright 1988, Fil Alleva and Carnegie Mellon University
 *------------------------------------------------------------*
 * HISTORY
 */

#ifndef _XtScaleP_h
#define _XtScaleP_h

#include <Scale.h>
#include <LyreDispP.h>
#include <X11/CoreP.h>

#include <sys/types.h>

/*
 * New fields for the Scale widget instance record
 */
typedef struct {
    GC                  scaleGC;	   /* Pointer to Scale Graphics
					    * Context           */
    Pixel               foreground_pixel;  /* Fore ground color */
    Font                font;		   /* Font to use       */

    Boolean             horizontal;	   /* Display a horizontal scale    */
    Boolean             scale_bottom;	   /* use bottom display for scale  */
    Boolean             scale_left;	   /* use left of display for scale */
    Boolean		show_extent;	   /* Show extent of scale */
    Boolean		count_up;	   /* count same dir as screen coord */

    char               *units_label;	   /* The units label     */
    u_int               fp_digits;	   /* Number digits left of decimal */
    float	 	unit_per_pix;	   /* Units per pixel     */
    float               unit_per_tm;	   /* Unit per tic mark   */
    float               pix_per_tm;	   /* pixels per tic mark */
    u_int               tm_per_mtm;	   /* tick mark per major tic mark */
    u_int               mtm_per_label;	   /* major tick marks per label */

    u_int               minor_tm_length;   /* minor tic mark height */
    u_int               major_tm_length;   /* major tic mark height */
    u_int               max_pix_per_tm;	   /* Max pixels per tm */
    u_int               min_pix_per_tm;	   /* Min pixels per tm */

    int			zero_pix_offset;   /* Offset in pixels for scale 0 */
    int		       *virtual_y;	   /* Offset in pixels of window y0 */

    u_int		ascent;		   /* Ascent of label font  */
    u_int		descent;	   /* Descent of label font */
    u_int		font_width;	   /* Width of widest char  */
    char                ctl_string[256];   /* Control String        */
    XFontStruct		*font_info;	   /* font_struct           */
} ScalePart;

/*
 * Full instance record declaration
 */
typedef struct _ScaleRec {
    CorePart            core;
    LyreDispPart        lyreDisp;
    ScalePart           scale;
} ScaleRec;

/*
 * New fields for the Scale widget class record
 */
typedef struct {
	int keep_compiler_happy_field;
} ScaleClassPart;

/*
 * Full class record declaration.
 */
typedef struct _ScaleClassRec {
    CoreClassPart       core_class;
    LyreDispClassPart   lyreDisp_class;
    ScaleClassPart      scale_class;
} ScaleClassRec;

/*
 * Class pointer.
 */
extern ScaleClassRec scaleClassRec;

#endif _XtScaleP_h


