/* LyreDispP.h - Private LyreDisp Widget Defs
 *------------------------------------------------------------*
 * Copyright 1988, Fil Alleva and Carnegie Mellon University
 *------------------------------------------------------------*
 * HISTORY
 */

#ifndef _XtLyreDispP_h
#define _XtLyreDispP_h

#include <LyreDisp.h>
#include <X11/CoreP.h>

#include <sys/types.h>

/*
 * New fields for the LyreDisp widget instance record
 */
typedef struct {
    float		secs_ppix;	   /* seconds per pixel */
    float		units_psec;	   /* Units per seconds */
    float		units_ppix;	   /* Units per pixel */
    u_int               top_padding;	   /* pixels of top padding */
    u_int               bottom_padding;	   /* pixels of bottom padding */
    u_int               virtual_width;	   /* Virtual width */
    int                 virtual_x;	   /* Vitual x Position of display */
    XtCallbackList      width_proc;	   /* Callbacks for width changes */
    Widget              scroll_widget;     /* The (optional) scroll widget */
    Widget		yoke_widget;	   /* The (optional) yoke widget */
    Widget              toolWidget;        /* The (optional) tool widget */
    GC                  cursorGC;          /* GC for drawing cursor */
    u_int               cursor_x;          /* Location of the x_cursor */
    u_int               cursor_y;          /* Location of the y_cursor */
    float               cursor_time;       /* Time (in secs) of cursor loc */
    float               *cursor_timeP;     /* Pointer to cursor time */
    String              (*pixToHZ)();      /* Subroutine to convert pixels to HZ */
    int                (*hzToPix)();      /* Subroutine to convert HZ to pixels */

}                   LyreDispPart;

/*
 * Full instance record declaration
v */
typedef struct _LyreDispRec {
    CorePart            core;
    LyreDispPart        lyreDisp;
}                   LyreDispRec;

/*
 * New fields for the LyreDisp widget class record
 */
typedef struct {
	int keep_compiler_happy_field;
} LyreDispClassPart;

/*
 * Full class record declaration.
 */
typedef struct _LyreDispClassRec {
    CoreClassPart       core_class;
    LyreDispClassPart   lyreDisp_class;
}                   LyreDispClassRec;

/*
 * Class pointer.
 */
extern LyreDispClassRec lyreDispClassRec;

#endif _XtLyreDispP_h
