/* LolatoolP.h - Private definitions for Lola tool widget
 *------------------------------------------------------------*
 * Copyright 1988, Fil Alleva and Carnegie Mellon University
 *------------------------------------------------------------*
 * HISTORY
 */

#ifndef _XtLolatooltP_h
#define _XtLolatooltP_h

#include <Lolatool.h>
#include <X11/Xaw/FormP.h>

typedef struct _LolatoolClass 
{
    int makes_compiler_happy;	/* not used */
} LolatoolClassPart;

typedef struct _LolatoolClassRec {
    CoreClassPart       core_class;
    CompositeClassPart  composite_class;
    ConstraintClassPart constraint_class;
    FormClassPart       form_class;
    LolatoolClassPart    lolatool_class;
}                   LolatoolClassRec;

extern LolatoolClassRec lolatoolClassRec;

/***************************************
 *
 *  Instance (widget) structure 
 *
 **************************************/

/* New fields for the Lolatool widget record */
typedef struct {
    /* resources */
    Widget              child;		/* Graphic part */
    Boolean		horiz_scale_on;	/* Horizontal scale on */
    Boolean		vert_scale_on;	/* Vertical scale on */
    Widget		hscale;		/* The (optional) hscale widget */
    Widget		vscale;		/* The (optional) vscale widget */
    Widget		scroll;		/* The (optional) scroll widget */
    char		*lyre_label;	/* the tool lable */
}                   LolatoolPart;


/* Full widget declaration */
typedef struct _LolatoolRec {
    CorePart            core;
    CompositePart       composite;
    ConstraintPart      constraint;
    FormPart            form;
    LolatoolPart         lolatool;
}                   LolatoolRec;

typedef struct _LolatoolConstraintsPart
{
    int makes_compiler_happy;	/* not used */
} LolatoolConstraintsPart;

typedef struct _LolatoolConstraintsRec {
    FormConstraintsPart		form;    
    LolatoolConstraintsPart	lolatool;
} LolatoolConstraintsRec, *LolatoolConstraints;

#endif _XtLolatoolP_h
