/*$Header: /projects/cslu/speech/work/src/bin/auto_lyre/RCS/GspecP.h,v 4.4 1993/05/27 21:13:44 johans Exp $*/
/* GspecP.h - Private Gspec Widget Defs
 *------------------------------------------------------------*
 * HISTORY
 *  1-Mar-89  Fil Alleva (faa) at Carnegie-Mellon University
 *	Added linear_data field.
 *
 * 23-Jan-89  Fil Alleva (faa) at Carnegie-Mellon University
 *	Changed look_ahead and look_back fields to integers so that we
 *	could do signed arithmetic on them using the Sun4 compilers.
 *
 * 23-Jan-89  Fil Alleva (faa) at Carnegie-Mellon University
 *	Added max_col_unit field.
 *
 */

#ifndef _XtGspecP_h
#define _XtGspecP_h

#include <Gspec.h>
#include <LyreDispP.h>

#include <sys/types.h>
#include <adata.h>
#include <floattab.h>
#include <gs.h>

/*
 * New fields for the Gspec widget instance record
 */
typedef struct {
    Pixel               foreground_pixel;  /* Foreground Pixel */
    GC                  myGC;		   /* Pointer to Graphics Context */
    Boolean             reverse_video;	   /* Reverse Video Flag */
    XImage             *image;		   /* The gray scale image */
    Pixmap		pixmap;		   /* pointer to pixmap    */
    adata_t            *input_data;	   /* New data is placed here */
    adata_t            *data;		   /* Data object */

    ScaleWidget         hscale_widget;	  /* Hscale widget (if there is one) */
    ScaleWidget         vscale_widget;	  /* Vscale widget (if there is one) */

    Widget              pmin_widget;	   /* pos min value text widget */
    Widget              pmax_widget;	   /* pos max value text widget */
    Widget              nmin_widget;	   /* neg min value text widget */
    Widget              nmax_widget;	   /* neg max value text widget */

    gs_t                gs;		   /* gray scale structure */
    height_t            height;		   /* height structure */
    u_int               pix_per_row;	   /* Pixels per row */
    int                *max_col_data;	   /* max col datum */
    int                *min_col_data;	   /* min col datum */
    int			max_col_unit;	   /* Max Width of Column data
					    * in Units */
    Boolean		linear_data;	   /* TRUE if data is linear and
					    * should NOT be massaged */
    float               sampsPerSec;  /* Sample per second. This is used to
                                       * correct the field in data, that may be
                                       * wrong because the syncstruct file 
                                       * format doesn't encode this.
                                       */
    String		*RowLabels;	   /* Row labels */
    float		start_time;	/* start time of left edage of image */
    float		aoffset;	/* alginment offset of image */
}                   GspecPart;

/*
 * Full instance record declaration
 */
typedef struct _GspecRec {
    CorePart core;
    LyreDispPart lyreDisp;
    GspecPart gspec;
}   GspecRec;

/*
 * New fields for the Gspec widget class record
 */
typedef struct {int dummy;} GspecClassPart;

/*
 * Full class record declaration.
 */
typedef struct _GspecClassRec {
    CoreClassPart core_class;
    LyreDispClassPart lyreDisp_class;
    GspecClassPart gspec_class;
}   GspecClassRec;

/*
 * Class pointer.
 */
extern GspecClassRec gspecClassRec;

#endif _XtGspecP_h




