#ifndef _graph_H_
#define _graph_H_

#include <stdio.h>
#include "search.h"
#include "bisearch.h"
#include "nodes.h"


/*                  BREADTH_GRAPH_

    This class implements a breadth first search algorithm, by generating
    a search GRAPH. It is derived from class SEARCH_.

*/

class BREADTH_GRAPH_ : public SEARCH_
{
    public:
        BREADTH_GRAPH_(NODE_ *, NODE_ *, int);
        int add(NODE_ *);
};



/*                 DEPTH_GRAPH_

    This class implements a depth first search algorithm, by generating
    a search GRAPH. It is derived from class SEARCH_.

*/

class DEPTH_GRAPH_ : public SEARCH_
{
    public:
        DEPTH_GRAPH_(NODE_ *, NODE_ *, int);
        int add(NODE_ *);
};



/*                       BIBREADTH_GRAPH_

    This class implements a bidirectional breadth first search algorithm,
    by generating two search GRAPHs. It is derived from class BISEARCH_.

*/

class BIBREADTH_GRAPH_ : public BISEARCH_
{
    public:
        BIBREADTH_GRAPH_(NODE_ *, NODE_ *, int);
        int add(SORTEDLIST_ *, SORTEDLIST_ *, NODE_ *);
};



/*                    BIDEPTH_GRAPH_

    This class implements a bidirectional depth first search algorithm,
    by generating two search GRAPHs. It is derived from class BISEARCH_.

*/

class BIDEPTH_GRAPH_ : public BISEARCH_
{
    public:
        BIDEPTH_GRAPH_(NODE_ *, NODE_ *, int);
        int add(SORTEDLIST_ *, SORTEDLIST_ *, NODE_ *);
};



/*                  BEST_

    This class implements a best first search algorithm. It is derived
    from class SEARCH_ and processes nodes of class BEST_NODE_ (see bnode.h).
    Classes that are derived from class BEST_NODE_ should have the following
    functions:

    compute_g() : to compute the G-value of a node.
    compute_h() : to compute the H-value of a node.

*/

class BEST_ : public SEARCH_
{
    public:
        BEST_(BEST_NODE_ *, BEST_NODE_ *, int);
        int add(NODE_ *);
        virtual int compute_g(const NODE_ &) = 0;
        virtual int compute_h(const NODE_ &) = 0;
};



/*               UNICOST_GRAPH_

    This class implements a uniform cost search algorithm, by generating
    a search GRAPH. It is derived from class SEARCH_ and processes nodes
    of class UNI_NODE_. Classes that are derived from class UNICOST_G_
    should have the following function:

    compute_g() : to compute the G-value of a node.

*/

class UNICOST_GRAPH_ : public SEARCH_
{
    public:
        UNICOST_GRAPH_(UNI_NODE_ *, UNI_NODE_ *, int);
        int add(NODE_ *);
        virtual int compute_g(const NODE_ &) = 0;
};

#endif
