/*                    AOSEARCH_

    The base class AOSEARCH_ defines a skeleton search class from
    which more the actual search classes such as AODEPTH_TREE_
    are derived, cf. class SEARCH_. It processes objects of class
    AONODE_.

    A class that is derived from AOSEARCH_ should pass the start node
    and the number of operators on to the constructor of AOSEARCH_.
    Also it must be implement the folllowing function:

    is_terminal() :  determines if a node is a terminal node,
                     1 : yes, 0 : no

*/

#ifndef _aosearch_H_
#define _aosearch_H_

#include <stdio.h>
#include "list.h"
#include "nodes.h"
#include "nodes.h"
#include "nodes.h"

class AOSEARCH_
{
    public:
        AOSEARCH_(AONODE_ *start, int numop);
        virtual ~AOSEARCH_();

        void generate();         // starts search process 
        int solve();             // actual search engine together with add()
        void print_sol(AONODE_ *);        // prints solution
        int solvable(AONODE_ *);          // labels nodes SOLVED
        int unsolvable(AONODE_ *);        // labels nodes UNSOLVED
        void prune(int);                  // prunes nodes from open 
        int deletable(AONODE_ *, int);    // determines if a node may be pruned

        virtual void add(AONODE_ *) = 0;                  // adds node to open
        virtual int is_terminal(const AONODE_ &) = 0;     // node is terminal?

    private:
        int
            num_op;         // the number of operators to be used
        AONODE_
              *startnode;       // initial node
    protected:
	LIST_ open,
	      closed;	
};

#endif
