;;; -*- Package: Toolbed; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolbed)

(DEFUN REMEMBER (&REST STUFF) 
                "Remembers something by storing it in an action record"
   (DECLARE (SPECIAL *CURRENT-DRAGON* *MEMORY-ON-FLAG*))
   (LET ((ACTION-RECORD (PCL::*make-instance 'ACTION-RECORD))
         (ENGRAM (SLOT-VALUE *CURRENT-DRAGON* 'CURRENT-ENGRAM)))
        (IF *MEMORY-ON-FLAG*
            (PROGN (SETF (SLOT-VALUE ACTION-RECORD 'INCLUDING-ENGRAM)
                         ENGRAM)
                   (IF (NOT (NULL (SLOT-VALUE
					    ENGRAM 'LAST-ACTION-RECORD)))
                       (PROGN (SETF (SLOT-VALUE ACTION-RECORD
                                           'PREVIOUS-RECORD)
                                    (SLOT-VALUE ENGRAM '
                                           LAST-ACTION-RECORD))
                              (SETF (SLOT-VALUE (SLOT-VALUE
                                                 ENGRAM
                                                 'LAST-ACTION-RECORD)
                                           'NEXT-RECORD)
                                    ACTION-RECORD)
                              (SETF (SLOT-VALUE ENGRAM '
                                           LAST-ACTION-RECORD)
                                    ACTION-RECORD))
                       (PROGN (SETF (SLOT-VALUE ENGRAM '
                                           FIRST-ACTION-RECORD)
                                    ACTION-RECORD)
                              (SETF (SLOT-VALUE ENGRAM '
                                           LAST-ACTION-RECORD)
                                    ACTION-RECORD)))
                   (SETF (SLOT-VALUE ENGRAM 'LAST-ACTION-RECORD)
                         ACTION-RECORD)
                   (SETF (SLOT-VALUE ACTION-RECORD 'BODY)
                         STUFF)
                   (CAR (LAST STUFF))))))
