;;; -*- Package: Xcl-User; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

;;; load file using pcl's defsys for GT Toolset Fafner Release 1.1-DoD

;;;  Copyright, 1988, The Ohio State University. All rights reserved.
;;; 
;;; Comments and bug reports to:
;;; 
;;; Dr. John R. Josephson
;;; The Ohio State University
;;; LAIR, CIS Dept.
;;; 228 CAE Bldg., 2036 Neil Ave.
;;; Columbus, Ohio  43210-2177
;;; 
;;; Netmail: 
;;; 
;;; Comments to: lair-toolset-info@tut.cis.ohio-state.edu
;;; 
;;; Bug reports: lair-toolset-bugs@tut.cis.ohio-state.edu
;;; 

;;; ---------------------------------------------------------------------
;;; Make sure we have pcl.
;;;	Later, load correct compatibility files based on the value of
;;;	pcl::*pcl-system-date*.
;;;  Also load hacked defsystem facility.

;;; ***# Enter site-specific location of pcl's defsys.lsp, and lisp-specific
;;;    extension for defsys here.

(defparameter *pcl-defsys-directory* #-(or :CMU :xerox) "/n/flower/1/toolset/pcl/dec88/"
		     #+:xerox "{lispdev\:}<pcl>dec88>")
(defparameter *pcl-defsys-extensions* #-(or :CMU :xerox) "lsp" 
					#+:CMU "lisp" #+:xerox "dfasl")

(if (not (find-package 'pcl))
    (in-package 'pcl))
(if (not (boundp 'pcl::*pcl-system-date*))
    (progn (load (make-pathname :name "defsys"
				:type user::*pcl-defsys-extensions*
				:defaults user::*pcl-defsys-directory*))
	   (pcl::load-pcl)))

;;; --------------------------------------------------------------------
;;; Create all the packages

(in-package 'pcl)		;hack to deal with kcl package binding

(in-package 'toolbed :use '(lisp pcl))
(in-package 'toolset :use '(lisp pcl toolbed)) 
(in-package 'toolset-user-interface :use '(lisp pcl toolbed)
	    :nicknames '(toolset-u-i))

;;;End up in toolbed package

(in-package 'toolbed)


;;; ---------------------------------------------------------------------
;;; ***#	SITE SPECIFIC GT TOOLSET DIRECTORY	***
;;;
;;; *GT-directory* is a variable which specifies the directory the source
;;; and compiled versions of the GT Toolset are stored in. If the value
;;; is a single pathname, both sources and binaries should be stored in
;;; that directory. It the value is a cons, the car is expected to be the
;;; source directory and the cdr the binary directory. If your system is,
;;; not listed, simply add an entry for it.
;;;

(defparameter *GT-directory*
  #+:Xerox 			(cons (pathname "{LispDev\:}<TOOLSET>")
				     (pathname "{LispDev\:}<TOOLSET>"))
  #+kcl				(cons (pathname "/n/flower/1/toolset/toolset/")
			  (pathname "/n/flower/1/toolset/toolset/kcl-fasl/"))
  #+(and ibcl sun4)	(cons (pathname "/n/flower/1/toolset/toolset/")
			  (pathname "/n/flower/1/toolset/toolset/ibcl4-fasl/"))
  #+(and ibcl sun3)	(cons (pathname "/n/flower/1/toolset/toolset/")
			  (pathname "/n/flower/1/toolset/toolset/ibcl3-fasl/"))
  #+:CMU			(cons (pathname "/usr1/toolset/toolset/")
				      (pathname "/usr1/toolset/toolset/"))
  #+(and excl sun4)		(cons (pathname "/n/flower/1/toolset/toolset/")
 			 (pathname "/n/flower/1/toolset/toolset/fcl4-fasl/"))
  #+(and excl sun3)		(cons (pathname "/n/flower/1/toolset/toolset/")
			 (pathname "/n/flower/1/toolset/toolset/fcl3-fasl/"))
  #+(and :coral (not excl))	(cons (pathname "")
				      (pathname ""))
)

;; this is a hack, fix it -- do a gt-extensions

#+xerox (setf pcl::*pathname-extensions* '("lsp" . "dfasl"))

;;; --------------------------------------------------------------------
;;; ***#		*Copyright-String*	       ***
;;;
;;; *Copyright-string* is a convenient (for us) system variable used to
;;; store/print the copyright notice appropriate for your installation.
;;; The series of lines below tries to deduce the installation from the
;;; value of *features*, and to add a new *feature* for the installation.
;;; If your installation does not appear below, (or the code below fails
;;; in your case), please add the appropriate *feature* here. (See the
;;; file copyright-string.lsp for the correct feature for your installation.)

;;; We want to have the following mapping from installations to features:
;;;	installation  		feature
;;;	  I.B.M			 ibm
;;;	 Texas Instruments	texasinst
;;;	  J.P.L			 jpl
;;;	  DEC			 dec
;;;	  O.S.U.		 osu
;;; etc.
;;;  Please edit this form to push the correct feature for your installation.
;;;  If you're not sure of what features to use (#+thing), simply
;;;  replace the form by (push 'installation-feature *features*)

(push
 #+:CMU 'ibm
 #+(and dec vax common) 'dec
 #+TI 'texasinst
 #+(or kcl :xerox :coral excl ibcl) ':osu
 *features*)

(if (probe-file (make-pathname :name "copyright-string"
			       :type (cdr pcl::*pathname-extensions*)
			       :defaults 
			       (cdr toolbed::*GT-directory*)))
    (load (make-pathname :name "copyright-string"
			 :type (cdr pcl::*pathname-extensions*)
			 :defaults 
			 (cdr toolbed::*GT-directory*)))
    (load (make-pathname :name "copyright-string"
			 :type (car pcl::*pathname-extensions*)
			 :defaults 
			 (car toolbed::*GT-directory*))))


;;; ---------------------------------------------------------------------
;;; ***			 PCL compatibility		***
;;;
;;; We have pcl. Now make sure it's one of the right PCL's, load whatever
;;; compatibility stuff is needed.

(cond
;;; None of the compatibility stuff is set up at the moment -- it's getting
;;; much too difficult to support, and PCL itself is rapidly getting more
;;; stable & portable. If you must use an older pcl, email to
;;; toolset-bugs (address in manual) for instructions on how to do it.

;; ((equal pcl::*pcl-system-date* "2/3/88  Febuary 3rd 1988")
;;  (in-package 'pcl)
;;  (if (probe-file (make-pathname :name "feb3-compat"
;;				 :type (cdr pcl::*pathname-extensions*)
;;				 :defaults 
;;				 (cdr toolbed::*GT-directory*)))
;;      (load (make-pathname :name "feb3-compat"
;;			   :type (cdr pcl::*pathname-extensions*)
;;			   :defaults 
;;			   (cdr toolbed::*GT-directory*)))
;;      (load (make-pathname :name "feb3-compat"
;;			   :type (car pcl::*pathname-extensions*)
;;			   :defaults 
;;			   (car toolbed::*GT-directory*))))
;;  (in-package 'toolbed)
;;  (if (probe-file (make-pathname :name "init-instance"
;;				 :type (cdr pcl::*pathname-extensions*)
;;				 :defaults 
;;				 (cdr toolbed::*GT-directory*)))
;;      (load (make-pathname :name "init-instance"
;;			   :type (cdr pcl::*pathname-extensions*)
;;			   :defaults 
;;			   (cdr toolbed::*GT-directory*)))
;;      (load (make-pathname :name "init-instance"
;;			   :type (car pcl::*pathname-extensions*)
;;			   :defaults 
;;			   (car toolbed::*GT-directory*)))))

;; ((or (equal pcl::*pcl-system-date* "3/17/88  St. Patrick's Day PCL")
;;      (equal pcl::*pcl-system-date* "3/10/88  March 10th 1988"))
;;  (in-package 'pcl)
;;  (if (probe-file (make-pathname :name "mar17-compat"
;;				 :type (cdr pcl::*pathname-extensions*)
;;				 :defaults 
;;				 (cdr toolbed::*GT-directory*)))
;;      (load (make-pathname :name "mar17-compat"
;;			   :type (cdr pcl::*pathname-extensions*)
;;			   :defaults 
;;			   (cdr toolbed::*GT-directory*)))
;;      (load (make-pathname :name "mar17-compat"
;;			   :type (car pcl::*pathname-extensions*)
;;			   :defaults 
;;			   (car toolbed::*GT-directory*)))))

 ((equal pcl::*pcl-system-date* "12/7/88   Can't think of a cute name PCL")

  ;; do nothing -- these are compatible with the current state
  ;; of things
  nil)

 ;; else -- this is not a pcl we can cope with, signal an error
 (t (error 
     "Sorry, ~S is not a CLOS release that can currently be used with the GT toolset." 
     pcl::*pcl-system-date*)))


;;; ---------------------------------------------------------------------
;;; ***			     Defsystem				***
;;;
;;; PCL's defsystem facility lacks a few useful variations, so load
;;; the hacked version that adds them (also takes care of the problem
;;; of PCL's too early to have defsystem).

(in-package 'pcl)

;;; NOTE: this will only change the value of pcl::*pathname-extensions*
;;; if it does not have a value at the time this file is loaded (for
;;; compatiblity with older pcl's, etc). If you want to change the
;;; value of *pathname-extensions* to allow you to have different
;;; extensions on you files, either edit pcl's defsys.lsp (in which case
;;; the toolset files must have the same extensions as the pcl files),
;;; or use SET to change the value of *pathname-extensions* before loading
;;; the defsystems in load-toolset. (Include the SET in here.)


(defvar *pathname-extensions*
  (let ((files-renamed-p t)
        (proper-extensions
          (car
           '(#+Symbolics                         ("lisp"  . "bin")
             #+(and dec common vax (not ultrix)) ("LSP"   . "FAS")
             #+(and dec common vax ultrix)       ("lsp"   . "fas")
             #+KCL                               ("lsp"   . "o")
             #+Xerox                             ("lsp"  . "dfasl")
             #+(and Lucid MC68000)               ("lisp"  . "lbin")
             #+(and Lucid VAX VMS)               ("lisp"  . "vbin")
             #+(and Lucid Prime)                 ("lisp"  . "pbin")
	     #+(and Lucid SUNRise)               ("lisp"  . "sbin")
             #+(and Lucid IBM-RT-PC)             ("lisp"  . "bbin")
	     ;; change (and excl allegro) from lisp to lsp so that
	     ;;we can share source with kcl
             #+(and excl allegro)                ("lsp"  . "fasl")
	     #+(and excl (not allegro))          ("cl"    . "fasl")
             #+:CMU                              ("slisp" . "sfasl")
             #+HP                                ("l"     . "b")
             #+TI ("lisp" . #.(string (si::local-binary-file-type)))
             #+:gclisp                           ("LSP"   . "F2S")
             #+pyramid                           ("clisp" . "o")
             #+:coral                            ("lisp"  . "fasl")
             ))))
    (cond ((null proper-extensions) '("l" . "lbin"))
          ((null files-renamed-p) (cons "lisp" (cdr proper-extensions)))
          (t proper-extensions))))


(if (probe-file (make-pathname :name "defsystem"
				     :type (cdr pcl::*pathname-extensions*)
				     :defaults 
				     (cdr toolbed::*GT-directory*)))
	  (load (make-pathname :name "defsystem"
			       :type (cdr pcl::*pathname-extensions*)
			       :defaults 
			       (cdr toolbed::*GT-directory*)))
	  (load (make-pathname :name "defsystem"
			       :type (car pcl::*pathname-extensions*)
			       :defaults 
			       (car toolbed::*GT-directory*))))


;;; ---------------------------------------------------------------------
;;; ***			     GT-toolbed				***
;;;
;;; This defsystem contains the files necessary to load the GT Toolbed,
;;; which the GT Toolset is written on top of.

(in-package 'toolbed)

(pcl::defsystem toolbed::GT-toolbed *GT-directory*
  ;;file	load		compile		files which	port
  ;;		environment	environment	force the 
  ;;						recompilation
  ;;						of this file
  ((lair-object	()		()		()			)
   (lair-agent	(lair-object)	(lair-object)	(lair-object)		)
   (data-structures
		(lair-object)	(lair-object)	(lair-object)		)
   (dragon	(lair-agent)	(lair-agent)	(lair-agent)		)
   (monitor	(data-structures)(data-structures)(data-structures)	)
   (engram	(data-structures)(data-structures)(data-structures)	)
   (action-record
		(data-structures)(data-structures)(data-structures)	)
   (transaction-record
     		(action-record)	(action-record)	(action-record)		)
   (utility-functions
   		()		()		()			)
   (invoke	(engram dragon transaction-record)
				(engram dragon transaction-record) 
						(utility-functions)	)
   (remember	(action-record)	(action-record)	()			)
   (monitor-code (monitor)	(monitor)	(monitor)		)
   (nuke-em-file (engram dragon transaction-record)
				(engram dragon transaction-record) () )
   (import-export-symbols
		()		()		()			)))
   


;;; ---------------------------------------------------------------------
;;; ***			     GT-toolset			***
;;;
;;; This defsystem contains the files necessary to load the GT toolset,
;;; including RA, CSRL, and a (very) minimal IDB.

(in-package 'toolset)

(pcl::defsystem GT-toolset toolbed::*GT-directory*
  ;;file	load		compile		files which	port
  ;;		environment	environment	force the 
  ;;						recompilation
  ;;						of this file
  ((recognition-agent
		()		()		()			)
  (match-1-ra
		(recognition-agent) (recognition-agent) (recognition-agent))
  (discrete-pattern-ra
    		(recognition-agent) (recognition-agent) (recognition-agent))
  (free-form-ra
    		(recognition-agent) (recognition-agent) (recognition-agent))
  (idb-classes	()		()		()			)
  (classification-specialist
   		()		()		()			)
  (classifier	()		()		()			)
  (hierarchy	()		()		()			)

  (define-confidence-set
		(utility-functions) (utility-functions) (utility-functions))
  (confidence	(define-confidence-set)	(define-confidence-set)
		(define-confidence-set))
  (confidence-conversions (define-confidence-set) (define-confidence-set)
		(define-confidence-set))

  (define-ra	(recognition-agent) (recognition-agent) ()		)
  (define-idb	(idb-classes)	(idb-classes)		(utility-functions))
  (define-cs
    		(classification-specialist) (classification-specialist) ())
  (define-classifier (classifier) (classifier)		(utility-functions))
			
  (ask-idb	(idb-classes confidence) (idb-classes confidence)
						(define-confidence-set)	)

  (stuff-ra-slots ()		()		()			)
  (parse-ra-slots (confidence)	(confidence) 
		  		      (confidence define-confidence-set
						  utility-functions))
  (apply-test     (confidence)	(confidence) 
		  		      (confidence define-confidence-set
						  utility-functions))
  (parse-transforms (confidence) (confidence)	
	    	    (define-confidence-set confidence confidence-conversions))
  (transform-invokes ()		()		()			)

  (fetch-feature	()	()		()			)
  (controllers	()		()		(utility-functions)     )
  (dragon-concepts	()	()		()			)
  (match-pattern	()	()		()			)

  (compile-match-1-ra (match-1-ra) (match-1-ra) (utility-functions))
  (compile-disc-patt-ra (discrete-pattern-ra) (discrete-pattern-ra) 
							(utility-functions))
  (compile-free-form-ra (free-form-ra) (free-form-ra) (utility-functions))

  (build-match-1-jl (match-1-ra) (match-1-ra)	()			)
  (build-discrete-pattern-jl (discrete-pattern-ra) (discrete-pattern-ra) ())

  (user-dragon	(define-ra compile-free-form-ra)
		(define-ra compile-free-form-ra)
		(define-ra compile-free-form-ra))
  (puff-start	()		()		()			)

  (csrl		(classification-specialist) (classification-specialist)
							(utility-functions))
  (cs-queries	()		()		()			)
  (context	(csrl cs-queries) (csrl cs-queries) (csrl cs-queries)	)

  (save-dragon	(match-1-ra free-form-ra discrete-pattern-ra
		idb-classes classification-specialist classifier hierarchy)
		(match-1-ra free-form-ra discrete-pattern-ra
		idb-classes classification-specialist classifier hierarchy)
		(utility-functions))

  (displays	()		()		(utility-functions))
  (monitor-ra	(recognition-agent) (recognition-agent) (recognition-agent))
  (trace-ra (recognition-agent) (recognition-agent) (recognition-agent
						     utility-functions))
  (justification (classification-specialist match-1-ra discrete-pattern-ra)
		 (classification-specialist match-1-ra discrete-pattern-ra)
	 			(hierarchy cs-queries utility-functions))
  (traced-tests	()		()		()			)))


;;; ---------------------------------------------------------------------
;;; ***			     GT-user-interface			***
;;;
;;; This defsystem contains the files for the GT user interface, which,
;;; at the moment, is rather minimal.

(in-package 'toolset-user-interface)

(pcl::defsystem GT-user-interface toolbed::*GT-directory*
  ((trace-functions 	()	()		()			)))


;;; ----------------------------------------------------------------------
;;; ***			   load-toolset			      ***

(in-package 'user)
(defun toolbed::load-toolset 
  (&optional &key (toolbed::sources nil) (toolbed::query nil))

  ;; assume PCL is loaded (see beginning of file) - we would have
  ;; died before now if we didn't have it (no defsystem), and the
  ;; code at the beginning of the file loads it

  (in-package "TOOLBED")
  (if toolbed::query
      (if toolbed::sources
	  (pcl::operate-on-system 'toolbed::GT-toolbed :query-load-source)
	  (pcl::operate-on-system 'toolbed::GT-toolbed :query-load))
      (if toolbed::sources
	  (pcl::operate-on-system 'toolbed::GT-toolbed :load-source)
	  (pcl::operate-on-system 'toolbed::GT-toolbed :load)))

  (defparameter toolbed::*invocation-single-step* nil)
  (defparameter toolbed::*invocation-trace-flag* t)
  (defparameter toolbed::*decision-support-mode* nil)
  (defparameter toolbed::*memory-on-flag* t)
  (defparameter toolbed::*idb-flushed-list* '())
  (defparameter toolbed::*puff* nil)
  (defparameter toolbed::*current-dragon* nil)
  (defparameter toolbed::*current-case* nil)

  ;; import-export-symbols is defined in IMPORT-EXPORT-SYMBOLS.LISP,
  ;; which was loaded with GT-toolbed

  (toolbed::import-export-symbols)


  (in-package "TOOLSET")

  (defparameter toolset::*verb-list* 
    '(toolset::judge toolset::ask toolset::ask-user toolset::establish-refine 
	    toolset::establish toolset::refine toolset::stipulate 
	    toolset::tell-me-about))
  (defparameter toolset::*associated-concepts-list* nil)
  (defparameter toolset::*csrl-establish-threshold* 'toolset::likely)
  (defparameter toolset::*csrl-suspend-threshold* 'toolset::neutral)
  (defparameter toolset::*compile-controller* t)
  (defparameter toolset::*idb-use-saved-cases* t)
  (defparameter toolset::*cs-use-cache* t)
  (defparameter toolset::*context-type-default* 'toolset::establish)

  (if toolbed::query
      (pcl::operate-on-system 'toolset::GT-toolset :query-load)
      (pcl::operate-on-system 'toolset::GT-toolset :load))


  (in-package "TOOLSET-U-I")
  (if toolbed::query
      (pcl::operate-on-system 'toolset-u-i::GT-user-interface :query-load)
      (pcl::operate-on-system 'toolset-u-i::GT-user-interface :load))

  (in-package "TOOLSET")
  (toolset::hatch-puff)
  (setf toolbed::*current-dragon* toolbed::*puff*)

  (format *trace-output* 
	"~%*** Generic Task Toolset -- Fafner Release 1.1-DoD ***~%")
  (format *trace-output* "~%~S~%" toolbed::*copyright-string*)
)


;;; ---------------------------------------------------------------------
;;; ***			     compile-toolset			***


(defun toolbed::compile-toolset (&optional (all nil))

  (in-package 'toolbed)
  (if all
      (pcl::operate-on-system 'toolbed::GT-toolbed :recompile)
      (pcl::operate-on-system 'toolbed::GT-toolbed :compile))


  (defparameter toolbed::*invocation-single-step* nil)
  (defparameter toolbed::*invocation-trace-flag* t)
  (defparameter toolbed::*decision-support-mode* nil)
  (defparameter toolbed::*memory-on-flag* t)
  (defparameter toolbed::*idb-flushed-list* '())
  (defparameter toolbed::*puff* nil)
  (defparameter toolbed::*current-dragon* nil)
  (defparameter toolbed::*current-case* nil)

  (toolbed::import-export-symbols) ;; defined in IMPORT-EXPORT-SYMBOLS.LISP,
				;; which was loaded with GT-toolbed

  (in-package 'toolset)

  (defparameter toolset::*verb-list* 
    '(toolset::judge toolset::ask toolset::ask-user toolset::establish-refine 
	    toolset::establish toolset::refine toolset::stipulate 
	    toolset::tell-me-about))
  (defparameter toolset::*associated-concepts-list* nil)
  (defparameter toolset::*csrl-establish-threshold* 'toolset::likely)
  (defparameter toolset::*csrl-suspend-threshold* 'toolset::neutral)
  (defparameter toolset::*compile-controller* t)
  (defparameter toolset::*idb-use-saved-cases* t)
  (defparameter toolset::*cs-use-cache* t)
  (defparameter toolset::*context-type-default* 'toolset::establish)

  (if all
      (pcl::operate-on-system 'toolset::GT-toolset :recompile)
      (pcl::operate-on-system 'toolset::GT-toolset :compile))

  (in-package 'toolset-u-i)

  (if all
      (pcl::operate-on-system 'toolset-u-i::GT-user-interface :recompile)
      (pcl::operate-on-system 'toolset-u-i::GT-user-interface :compile))

  (in-package 'toolset)
  (format *trace-output* "Toolset compiled.~%"))

;;; ---------------------------------------------------------------------


(export '(toolbed::load-toolset
	  toolbed::compile-toolset)
	(find-package "TOOLBED"))

(in-package 'user)
(import '(toolbed::load-toolset toolbed::compile-toolset)
	(find-package "USER"))
(in-package 'toolset)

