;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)

(DEFUN CHECK-FEATURE (FEATURE-NUMBER) 
                "Check feature, cache results. Numbers starting with 0"
   (DECLARE (TYPE INTEGER FEATURE-NUMBER)
          (SPECIAL *CURRENT-DRAGON*)
          (OPTIMIZE SPEED))
   (LET (
       
       ;; read the cache

         (FEATURE-VAL (AREF (SLOT-VALUE *CURRENT-DRAGON* 'FEATURE-CACHE
                                   )
                            FEATURE-NUMBER)))
        (COND
       
       ;; if it's not there:

           ((EQ FEATURE-VAL 'UNFETCHED)
       
       ;; get the value:

            (SETF FEATURE-VAL (EVAL (AREF (SLOT-VALUE *CURRENT-DRAGON*
                                                 'FEATURES)
                                          FEATURE-NUMBER)))
       
       ;; display it if appropriate, stuff the cache,  and
       ;; return the value:

            (SETF (AREF (SLOT-VALUE *CURRENT-DRAGON* 'FEATURE-CACHE)
                        FEATURE-NUMBER)
                  FEATURE-VAL)
            (RETURN-FROM CHECK-FEATURE FEATURE-VAL))
       
       ;;  if it's there, just return the value:

           (T (RETURN-FROM CHECK-FEATURE FEATURE-VAL)))))


(DEFUN FETCH-TRANSFORMED-FEATURE (FEATURE-NUMBER) "Calls check feature to get the cached feature value, applies the appropriate transform to it and returns it."
   (DECLARE (TYPE INTEGER FEATURE-NUMBER)
          (SPECIAL *CURRENT-DRAGON*))
   (LET ((REPLY NIL) (transformed-val nil))
        (SETF REPLY (CHECK-FEATURE FEATURE-NUMBER))
	
        (SETF transformed-val (APPLY (AREF (SLOT-VALUE *CURRENT-DRAGON*
                                        'TRANSFORMS)
                                 FEATURE-NUMBER)
                           (LIST REPLY)))
	(remember 'FEATURE-NUMBER= feature-number
		  'before-transform= reply 'after-transform=
		  transformed-val)
        (RETURN-FROM FETCH-TRANSFORMED-FEATURE transformed-val)))


(DEFUN FLUSH-FEATURE-CACHE NIL "all values set to 'UNFETCHED"
                               (DECLARE (SPECIAL *CURRENT-DRAGON*))
                               (SETF (SLOT-VALUE *CURRENT-DRAGON*
                                            'FEATURE-CACHE)
                                     (MAKE-ARRAY
                                      (LIST (SLOT-VALUE 
                                                   *CURRENT-DRAGON*
                                                   'NUMBER-OF-FEATURES)
                                            )
                                      :INITIAL-ELEMENT
                                      'UNFETCHED)))

