;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)

(DEFMACRO DEFINE-RECOGNITION-AGENT (RA-NAME RA-TYPE &BODY GT-CODE)
   (IF (NULL GT-CODE)
       (ERROR "Error in the recognition agent definition of ~S. Nothing was specified." 
              RA-NAME))
   `(LET (TEMP)
         (FORMAT *TRACE-OUTPUT* "~%~%~%~%~%")
         (IF (AND (BOUNDP ',RA-NAME)
                  (TYPEP ,RA-NAME 'DRAGON))
             (PROGN (FORMAT *TRACE-OUTPUT* 
                           "Destroying old version of ~S.~%"
                           ',RA-NAME)
                    (TOOLBED::DESTROY ,RA-NAME)
                    (FORMAT *TRACE-OUTPUT* 
                           "Making new instance of ~S named ~S.~%"
                           ',RA-TYPE
                           ',RA-NAME)
                    (SETF ,RA-NAME (PCL::*make-instance ',RA-TYPE)))
             (PROGN (FORMAT *TRACE-OUTPUT* 
                           "Making new instance of ~S named ~S.~%"
                           ',RA-TYPE
                           ',RA-NAME)
                    (DEFPARAMETER ,RA-NAME 
		      		(PCL::*make-instance ',RA-TYPE))))
         (SETF (SLOT-VALUE ,RA-NAME 'UNIQUE-NAME)
               ',RA-NAME)
         (FORMAT *TRACE-OUTPUT* "Compiling ~S. ~%" ',RA-NAME)
         (COMPILE-dragon-type ',RA-NAME ,RA-NAME
                ',GT-CODE)))

