;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)

(defmacro get-establish-threshold (cs)
  `(let ((cs (if (typep ,cs 'classification-specialist) ,cs (eval ,cs))))
     (if (slot-value cs 'establish-threshold)
	 (slot-value cs 'establish-threshold) 
         *csrl-establish-threshold*)))

(defmacro get-suspend-threshold (cs)
  `(let ((cs (if (typep ,cs 'classification-specialist) ,cs (eval ,cs))))
     (if (slot-value cs 'suspend-threshold)
	(slot-value cs 'suspend-threshold)
         *csrl-suspend-threshold*)))


(DEFMACRO GET-LAST-establish-THRESHOLD (CS)
  `(SLOT-VALUE (if (typep ,cs 'classification-specialist)
		    ,cs (eval ,CS))
	       'LAST-establish-THRESHOLD))

(DEFMACRO GET-LAST-suspend-THRESHOLD (CS) 
  `(SLOT-VALUE (if (typep ,cs 'classification-specialist)
		    ,cs (eval ,CS))
	       'LAST-suspend-THRESHOLD))


(DEFun get-refine-result (CS &optional (case *current-case*))
  (let ((cs (if (typep cs 'classification-specialist) cs (eval cs))))
     (if (not (equal (slot-value cs 'case) case))
       nil
       (slot-value cs 'refine-result))))

(DEFun GET-STATUS (CS &optional (case *current-case*))
  (let ((cs (if (typep cs 'classification-specialist) cs (eval cs))))
     (if (equal (slot-value cs 'case) case)
	 (SLOT-VALUE CS 'STATUS)
         'not-run)))



(DEFun GET-LAST-RESULT (CS &optional (case *current-case*))
  (let ((cs (if (typep cs 'classification-specialist) cs (eval cs))))
     (if (not (equal (slot-value cs 'case) case))
	 nil
         (SLOT-VALUE Cs 'LAST-RESULT))))

(DEFMACRO HIERARCHY-COMPLETE? (CLASSIFIER) `(not (SLOT-VALUE ,CLASSIFIER
                                                   'UNRESOLVED)))


(defun hierarchy-ok? (classifier)
  "Checks function for completeness and internal consistency."
  (let ((multi-parents nil) (no-parents nil))
    (if (not (hierarchy-complete? classifier))
	(format t
		"The hierarchy is incomplete. Nodes ~S are undefined.~%"
		(mapcar #'car (slot-value classifier 'unresolved))))
    (dolist (node (get-nodes classifier))
	    (case (length (get-supers node classifier))
		  (0 (setf no-parents (cons node no-parents)))
		  (1 nil)
		  (otherwise (setf multi-parents (cons node multi-parents)))))
    (if (not (= (length no-parents) 1))
	(format t 
		"The hierarchy does not have a single root node -- nodes ~S have no parents.~%" no-parents))
    ;; check for nodes with multiple or-joined parents, whose parents
    ;; have exclusive subs
    (if multi-parents
	(progn
	  (format t
		  "The hierarchy is not a tree. Some nodes have more than one parent. This is acceptable, but should be noted.~%")
	  (dolist (node multi-parents)
		  (if (eq (slot-value (eval node) 'parent-join) 'or)
		      (dolist (parent (get-supers node classifier))
			      (if (member 'exclusive 
 				  (slot-value (eval parent) 'child-join))
				  (format t
					  "The node ~S has multiple parents, including ~S who has an exclusive child-join. This is an inconsistent situation.~%"
					  node parent)))))))))




(defmacro get-case (dragon)
  `(let ((drag (if (symbolp ,dragon)
		   (eval ,dragon)
		   ,dragon)))
     (cond ((typep drag 'classification-specialist)
	    (if (not (slot-empty-p drag 'case))
		(slot-value drag 'case)
	        nil))
	   ((typep drag 'dragon)
	    (if (not (slot-empty-p drag 'current-engram))
		(if (not (slot-empty-p (slot-value drag 'current-engram)
				       'case))
		    (slot-value (slot-value drag 'current-engram) 'case)
		    nil)
	        nil))
	   (t (error "GET-CASE: ~S is not a dragon or the name of a dragon."
		     ,dragon)))))


(DEFMACRO LOCAL-establish-THRESHOLD? (CS) 
     `(SLOT-VALUE (if (typep ,cs 'classification-specialist)
			 ,cs (eval ,cs))
		    'establish-THRESHOLD))

(DEFMACRO LOCAL-suspend-THRESHOLD? (CS) 
     `(SLOT-VALUE (if (typep ,cs 'classification-specialist)
			 ,cs (eval ,cs))
		    'suspend-THRESHOLD))


(DEFMACRO RUN-YET? (CS &optional (case *current-case*))
  `(let ((cs (if (typep ,cs 'classification-specialist) ,cs (eval ,cs))))
     (if (not (equal (slot-value cs 'case) ',case))
       nil
       (NOT (EQUAL (SLOT-VALUE  Cs 'STATUS) 'NOT-RUN)))))



(defmacro propagate? (classifier)
  `(let ((classifier (if (typep ,classifier 'classifier)
			 ,classifier
		         (eval ,classifier))))
     (slot-value classifier 'propagate-status)))

(defmacro propagation-on (classifier)
  `(let ((classifier (if (typep ,classifier 'classifier)
			 ,classifier
		         (eval ,classifier))))
     (setf (slot-value classifier 'propagate-status) t)))

(defmacro propagation-off (classifier)
  `(let ((classifier (if (typep ,classifier 'classifier)
			 ,classifier
		         (eval ,classifier))))
     (setf (slot-value classifier 'propagate-status) nil)))

