;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)

(DEFMETHOD COMPILE-dragon-type (RA-NAME (RA-INSTANCE 
                                              MATCH-1-RECOGNITION-AGENT
                                                     )
                                            GT-CODE-BODY) 
                  "Compiles a match-1-recognition-agent specification."
   (LET
    ((MANDATORIES '(FEATURES PATTERNS AUTHOR))
     (FORBIDDEN '(JUDGE-LAMBDA HIERARCHY TOP-NODE MATCH-ACTION 
                        MATCH-CONFIDENCE PATTERN SUCCESS-THRESHOLD 
                        COMPONENTS)))
    (FORMAT *TRACE-OUTPUT* 
           "Storing the specifications into the appropriate slots.~%")
       
       ;; next, stuff the rest of the slots, checking that all
       ;; of the MANDATORIES and none of the FORBIDDEN list are
       ;; present

    (IF (EQUAL (STUFF-RA-SLOTS RA-INSTANCE GT-CODE-BODY MANDATORIES 
                      FORBIDDEN)
               'FREE-FORM)
        (RETURN-FROM COMPILE-dragon-type
               (EVAL `(DEFINE-RECOGNITION-AGENT ,RA-NAME 
                             FREE-FORM-RECOGNITION-AGENT ,@GT-CODE-BODY
                             ))))
    (FORMAT *TRACE-OUTPUT* "Adding default values.~%")
    (IF (slot-empty-p ra-instance 'display-name)
        (SETF (SLOT-VALUE RA-INSTANCE 'DISPLAY-NAME)
              (SYMBOL-NAME (SLOT-VALUE RA-INSTANCE 'UNIQUE-NAME))))
    (IF (slot-empty-p ra-instance 'display-no-match-confidence)
        (SETF (SLOT-VALUE RA-INSTANCE 'DISPLAY-NO-MATCH-CONFIDENCE)
              'NEUTRAL))
    (IF (slot-empty-p ra-instance 'output-confidence-vocabulary)
        (SETF (SLOT-VALUE RA-INSTANCE 'OUTPUT-CONFIDENCE-VOCABULARY)
              USUAL-9-VAL-GENERIC-INSTANCE))
       
       ;; arrange to set up confidence set, and parse up the
       ;; controller

    (FORMAT *TRACE-OUTPUT* "Setting up parsed controller. ~%")

    (SETF (SLOT-VALUE RA-INSTANCE 'PARSED-CONTROLLER) NIL)
    (SETF (SLOT-VALUE RA-INSTANCE 'PARSED-TRACING-CONTROLLER) NIL)

    (IF (NOT (slot-empty-p ra-instance 'control-additions))
        (PARSE-CONTROLLER-SLOT RA-INSTANCE 'MATCH-1-RECOGNITION-AGENT))
       
       ;; set up features, patterns, transforms

    (LET
     ((NUMB-PATTERNS (SLOT-VALUE RA-INSTANCE 'NUMBER-OF-PATTERNS))
      (NUMB-FEATURES (SLOT-VALUE RA-INSTANCE 'NUMBER-OF-FEATURES))
       
       ;; temporary var for holding the transform result types
       ;; for parse-features type-checking

      (TRANSFORM-RESULT-TYPES NIL))
     (FORMAT *TRACE-OUTPUT* "Checking that each pattern has the same number of tests as there are features to match. ~%"
            )
     (DOLIST (PATT (SLOT-VALUE RA-INSTANCE 'PATTERNS))
            (IF (NOT (= (LENGTH PATT)
                        NUMB-FEATURES))
                (ERROR "ERROR in the specification of match-1 RA ~S. The pattern ~S doesn't have the right number of tests. ~%" 
                       RA-NAME PATT)))
     (IF (NOT (slot-empty-p ra-instance 'display-transforms))
         (PROGN (FORMAT *TRACE-OUTPUT* "Checking that there are the same number of transforms as there are features.~%"
                       )
                (IF (NOT (= NUMB-FEATURES (LENGTH (SLOT-VALUE
                                                   RA-INSTANCE
                                                   'DISPLAY-TRANSFORMS)
                                                 )))
                    (ERROR "ERROR in the specification of RA ~S. The number of transforms does not equal the number of features.~%" 
                           RA-NAME))))
     (FORMAT *TRACE-OUTPUT* "Transforming the feature specs to runnable form, setting up if-needed triggers.~%"
            )
       
       ;; parse-features sets up FEATURES, FEATURE-FETCH-TYPES,
       ;; and FEATURE-VALUE-TYPES slots

     (PARSE-FEATURES RA-INSTANCE)
     (FORMAT *TRACE-OUTPUT* "Building runnable form of transforms.~%")
     (IF (slot-empty-p ra-instance 'display-transforms)
         (PROGN (SETF (SLOT-VALUE RA-INSTANCE 'TRANSFORMS)
                      (MAKE-ARRAY (LIST NUMB-FEATURES)
                             :INITIAL-ELEMENT NIL))
                (SETF TRANSFORM-RESULT-TYPES (SLOT-VALUE RA-INSTANCE
                                                    '
                                                    FEATURE-VALUE-TYPES
                                                    )))
         (PROGN 
       
       ;; parse-transforms returns two values - a vector
       ;; containing the parsed transforms, and a vector
       ;; listing the confidence set resulting from applying
       ;; each transform, used for type-checking in
       ;; parse-features

                (SETF TRANSFORM-RESULT-TYPES
                      (MULTIPLE-VALUE-LIST (PARSE-TRANSFORMS
                                            (SLOT-VALUE RA-INSTANCE
                                                   'DISPLAY-TRANSFORMS)
                                            (SLOT-VALUE RA-INSTANCE
                                           'OUTPUT-CONFIDENCE-VOCABULARY)
                                            (SLOT-VALUE RA-INSTANCE
                                                   'FEATURE-VALUE-TYPES
                                                   ))))
                (SETF (SLOT-VALUE RA-INSTANCE 'TRANSFORMS)
		      (CAR TRANSFORM-RESULT-TYPES))
                (SETF TRANSFORM-RESULT-TYPES (CADR 
                                                 TRANSFORM-RESULT-TYPES
                                                   ))))
     (FORMAT *TRACE-OUTPUT* 
            "Stuffing the pattern specs into an array.~%")
     (SETF (SLOT-VALUE RA-INSTANCE 'DISPLAY-BLOCK)
           (MAKE-ARRAY (LIST NUMB-PATTERNS NUMB-FEATURES)
                  :ELEMENT-TYPE
                  (OR 'SYMBOL 'CONS)
                  :INITIAL-CONTENTS
                  (SLOT-VALUE RA-INSTANCE 'PATTERNS)))
     (FORMAT *TRACE-OUTPUT* 
            "Make an array to hold tests in runnable form.~%")
     (SETF (SLOT-VALUE RA-INSTANCE 'TEST-BLOCK)
           (MAKE-ARRAY (LIST NUMB-PATTERNS NUMB-FEATURES)
                  :ELEMENT-TYPE
                  (OR 'SYMBOL 'CONS)))
     (FORMAT *TRACE-OUTPUT* 
            "Transform the tests in the spec array to runnable form.~%"
            )
     (DOTIMES (I NUMB-PATTERNS)
            (DOTIMES (J NUMB-FEATURES)
                   (SETF (AREF (SLOT-VALUE RA-INSTANCE 'TEST-BLOCK)
                               I J)
                         (PARSE-TEST (AREF (SLOT-VALUE RA-INSTANCE
                                                  'DISPLAY-BLOCK)
                                           I J)
                                (AREF TRANSFORM-RESULT-TYPES j)
                                J
				(aref
				 (SLOT-VALUE RA-INSTANCE 'TRANSFORMS) j)))))
       
       ;; make an array to hold the confidences in internal
       ;; runnable form

     (SETF (SLOT-VALUE RA-INSTANCE 'ASSOCIATED-CONFIDENCES)
           (MAKE-ARRAY NUMB-PATTERNS))
     (FORMAT *TRACE-OUTPUT* "Transforming the confidences from display from to internal runnable form.~%"
            )
     (DOTIMES (I NUMB-PATTERNS)
            (SETF (AREF (SLOT-VALUE RA-INSTANCE 'ASSOCIATED-CONFIDENCES
                               )
                        I)
                  (PARSE-CONFIDENCE (AREF (SLOT-VALUE RA-INSTANCE
                                                 'DISPLAY-CONFIDENCES)
                                          I))))
       
       ;; if any of the confidences are INVOKES that are
       ;; precisely the same as something that appars as a
       ;; feature, substitute an appropriate CHECK-FEATURE form
       ;; so as to avoid repeating a dragon invocation

     (FORMAT *TRACE-OUTPUT* "Checking to see if any of the confidences are INVOKE's that are precisely the same as something that appears as a feature.~%"
            )
     (DOTIMES
      (I NUMB-PATTERNS)
      (IF (FIND (AREF (SLOT-VALUE RA-INSTANCE 'ASSOCIATED-CONFIDENCES)
                      I)
                (SLOT-VALUE RA-INSTANCE 'FEATURES)
                :TEST
                #'EQUAL)
          (SETF (AREF (SLOT-VALUE RA-INSTANCE 'ASSOCIATED-CONFIDENCES)
                      I)
                `(CHECK-FEATURE
                  ,(POSITION (AREF (SLOT-VALUE RA-INSTANCE '
                                          ASSOCIATED-CONFIDENCES)
                                   I)
                          (SLOT-VALUE RA-INSTANCE 'FEATURES)
                          :TEST
                          #'EQUAL)))))
       
       ;; similarly for the NO-MATCH confidence

     (FORMAT *TRACE-OUTPUT* "Setting up the NO-MATCH confidence.~%")
     (SETF (SLOT-VALUE RA-INSTANCE 'NO-MATCH-CONFIDENCE)
           (PARSE-CONFIDENCE (SLOT-VALUE RA-INSTANCE '
                                    DISPLAY-NO-MATCH-CONFIDENCE)))
     (IF (FIND (SLOT-VALUE RA-INSTANCE 'NO-MATCH-CONFIDENCE)
               (SLOT-VALUE RA-INSTANCE 'FEATURES)
               :TEST
               #'EQUAL)
         (SETF (SLOT-VALUE RA-INSTANCE 'NO-MATCH-CONFIDENCE)
               `(CHECK-FEATURE ,(POSITION (SLOT-VALUE RA-INSTANCE
                                                 'NO-MATCH-CONFIDENCE)
                                       (SLOT-VALUE RA-INSTANCE
                                              'FEATURES)
                                       :TEST
                                       #'EQUAL))))
       
       ;; set up MATCH-ACTIONS

     (FORMAT *TRACE-OUTPUT* "Parsing match-actions.~%")
     (SETF (SLOT-VALUE RA-INSTANCE 'MATCH-ACTIONS)
           (MAKE-ARRAY NUMB-PATTERNS :INITIAL-ELEMENT NIL))
     (WHEN
      (NOT (slot-empty-p ra-instance 'display-match-actions))
      (DOTIMES
       (J (LENGTH (SLOT-VALUE RA-INSTANCE 'DISPLAY-MATCH-ACTIONS)))
       (SETF
        (AREF (SLOT-VALUE RA-INSTANCE 'MATCH-ACTIONS)
              J)
        (CASE
         (LENGTH (AREF (SLOT-VALUE RA-INSTANCE 'DISPLAY-MATCH-ACTIONS)
                       J))
         (0 NIL)
         (1
          `,(CAR (MAPCAR #'TRANSFORM-PATTERN-REFERENCES
                        (MAPCAR #'TRANSFORM-CONFIDENCE-REFERENCES
                               (MAPCAR #'TRANSFORM-INVOKE-FORMS
                                      (AREF (SLOT-VALUE RA-INSTANCE
                                                   '
                                                  DISPLAY-MATCH-ACTIONS
                                                   )
                                            J))))))
         (OTHERWISE
          `,(CONS 'PROGN
                  (MAPCAR #'TRANSFORM-PATTERN-REFERENCES
                         (MAPCAR #'TRANSFORM-CONFIDENCE-REFERENCES
                                (MAPCAR #'TRANSFORM-INVOKE-FORMS
                                       (AREF (SLOT-VALUE RA-INSTANCE
                                                    '
                                                  DISPLAY-MATCH-ACTIONS
                                                    )
                                             J))))))))))
       
       ;; set up NO-MATCH-ACTION

     (IF
      (NOT (slot-empty-p ra-instance 'display-no-match-action))
      (PROGN (FORMAT *TRACE-OUTPUT* "Setting up NO-MATCH-ACTION.~%")
	     (SETF
	       (SLOT-VALUE RA-INSTANCE 'NO-MATCH-ACTION)
	       (CASE
		 (LENGTH (SLOT-VALUE RA-INSTANCE 'DISPLAY-NO-MATCH-ACTION))
		 (0 NIL)
		 (1
		   `,(CAR (MAPCAR #'TRANSFORM-PATTERN-REFERENCES
				  (MAPCAR #'TRANSFORM-CONFIDENCE-REFERENCES
					  (MAPCAR #'TRANSFORM-INVOKE-FORMS
						  (SLOT-VALUE RA-INSTANCE
						   'DISPLAY-NO-MATCH-ACTION)))
                       )))
		 (OTHERWISE
		   `,(CONS 'PROGN (MAPCAR #'TRANSFORM-PATTERN-REFERENCES
					  (MAPCAR #'
					    TRANSFORM-CONFIDENCE-REFERENCES
					    (MAPCAR #'TRANSFORM-INVOKE-FORMS
						    (SLOT-VALUE RA-INSTANCE
                                                    '
						      DISPLAY-NO-MATCH-ACTION
                                                    )))))))))
      (SETF (SLOT-VALUE RA-INSTANCE 'NO-MATCH-ACTION) NIL))
       
       ;; build judge and tracing judge

     (FORMAT *TRACE-OUTPUT* 
            "Building standard and tracing controller.~%")
     (SETF (SLOT-VALUE RA-INSTANCE 'PARSED-CONTROLLER)
	   ;; make sure things come out in the right order -- the
	   ;; user-specified lambdas must come first in the assoc list,
	   ;; so they can shadow any system-define verbs they redefine
	   (append
	    (SLOT-VALUE RA-INSTANCE 'PARSED-CONTROLLER)
	    (controllers ra-instance)))

     (SETF (SLOT-VALUE RA-INSTANCE 'PARSED-TRACING-CONTROLLER)
	   (append
	    (SLOT-VALUE RA-INSTANCE 'PARSED-TRACING-CONTROLLER)
	    (tracing-controllers ra-instance)))
     (FORMAT *TRACE-OUTPUT* "Compiling controller.~%")
     (if *compile-controller*
	 (SETF (SLOT-VALUE RA-INSTANCE 'ACTIONS)
	       (COMPILE-CONTROLLER (SLOT-VALUE RA-INSTANCE '
					       PARSED-CONTROLLER)))
         (setf (slot-value ra-instance 'actions)
	       (slot-value ra-instance 'parsed-controller))))
       
    (FORMAT *TRACE-OUTPUT* 
           "Finished compiling match-1-recognition-agent ~S.~%" RA-NAME
           )))



