;; -*- LISP -*-


;;;; Simple loader for Building Problem Solvers

;; Source code type
#+(OR Lucid Symbolics)
(defvar *default-source-type* "lisp")
#+GC-Lisp
(defvar *default-source-type* "lsp")

;; compiled file type
(defvar *default-bin-type* #+RT "bbin"
  #+(:And :Lucid :RIOS) "rbin" )
#+GC-Lisp
(defvar *default-bin-type* "lsp") ;;Grumble.

;; Where to get stuff
#+Lucid
(defvar *default-pathname* "/u/bps/")
#+Symbolics
(defvar *default-pathname* "rube:>bps>")
#+GCLisp
(defvar *default-pathname* "C:\\GCLISP2\\BPS\\")

(defun load-files (file-list &optional (path *default-pathame*)
			     (type *default-bin-type*))
  (dolist (file file-list)
	  (load (merge-pathnames path
				 (concatenate 'string file "." type)))))

(defun compile-files (file-list
		       &optional (path *default-pathname*))
  (dolist (file file-list)
    (format t "~% Compiling ~A..."
	    (merge-pathnames path 
			     (concatenate 'string file "."
					  *default-source-type*)))
	  (compile-file
	    (merge-pathnames path 
			     (concatenate 'string file "."
					  *default-source-type*))
	    :output-file
	    (merge-pathnames path
			     (concatenate 'string file "."
					  *default-bin-type*)))))

(defun load-from (file path)
  (load (concatenate 'string path file)))

;;;; Compiling and loading files

;; (Not relevant for GC-Lisp)

(defun compile-load-files (file-list
			    &optional (path *default-pathname*)
			   (pre-load? t) 
			    &aux out-path)
  (dolist (file file-list)
	  (setq out-path 
	    (merge-pathnames path
			     (concatenate 'string file "."
					  *default-bin-type*)))
    	    (when pre-load?
	      (load (merge-pathnames path 
				     (concatenate 'string file "."
						  *default-source-type*))))
	  (compile-file
	    (merge-pathnames path 
			     (concatenate 'string file "."
					  *default-source-type*))
	    :output-file out-path)
	  (load out-path)))
