/*  MOTHER
    A d-Prolog Database
    Copyright (C) Donald Nute

Mother is unhappy when baby cries, and normally mother is happy
when baby isn't crying.  Baby normally doesn't cry when the
little girl next door plays with her.  At a certain time, the
little girl next door played with baby.  We would expect mother
to be happy.  However, the little girl next door has measles.
This should defeat our conclusion that mother is happy.  For this
to happen, we need some background knowledge.  First, measles is
an infectious disease.  Second, anyone who comes near a person
with an infectious disease is exposed to infection.  Third,
anyone with whom a person plays comes near that person.  Finally,
mother is unhappy when baby is exposed to an infectious disease.

We represent these facts in a d-Prolog database.               */

    happy(mother,T):=
        neg crying(baby,T).

    neg crying(baby,T):=
        plays_with(little_girl_next_door,baby,T).

    plays_with(little_girl_next_door,baby,t).

    has(little_girl_next_door,measles,t).

    infectious_disease(measles).

    near(X,Y,T):-
        plays_with(Y,X,T).

    exposed_to_infection(X,T):=
        near(X,Y,T),
        has(Y,Z,T),
        infectious_disease(Z).

    neg happy(mother,T):=
        exposed_to_infection(baby,T).

/*  Can we infer that mother is happy at time t?  That is, does
    the d-Prolog goal '@ happy(mother,t)' succeed?             */

