
prescribe(Treatment,Ailment):=
        indicated(Treatment,Ailment),
        diagnosis(Ailment).

neg prescribe(Treatment,_):^
        counter_indicated(Treatment).

prescribe(Treatment,Ailment):=
        indicated(Treatment,Ailment),
        diagnosis(Ailment),
        counter_indicated(Treatment),
        condition(critical).

neg prescribe(Treatment,Ailment):=
        counter_indicated(Treatment),
        indicated(AlternateTreatment,Ailment),
        AlternateTreatment \= Treatment,
        not counter_indicated(AlternateTreatment).

counter_indicated(Treatment):-
        allergy(Treatment).

indicated(penicillin,pneumonia).

indicated(erythrocyn,strep_throat).

indicated(antihistamine,allergic_rhinitis).

diagnosis(allergic_rhinitis):=
        symptom(nasal_congestion).

diagnosis(strep_throat):=
        symptom(nasal_congestion),
        symptom(sore_throat).

diagnosis(pneumonia):=
        symptom(nasal_congestion),
        symptom(chest_congestion).

neg diagnosis(allergic_rhinitis):^
        symptom(sore_throat).

neg diagnosis(allergic_rhinitis):^
        symptom(chest_congestion).

condition(fair):=true.

incompatible(condition(fair),condition(serious)).

incompatible(condition(fair),condition(critical)).

symptom(nasal_congestion).

allergy(penicillin).

history:-
        symptom(X),
        write('Symptom: '),
        write(X),
        nl,
        fail.

history:-
        allergy(X),
        write('Allergic to: '),
        write(X),
        nl,
        fail.

history:-
        (@ condition(X)),
        write('Condition: '),
        write(X),
        nl,
        fail.

history.

diagnose:-
        history,
        nl,
        fail.

diagnose:-
        @ diagnosis(X),
        write('Possible diagnosis: '),
        write(X),
        nl,
        fail.

diagnose:-
        @ prescribe(X,Y),
        write('Prescribed treatment for '),
        write(Y),
        write(' is '),
        write(X),
        nl,
        fail.

diagnose:-
        nl.

