;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Code for forming rules based on success.
;;
;; Author:  Oren Etzioni
;; 
;; Modified: Julie Roomy 
;;
;; Notes: 
;;  Try to add into op-failure traversal of tree.  Would 
;;  increase efficiency.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; Notes:
;; Need to think about how to avoid Prodigy's success/failure
;; redundancy. Ie, if you have a reject rule, then don't create a
;; prefer rule that has the same semantics (this is likely to happen
;; when there are exactly two potential operators for a goal).


;;; Algorithm:
;;; 1.  Ignore operators with recursive preconditions (labelled
;;; recursion). 
;;; 2. Ignore operators all of whose preconditions are satisfied
;;; without any backchaining.  Prodigy will choose these automatically!
;;; 3. If all of an operator's preconditions have a way of satisfying
;;; them that's guaranteed to work, that is all of the plans
;;; preconditions are guaranteed to be true, then choose *that*
;;; operator because the rules you use won't have any preconditions
;;; and will thuus be both general and cheap to match.


(defun create-op-success-rules (&optional roots excised)
  (setq *srules* nil)
  (unless roots (setq roots *roots*))
  (iter:iterate
   (iter:for root iter:in roots)
   (form-op-pref-rules root)
   )
  (format t "Learned ~s preference rules ~%" (length *srules*)))



;; Julie Roomy, I removed this function from Oren's code.  It used
;; to be called in create-op-success-rules before iterating over 
;; the roots and calling form-op-pref-rules.
; Code for removing gs-loops from the graph, for the purpose of dgi.
;(defun excise-looping-ops (lit)
;; (iter:iterate
;;  (iter:for op iter:in (lit-ops lit))
;;  (let ((precs (op-precs op)))
;;  (if (looping-prec? precs)
;;    (excise-op lit op)
;;   (iter:iterate
;;    (iter:for p iter:in precs)
;;    (unless (leaf? p) (excise-looping-ops p)))))))


;;(defun excise-op (lit op)
;; (setf (lit-ops lit)
;;     (rem-equal op (lit-ops lit)))
;; (when (null (lit-ops lit))
;;       (setf (lit-label lit) 'unach)))



; Encodes the bias for forming preference rules for the top ops.
; If |ops|<2 then don't form an op-pref rule, only a bindings rule.
; Should still form rules for sole-op in order to get bindings-pref
; rules. 
(defun form-op-pref-rules (root)
  (let* ((ops (Literal-operators root))
	 (sole-op (= (length ops) 1)))
    (iter:iterate
     (iter:for op iter:in ops)
     (let (
	   (label (Operator-label op))
	   (dec-goal (Literal-name root)))
       (cond 

	;; if label is pure failure or success create a op preference rule
	;; unless the operator is the only applicable operator
	((and
	  (or (pure-failure-label? label)
	      (success-label? label))
	  (null sole-op))

	 ;; dont bother to create rule if prodigy will chose op by default
	 (unless
	  (immediately-applicable? (Operator-preconditions op)) 
	  (create-pref-rule
	   dec-goal op sole-op (negate-formula 
				(Operator-failure-condition op)))))

	;; if the label is anything else look for preference rules in subtree
	(T (traverse-preconds (Operator-preconditions op))))))))





;****************************************************************
;; immediately-applicable?
;; if the failure condition is a "subset" of the precondition 
;; expression of the operator then the operator is immediately 
;; applicable.  However, this is consuming to compute, so instead
;; don't generate a preference rule if ALL of the atomic literals
;; in the preconditions of the operator are immediately-applicable.
;; It is conservative to generate preference rules when it can not
;; be determined that the operator is immediately applicable, since
;; if the operator is immediately applicable the operator will be
;; prefered both by the rule and by default.
(defun immediately-applicable? (precond) 
  (cond
   ((null precond) nil)

   ((literal-p precond)
    (immediate-label? (Literal-label precond)))

   ((InternalNode-p precond)
    (immediately-applicable? (InternalNode-operands precond)))

   ((> (length precond) 1)
    (all-true 
     (iter:iterate
      (iter:for each iter:in precond)
      (iter:collect (immediately-applicable? each)))))))


(defun all-true (l)
  (cond
   ((null l) T)
   ((eq (first l) 'nil)
    nil)
   (T (all-true (rest l)))))

    


(defun disjoin (ll)
  (cond ((null ll) nil)
	((= (length ll) 1) ll)
	(t (simplify-or ll))))


;;------------------
;; traverse-preconds
;; instead of assuming the children of op are all literals, 
;; also if any of the literals have already been traversed, dont do it again.
(defun traverse-preconds (children)
  (iter:iterate
   (iter:for child iter:in children)
   (cond
    ((literal-p child)
     (unless 
      (Literal-already-traversed child)
      (progn
	(setf (Literal-already-traversed child) 't)
	(form-op-pref-rules child))))
    ((InternalNode-p child)
     (traverse-preconds (InternalNode-operands child)))
    (t "error"))))
