;;-------------------------------------------------------------------
;;-  Author        :  Rob Spiger 
;;- Sponsoring Prof:  Oren Etzioni
;;-    Date        :  2/9/93
;;-------------------------------------------------------------------
(defun rob-negate-exactly (pred1 pred2)
 (let* (
   (pred1 (negate-exp pred1)))
  (equal pred1 pred2)))


(defun rob-negate-exactly-w-axioms (pred1 pred2)
 (when (AND
        (member (predicate-name pred1) *negation-list-predicates*)
        (member (predicate-name pred2) *negation-list-predicates*))
  (let* (
    (blists (rob-negate-return-blists-w-axioms pred1 pred2)))
   (not (not (member nil blists))))));;not not makes result a straight T

(defun rob-match (pred1 pred2)
 (if (eq (first pred1) (first pred2))
  (if (eq (first pred1) '~)
   (if (eq (first (second pred1)) (first (second pred2)))
    (Rob-do-match pred1 pred2)
    'No-match)
   (Rob-do-match pred1 pred2))
  'No-match))

;;Function rob-do-match
;; Is a subfunction of rob-match
;; (Calls the matcher and removes if present
;;  the binding pair (nil nil).)

(defun rob-do-match (pred1 pred2)
 (let ((Blist (match pred1 pred2)))
  (cond 
   ((null Blist) 'No-match)
   (t (if (equal '((NIL NIL)) (last (first Blist)))
       (butlast (first Blist))
       (first Blist))))))


(defun rob-negate-return-blist (pred1 pred2)
 (rob-match pred1 (negate-exp pred2)))


(defun rob-negate-return-blists-w-axioms (pred1 pred2)
 (let* (
   (blist-from-not (rob-negate-return-blist pred1 pred2))
   (blists-from-negation 
                   (sub-rob-negate-return-blists-w-axioms
                       pred1 pred2)))
  (if (eq 'No-match blist-from-not)
   blists-from-negation
   `(,blist-from-not ,@blists-from-negation))))


(defun sub-rob-negate-return-blists-w-axioms (pred1 pred2)
 (iter:iterate
 (iter:for axiom iter:in *negation-list-both-ways*)
  (let* (
    (axiom-pred1 (first axiom))
    (axiom-vars  (find-variables axiom))
    (blist1      (rob-match axiom-pred1 pred1)))

   (unless (eq blist1 'No-match)
    (let* (
      (axiom-pred2 (instantiate (second axiom) blist1))
      (blist2      (rob-match pred2 axiom-pred2)))
     (unless (eq blist2 'No-match)
      (unless (find-if #'(lambda (bpair) 
                          (and (member (first  bpair) axiom-vars)
                               (member (second bpair) axiom-vars))) blist2)
       (unless (has-duplicate (instantiate 
                              (instantiate axiom-vars blist1) blist2))
        (let* (
          (blist (remove-if #'(lambda (bpair) 
                               (or (member (first  bpair) axiom-vars)
                                   (member (second bpair)
 												  axiom-vars))) blist2)))
         (iter:collect (reverse-blist blist)))))))))))


(defun rob-hard-match (pred1 pred2)
 (let (
   (pred1-vars (find-variables pred1))
   (pred2-vars (find-variables pred2))
   (blist      (rob-match pred1 pred2)))
  (if (eq 'No-match blist)
   'No-match
   (let* (
     (var1-first-blist  (remove-if-not #'(lambda (bpair)
                            (member (first  bpair) pred1-vars))
                            blist))
     (var2-first-blist  (remove-if-not #'(lambda (bpair)
                            (member (first  bpair) pred2-vars))
                            blist))
     (var1-second-blist (remove-if-not #'(lambda (bpair)
                            (member (second bpair) pred1-vars))
                            blist))
     (var2-second-blist (remove-if-not #'(lambda (bpair)
                            (member (second bpair) pred2-vars))
                            blist))
     (pred2-blist       (append var2-second-blist
                                (reverse-blist var2-first-blist)))
     (pred1-blist       (append var1-first-blist
                                (reverse-blist var1-second-blist))))
    (append pred1-blist pred2-blist)))))

(defun rob-hard-negate-return-blist (pred1 pred2)
 (rob-hard-match (negate-exp pred1) pred2))

(defun match-var-to-var-only (pred1 pred2)
 (let ((Blist (rob-match pred1 pred2)))
  (unless (equal Blist 'No-match)
   (if (find-if #'
           (lambda (bpair) (not (and (rob-is-var? (first bpair))
                                     (rob-is-var? (second bpair)))))
         Blist)
    nil
    t))))

(defun match-var-to-var-only-return-blist (pred1 pred2)
 (let ((Blist (rob-match pred1 pred2)))
  (if (not (equal Blist 'No-match))
   (if (find-if #'
           (lambda (bpair) (not (and (rob-is-var? (first bpair))
                                     (rob-is-var? (second bpair)))))
         Blist)
    'No-match
    blist) 
   'No-match)))

(defun match-nonvar-or-var-to-var-only (pred1 pred2)
 (let ((Blist (rob-hard-match pred1 pred2)))
  (unless (equal Blist 'No-match)
   (if (null Blist)
    t
    (if (find-if #'
         (lambda (bpair) (and (not (rob-is-var? (second bpair)))
                                  (rob-is-var? (first bpair)))) Blist)
     nil
     t)))))

(defun match-only-with-goal-or-wild-variables (pred1 pred2)
 (let* (
  (blist (rob-match pred1 pred2)))
 (if (non-goal-or-wild-var-in-blist blist)
  'No-match
   blist)))

(defun match-only-with-wild-variables (pred1 pred2)
 (let* (
   (blist (rob-match pred1 pred2))
   (vars  (find-variables blist)))
  (if (find-if #'(lambda (x) (not wild-var? x)) vars)
   'no-match
    blist)))

 

(defun negate-return-blists-only-with-goal-or-wild-vars-w-axioms (pred1 pred2)
 (let* (
   (blists (rob-negate-return-blists-w-axioms pred1 pred2))
   (ok-blists (remove-if #'non-goal-or-wild-var-in-blist blists)))
  ok-blists))





   
  