;; Search-control rules for kite-building domain
;; Written by Julie Roomy and Rob Spiger




(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES* 
      '(


         (SELECT-FIRST-GOAL
  	  (lhs (and (current-node <node>)
		    (not-top-level-node <node>)
                    (primary-candidate-goal <node> <goal>)))
           (rhs (select goal <goal>)))


 
       ))
(setq *SCR-OP-SELECT-RULES*  nil)
(setq *SCR-BINDINGS-SELECT-RULES* 
'(

;;Select-bindings-for-cut-fabric, specifies that fabric should only be 
;; cut to existing frame shapes.  This way the fabric shape is
;; made to match the frame, instead of eventually trying to match the
;; frame shape to the fabric shape which leads to failure.

   ; used in same-shape

(Select-bindings-for-cut-fabric-one
 (lhs
  (and
   (current-node <node>)
   (current-goal <node> (same-shape <fabric> <frame>))
   (current-op <node> infer-fabric-same-shape-as-frame)
   (known <node> 
          (and
		   (is-frame <frame>)
		   (~ (frame-properties <frame> addition covering))
		   (frame-properties <frame> shape <frame-shape>)))))
 ;;binds the shape as the shape of the existing frame, NOT the fabric
 ;;to be made. 
 (rhs                                  
  (select bindings (<fabric> <frame> <frame-shape>))))

   ; used in cut-fabric-with-fabric-cutter

(Select-bindings-for-cut-fabric-two
 (lhs
  (and
   (current-node <node>)
   (current-op <node> cut-fabric-with-fabric-cutter)
   (known <node> 
          (and
		   (is-frame <frame>)
		   (~ (frame-properties <frame> addition covering))
		   (frame-properties <frame> shape <frame-shape>)))))
 ;;binds the shape as the shape of the
 ;;existing frame, NOT the fabric to be made.
 (rhs
  (select bindings (<bulk-fabric> <shaped-fabric> <frame-shape>))))
       

;;Cut-stick with saw has a lot of possible bindings.  A lot of which
;; are just repetitions of each other and a lot of which are just
;; plain bad ideas.  This is because it has a lot of factors that have
;; to be true at once and can't be changed by subgoaling on them.  For
;; example, the stick to cut has to have the type and size of an
;; existing stick.  So, this control rule just helps it 'get it all
;; right' at once.  This GREATLY narrows down the task of cutting
;; sticks.

;; Also, another very important point and a subtle point is that the
;;   sticks sizes prodigy subgoals on always end up being sticks with
;;   generated names.  This means that the sticks with the original
;;   stick names are the "leftovers" from the sticks prodigy has
;;   subgoaled hard to get.  This in conjunction with the control rule
;;   prefer-to-cut-original-sticks keeps prodigy from cutting up the
;;   sticks it is working to make.

;; One may ask why it is only a preference rule to prefer to cut
;; original sticks.  The answer is that after a bamboo-stick has been
;; stripped, four bamboo-strips are generated.  Some problems may need
;; to further cut these generated strips to yield a solution.


(Select-best-bindings-for-cut-stick-with-saw
 (lhs
  (and
   (current-node <node>)
   (current-goal <node> (stick-properties <new-stick2> size <new-size2>))    
   (current-op <node> cut-stick-with-saw)
   (known <node>
          (and    
		   (is-stick <stick>)
		   (stick-properties <stick> size <stick-size>)
		   (stick-properties <stick> type <stick-type>)))))
 (rhs
  (select bindings (<stick> <stick-type> <stick-size> <new-size1>
							<new-stick2> <new-size2>))))

;;Strip-bamboo-with-knife is very much like Cut-stick-with-saw in that
;; it has lots of freedom in choosing bindings, but few are truly
;; different from each other or good ideas.  It looks more
;; complicated, but it is accomplishing the same things.  The extra
;; complication cames from the fact stripping bamboo produces four new
;; sticks instead of two.  So, to avoid trying all four different
;; possible new-sticks produced as yeilding the goal stick the goal
;; stick is bound to only one of the sticks yeilded.  If it already is
;; an existing stick in the state, it is yeilded with it's original
;; stick name.  Otherwise, if the goal stick isn't bound to a name
;; already, it is output as new-strip2 and inside the function
;; Strip-bamboo-with-knife it is generated a name.

(Select-best-bindings-for-strip-bamboo-with-knife
 (lhs
  (and
   (current-node <node>)
   (current-goal <node> (stick-properties <goal-stick> type bamboo-strip))
   (current-op <node> strip-bamboo-with-knife)
   (or
	(and
	 (meta-func-is-bound <goal-stick>);;if the goal-stick 
	 ;;is bound to a name the goal stick is set equal to the original stick
	 (is-equal <stick> <goal-stick>)
	 ;;  and new-strip2 is required to not be bound so it's name will be
	 ;;  generated.
	 (~ (meta-func-is-bound <new-strip2>)))
	(and
	 ;;if the goal-stick isn't bound to a name, it is output as new-strip2
	 ;;which	is generated in a name in the operator.
	 (~ (meta-func-is-bound <goal-stick>))
	 (is-equal <new-strip2> <goal-stick>)))
   (~ (meta-func-is-bound <new-strip3>))        
   (~ (meta-func-is-bound <new-strip4>));;both of the other new strips are required to not be bound or used until 
   (known <node>;;   if possibly later another strip is needed.
          (and
		   (is-stick <stick>)
		   (stick-properties <stick> size <stick-size>)
		   (stick-properties <stick> type bamboo)))))
 (rhs
  (select bindings (<stick> <stick-size> <new-strip2> <new-strip3> <new-strip4>))))

            
))
        


(setq *SCR-NODE-REJECT-RULES* nil)
(setq *SCR-GOAL-REJECT-RULES* 
'(
;; Instead of trying to get rid of stick-properties lashed by
;; building a new frame with the same stick, just reject the
;; node if ~(stick-properties <stick> lashed <point>) occurs.

  (Reject-goal-of-making-lashed-stick-unlashed
   (lhs
    (and
     (current-node <node>)
     (candidate-goal <node> (~(stick-properties <stick> lashed <point>)) ) ))
   (rhs
    (reject goal (~(stick-properties <stick> lashed <point>)))))


;;  Since only bamboo can be stripped, it makes sense not to work at
;;    trying to strip any other type of stick.

   (Reject-goal-of-making-stick-bamboo-strip-unless-stick-is-bamboo
    (lhs
      (and
        (current-node <node>)
        (current-op <node> strip-bamboo-with-knife)
        (candidate-goal <node> (stick-properties <stick> type bamboo-strip))
        (known <node> (~ (stick-properties <stick> type bamboo)))))
    (rhs
      (reject goal (stick-properties <stick> type bamboo-strip))))

;;  Since stick type can only change when stripping bamboo, if prodigy is
;;    trying to subgoal on altering the type of a stick and it's not making it
;;    a bamboo strip, it will fail.  So, to make it fail fast, this 
;;    control rule rejects the goal of trying to change the type of a stick.

(Reject-goal-of-changing-stick-type-unless-trying-to-achieve-bamboo-strip
 (lhs
  (and
   (current-node <node>)
   (candidate-goal <node> (stick-properties <stick> type <stick-type>))
   (not-equal <stick-type> bamboo-strip)));; bamboo-strip is OK
 (rhs
  (reject goal (stick-properties <stick> type <stick-type>))))


))
(setq *SCR-OP-REJECT-RULES* 
    '(

;;  Since cut-stick-with-saw adds to the state (stick-properties
;;  <stick> type <stick-type>) Prodigy sees it as a possible way to
;;  change stick types.  but this is not really the case because the
;;  yielded sticks always have the same type as the original stick.
;;  So, to stop it from trying this control rule rejects the operator
;;  cut-stick-with-saw as a possible way of changing a stick's type.

   (Dont-try-to-change-stick-type-with-cut
    (lhs
      (and
        (current-node <node>)
        (current-goal <node> (stick-properties <stick> type <stick-type>))
        (candidate-op <node> cut-stick-with-saw)))
    (rhs
      (reject operator cut-stick-with-saw)))
        


;; Since strip-bamboo-with-knife adds to the state (stick-properties
;;    <stick> size <stick-size>) Prodigy sees it as a possible way to
;;    change stick sizes.  But this is not really the case because the
;;    bamboo-strips always have the same size as the original bamboo.
;;    ;; So, to stop it from trying this control rule rejects the
;;    operator strip-bamboo-with-knife as a possible way of changing a
;;    stick's size.

   (Dont-try-to-change-stick-sizes-with-strip-bamboo-with-knife
    (lhs
      (and
        (current-node <node>)
        (current-goal <node> (stick-properties <stick> size <stick-size>))
        (candidate-op <node> Strip-bamboo-with-knife)))
    (rhs 
      (reject operator strip-bamboo-with-knife)))

))

(setq *SCR-BINDINGS-REJECT-RULES* nil)
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES* 

  '(

;;;Prefer-notch-before-lashing
;;; Since lashed is easier to achieved than notched,  
;;; the goal notched-and-lashed always tries to achieve lashed before notched.
;;; However, a stick may only be notched at a point that is not lashed so
;;; backtracking occurs.
(Prefer-notch-before-lashing
 (lhs
  (and
   (current-node <node>)
   (candidate-goal <node> (stick-properties <stick> notched <point>))
   (candidate-goal <node> (stick-properties <stick> lashed <point>))))
 (rhs
  (prefer goal
		  (stick-properties <stick> notched <point>)
		  (stick-properties <stick> lashed <point>))))

;;;Prefer-notch-before-attaching-other-stick-one differs from (...two)
;;; in that inter-stick-properties differenciates between 
;;;  (inter-stick-properties <attch> <STICK> at <pt1> <other-stick> at <pt2>)
;;;  (inter-stick-properties <attch> <other-stick> at <pt1> <STICK> at <pt2>)

(Prefer-notch-before-attaching-other-stick-one
 (lhs
  (and
   (current-node <node>)
   (candidate-goal <node> (stick-properties <stick> notched <point>))
   (candidate-goal <node>
				   (inter-stick-properties <attch> <stick> at <point1> <stick2> at <point2>))))
 (rhs
  (prefer goal (stick-properties <stick> notched <point>)
		  (inter-stick-properties <attch> <stick> at <point1> <stick2> at <point2>))))


    (Prefer-notch-before-attaching-other-stick-two
     (lhs
      (and
       (current-node <node>)
       (candidate-goal <node> (stick-properties <stick> notched <point>))
       (candidate-goal <node>
	(inter-stick-properties <attch> <stick1> at <point1> <stick> at <point2>))))
      (rhs
       (prefer goal (stick-properties <stick> notched <point>)
	(inter-stick-properties <attch> <stick1> at <point1> <stick> at <point2>))))


;;; Sticks may not be lashed once they are attached to another stick
;;;Prefer-lash-before-attaching-other-stick-one differs from (...two)
;;; in that inter-stick-properties differenciates between 
;;;  (inter-stick-properties <attch> <STICK> at <pt1> <other-stick> at <pt2>)
;;;  (inter-stick-properties <attch> <other-stick> at <pt1> <STICK> at <pt2>)

    (Prefer-lash-before-attaching-other-stick-one
     (lhs
      (and
       (current-node <node>)
       (candidate-goal <node> (stick-properties <stick> lashed <point>))
       (candidate-goal <node>
	(inter-stick-properties <attch> <stick> at <point1> <stick2> at <point2>))))
      (rhs
       (prefer goal (stick-properties <stick> lashed <point>)
	(inter-stick-properties <attch> <stick> at <point1> <stick2> at <point2>))))


    (Prefer-lash-before-attaching-other-stick-two
     (lhs
      (and
       (current-node <node>)
       (candidate-goal <node> (stick-properties <stick> lashed <point>))
       (candidate-goal <node>
	(inter-stick-properties <attch> <stick1> at <point1> <stick> at <point2>))))
      (rhs
       (prefer goal (stick-properties <stick> lashed <point>)
	(inter-stick-properties <attch> <stick1> at <point1> <stick> at <point2>))))


;;; Sticks may not be sanded once they are attached to another stick
;;;Prefer-sand-before-attaching-other-stick-one differs from (...two)
;;; in that inter-stick-properties differenciates between 
;;;  (inter-stick-properties <attch> <STICK> at <pt1> <other-stick> at <pt2>)
;;;  (inter-stick-properties <attch> <other-stick> at <pt1> <STICK> at <pt2>)

    (Prefer-sand-before-attaching-other-stick-one
     (lhs
      (and
       (current-node <node>)
       (candidate-goal <node> (stick-properties <stick> surface sanded))
       (candidate-goal <node>
	(inter-stick-properties <attch> <stick> at <point1> <stick2> at <point2>))))
      (rhs
       (prefer goal (stick-properties <stick> surface sanded)
	(inter-stick-properties <attch> <stick> at <point1> <stick2> at <point2>))))

    (Prefer-sand-before-attaching-other-stick-two
     (lhs
      (and
       (current-node <node>)
       (candidate-goal <node> (stick-properties <stick> surface sanded))
       (candidate-goal <node>
	(inter-stick-properties <attch> <stick1> at <point1> <stick> at <point2>))))
      (rhs
       (prefer goal (stick-properties <stick> surface sanded)
	(inter-stick-properties <attch> <stick1> at <point1> <stick> at <point2>))))


;;;Prefer-tied-before-glued
;;; When satisfying goal tied-and-glued, gluing the tie, strengthens the tie.
;;; Therefore the  desirable order is first tie, then glue.
    (Prefer-tied-before-glued
     (lhs
      (and
       (current-node <node>)
       (candidate-goal <node> (inter-stick-properties tied <stick1> at <point1> <stick2> at <point2>))
       (candidate-goal <node> (inter-stick-properties glued <stick1> at <point1> <stick2> at <point2>))))
       (rhs
	(prefer goal (inter-stick-properties tied <stick1> at <point1> <stick2> at <point2>) 
                     (inter-stick-properties glued <stick1> at <point1> <stick2> at <point2>))))
))

(setq *SCR-OP-PREFERENCE-RULES* nil)
(setq *SCR-BINDINGS-PREFERENCE-RULES* 

'(


;;  For an explaination of this control rules, see the control rule 
;;  Select-best-bindings-for-cut-stick-with-saw.  


(Prefer-to-cut-original-sticks
 (lhs
  (and
   (current-node <node>)
   (current-op <node> cut-stick-with-saw)
   (current-goal <node> (stick-properties <new-stick2> size <new-size2>))
   (candidate-bindings <node> (<original-stick> <stick-type> <stick-size> <new-size1> <new-stick2> <new-size2>))
   (~ (meta-func-is-generated-name <original-stick>))))
 (rhs
  (prefer bindings (<original-stick>  <stick-type> <stick-size> <new-size1> <new-stick2> <new-size2>)
		  (<*generated-stick> <*g-stick-type> <*g-stick-size> <*g-new-size1> <*g-new-stick2> <*g-new-size2>))))

))








