/* External declarations and defined return values for socket_server
 */
#ifndef _SOCKET_SERVER_H_
#define _SOCKET_SERVER_H_

#include <sys/time.h>
#include <sys/types.h>

struct connection {
  /* The connection socket: */
  int    connect_fd;

  /* The maximum number of clients we will allow to connect at once: */
  int    max_clients;

  /* The current number of clients connected to this server. */
  int    n_clients;

  /* The port number which this connect sd is bound to. */
  char  *port;

  /* The function that will be used to handle input from client connections. */
  void (*input_procedure)();

  /* The function that will be called whenever a new connection is made. */
  void (*new_connection_procedure)();

  /* The function that will be used to close sockets. */
  void (*end_of_file_procedure)();
  };


#ifdef __STDC__
extern void socket_server_add_input_fd(int fd);
extern void socket_server_end_of_file(int fd);
extern struct connection *socket_server_get_connection(void);
extern void socket_server_initialize(void  (*other_input_proc)(int), 
				     fd_set *other_input_fds);
extern int socket_server_startup(char  *socket_port, 
				 void (*input_proc)(int),
				 int    max_clients_in,
				 void (*new_connection_proc)(int),
				 void (*socket_shutdown_proc)(int));
extern int socket_server_poll(struct timeval *timeout);
extern int socket_server_shutdown(void);
#else  __STDC__
extern int socket_server_get_active_sd();
extern int socket_server_loop();
extern int socket_server_poll();
extern int socket_server_shutdown();
extern int socket_server_startup();
#endif __STDC__

#define SS_NORMAL_END      0
#define SS_FAILED_ACCEPT   1
#define SS_FAILED_BIND     2
#define SS_FAILED_LISTEN   3
#define SS_FAILED_SELECT   4
#define SS_FAILED_SOCKET   5
#define SS_ILLEGAL_CALL    6
#define SS_PORT_TAKEN      7

#endif  _SOCKET_SERVER_H_
