/* Buffer I/O for sockets: read/write length of buffer, then buffer itself.
 */

#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <netinet/in.h>
#include "buffer_io.h"


int write_buffer(fd, buf, nbyte)
     int fd;
     char *buf;
     int nbyte;
{
  struct iovec iov[2];
  int x;
  u_short n_byte;

  if (nbyte <= 0)
    nbyte = strlen(buf)+1;
  if (nbyte <= 65535) 
    n_byte = nbyte;
  else {
    static char *x = "buffer_io: write_buffer: buffer too large!\n";
    write(2, x, strlen(x));
    n_byte = 65535;
    }
  iov[0].iov_base = (char *) &n_byte;
  iov[0].iov_len  = sizeof(u_short);
  iov[1].iov_base = buf;
  iov[1].iov_len  = n_byte;
  
  x = writev(fd, iov, 2);
  if (x == -1)
    return -1;
#if 0
  /* This shouldn't happen. */
  if (x != n_byte + sizeof(u_short))
    return x-4;
#endif
  return n_byte;
  }


int read_buffer(fd, buf, maxbytes)
     int fd;
     char *buf;
     int maxbytes;
{
  int x, n;
  u_short nbyte;
  int remainder;
  char junk[128];

  x = 0;
  while (x != sizeof(u_short)) {
    n = read(fd, ((char*)&nbyte)+x, sizeof(u_short)-x);
    if (n <= 0)
      return n;
    x += n;
    }
  nbyte = ntohs(nbyte);
  if (nbyte <= maxbytes)
    remainder = 0;
  else {
    remainder = maxbytes - nbyte;
    nbyte = maxbytes;
    }
  x = 0;
  while (x != nbyte) {
    n = read(fd, buf, nbyte-x);
    if (n <= 0)
      return n;
    x += n;
    }
  while (remainder > 0) {
    n = read(fd, junk, (remainder > 128)?128:remainder);
    remainder -= n;
    }
  return nbyte;
  }


int read_malloc(fd, pbuf)
     int fd;
     char **pbuf;
{
  char *malloc();
  int x, n;
  u_short nbyte;

  x = 0;
  while (x != sizeof(u_short)) {
    n = read(fd, ((char*)&nbyte)+x, sizeof(u_short)-x);
    if (n <= 0)
      return n;
    x += n;
    }
  nbyte = ntohs(nbyte);
  *pbuf = malloc(nbyte);
  x = 0;
  while (x != nbyte) {
    n = read(fd, *pbuf, nbyte-x);
    if (n <= 0)
      return n;
    x += n;
    }
  return nbyte;
  }
