/* brec: like rec, but uses buffer_io
 *      
 */
#include <signal.h>
#include <sys/ioctl.h>
#include <sys/wait.h>
#include "buffer_io.h"
#include "socket_server.h"

#define NULL 0

void brec_exit()
{
  socket_server_shutdown();
  exit(0);
  }


void brec_read_input(sd)
     int sd;
{
  int x;  
  char buffer[128];

  while (128 == (x = read_buffer(sd, buffer, 128)))
    write(1, buffer, 128);
  if (x > 0)
    write(1, buffer, x);

  if (x == 0) {
    socket_server_end_of_file(sd);
    return;
    }
  }


int main(argc, argv)
     int argc;
     char *argv[];
{
  char *socket_port = NULL;
  int x, max_clients;

  /* close all files except standards so that we can use them: */
  for (x = 3; x < 64; x++)
    close(x);

  x = 1;
  while (x < argc)
    {
    if (argv[x][0] == '-')
      switch (argv[x][1]) {
      case 'p': /* Port */
	socket_port = argv[++x];
	break;
      case 'c': /* Client limit */
	max_clients = atoi(argv[++x]);
	break;
	}
    x++;
    }

  if (socket_port == NULL)
    {
    char *usage_string = "\n\
Usage: brec [-c L] -p N\n\
          -c L  means `at maximum, allow L clients to connect at once'\n\
          -p N  means `use port N for connection socket'\n\
\n";
    write(1, usage_string, strlen(usage_string));
    exit(0);
    }

  /* catch broken pipe signals (i.e. a client process died) harmlessly. */
  signal(SIGINT,  brec_exit);
  signal(SIGTERM, brec_exit);
  signal(SIGQUIT, brec_exit);

  socket_server_initialize(NULL, NULL);

  if (socket_server_startup(socket_port, brec_read_input, max_clients, 
			    NULL, NULL))
    return;
  socket_server_poll(NULL);
  }

