;;
;;
;;      Title : mkgram
;;
;;      Function : UNIX level command to compile a word grammar
;;
;;      Author :  Alan W Black  November 1985
;;                Dept of Artificial Intelligence
;;                University of Edinburgh
;;
;;      Copyright Graeme Ritchie, Alan Black,
;;                Steve Pulman and Graham Russell  1987
;;
;;         ---------------------------------------------
;;         |    Not to be used for military purposes   |
;;         ---------------------------------------------
;;
;;      Description :
;;         This is designed as a UNIX level command, although written
;;         in lisp the user should be unaware of that fact.  For
;;         details of use see the the laatest version of the user document
;;         "Dictionary and Morphological Analyser"  or type
;;            man mkgram
;;
;;         This command has the same basic function as the the lisp
;;         function D-MakeWordGrammar
;;         
;;
;;      Parameters :
;;         filename:  the filename (without .gr extension) containing
;;             the grammar description 
;;      Returns :
;;             0 if all ok
;;             1 if error found
;;      Side Effect :
;;             writes the file  <filename>.gr.ma
;;
;;      External references :
;;
;;      System functions used :
;;        Name     type      Args #  type                 Comment
;;
;;      Restrictions :
;;
;;      In Franz version 38.75 (i.e. vax version) you have to change
;;      the quoting from "usemap" to 'usemap.  See section 4.3 in the
;;      User manual for more details about this
;;

(declare
   (special
      $ldprint
      rcode
   )
)

(princ "Loading word grammar compiler")
(terpri)

(include "keywords")

(let ( (usemap (assoc (DK-USEMAP) environment)) )
   (cond
      ((null usemap)   ;;  usemap variable not set
	 nil
      )
      (t               ;; add usemap to search path
         (eval (list 'sstatus 'load-search-path
                   (append
	              (list (cdr usemap))
	              (status load-search-path))))
      )
   )
)
(include "maload.l")

(defun top-level ()
(setq $ldprint nil)   ;; no loading info 
(sstatus translink on)
(allocate 'list 500)
(allocate 'symbol 100)
(allocate 'fixnum 50)
   (setq rcode
   (errset
      (let ()
         (cond
            ((eq (argv -1) 4)  ;; if one param is given its the name of the file
	       (d-maloadcomp)
	       (princ "Starting compilation of ")
	       (princ (argv 3))
	       (terpri)
               (D-MakeWordGrammar (argv 3))
	       0                      ;; return code
            )
            (t                  ;; zero or more than 1 param then wrong number of
                                ;; params             
               (princ "mkgram: error: should be only one parameter")
               (terpri)
               (princ "usage:  mkgram <name>  where <name>.gr is the grammar file")
               (terpri)
               1                ;; exit with error code 
            )
         )
      )
   ))
   (cond
      ((eq (car rcode) 0)
         (exit)             ;; exit with 0 retrun code
      )
      (t                    ;; must have been some error
         (exit 1)
      )
   )
)

(reset)      ;; call the new top-level
