;;
;;      Name: example.l
;;
;;      Functions:  this example lisp program shows how the 
;;                  system can be used from a normal program
;;
;;      Author: Alan W Black June 1987       
;;              Dept of A.I.
;;              University of Edinburgh
;;
;;      Copyright Graeme Ritchie, Alan Black,
;;                Steve Pulman and Graham Russell  1987
;;
;;         ---------------------------------------------
;;         |    Not to be used for military purposes   |
;;         ---------------------------------------------
;;
;;
;;      This reads in all the words in the given file name
;;      and prints the results into the file output in the current
;;      directory
;;
;;      This runs in franz lisp but will run in common lisp if the file
;;      common/mapcl is loaded.
;;
;;

; (load "../common/mapcl")    ;; needed if to be run in common lisp

(defmacro D-while (test &rest statements)
;;
;;  This defines a macro for the while construct
;;     (while test  statement1 statement2 ...)
;;
   `(prog ()
    loop
       (cond
	 ((not ,test) (return)))
        ,@statements
	(go loop))
)

(defun Example (fname)
;;
;;   reads in all the words in the file fname and looks them
;;   up printing the results into the file output
;;
   (let  (    (ifd (infile fname))      ;; open input file
	      (ofd (outfile "output"))  ;; open output file
	      word )                    
      ;; 
      ;;  Although these are not necessary setting up the memory
      ;;  management makes a big difference to the efficiency
      ;;  - something different would be necessary in common lisp
	 (allocate 'list 2000)
	 (allocate 'bignum 50)
	 (allocate 'fixnum 150)
	 (allocate 'symbol 200)
      ;; 
      ;;  load in bootstrap code.  Note that full path to the file
      ;;  maload has to be specified
      ;;
      (load "../maload")  
      ;;
      ;;   Now load the analyser files - naming the directory where the 
      ;;   the files are
      ;;
      (d-maload "..")
      ;;
      ;;   Again not actually necessary as it is done by d-maload
      ;;   but its nice to be safe
      ;;
      (D-Initialise)      ;; initialise the whole system
      ;;
      ;;   Load in a lexicon and analyser - (it assumed that they
      ;;   are already compiled)
      ;;
      (D-LoadAll "../examples/Simple/simple"  ;; the spelling rules
		 "../examples/Simple/simple"  ;; the word grammar 
		 "../examples/Simple/simple")  ;; the lexicon
      ;;
      ;;   Default lookup format is D-CATEGORYFORM - we choose
      ;;   D-WORDSTRUCTURE here
      ;;
      (D-ChangeLookUpFormat 'D-WORDSTRUCTURE)
      ;;
      ;;   Now look up the words
      ;;
      (D-while (neq (setq word (read ifd 'EOF)) 'EOF)  ;; while words to lookup
	 (print word ofd)
	 (terpri ofd)
	 (pp-form (D-LookUp word) ofd)  ;; pretty print the result of lookup
	 (terpri ofd)
      )
   )
)

