/******************************************************************************/
/*                                                                            */
/*   theorize.h                                                               */
/*   Header File containing global variables and data structures              */
/*                                                                            */
/*   Programmer: Eric Melz                                                    */
/*   Created: 4/9/90                                                          */
/*   Updated: 4/9/90                                                          */
/*                                                                            */
/******************************************************************************/


/******************************************************************************/
/*                                                                            */
/*   Global variables                                                         */
/*                                                                            */
/******************************************************************************/



#define MAXLINE               200            /* String Length                 */
#define MAXCMDS               50             /* Size of cmd array             */
#define MAXCMDBLOCKS          5              /* Number of command blocks      */
#define MAXSYMBOLS            25             /* Number of objects in a domain */
#define MAXNODES              200            /* Number of allowable nodes in  */
                                             /*   a network                   */
#define MAXWEIGHTS            1000           /* Number of allowable weights   */
                                             /*   in a network                */
#define MAXNETS               10             /* Number of total allowable     */
                                             /*   networks                    */
#define MAXLAYERS             15              /* Number of allowable layers    */
                                             /*   and projections between     */
                                             /*   layers (i.e. connectivity)  */
#define MAXNETWORKS           5              /* Number of allowable networks  */
#define MAXPATTERNS           250            /* Number of allowable ts pats   */
#define MAXINNODES            30             /* Max input and output nodes    */
#define MAXOUTNODES           30             /*   for training patterns       */
#define DIFFMIN              -.9999999       /* Limits for hyperbolic atan    */
#define DIFFMAX               .9999999       /*   error function              */
#define HYPMIN               -17.0 
#define HYPMAX                17.0
#define OUT_MIDVAL            0.5            /* Mipoint of simgoid output     */

#define MAXCANDIDATES         70             /* The maximum number of cand-   *
                                              * idate nodes for cascade       *
                                              * correlation                   */
#define QPEPSILON             .001           /* The amount a weight is        *
					      * shifted to generate the       *
					      * curvature estimate in         *
					      * quickprop                     */
#define MAXESTIMATES          10             /* The maximum number of weight  *
					      * estimates that are generated  *
					      * in the "semi-epoch" mode in   *
					      * quickprop                     */


/* Control and status flags */
#define FALSE                 0
#define TRUE                  1

#define INMODE                2
#define OUTMODE               3
#define WIN                   4
#define TIMEOUT               5
#define STAGNANT              6
#define CONTINUE              7

/* Annealing modes */
#define CAUCHY                8
#define UNIFORM               9

/* object classes */
#define WEIGHT                10
#define BIAS                  11

#define ERROR                 999
#define PI                    3.14159

/******************************************************************************/
/*                                                                            */
/*   Networks data structure contains networks                                */
/*                                                                            */
/******************************************************************************/

struct node {                               /* Node Structure                 */
  int    first_weight_to,                   /* Index of the first and last    */
         last_weight_to,                    /*   weights to this node         */
         clamped;                           /* 1=>Output is clamped           */
  float  activation,                        /* Weighted sum of input to       */
         output,                            /* Sigmoided activation           */
         delta,
         bias_weight,
         bias_est[MAXESTIMATES],            /* Table of estimates of optimal  */
	                                    /* Bias weights in quickprop      */
         prevbed,                           /* Previous bias error derivative */
         bed,                               /* Bias error derivative          */
         dbias,                             /* Amount of bias change          */
         bedcache,                          /* bedcache and dbias cache are   */
         dbiascache,                        /* Used in cascade correlation    */
                                            /* To save the error derivatives  */
                                            /* From one processing mode when  */
                                            /* Switching to another           */
         cand_sum_value,                    /* Used for cascade correlation   */
                                            /* to accumulate outputs over an  */
                                            /* epoch                          */
         desired_output,                    /* The target value of the unit   */
         error;                             /* desired_output=output          */
         int freezetag;                     /* 1=>Bias is frozen and won't    */
                                            /*   change                       */
};

struct connectivity {                       /* Structure to hold the          */
  int to_layer,                             /*    connectivity between        */
      from_layer;                           /*    layers                      */
};

struct netstruct {                          /* Network Structure              */
  char        ID[MAXLINE];                  /* Network's label                */
  struct node *nodes[MAXNODES];             /* Vector of pointers to nodes    */
  float       weights[MAXWEIGHTS],          /* Vector of weights              */
              wed[MAXWEIGHTS],              /* Error derivative               */
              dweights[MAXWEIGHTS],         /* Amount of weight change        */
              weightest[MAXWEIGHTS][MAXESTIMATES];/* The estimates for the    */
		                            /* optimal weights in semi-epoch  */
		                            /* mode in quickprop              */
  float       accumweightchange;            /* Accumulated weight change      */
  int         nodesfrom[MAXWEIGHTS];        /* Indices of the link sources    */
  int         totalnodes,                   /* Total number of nodes          */
              inputnodes,                   /* Number of input nodes          */
              hiddennodes,                  /* Number of hidden nodes         */
              outputnodes,                  /* Number of output nodes         */
              outputweights,                /* Number of output weights       */
              nonoutputweights;             /* Number of non-output weights   */
  float       eta,                          /* Learning rate                  */
              alpha,                        /* Momentum                       */
              gamma,                        /* Non-reinforced learning rate   */
              weight_min,                   /* Constrains the weight range      */
              weight_max;
           struct connectivity
             connectivity_vector[MAXLAYERS];/* Connectivity                    */
  int        unitvector[MAXLAYERS];         /* Structure to hold               */
                                            /*    the # of units per layer     */
  int        distributed_layer;             /* The index of the layer of distr *
                                             * ibuted representations          */
  int        avg_mapped_weights_flag,       /* 1=>Average the weights of       *
                                             * mapped distributed reps         */
             avg_mapped_weds_flag,          /* 1=>Average the weds of the      *
                                             * mapped weights to the distr rep *
                                             * layer                           */
             avg_pen_mapped_weds_flag;      /* 1=>Average the weds of the      *
                                             * mapped weights to the out layer */
  float      sigmoid_prime_offset,          /* amount to add to sigmoide prime */
             out_sigmoid_prime_offset,      /* amount to add to s' of out units*/
             error_margin,                  /* amount from midpoint output     *
                                             * should be to pass criteria      */
             cutoff_margin;                 /* |out-desired| tolerance for     *
                                             * zeroifying the delta            */
  int        epoch_learn_flag,              /* 1=>learn by epoch (cycle)       *
                                             * instead of by pattern           */
             lflag,                         /* 1=>net learns                   */
             weights_from_file_flag,        /* 1=>Use the weights loaded in    *
                                             * from the weights file           */
             local_weights_flag,            /* 1=>Use the weights loaded in    *
                                             * from the weights file           */
             hyperr_flag,                   /* 1=>Use hyperbolic arctangent    *
                                             * for error function              */
             linear_flag,                   /* 1=>Use linear rather than       *
               				     * sigmoided output units          */
             linear_thresh_flag,           /* 1=>Use linear thresholded units  *
               				     * instead of sig. or lin. units   */
             symmetric_sig_flag,            /* 1=>Use sigmoid with range       *
                                             * (-.5,+.5)                       */
             quickprop_flag,                /* 1=>Use quickprop learning       *
					       algorithm                       */
             estimate_counter,              /* Number of estimates for the     *
					     * optimal weight which have been  *
					     * generated in qp semi-epoch mode */
             estimate_number,               /* The number of trials which      *
					     * are to elapse between weight    *
					     * changes which in qp semi-epoch  *
					     * mode                            */
             cutoff_error_flag,             /* sets error to 0 if its out-net  *
                                             * is in a small range             */
             nepochs,                       /* number of subepochs tacked to   *
					       an end of an epoch.  Implemented*
					       for quickprop only              */
             no_bias_flag;                  /* 1=>suppress bias                */
  float      prevwed[MAXWEIGHTS],	    /* Previous weight-error-deriv.    *
                                             * (slope) for quickprop use       */
             mu,                            /* The Max-increase factor in      *
                                             * quickprop                       */
             decay,                         /* Weight decay for quickprop      */
             curvature_threshold,           /* Limeter for the steepness of    *
					     * the sigmoid-prime slope in qp   */
             mode_switch_threshold;         /* Inside thresh, do grad descent; *
                                             * outside, jump                   */
          /******* Buffers for storing hidden unit activations ******/
  float      layerpat_buff1[MAXLAYERS][MAXPATTERNS][MAXINNODES],
             layerpat_buff2[MAXLAYERS][MAXPATTERNS][MAXINNODES];
  int        domain_switch_node;            /* index of the hidden unit used as*
                                             * a "domain switch"               */
          /************** Cascade Correlation Stuff ****************/
  int        cascor_flag,                   /* 1=> Using cascade correlation   *
                                             * rather than regular backprop    */
             cascor_training_mode,          /* Either INMODE or OUTMODE,       *
                                             * depending on whether candidates *
                                             * or output nodes are in training */
             just_won_flag,                 /* Set until error criteria is met */
             cycle_at_settling,             /* The cycle at which criteria was *
                                             * met                             */

             first_out_epoch,               /* Set to initizialize timeout and *
                                             * error information for out cycle */
             output_patience,               /* Number of cycles to go with     *
                                               little change in the output     *
                                               errors before stagnation is     *
                                               declared.                       */
             output_timeout,                /* The number of cycles (epochs)   *
                                             * allowed for an output round     *
                                             * before timeout is declared.     */
             timeout_epoch,                 /* The epoch to quit due to timeout*/
             quit_epoch,                    /* The epoch to quit due to        *
                                             * stagnation. Both timeout_epoch  *
                                             * and quit_epoch are used for     *
                                             * Input and Output phases         */
             first_in_epoch,                /* Set to jump to correlation      *
                                             * computation epoch for init phase*/
             first_in_train_epoch,          /* Set to initialize Candidate     *
                                               score and timeout information   */
             input_patience,                /* Number of cycles to go with     *
                                             * little change in the candidate  *
                                             * score before stagnation is      *
                                             * declared.                       */
             input_timeout,                 /* The number of epochs allowed    *
                                             * for an input round              */
             errorbits,                     /* The number of bits which are    *
                                             * over the error margin           */
             num_candidates,                /* The number of candidates to     *
                                             * create and train                */
             first_candidate,               /* Index of the first candidate    *
                                             * node in the network structure   */
             first_candidate_weight,        /* Index of the first candidate    *
                                             * weight in the structure         */
             best_candidate,                /* Index of the candidate with the *
                                             * best score                      */
             freezetag[MAXWEIGHTS];         /* Tags for frozen weights         *
                                             * 1=> frozen weight               */
float        input_eta,                     /* The learning rate for the       *
                                             * weights to the candidate units  */ 
             true_error,                    /* Like tss: The sum-squared       *
                                             * differences between output      *
                                             * and desired values of the output*
                                             * nodes.                          */
             last_error,                    /* Previous true-error, used for   *
                                             * stagnation checking in out round*/
             output_change_threshold,       /* The tolerable change in error   *
                                             * for stagnation criteria         */
             input_change_threshold,        /* The tolerable change in the     *
                                             * candidate score for stagnation  */
             best_candidate_score,          /* The normalized correlation of   *
                                             * the best candidate              */
             last_score,                    /* Previous best candidate score,  *
                                             * used for stagnation checking in *
                                             * in rounds.                      */
             sum_error,                     /* The accumulated deltas over an  *
                                             * epoch.  The program MUST be in  *
                                             * train-by-pattern mode in order  *
                                             * for this to work properly.      */
             sum_sq_error,                  /* The squared accumulated deltas  *
                                             * over an epoch of training.  The *
                                             * same warning above applies here */
             avg_error,                     /* The average of the deltas       *
                                             * over all outputs and patterns   */
             weight_multiplier,             /* The magnitude relative to the   *
					     * correlation between the new     *
					     * candidate and the output        */
             errorcache [MAXOUTNODES][MAXPATTERNS], /* Cache for the output    *
                                                     * errors, (deltas) used   *
                                                     * for correlation         */
             dweightscache[MAXWEIGHTS],     /* Used to swap candidate and      *
                                             * output dweights, to simulate    *
                                             * Crowder's code                  */
             wedcache[MAXWEIGHTS],          /* similar to dweightscache        */
             CandPrevCor[MAXCANDIDATES][MAXOUTNODES],
             CandCor[MAXCANDIDATES][MAXOUTNODES]; /* Table of candidate/output *
                                                   * correlations              */

  /* Annealing stuff */
  int    anneal_flag,                       /* 1=>annealing is active          */
         anneal_type;                       /* Mode of annealing (Cauchy, etc) */
  float  anneal_rate,                       /* rate of variance (temp) decline */
         anneal_variance,                   /* uniform variance or temperature */
         variance_scale,                    /* internal variable               */
         grad_coeff,                        /* weight of bp or qp weight adj   */
         anneal_coeff,                      /* weight of random weight adj     */
         boltz_cons;                        /* Constant used to scale the temp */
                                            /* In the boltzmann distr. fn.     */

   /* Training-set noise stuff */
  float  ts_noise_variance;                 /* The variance of the noise added */
                                            /* to the training pattterns       */
  int    ts_noise_type;                     /* Mode of ts noise (cauchy, etc)  */
};
  


/******************************************************************************/
/*                                                                            */
/*   Commands data structure holds commands for interpreter                   */
/*   and epoch structure which contains command block IDs                     */
/*                                                                            */
/******************************************************************************/


struct cmdstruct {
  int    cmdline;
  char   ID[MAXLINE];
  char   cmd[MAXCMDS][MAXLINE];
};

struct epochstruct {
  int    cmdline;
  char   cmd[MAXCMDS][MAXLINE];
};

/******************************************************************************/
/*                                                                            */
/*   Globals data structure holds global parameters                           */
/*                                                                            */
/******************************************************************************/

struct globalstruct {
  int maxcycles,     
      cycle_criteria,
      no_bias_flag,                       /* True if bias terms are          */
      no_output_bias_flag,                /*   elimnated                     */
      print_tn_change_flag,               /* Print TN/DN weight cumulative   */
      print_dn_change_flag,               /*   weight changes                */ 
      print_weight_flag,
      print_vc_tn_settled_flag,
      print_ve_cor_tn_settled_flag,
      print_ve_lin_tn_settled_flag,
      print_tss_flag,
      scale_error_flag,
      abs_error_flag,
      invert_error_flag,
      prob_decision_flag,
      mid_il_plateau_flag,
      rand_il_plateau_flag,
      randomize_ts_flag;
  float  weight_min,                      /* Constrains the weight range      */
         weight_max,
         error_scale,
         error_offset,
         cause_offset,
         error_threshold,
         mid_il_plateau_range,
         inner_loop_increment,
         inner_loop_min,
         inner_loop_max;
};
  
/******************************************************************************/
/*                                                                            */
/*   Training set data structure                                              */
/*                                                                            */
/******************************************************************************/

struct tsstruct {
  int in,                                 /* The number of input nodes        */
      out,                                /* The number of output nodes       */
      neg_cases,
      tsnum,                              /* the number of patterns           */
      layer[MAXLAYERS];                   /* the number of nodes in layer #i  */
  float  inpat[MAXPATTERNS][MAXINNODES],  /* The input and output patterns    */
         outpat[MAXPATTERNS][MAXOUTNODES],
         inpat_buff[MAXPATTERNS][MAXINNODES],/* copies of in and out pats for */
         outpat_buff[MAXPATTERNS][MAXINNODES],/* randomization                */
         layerpat[MAXLAYERS][MAXPATTERNS][MAXINNODES], /* The input patterns  */
                                                       /* for clamping a given*/
                                                       /* layer               */
         layerpat_buff[MAXLAYERS][MAXPATTERNS][MAXINNODES]; /* Temporary      */
                                          /* space used for storing and ma-   */
                                          /* nipulating distributed reps      */
};                                          


/******************************************************************************/
/*                                                                            */
/*   Structures to hold the symbolic mappings, the symbol table and the       */
/*   table of mapped nodes                                                    */
/*                                                                            */
/******************************************************************************/

struct mappingstruct {
  int  lastrow;         
  char source[MAXSYMBOLS][MAXLINE],                    /* corresponding source*/
       target[MAXSYMBOLS][MAXLINE];                    /* and target symbols  */
};

struct symbolstruct {                                  /* node index of each  */
  int  lastrow;
  int  index[MAXSYMBOLS];                              /* analogical symbol   */
  char symbol[MAXSYMBOLS][MAXLINE];
};

struct mapnodestruct {                                 /* table of correspond */
  int  lastrow;
  int  sourcenode[MAXSYMBOLS],                         /* ing nodes           */
       targetnode[MAXSYMBOLS];
};


/******************************************************************************/
/*                                                                            */
/*   Structure to hold the simulation state                                   */
/*                                                                            */
/******************************************************************************/

struct simstruct {
  int total_errors,
      cycles_correct,
      current_cycle,
      current_pattern,
      current_cmdblock,
      decision,
      did_gradient,                       /* The number of times a gradient  */
                                          /* descent occured in quickprop    */
      tnsettledcycles,                    /* The number of cycles the TN     */
                                          /*   settles in                    */
      first,                              /* Flag set when TN settles        */
      dn_cc_trigger_flag;                 /* 1=> Hidden units are added when */
                                          /*   the decision net stagnates    */
   float   dn_total_change,
           tn_total_change,
           dn_true_error,                 /* The combined tss of the YN and  */
                                          /* NN used for cascade correlation */
                                          /* hidden unit introduction        */
           dn_last_error;

};

