/*
 *    Codegenerator:  PARSE.C
 *
 */

#define __PARSE_C 1

#define SNET    0
#define LNET    1
#define CNET    2

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "util.h"
#include "error.h"
#include "y_tab.h"

#define ALLOC(typ)      (typ *)calloc(1,sizeof(typ))

extern BOOL ldim_used;

extern FILE      *yyout;
extern S_OBJECT  *s_actual;
extern short     s_sp,
		 vec_cnt;

struct
{
    S_OBJECT  *ps;
    S_REFLIST *psr;
} p_stk[MAXNEST];

STR_CHAIN       *str_root=0;
short           anz_dim=0, anz_fdim=0, ldc=0;

void pushp (S_OBJECT **s, S_REFLIST **sr)
{
    if      (s_sp  >=MAXNEST)
	Error (100+s_sp  );
    else if (s_sp+1>=MAXNEST)
	Error (100+s_sp+1);
    else
	p_stk[s_sp].ps= *s;

    p_stk[s_sp++].psr= *sr;

    *s  = 0;
    *sr = 0;
}

void popp(S_OBJECT **s, S_REFLIST **sr)
{
    if   (s_sp-1>=MAXNEST)
	Error (100+s_sp-1);
    else
	*s=p_stk[--s_sp].ps;
    if   (s_sp  >=MAXNEST)
	Error (100+s_sp  );
    else
	*sr=p_stk[s_sp].psr;
}

void free_all_range(RANGE *r)
{
    for (;r; r=r->r_next)
	free(r);
}

int anzid(STRING pStr)
{
    int nAnzahl = 0;

    for (;pStr && *pStr; pStr=strchr (pStr+1, ','))
	nAnzahl ++;

    return nAnzahl;
}

STRING indimlst(STRING idlist, STRING dim)  /* a,b --> a[1],b[1] */
{
	STRING r, aux, pCpy;

	if(!dim || !strlen(dim))
	    return idlist;

	r   =
	aux = (STRING)malloc(anzid(idlist)*strlen(dim)+strlen(idlist)+1);

	pCpy = idlist;

	while(*pCpy)
	{
	    while(
		isalnum(*pCpy) ||
		*pCpy=='_'     ||
		*pCpy=='*'
	    )
		*aux++ = *pCpy++;

	    *aux = '\0';

	    r    = strcat (r,dim);
	    aux += strlen (  dim);

	    if(*pCpy==',')
	    {
		r = strcat(r,",");

		aux ++;
		pCpy++;
	    }

	}

	*aux='\0';

	free(idlist);

	return r;
}

STRING init_zero (STRING idlist)
{
    STRING pCpy = idlist,
	   r    = (STRING)malloc(anzid(idlist)*2+strlen(idlist)+1),
	   aux  = r;

    while(isprint (*pCpy))
    {
	while(
	  isalnum(*pCpy) ||
	  *pCpy=='_'     ||
	  *pCpy=='*'
	)
	    *(aux++) = *pCpy++;

	*(aux++) = '=';
	*(aux++) = '0';

	if(*pCpy==',') {
	    *(aux++)=',';
	    pCpy++;
	}
    }
    free(idlist);
    *aux='\0';
    return r;
}

STRING make_varp (STRING idlist, short idtype)
/* a,bc --> *a,*bc */
{
    if((idtype != S_ARR) && (idtype != S_STRING))
    {
	STRING r    = (STRING)malloc(strlen(idlist)+anzid(idlist)+1),
	       aux  = r,
	       pCpy = idlist;

	while(*pCpy)
	{
	    *aux++='*';
	    while(
		isalnum(*pCpy) ||
		*pCpy=='_'     ||
		*pCpy=='*'
	    ) *aux++ = *pCpy++;

	    if(*pCpy==',') *aux++ = *pCpy++;
	}

	free(idlist);
	*aux='\0';
	return r;

    }

    return idlist;
}

void del_para (STRING f)
{
    for(; *f && *f != '('; f++);

    *f='\0';
}

void complex_ass (CEXP vt, CEXP vs, short ext)
{
    RANGE *aux;
    int i;

    fprintf (yyout,"reset_rng();");

    aux = vt.val.rlist;

    if(aux)
    {
	fprintf(yyout,"rflag[%d]=1;",vec_cnt);

	for(i=0; aux; aux=aux->r_next, i++)
	{
	    fprintf(yyout, "rng[%d][%d].lb=%s;", vec_cnt, i, aux->from);

	    if(aux->from == aux->to)
	       fprintf(
		   yyout,
		   "rng[%d][%d].ub=rng[%d][%d].lb;\n",
		   vec_cnt,
		   i,
		   vec_cnt,
		   i
	       );
	    else
		fprintf(
		    yyout,
		    "rng[%d][%d].ub=%s;\n",
		    vec_cnt,
		    i,
		    aux->to
		);

	}

	free_all_range(vt.val.rlist);

    }
    else
	fprintf(yyout,"rflag[%d]=0;",vec_cnt);

    vec_cnt++;

    aux = vs.val.rlist;

    if(aux)
    {
	fprintf(yyout,"rflag[%d]=1;",vec_cnt);

	for(i=0;aux;aux=aux->r_next,i++)
	{
	    fprintf(yyout,"rng[%d][%d].lb=%s;",vec_cnt,i,aux->from);

	    if(aux->from==aux->to)
		fprintf(
		    yyout,
		    "rng[%d][%d].ub=rng[%d][%d].lb;\n",
		    vec_cnt,
		    i,
		    vec_cnt,
		    i
		);
	    else
		fprintf(yyout,"rng[%d][%d].ub=%s;\n", vec_cnt,i,aux->to);

	}
	free_all_range(vs.val.rlist);
    }
    else
	fprintf(yyout,"rflag[%d]=0;", vec_cnt);

    fprintf(yyout,"init_idx(%d);init_idx(%d);",vec_cnt-1, vec_cnt);
    fprintf(
	 yyout,
	 "cmplx_vec_asgn(&%s,%d,%s,%d,%d);\n",
	 vt.expr,
	 vec_cnt-1,
	 vs.expr,
	 vec_cnt,ext
    );

    free(vt.expr);
    free(vs.expr);
}

RANGE *rangesave(RANGE r)
{
    RANGE *aux=ALLOC(RANGE);

    if(!aux)
	FatalError (ERR_MEMORY);

    aux->from   = r.from;
    aux->to     = r.to;
    aux->r_next = r.r_next;

    return aux;
}

RANGE append_range(RANGE *dd, RANGE *cr) /*liefert immer den 1. Range. */
{
    RANGE *aux;

    if(!dd->r_next)
    {
	dd->r_next=rangesave(*cr);
	return *dd;
    }

    for (aux=dd->r_next; aux->r_next!=0; aux=aux->r_next);

    aux->r_next=rangesave(*cr);

    return *dd;
}

CEXP complex_vec_eq(CEXP v1, CEXP v2, short neg)
{
    int     i;
    CEXP    res;
    RANGE  *aux;
    STRING  act,
	    cve;

    act =
    cve = (STRING)malloc(400);

    if(!act)
       FatalError (ERR_MEMORY);

    act += sprintf(act,"(rflag[%d]=1,",vec_cnt);

    for(aux=v1.val.rlist, i=0; aux; aux=aux->r_next, i++)
    {
	act += sprintf(act,"rng[%d][%d].lb=%s,", vec_cnt, i, aux->from);

	if(aux->from==aux->to)
	    act += sprintf(
		      act,
		      "rng[%d][%d].ub=rng[%d][%d].lb,\n",
		       vec_cnt,i,vec_cnt,i
		   );
	else
	    act += sprintf(act,"rng[%d][%d].ub=%s,\n",vec_cnt,i,aux->to);
    }

    free_all_range(v1.val.rlist);
    vec_cnt++;

    act += sprintf(act,"rflag[%d]=1,",vec_cnt);

    for (i=0, aux=v2.val.rlist; aux; aux=aux->r_next, i++)
    {
	act += sprintf(act,"rng[%d][%d].lb=%s,",vec_cnt,i,aux->from);

	if(aux->from==aux->to)
	    act += sprintf(
		     act,
		     "rng[%d][%d].ub=rng[%d][%d].lb,\n",
		     vec_cnt,
		     i,
		     vec_cnt,
		     i
		   );
	else
	    act += sprintf(act,"rng[%d][%d].ub=%s,\n",vec_cnt,i,aux->to);
    }

    free_all_range(v2.val.rlist);

    act += sprintf(act,"init_idx(%d),init_idx(%d),",vec_cnt-1,vec_cnt);

    if(neg)
	act += sprintf(
		 act,
		 "!cmplx_vec_eq(%s,%d,%s,%d))",
		 v1.expr,
		 vec_cnt-1,
		 v2.expr,
		 vec_cnt
	       );
    else
	act += sprintf(
		 act,
		 "cmplx_vec_eq(%s,%d,%s,%d))",
		 v1.expr,
		 vec_cnt-1,v2.expr,vec_cnt
	       );

    vec_cnt++;
    res.expr      = cve;
    res.val.rlist = 0;
    res.exprtyp   = st_ptr(S_INT);

    return res;
}


CEXP vec_neg(CEXP v)
{
    CEXP res;
    STRING  vecneg;
    RANGE  *aux;
    STRING  act;
    int     i;

    act    =
    vecneg = (STRING)malloc(400);

    if(!act)
	FatalError (ERR_MEMORY);

    if(v.val.rlist)
    {
	sprintf(act,"(rflag[%d]=1,",vec_cnt);

	act = vecneg+strlen(vecneg);

	for (i=0, aux=v.val.rlist; aux; aux=aux->r_next, i++)
	{
	    sprintf(act,"rng[%d][%d].lb=%s,",vec_cnt,i,aux->from);

	    act = vecneg+strlen(vecneg);

	    if(aux->from == aux->to)
		sprintf(
		    act,
		    "rng[%d][%d].ub=rng[%d][%d].lb,\n",
		    vec_cnt,
		    i,
		    vec_cnt,
		    i
		);
	    else
		sprintf(act,"rng[%d][%d].ub=%s,\n",vec_cnt,i,aux->to);

	    act = vecneg+strlen(vecneg);

	}
	free_all_range(v.val.rlist);
	sprintf(
	    act,
	    "init_idx(%d), cmplx_vec_neg(%s,%d))",
	    vec_cnt,
	    v.expr,
	    vec_cnt
	);

	vec_cnt++;
    }
    else
	sprintf(act, "vec_neg(%s)", v.expr);

    res.val.rlist = 0;
    res.expr      = vecneg;
    res.exprtyp   = st_ptr(S_VECT);

    return res;
}

CEXP compute_vect(short op, CEXP v1, CEXP v2)
{
    RANGE  *aux;
    int     i;
    CEXP res;
    STRING  com_vec,
	    act;

    if(v1.val.rlist==0 && v2.val.rlist==0)
    {
	com_vec=(STRING)malloc(strlen(v1.expr)+strlen(v2.expr)+12);

	if(!com_vec)
	    FatalError (ERR_MEMORY);

	switch(op)
	{
	  case V_ADD:
	    sprintf(com_vec,"vec_add(%s,%s)",v1.expr,v2.expr);
	    res.exprtyp=st_ptr(S_VECT);
	    break;

	  case V_SUB:
	    sprintf(com_vec,"vec_sub(%s,%s)",v1.expr,v2.expr);
	    res.exprtyp=st_ptr(S_VECT); break;
	  case V_MUL:
	    if(v1.exprtyp==st_ptr(S_VECT))
	    {
		 sprintf(com_vec,"vec_mul(%s,%s)",v1.expr,v2.expr);
		 res.exprtyp=st_ptr(S_PROC);
	    }
	    else
	    {
		sprintf(com_vec,"vec_skal(%s,%s)",v1.expr,v2.expr);
		res.exprtyp=st_ptr(S_VECT);
	    }
	    break;

	}
	res.expr      = com_vec;
	res.val.rlist = 0;

	return res;
    }

    act     =
    com_vec = (STRING)malloc(300);

    if(!act)
	FatalError (ERR_MEMORY);

    if(v1.exprtyp->st_type==S_VECT || v1.exprtyp->st_type==S_VPROC)
    {
	 if(v1.val.rlist==0)
	     act += sprintf(act,"(rflag[%d]=0,", vec_cnt);

	 else
	 {
	     act += sprintf(act,"(rflag[%d]=1,", vec_cnt);

	     for (i=0, aux=v1.val.rlist; aux; aux=aux->r_next, i++)
	     {
		 act += sprintf(
			    act,
			    "rng[%d][%d].lb=%s,",
			    vec_cnt,
			    i,
			    aux->from
			);

		 if (aux->from==aux->to)
		    act += sprintf(
			     act,
			     "rng[%d][%d].ub=rng[%d][%d].lb,\n",
			     vec_cnt,
			     i,
			     vec_cnt,
			     i
			   );
		 else
		    act += sprintf(
			     act,
			     "rng[%d][%d].ub=%s,\n",
			     vec_cnt,
			     i,
			     aux->to
			   );

	     }
	     free_all_range(v1.val.rlist);
	 }
	 vec_cnt++;
    }

    if(!v2.val.rlist)
	 act += sprintf(act,"rflag[%d]=0,",vec_cnt);
    else
    {
	act += sprintf(act,"rflag[%d]=1,", vec_cnt);

	for (i=0, aux=v2.val.rlist; aux; aux=aux->r_next, i++)
	{
	    act += sprintf(act,"rng[%d][%d].lb=%s,",vec_cnt,i,aux->from);

	    if(aux->from==aux->to)
		act += sprintf(
			act,
			"rng[%d][%d].ub=rng[%d][%d].lb,\n",
			vec_cnt,
			i,
			vec_cnt,
			i
		    );
	    else
		act += sprintf(
			act,
			"rng[%d][%d].ub=%s,\n",
			vec_cnt,
			i,
			aux->to
		       );
	}
	free_all_range(v2.val.rlist);
    }
    switch (op)
    {
      case V_ADD:
	res.exprtyp = st_ptr(S_VECT);
	act += sprintf(
		 act,
		 "cmplx_vec_add(%s,%d,%s,%d))",
		 v1.expr,
		 vec_cnt-1,
		 v2.expr,
		 vec_cnt
	       );
	break;

      case V_SUB:
	res.exprtyp = st_ptr(S_VECT);
	sprintf(
	    act,
	    "cmplx_vec_sub(%s,%d,%s,%d))",
	    v1.expr,
	    vec_cnt-1,
	    v2.expr,
	    vec_cnt
	);
	break;

      case V_MUL:
	if(v1.exprtyp->st_type!=S_VECT)
	{
	    res.exprtyp=st_ptr(S_VECT);

	    act += sprintf(
		     act,
		     "cmplx_vec_scal(%s,%s,%d))",
		     v1.expr,
		     v2.expr,
		     vec_cnt
		   );
	}
	else
	{
	    res.exprtyp=st_ptr(S_PROC);
	    act += sprintf(
		     act,
		     "cmplx_vec_mul(%s,%d,%s,%d))",
		     v1.expr,
		     vec_cnt-1,
		     v2.expr,
		     vec_cnt
		   );
	}
	break;
    }

    vec_cnt++;
    res.expr      = com_vec;
    res.val.rlist = 0;
    return res;
}

void ins_str_chain(STRING id)
{
    STR_CHAIN *new=ALLOC(STR_CHAIN);

    if(!new)
	FatalError (ERR_MEMORY);

    new->s        = id;
    new->str_next = str_root;
    str_root      = new;
}

BOOL in_chain(STRING id)
{
    STR_CHAIN *aux;

    for (aux=str_root; aux; aux=aux->str_next)
	if(!strcmp(aux->s,id))
	    return TRUE;

    return FALSE;
}

void def_top(L_OBJECT *aux)
{
    STRING    pStr;
    short     i;
    L_OBJECT *sub;

    if(!aux)
	return;

    def_top (aux->l_next);

    if(!aux->l_descflg)
	return;

    if (aux->l_desc.l_desc1.l_sublay)
	def_top(aux->l_desc.l_desc1.l_sublay);

    if (in_chain (aux->l_name))
	return;

    fprintf(yyout,"typedef struct {");

    if(aux->l_desc.l_desc1.l_fielddim[0])
    {
       fprintf(yyout,"%s ", aux->l_desc.l_desc1.l_fieldunit);

       for (i=0; aux->l_desc.l_desc1.l_fielddim[i]; i++)
	  fprintf(yyout,"*");

       fprintf(yyout,"fld;");
    }

    fprintf(yyout,"%s *pool;", aux->l_desc.l_desc1.l_poolunit);

    for (sub=aux->l_desc.l_desc1.l_sublay; sub; sub=sub->l_next)
    {
	pStr=upstr(sub->l_descflg ? sub->l_name : sub->l_desc.l_ptr->l_name);

	fprintf (yyout, "%s *%s", pStr, sub->l_name);
	free    (pStr                              );

	for (i=0; sub->l_dim[i]>0; i++)
	    fprintf(yyout,"[%s]",sub->l_dim[i]);

	out  (";" );
	free (pStr);
    }

    pStr = upstr(aux->l_name);

    fprintf       (yyout,"} %s;\n", pStr);
    free          (pStr                 );
    ins_str_chain (aux->l_name          );
}

void allo_nsub_fld (STRING t, L_OBJECT *l, short afd, int mode)
{
    short i=afd;
    STRING tp=t+strlen(t);

    if (mode==CNET) {
	    fprintf(
		yyout,
		"%s=CALLOC(%s,%s ",
		t,
		l->l_desc.l_desc1.l_fielddim[anz_fdim-afd],
		l->l_desc.l_desc1.l_fieldunit
	    );
	
	    while(--i)
		fprintf(yyout,"*");
	
	    fprintf(yyout,");\n");
	
	    /* SAM-ON */
	
	    if (!strcmp(l->l_desc.l_desc1.l_fieldunit,"UNIT"))
		fprintf(
			yyout,
			"setnull(%s,%s);\n",
			t,
			l->l_desc.l_desc1.l_fielddim[anz_fdim-afd]
		);
	
	    /* SAM-OFF */
    }

    if (mode==LNET)
	    if (!strcmp(l->l_desc.l_desc1.l_fieldunit,"UNIT"))
		fprintf(
			yyout,
			"loadunits(%s,%s,fdsc);\n",
			t,
			l->l_desc.l_desc1.l_fielddim[anz_fdim-afd]
		);

    if (mode==SNET) 
	    if (!strcmp(l->l_desc.l_desc1.l_fieldunit,"UNIT"))
		fprintf(
			yyout,
			"saveunits(%s,%s,fdsc);\n",
			t,
			l->l_desc.l_desc1.l_fielddim[anz_fdim-afd]
		);
	
    if(afd>1)
    {
	sprintf(tp,"[d%d]", afd-1);
	fprintf(
	    yyout,
	    "for (d%d=0; d%d<%s; d%d++)\n{",
	    afd-1,
	    afd-1,
	    l->l_desc.l_desc1.l_fielddim[anz_fdim-afd],
	    afd-1
	);

	allo_nsub_fld (t,l,afd-1,mode);
	fprintf       (yyout,"}");
    }
}

void allo_nsub(STRING t, STRING obj, L_OBJECT *l, int mode)
{
    L_OBJECT *sub;
    BOOL      f  = FALSE;
    STRING    tp = t+strlen(t),
	      pStr;
    short     i,
	      afd,
	      ldc_tmp = ldc,
	      t_len   = strlen(t);

    for (i=0; l->l_desc.l_desc1.l_fielddim[i]; i++);

    afd      =
    anz_fdim = i;

    if(i>1)
    {
	fprintf(yyout,"short ");

	while(i-->1)
	    fprintf(yyout,"d%d%s",i,i==1?";":",");
    }

    if (mode==CNET) {
	    fprintf (yyout,"%s = ALLOC(%s);\n", t, obj);
	    if(l->l_desc.l_desc1.l_poolsiz)
		fprintf(
		    yyout,
		    "%s->pool=CALLOC(%s,%s);\n",
		    t,
		    l->l_desc.l_desc1.l_poolsiz,
		    l->l_desc.l_desc1.l_poolunit
		);

	    /* SAM-ON */

	    if ((l->l_desc.l_desc1.l_poolsiz)&&(!strcmp(l->l_desc.l_desc1.l_poolunit,"UNIT")))
		fprintf(
			yyout,
			"setnull(%s,%s);\n",
			t,
			l->l_desc.l_desc1.l_poolsiz
		);

	    /* SAM-OFF */
    }

    if (mode==LNET) 
	    if ((l->l_desc.l_desc1.l_poolsiz)&&(!strcmp(l->l_desc.l_desc1.l_poolunit,"UNIT")))
		fprintf(
			yyout,
			"loadunits(%s,%s,fdsc);\n",
			t,
			l->l_desc.l_desc1.l_poolsiz
		);
    

    if (mode==SNET)
	    if ((l->l_desc.l_desc1.l_poolsiz)&&(!strcmp(l->l_desc.l_desc1.l_poolunit,"UNIT")))
		fprintf(
			yyout,
			"saveunits(%s,%s,fdsc);\n",
			t,
			l->l_desc.l_desc1.l_poolsiz
		);


    sprintf(tp,"->fld");

    if(afd)
	allo_nsub_fld(t,l,afd,mode);

    t[t_len]='\0';
    tp=t+strlen(t);

    if(!l)
	return;

    for (sub=l->l_desc.l_desc1.l_sublay; sub; sub=sub->l_next)
    {
	anz_dim=0;

	for (i=0; sub->l_dim[i]; i++) anz_dim++;

	tp += sprintf(tp,"->%s",sub->l_name);

	fprintf(yyout,"{%s ", anz_dim?"short":"");

	for (i=0; i<anz_dim; i++)
	    fprintf(yyout,"ii%d%s",ldc_tmp++, i+1==anz_dim?";":",");

	for (i=0; i<anz_dim; i++,ldc++)
	{
	    sprintf (tp,"[ii%d]",ldc);
	    tp=t+strlen(t); f=TRUE;

	    fprintf(
		yyout,
		"for (ii%d;ii%d<%s;ii%d++)",
		ldc,
		ldc,
		sub->l_dim[i],
		ldc
	    );
	}

	if(f)
	    fprintf(yyout,"{");

	if(sub->l_descflg)
	{
	    pStr = upstr(sub->l_name);

	    allo_nsub (t, pStr, sub, mode );
	    free      (pStr         );
	}
	else
	{
	    pStr = upstr(sub->l_desc.l_ptr->l_name);

	    allo_nsub (t, pStr, sub->l_desc.l_ptr,mode);
	    free      (   pStr                   );
	}

	if(f)
	    out("}}\n");
	else
	    out("}\n");

	t[t_len] = '\0';
	tp       = t+strlen(t);
	ldc_tmp  = ldc;

    }
}

void allo_ntop (STRING t, STRING obj, STRING *dynamic_dim, short anzd, int mode)
{
    short  i;
    STRING tp = t+strlen(t);

    if(!anzd)
    {
	allo_nsub (t, obj, s_actual->s_descriptor.netw.net_descriptor,mode);
	return;
    }

    fprintf (yyout,"{ short i%d;", anzd);
    if (mode==CNET) {
	    fprintf(
		yyout,
		"%s=CALLOC(%s,%s ",
		t,
		ldim_used ?
		   dynamic_dim[anz_dim-anzd] :
		   s_actual->s_descriptor.netw.s_dim [anz_dim-anzd],
		obj
	    );

	    for(i=0; i<anzd; i++)
		fprintf(yyout,"*");

	    fprintf(yyout,");\n");

	    /* SAM-ON */

	    if (!strcmp(s_actual->s_descriptor.netw.s_dim[anz_dim-anzd],"UNIT"))
		fprintf(
			yyout,
			"setnull(%s,%s);\n",
			t,
			ldim_used ?
				dynamic_dim[anz_dim-anzd] :
				s_actual->s_descriptor.netw.s_dim[anz_dim-anzd]
		);
	
	    /* SAM-OFF */
    }

    if (mode==LNET)
	    if (!strcmp(s_actual->s_descriptor.netw.s_dim[anz_dim-anzd],"UNIT"))
		fprintf(
			yyout,
			"loadunits(%s,%s,fdsc);\n",
			t,
			ldim_used ?
				dynamic_dim[anz_dim-anzd] :
				s_actual->s_descriptor.netw.s_dim[anz_dim-anzd]
		);


    if (mode==SNET)
	    if (!strcmp(s_actual->s_descriptor.netw.s_dim[anz_dim-anzd],"UNIT"))
		fprintf(
			yyout,
			"saveunits(%s,%s,fdsc);\n",
			t,
			ldim_used ?
				dynamic_dim[anz_dim-anzd] :
				s_actual->s_descriptor.netw.s_dim[anz_dim-anzd]
		);


    fprintf(
	yyout,
	"for (i%d=0; i%d<%s; i%d++)\n{",
	anzd,
	ldim_used ?
	    dynamic_dim[anz_dim-anzd] :
	    s_actual->s_descriptor.netw.s_dim[anz_dim-anzd]
    );

    sprintf(tp,"[i%d]", anzd);

    allo_ntop (t, obj, dynamic_dim, anzd-1, mode);
    fprintf   (yyout,"}}\n"               );
}

BOOL cre_top(STRING id, STRING *dynamic_dim, int mode)
{
    short     dyn_ad, i;
    L_OBJECT *aux;
    STRING    target,
	      ntyp;

    aux = s_actual->s_descriptor.netw.net_descriptor;

    for (i=0; s_actual->s_descriptor.netw.s_dim[i]; i++, anz_dim++);

    for (dyn_ad=i=0; dynamic_dim[i]; i++, dyn_ad++);

    if(ldim_used && dyn_ad!=anz_dim)
	return FALSE;

    target = (STRING)malloc(300);

    if(!target)
	FatalError (ERR_MEMORY);

    sprintf (target,id);

    ntyp = upstr(aux->l_name);

    fprintf   (yyout, "{"                        );
    allo_ntop (target, ntyp, dynamic_dim, anz_dim, mode);
    fprintf   (yyout, "}"                        );

    free (target);
    free (ntyp  );

    ldc     = 0;
    anz_dim = 0;

    return TRUE;
}

void print_usp (STR_CHAIN* us_proc)
{
    STR_CHAIN *aux;

    for (aux=us_proc; aux; aux=aux->str_next)
	fprintf(yyout,"%s\n",aux->s);
}

void out(STRING s)
{
    fputs(s, yyout);
}


