/*
 *    Runtime definitions: condela.h
 *
 */

#ifndef __CONDELA_H
#define __CONDELA_H 1

#define MAXEXP       20
#define MAXRANGELEN  20

typedef float (*INIT_FKT) (void);

typedef struct weight {
        float gew;
        struct weight *to_next, *from_next;
        struct unit *c_to, *c_from;
} WEIGHT;

typedef struct unit {
        float net, out, del;
        WEIGHT *c_to, *c_from;
} UNIT;

typedef struct {
        float net, out, del, more;
        WEIGHT *c_to, *c_from;
} special_unit;

#define ALLOC(typ)      (typ *)calloc(1,sizeof(typ))
#define CALLOC(anz,typ) (typ *)calloc(anz,sizeof(typ))
#define FREE(ptr)       free(ptr)

typedef char * STRING;
typedef struct vector {
                short vlen;
                float *vloc;
        } VECTOR;
typedef struct usel {
                UNIT *p;
                struct usel *u_next;
        } USEL;

int    runtime_err (int);

short  resize_vec  (VECTOR*, short);
void   clear_vec   (VECTOR,  short);
short  create_vec  (VECTOR*, short);
void   read_vec    (VECTOR*       );
void   write_vec   (VECTOR        );

short  vec_eq   (VECTOR,  VECTOR       );
VECTOR vec_add  (VECTOR,  VECTOR       );
VECTOR vec_sub  (VECTOR,  VECTOR       );
VECTOR vec_neg  (VECTOR                );
float  vec_mul  (VECTOR,  VECTOR       );
VECTOR vec_skal (float,   VECTOR       );
short  vec_asgn (VECTOR*, VECTOR, short);

void   reset_rng (     );
void   init_idx  (short);
short  next_idx  (short);

short  cmplx_vec_eq   (VECTOR,  short, VECTOR, short       );
void   cmplx_vec_asgn (VECTOR*, short, VECTOR, short, short);
void   cmplx_vec_init (VECTOR*, short, float               );
VECTOR cmplx_vec_neg  (VECTOR,  short                      );
VECTOR cmplx_vec_add  (VECTOR,  short, VECTOR, short       );
VECTOR cmplx_vec_sub  (VECTOR,  short, VECTOR, short       );
float  cmplx_vec_mul  (VECTOR,  short, VECTOR, short       );
VECTOR cmplx_vec_scal (float,          VECTOR, short       );

void   ins_usc  (USEL**, UNIT*);
void   less_usc (USEL**, UNIT*);

float  random    (       );
int    random_to (int max);

void   free_all_usel (USEL *s);

void   connect_u  (UNIT*,  USEL*, STRING, INIT_FKT, float, short, short);
void   connect    (USEL*,  USEL*, STRING, INIT_FKT, float, short, short);
void   re_connect (UNIT**, int,   int                                  );

short  in_list (short, short*, short);
short  rnd_p   (short, short        );
int    trunc   (float               );

float  transfer   (float);
float  transfer_1 (float);

void   ff     (        USEL*);
void   bp_out (VECTOR, USEL*);
void   bp_hid (        USEL*);

#ifndef __CONDELA_C
extern struct {
           short lb,
                 ub;
       } rng [MAXEXP][MAXRANGELEN];

extern short idx     [MAXEXP],
             rng_idx [MAXEXP],
             rflag   [MAXEXP];
#endif

#endif
