#include <math.h>
#include <malloc.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

/*#################################################################

   Change this statement to use a different impurity measure. */

#define IMPURITY info_gain()
/* possible values are: maxminority                             */
/*			summinority				*/
/*			sum_of_impurities			*/
/*			info_gain				*/
/*			gini_index				*/
/*			twoing					*/

/*#################################################################*/


#define LEFT 			0
#define RIGHT 			1
#define LESS_THAN 		0
#define MORE_THAN 		1
#define TRUE 			1
#define FALSE 			0
#define MAX_COEFFICIENT 	100
#define SEQUENTIAL 		0
#define RANDOM 			1 
#define BEST_FIRST 		2
#define MAX_DT_DEPTH 		50 
#define CORRECT 		1
#define INCORRECT 		0
#define LINESIZE 		80
#define TOLERANCE		0.0001
#define MAX_DIMENSIONS		100


#define translatex(x) ((x - xmin) * (pmaxx - pminx) / (xmax - xmin) + pminx)
#define translatey(y) ((y - ymin) * (pmaxy - pminy) / (ymax - ymin) + pminy)

typedef struct point
 {
   float *dimension;
   int category;
   double val; /*Value obtained by substituting this point in the 
                equation of the hyperplane under consideration.
                This field is maintained to avoid redundant
                computation. */
 }POINT;

struct endpoint
 {
  float x,y;
 };

typedef struct edge
 {
  struct endpoint from,to;
 }EDGE;



struct tree_node
 {
  float *coefficients;
  int *left_count, *right_count;
  struct tree_node *parent,*left,*right;
  int left_cat,right_cat;
  char label[MAX_DT_DEPTH];
  float alpha; /* used only in error_complexity pruning. */
  int no_of_points;
  EDGE edge; /* used only in the display module. */
 };

struct unidim
 {
  float value;
  int cat;
 };

struct test_outcome
 {
  float leaf_count,tree_depth;
  float accuracy;
  int *class; /*For each class, store the number of correctly
                classified examples and total number of examples */
 };

void error(),free_ivector(),free_vector(),free_dvector();
float myrandom(),*vector();
double *dvector();
int *ivector();
