#!/home/garfield/tmp/tk3.6/wish -f
# Program: tkmobal
# Tcl version: 7.3 (Tcl/Tk/XF)
# Tk version: 3.6
# XF version: 2.2
#


# procedure to show window ShowWindow.knowledge
proc ShowWindow.knowledge { args} {
# xf ignore me 7

  # build widget .knowledge
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .knowledge"
  } {
    catch "destroy .knowledge"
  }
  toplevel .knowledge   -relief {raised}

  # Window manager configurations
  global tkVersion
  wm positionfrom .knowledge program
  wm sizefrom .knowledge program
  wm maxsize .knowledge 1024 1024
  wm title .knowledge {Knowledge Revision}


  # build widget .knowledge.frame0
  frame .knowledge.frame0  -relief {raised}

  # build widget .knowledge.frame0.frame
  frame .knowledge.frame0.frame

  # build widget .knowledge.frame0.frame.scrollbar3
  scrollbar .knowledge.frame0.frame.scrollbar3  -command {.knowledge.frame0.frame.listbox1 xview}  -orient {horizontal}  -relief {raised}

  # build widget .knowledge.frame0.frame.scrollbar2
  scrollbar .knowledge.frame0.frame.scrollbar2  -command {.knowledge.frame0.frame.listbox1 yview}  -relief {raised}

  # build widget .knowledge.frame0.frame.listbox1
  listbox .knowledge.frame0.frame.listbox1  -exportselection {0}  -geometry {1x10}  -relief {raised}  -xscrollcommand {.knowledge.frame0.frame.scrollbar3 set}  -yscrollcommand {.knowledge.frame0.frame.scrollbar2 set} -geometry 20x5
  # bindings
  bind .knowledge.frame0.frame.listbox1 <B1-Motion> {%W select from [%W nearest %y]}
  bind .knowledge.frame0.frame.listbox1 <Button-1> {%W select from [%W nearest %y]; KnowledgeSelectItem}
  bind .knowledge.frame0.frame.listbox1 <Shift-B1-Motion> {%W select from [%W nearest %y]}
  bind .knowledge.frame0.frame.listbox1 <Shift-Button-1> {%W select from [%W nearest %y]}

  # build widget .knowledge.frame0.frame.frame8
  frame .knowledge.frame0.frame.frame8  -borderwidth {2}  -relief {raised}

  # build widget .knowledge.frame0.frame.frame8.label9
  label .knowledge.frame0.frame.frame8.label9  -borderwidth {1}  -text {Inferences To Remove}  -width {30}

  # pack widget .knowledge.frame0.frame.frame8
  pack append .knowledge.frame0.frame.frame8  .knowledge.frame0.frame.frame8.label9 {top frame center expand}

  # build widget .knowledge.frame0.frame.frame17
  frame .knowledge.frame0.frame.frame17  -borderwidth {2}  -relief {raised}

  # build widget .knowledge.frame0.frame.frame17.button18
  button .knowledge.frame0.frame.frame17.button18  -command {KnowledgeAdd}  -height {1}  -text {Add}  -width {8}

  # build widget .knowledge.frame0.frame.frame17.button19
  button .knowledge.frame0.frame.frame17.button19  -command {KnowledgeFlipSign}  -height {1}  -text {Flip Sign}  -width {8}

  # build widget .knowledge.frame0.frame.frame17.button20
  button .knowledge.frame0.frame.frame17.button20  -command {KnowledgeRemove}  -height {1}  -text {Remove}  -width {8}

  # pack widget .knowledge.frame0.frame.frame17
  pack append .knowledge.frame0.frame.frame17  .knowledge.frame0.frame.frame17.button18 {left frame center padx 6 pady 6 expand}  .knowledge.frame0.frame.frame17.button19 {left frame center padx 6 pady 6 expand}  .knowledge.frame0.frame.frame17.button20 {left frame center padx 6 pady 6 expand}

  # pack widget .knowledge.frame0.frame
  pack append .knowledge.frame0.frame  .knowledge.frame0.frame.frame8 {top frame center fill}  .knowledge.frame0.frame.frame17 {bottom frame center fill}  .knowledge.frame0.frame.scrollbar2 {left frame center filly}  .knowledge.frame0.frame.listbox1 {top frame center expand fill}  .knowledge.frame0.frame.scrollbar3 {bottom frame center fillx}

  # build widget .knowledge.frame0.frame2
  frame .knowledge.frame0.frame2

  # build widget .knowledge.frame0.frame2.scrollbar3
  scrollbar .knowledge.frame0.frame2.scrollbar3  -command {.knowledge.frame0.frame2.listbox1 xview}  -orient {horizontal}  -relief {raised}

  # build widget .knowledge.frame0.frame2.scrollbar2
  scrollbar .knowledge.frame0.frame2.scrollbar2  -command {.knowledge.frame0.frame2.listbox1 yview}  -relief {raised}

  # build widget .knowledge.frame0.frame2.listbox1
  listbox .knowledge.frame0.frame2.listbox1  -exportselection {0}  -geometry {1x1}  -relief {raised}  -xscrollcommand {.knowledge.frame0.frame2.scrollbar3 set}  -yscrollcommand {.knowledge.frame0.frame2.scrollbar2 set} -geometry 20x5
  # bindings
  bind .knowledge.frame0.frame2.listbox1 <B1-Motion> {%W select from [%W nearest %y]}
  bind .knowledge.frame0.frame2.listbox1 <Button-1> {%W select from [%W nearest %y]; KnowledgeSelectSet}
  bind .knowledge.frame0.frame2.listbox1 <Shift-B1-Motion> {%W select from [%W nearest %y]}
  bind .knowledge.frame0.frame2.listbox1 <Shift-Button-1> {%W select from [%W nearest %y]}

  # build widget .knowledge.frame0.frame2.frame1
  frame .knowledge.frame0.frame2.frame1  -borderwidth {2}  -relief {raised}

  # build widget .knowledge.frame0.frame2.frame1.label2
  label .knowledge.frame0.frame2.frame1.label2  -borderwidth {1}  -height {1}  -text {Minimal Removal Sets}  -width {23}

  # pack widget .knowledge.frame0.frame2.frame1
  pack append .knowledge.frame0.frame2.frame1  .knowledge.frame0.frame2.frame1.label2 {top frame center expand}

  # build widget .knowledge.frame0.frame2.frame21
  frame .knowledge.frame0.frame2.frame21  -borderwidth {2}  -relief {raised}

  # build widget .knowledge.frame0.frame2.frame21.button22
  button .knowledge.frame0.frame2.frame21.button22  -command {KnowledgeRecompute}  -height {1}  -text {Recompute}  -width {12}

  # pack widget .knowledge.frame0.frame2.frame21
  pack append .knowledge.frame0.frame2.frame21  .knowledge.frame0.frame2.frame21.button22 {left frame center padx 6 pady 6 expand}

  # pack widget .knowledge.frame0.frame2
  pack append .knowledge.frame0.frame2  .knowledge.frame0.frame2.frame1 {top frame center fill}  .knowledge.frame0.frame2.frame21 {bottom frame center fill}  .knowledge.frame0.frame2.scrollbar2 {left frame center filly}  .knowledge.frame0.frame2.listbox1 {top frame center expand fill}  .knowledge.frame0.frame2.scrollbar3 {bottom frame center fillx}

  # build widget .knowledge.frame0.frame3
  frame .knowledge.frame0.frame3

  # build widget .knowledge.frame0.frame3.scrollbar3
  scrollbar .knowledge.frame0.frame3.scrollbar3  -command {.knowledge.frame0.frame3.listbox1 xview}  -orient {horizontal}  -relief {raised}

  # build widget .knowledge.frame0.frame3.scrollbar2
  scrollbar .knowledge.frame0.frame3.scrollbar2  -command {.knowledge.frame0.frame3.listbox1 yview}  -relief {raised}

  # build widget .knowledge.frame0.frame3.listbox1
  listbox .knowledge.frame0.frame3.listbox1  -exportselection {0}  -geometry {1x1}  -relief {raised}  -xscrollcommand {.knowledge.frame0.frame3.scrollbar3 set}  -yscrollcommand {.knowledge.frame0.frame3.scrollbar2 set} -geometry 20x5
  # bindings
  bind .knowledge.frame0.frame3.listbox1 <B1-Motion> {%W select from [%W nearest %y]}
  bind .knowledge.frame0.frame3.listbox1 <Button-1> {%W select from [%W nearest %y]; KnowledgeSelectSetItem}
  bind .knowledge.frame0.frame3.listbox1 <Shift-B1-Motion> {%W select from [%W nearest %y]}
  bind .knowledge.frame0.frame3.listbox1 <Shift-Button-1> {%W select from [%W nearest %y]}

  # build widget .knowledge.frame0.frame3.frame4
  frame .knowledge.frame0.frame3.frame4  -borderwidth {2}  -relief {raised}

  # build widget .knowledge.frame0.frame3.frame4.label6
  label .knowledge.frame0.frame3.frame4.label6  -borderwidth {1}  -height {1}  -text {Chosen Set}  -width {23}

  # pack widget .knowledge.frame0.frame3.frame4
  pack append .knowledge.frame0.frame3.frame4  .knowledge.frame0.frame3.frame4.label6 {top frame center expand}

  # build widget .knowledge.frame0.frame3.frame24
  frame .knowledge.frame0.frame3.frame24  -borderwidth {2}  -relief {raised}

  # build widget .knowledge.frame0.frame3.frame24.frame26
  frame .knowledge.frame0.frame3.frame24.frame26  -relief {raised}

  # build widget .knowledge.frame0.frame3.frame24.frame26.label30
  label .knowledge.frame0.frame3.frame24.frame26.label30  -text {N: }

  # build widget .knowledge.frame0.frame3.frame24.frame26.label44
  label .knowledge.frame0.frame3.frame24.frame26.label44  -text {0}

  # pack widget .knowledge.frame0.frame3.frame24.frame26
  pack append .knowledge.frame0.frame3.frame24.frame26  .knowledge.frame0.frame3.frame24.frame26.label30 {left frame center}  .knowledge.frame0.frame3.frame24.frame26.label44 {left frame center}

  # build widget .knowledge.frame0.frame3.frame24.frame45
  frame .knowledge.frame0.frame3.frame24.frame45  -relief {raised}

  # build widget .knowledge.frame0.frame3.frame24.frame45.label47
  label .knowledge.frame0.frame3.frame24.frame45.label47  -text {K:}

  # build widget .knowledge.frame0.frame3.frame24.frame45.label48
  label .knowledge.frame0.frame3.frame24.frame45.label48  -text {0.00}

  # pack widget .knowledge.frame0.frame3.frame24.frame45
  pack append .knowledge.frame0.frame3.frame24.frame45  .knowledge.frame0.frame3.frame24.frame45.label47 {left frame center}  .knowledge.frame0.frame3.frame24.frame45.label48 {left frame center}

  # build widget .knowledge.frame0.frame3.frame24.frame46
  frame .knowledge.frame0.frame3.frame24.frame46  -relief {raised}

  # build widget .knowledge.frame0.frame3.frame24.frame46.label49
  label .knowledge.frame0.frame3.frame24.frame46.label49  -text {c:}

  # build widget .knowledge.frame0.frame3.frame24.frame46.label50
  label .knowledge.frame0.frame3.frame24.frame46.label50  -text {0}

  # pack widget .knowledge.frame0.frame3.frame24.frame46
  pack append .knowledge.frame0.frame3.frame24.frame46  .knowledge.frame0.frame3.frame24.frame46.label49 {left frame center}  .knowledge.frame0.frame3.frame24.frame46.label50 {left frame center}

  # pack widget .knowledge.frame0.frame3.frame24
  pack append .knowledge.frame0.frame3.frame24  .knowledge.frame0.frame3.frame24.frame26 {left frame center padx 6 pady 6 expand fillx}  .knowledge.frame0.frame3.frame24.frame45 {left frame center padx 6 pady 6 expand fillx}  .knowledge.frame0.frame3.frame24.frame46 {left frame center padx 6 pady 6 expand fillx}

  # pack widget .knowledge.frame0.frame3
  pack append .knowledge.frame0.frame3  .knowledge.frame0.frame3.frame4 {top frame center fill}  .knowledge.frame0.frame3.frame24 {bottom frame center fill}  .knowledge.frame0.frame3.scrollbar2 {left frame center filly}  .knowledge.frame0.frame3.listbox1 {top frame center expand fill}  .knowledge.frame0.frame3.scrollbar3 {bottom frame center fillx}

  # build widget .knowledge.frame0.frame0
  frame .knowledge.frame0.frame0

  # build widget .knowledge.frame0.frame0.scrollbar3
  scrollbar .knowledge.frame0.frame0.scrollbar3  -command {.knowledge.frame0.frame0.listbox1 xview}  -orient {horizontal}  -relief {raised}

  # build widget .knowledge.frame0.frame0.scrollbar2
  scrollbar .knowledge.frame0.frame0.scrollbar2  -command {.knowledge.frame0.frame0.listbox1 yview}  -relief {raised}

  # build widget .knowledge.frame0.frame0.listbox1
  listbox .knowledge.frame0.frame0.listbox1  -exportselection {0}  -geometry {1x1}  -relief {raised}  -xscrollcommand {.knowledge.frame0.frame0.scrollbar3 set}  -yscrollcommand {.knowledge.frame0.frame0.scrollbar2 set} -geometry 20x5
  # bindings
  bind .knowledge.frame0.frame0.listbox1 <B1-Motion> {%W select from [%W nearest %y]}
  bind .knowledge.frame0.frame0.listbox1 <Shift-B1-Motion> {%W select from [%W nearest %y]}
  bind .knowledge.frame0.frame0.listbox1 <Shift-Button-1> {%W select from [%W nearest %y]}

  # build widget .knowledge.frame0.frame0.frame11
  frame .knowledge.frame0.frame0.frame11  -borderwidth {2}  -relief {raised}

  # build widget .knowledge.frame0.frame0.frame11.label13
  label .knowledge.frame0.frame0.frame11.label13  -borderwidth {1}  -height {1}  -text {Item Info}  -width {23}

  # pack widget .knowledge.frame0.frame0.frame11
  pack append .knowledge.frame0.frame0.frame11  .knowledge.frame0.frame0.frame11.label13 {top frame center expand}

  # build widget .knowledge.frame0.frame0.frame35
  frame .knowledge.frame0.frame0.frame35  -borderwidth {2}  -relief {raised}

  # build widget .knowledge.frame0.frame0.frame35.frame37
  frame .knowledge.frame0.frame0.frame35.frame37  -relief {raised}

  # build widget .knowledge.frame0.frame0.frame35.frame37.label40
  label .knowledge.frame0.frame0.frame35.frame37.label40  -text {K:}

  # build widget .knowledge.frame0.frame0.frame35.frame37.label41
  label .knowledge.frame0.frame0.frame35.frame37.label41  -text {0}

  # pack widget .knowledge.frame0.frame0.frame35.frame37
  pack append .knowledge.frame0.frame0.frame35.frame37  .knowledge.frame0.frame0.frame35.frame37.label40 {left frame center}  .knowledge.frame0.frame0.frame35.frame37.label41 {left frame center}

  # build widget .knowledge.frame0.frame0.frame35.frame38
  frame .knowledge.frame0.frame0.frame35.frame38  -relief {raised}

  # build widget .knowledge.frame0.frame0.frame35.frame38.label42
  label .knowledge.frame0.frame0.frame35.frame38.label42  -text {c:}

  # build widget .knowledge.frame0.frame0.frame35.frame38.label43
  label .knowledge.frame0.frame0.frame35.frame38.label43  -text {0.0}

  # pack widget .knowledge.frame0.frame0.frame35.frame38
  pack append .knowledge.frame0.frame0.frame35.frame38  .knowledge.frame0.frame0.frame35.frame38.label42 {left frame center}  .knowledge.frame0.frame0.frame35.frame38.label43 {left frame center}

  # pack widget .knowledge.frame0.frame0.frame35
  pack append .knowledge.frame0.frame0.frame35  .knowledge.frame0.frame0.frame35.frame37 {left frame center padx 6 pady 6 expand fillx}  .knowledge.frame0.frame0.frame35.frame38 {left frame center expand fillx}

  # pack widget .knowledge.frame0.frame0
  pack append .knowledge.frame0.frame0  .knowledge.frame0.frame0.frame11 {top frame center fill}  .knowledge.frame0.frame0.frame35 {bottom frame center fill}  .knowledge.frame0.frame0.scrollbar2 {left frame center filly}  .knowledge.frame0.frame0.listbox1 {top frame center expand fill}  .knowledge.frame0.frame0.scrollbar3 {bottom frame center fillx}

  # pack widget .knowledge.frame0
  pack append .knowledge.frame0  .knowledge.frame0.frame {left frame center expand fill}  .knowledge.frame0.frame2 {left frame center expand fill}  .knowledge.frame0.frame3 {left frame center expand fill}  .knowledge.frame0.frame0 {left frame center expand fill}

  # build widget .knowledge.frame1
  frame .knowledge.frame1  -borderwidth {2}  -relief {raised}

  # build widget .knowledge.control.frame1
  frame .knowledge.frame1.control  -borderwidth {0}  -relief {raised}

  # build widget .knowledge.frame1.control.label51
  label .knowledge.frame1.control.label51  -anchor {w}  -borderwidth {1}  -text {Please left click to (un)mark additional entries. Select "Do It" when you have finished.}

  button .knowledge.frame1.control.small  -anchor {w}  -text {Smaller}  -command "[SN KnowledgeGraph].xfgraph.graph.xfcanvas.xfcanvas.xfcanvas config -height \[expr \[lindex \[[SN KnowledgeGraph].xfgraph.graph.xfcanvas.xfcanvas.xfcanvas config -height\] 4\]-10\]"

  button .knowledge.frame1.control.big  -anchor {w}  -text {Bigger}  -command "[SN KnowledgeGraph].xfgraph.graph.xfcanvas.xfcanvas.xfcanvas config -height \[expr \[lindex \[[SN KnowledgeGraph].xfgraph.graph.xfcanvas.xfcanvas.xfcanvas config -height\] 4\]+10\]"

  # pack widget .knowledge.frame1
  pack append .knowledge.frame1.control  .knowledge.frame1.control.big {right fill}  .knowledge.frame1.control.small {right fill}  .knowledge.frame1.control.label51 {left frame w fillx}

  # pack widget .knowledge.frame1
  pack append .knowledge.frame1  .knowledge.frame1.control {top frame w fillx}

  # build widget .knowledge.frame14
  frame .knowledge.frame14  -borderwidth {2}  -relief {raised}

  # build widget .knowledge.frame14.button15
  button .knowledge.frame14.button15  -command {KnowledgeDoIt}  -height {1}  -text {Do It}  -width {9}

  # build widget .knowledge.frame14.button16
  button .knowledge.frame14.button16  -command {KnowledgeCancel}  -height {1}  -text {Cancel}  -width {9}

  # pack widget .knowledge.frame14
  pack append .knowledge.frame14  .knowledge.frame14.button15 {left frame center padx 6 pady 6}  .knowledge.frame14.button16 {right frame center padx 6 pady 6}

  # pack widget .knowledge
  pack append .knowledge  .knowledge.frame0 {top frame center expand fill}  .knowledge.frame1 {top frame center expand fill}  .knowledge.frame14 {bottom frame center fill}

  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .knowledge"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.knowledge {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .knowledge]" != ""} {
      global xfShowWindow.knowledge
      set xfShowWindow.knowledge 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .knowledge; XFEditSetShowWindows"
    }
  } {
    catch "destroy .knowledge"
    update
  }
}


# procedure to show window ShowWindow.metaPred
proc ShowWindow.metaPred { args} {
# xf ignore me 7

  # build widget .metaPred
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .metaPred"
  } {
    catch "destroy .metaPred"
  }
  toplevel .metaPred   -relief {raised}

  # Window manager configurations
  global tkVersion
  wm positionfrom .metaPred program
  wm sizefrom .metaPred program
  wm maxsize .metaPred 1000 1000
  wm title .metaPred {Meta Predicates}


  # build widget .metaPred.frame52
  frame .metaPred.frame52  -relief {raised}

  # build widget .metaPred.frame52.frame
  frame .metaPred.frame52.frame

  # build widget .metaPred.frame52.frame.scrollbar3
  scrollbar .metaPred.frame52.frame.scrollbar3  -command {.metaPred.frame52.frame.listbox1 xview}  -orient {horizontal}  -relief {raised}

  # build widget .metaPred.frame52.frame.scrollbar2
  scrollbar .metaPred.frame52.frame.scrollbar2  -command {.metaPred.frame52.frame.listbox1 yview}  -relief {raised}

  # build widget .metaPred.frame52.frame.listbox1
  listbox .metaPred.frame52.frame.listbox1  -exportselection {0}  -relief {raised}  -xscrollcommand {.metaPred.frame52.frame.scrollbar3 set}  -yscrollcommand {.metaPred.frame52.frame.scrollbar2 set} -geometry 20x5
  # bindings
  bind .metaPred.frame52.frame.listbox1 <B1-Motion> {%W select from [%W nearest %y]}
  bind .metaPred.frame52.frame.listbox1 <Button-1> {%W select from [%W nearest %y]; MetaPredSelectItem}
  bind .metaPred.frame52.frame.listbox1 <Shift-B1-Motion> {%W select from [%W nearest %y]}
  bind .metaPred.frame52.frame.listbox1 <Shift-Button-1> {%W select from [%W nearest %y]}

  # build widget .metaPred.frame52.frame.frame58
  frame .metaPred.frame52.frame.frame58  -borderwidth {2}  -relief {raised}

  # build widget .metaPred.frame52.frame.frame58.label64
  label .metaPred.frame52.frame.frame58.label64  -borderwidth {1}  -text {Variables}

  # pack widget .metaPred.frame52.frame.frame58
  pack append .metaPred.frame52.frame.frame58  .metaPred.frame52.frame.frame58.label64 {top frame center}

  # pack widget .metaPred.frame52.frame
  pack append .metaPred.frame52.frame  .metaPred.frame52.frame.frame58 {top frame center fillx}  .metaPred.frame52.frame.scrollbar2 {left frame center filly}  .metaPred.frame52.frame.listbox1 {top frame center expand fill}  .metaPred.frame52.frame.scrollbar3 {bottom frame center fillx}

  # build widget .metaPred.frame52.frame54
  frame .metaPred.frame52.frame54

  # build widget .metaPred.frame52.frame54.scrollbar3
  scrollbar .metaPred.frame52.frame54.scrollbar3  -command {.metaPred.frame52.frame54.listbox1 xview}  -orient {horizontal}  -relief {raised}

  # build widget .metaPred.frame52.frame54.scrollbar2
  scrollbar .metaPred.frame52.frame54.scrollbar2  -command {.metaPred.frame52.frame54.listbox1 yview}  -relief {raised}

  # build widget .metaPred.frame52.frame54.listbox1
  listbox .metaPred.frame52.frame54.listbox1  -exportselection {0}  -relief {raised}  -xscrollcommand {.metaPred.frame52.frame54.scrollbar3 set}  -yscrollcommand {.metaPred.frame52.frame54.scrollbar2 set} -geometry 20x5
  # bindings
  bind .metaPred.frame52.frame54.listbox1 <Double-Button-1> {MetaPredRemove}

  # build widget .metaPred.frame52.frame54.frame59
  frame .metaPred.frame52.frame54.frame59  -borderwidth {2}  -relief {raised}

  # build widget .metaPred.frame52.frame54.frame59.label65
  label .metaPred.frame52.frame54.frame59.label65  -borderwidth {1}  -text {Restrictions}

  # pack widget .metaPred.frame52.frame54.frame59
  pack append .metaPred.frame52.frame54.frame59  .metaPred.frame52.frame54.frame59.label65 {top frame center}

  # build widget .metaPred.frame52.frame54.frame60
  frame .metaPred.frame52.frame54.frame60  -borderwidth {2}  -relief {raised}

  # build widget .metaPred.frame52.frame54.frame60.button66
  button .metaPred.frame52.frame54.frame60.button66  -command {MetaPredRemove}  -height {1}  -text {Remove restriction}  -width {20}

  # pack widget .metaPred.frame52.frame54.frame60
  pack append .metaPred.frame52.frame54.frame60  .metaPred.frame52.frame54.frame60.button66 {top frame center padx 6 pady 6}

  # pack widget .metaPred.frame52.frame54
  pack append .metaPred.frame52.frame54  .metaPred.frame52.frame54.frame59 {top frame center fillx}  .metaPred.frame52.frame54.frame60 {bottom frame center fill}  .metaPred.frame52.frame54.scrollbar2 {left frame center filly}  .metaPred.frame52.frame54.listbox1 {top frame center expand fill}  .metaPred.frame52.frame54.scrollbar3 {bottom frame center fillx}

  # build widget .metaPred.frame52.frame55
  frame .metaPred.frame52.frame55

  # build widget .metaPred.frame52.frame55.scrollbar3
  scrollbar .metaPred.frame52.frame55.scrollbar3  -command {.metaPred.frame52.frame55.listbox1 xview}  -orient {horizontal}  -relief {raised}

  # build widget .metaPred.frame52.frame55.scrollbar2
  scrollbar .metaPred.frame52.frame55.scrollbar2  -command {.metaPred.frame52.frame55.listbox1 yview}  -relief {raised}

  # build widget .metaPred.frame52.frame55.listbox1
  listbox .metaPred.frame52.frame55.listbox1  -exportselection {0}  -relief {raised}  -xscrollcommand {.metaPred.frame52.frame55.scrollbar3 set}  -yscrollcommand {.metaPred.frame52.frame55.scrollbar2 set} -geometry 20x5
  # bindings
  bind .metaPred.frame52.frame55.listbox1 <Double-Button-1> {MetaPredAdd}

  # build widget .metaPred.frame52.frame55.frame62
  frame .metaPred.frame52.frame55.frame62  -borderwidth {2}  -relief {raised}

  # build widget .metaPred.frame52.frame55.frame62.label67
  label .metaPred.frame52.frame55.frame62.label67  -borderwidth {1}  -text {Predicates}

  # pack widget .metaPred.frame52.frame55.frame62
  pack append .metaPred.frame52.frame55.frame62  .metaPred.frame52.frame55.frame62.label67 {top frame center}

  # build widget .metaPred.frame52.frame55.frame63
  frame .metaPred.frame52.frame55.frame63  -borderwidth {2}  -relief {raised}

  # build widget .metaPred.frame52.frame55.frame63.button68
  button .metaPred.frame52.frame55.frame63.button68  -command {MetaPredAdd}  -text {Add restriction}  -width {20}

  # pack widget .metaPred.frame52.frame55.frame63
  pack append .metaPred.frame52.frame55.frame63  .metaPred.frame52.frame55.frame63.button68 {top frame center padx 6 pady 6}

  # pack widget .metaPred.frame52.frame55
  pack append .metaPred.frame52.frame55  .metaPred.frame52.frame55.frame62 {top frame center fillx}  .metaPred.frame52.frame55.frame63 {bottom frame center fillx}  .metaPred.frame52.frame55.scrollbar2 {left frame center filly}  .metaPred.frame52.frame55.listbox1 {top frame center expand fill}  .metaPred.frame52.frame55.scrollbar3 {bottom frame center fillx}

  # pack widget .metaPred.frame52
  pack append .metaPred.frame52  .metaPred.frame52.frame {left frame center expand fill}  .metaPred.frame52.frame54 {left frame center expand fill}  .metaPred.frame52.frame55 {left frame center expand fill}

  # build widget .metaPred.frame53
  frame .metaPred.frame53  -borderwidth {2}  -relief {raised}

  # build widget .metaPred.frame53.button56
  button .metaPred.frame53.button56  -command {MetaPredDoIt}  -height {1}  -text {Do It}  -width {8}

  # build widget .metaPred.frame53.button57
  button .metaPred.frame53.button57  -command {MetaPredCancel}  -height {1}  -text {Cancel}  -width {8}

  # pack widget .metaPred.frame53
  pack append .metaPred.frame53  .metaPred.frame53.button56 {left frame center padx 6 pady 6}  .metaPred.frame53.button57 {right frame center padx 6 pady 6}

  # pack widget .metaPred
  pack append .metaPred  .metaPred.frame52 {top frame center expand fill}  .metaPred.frame53 {top frame center fillx}

  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .metaPred"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.metaPred {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .metaPred]" != ""} {
      global xfShowWindow.metaPred
      set xfShowWindow.metaPred 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .metaPred; XFEditSetShowWindows"
    }
  } {
    catch "destroy .metaPred"
    update
  }
}


# procedure to show window .
proc ShowWindow. {args} {# xf ignore me 7

  # Window manager configurations
  global tkVersion
  wm positionfrom . user
  wm sizefrom . user
  wm maxsize . 1152 900
  wm minsize . 10 10
  if {$tkVersion >= 3.0} {
    wm protocol . WM_DELETE_WINDOW {MobalFileQuit}
  }
  wm title . {Mobal}


  # build widget .frame0
  frame .frame0 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .frame0.frame2
  frame .frame0.frame2 \
    -relief {raised}

  # build widget .frame0.frame2.frame5
  frame .frame0.frame2.frame5 \
    -relief {raised}

  # build widget .frame0.frame2.frame5.frame18
  frame .frame0.frame2.frame5.frame18 \
    -relief {raised}

  # build widget .frame0.frame2.frame5.frame18.mobalDomain
  menubutton .frame0.frame2.frame5.frame18.mobalDomain \
    -anchor {w} \
    -borderwidth {0} \
    -menu {.frame0.frame2.frame5.frame18.mobalDomain.m} \
    -text {} \
    -textvariable {mobal(domainShort)}

  # build widget .frame0.frame2.frame5.frame18.mobalDomain.m
  menu .frame0.frame2.frame5.frame18.mobalDomain.m \
    -postcommand {MiscDomainNameUpdate}
  .frame0.frame2.frame5.frame18.mobalDomain.m add command

  # build widget .frame0.frame2.frame5.frame18.mobalStatus
  label .frame0.frame2.frame5.frame18.mobalStatus \
    -anchor {w} \
    -borderwidth {0} \
    -relief {raised} \
    -text {Ready} \
    -textvariable {mobal(status)} \
    -width {30}

  # build widget .frame0.frame2.frame5.frame18.mobalVersion
  label .frame0.frame2.frame5.frame18.mobalVersion \
    -borderwidth {0} \
    -relief {raised} \
    -text {3.0b}

  # pack widget .frame0.frame2.frame5.frame18
  pack append .frame0.frame2.frame5.frame18 \
    .frame0.frame2.frame5.frame18.mobalDomain {bottom frame w} \
    .frame0.frame2.frame5.frame18.mobalStatus {left frame center expand fill} \
    .frame0.frame2.frame5.frame18.mobalVersion {left frame center}

  # build widget .frame0.frame2.frame5.mobalLabel
  label .frame0.frame2.frame5.mobalLabel \
    -anchor {w} \
    -borderwidth {0} \
    -relief {raised} \
    -text {MOBAL}

  # pack widget .frame0.frame2.frame5
  pack append .frame0.frame2.frame5 \
    .frame0.frame2.frame5.mobalLabel {top frame center fillx} \
    .frame0.frame2.frame5.frame18 {top frame center expand fill}

  # build widget .frame0.frame2.gmdLabel
  label .frame0.frame2.gmdLabel \
    -borderwidth {0} \
    -relief {raised} \
    -text {GMD}
  # bindings
  bind .frame0.frame2.gmdLabel <Triple-Button-1> {MiscSetDebugging}

  # pack widget .frame0.frame2
  pack append .frame0.frame2 \
    .frame0.frame2.frame5 {left frame center expand fill} \
    .frame0.frame2.gmdLabel {top frame center expand fill}

  # build widget .frame0.frame3
  frame .frame0.frame3 \
    -relief {raised}

  # build widget .frame0.frame3.button4
  button .frame0.frame3.button4 \
    -command {MobalFileQuit} \
    -text {  Quit  } \
    -width {7}

  # pack widget .frame0.frame3
  pack append .frame0.frame3 \
    .frame0.frame3.button4 {top frame center padx 6 pady 6 expand}

  # pack widget .frame0
  pack append .frame0 \
    .frame0.frame2 {left frame center expand fill} \
    .frame0.frame3 {top frame center expand fill}

  # build widget .frame1
  frame .frame1 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .frame1.frame7
  frame .frame1.frame7 \
    -relief {raised}

  # build widget .frame1.frame7.button10
  button .frame1.frame7.button10 \
    -command {MobalFileHelp top} \
    -state {disabled} \
    -text {  Help  }

  # build widget .frame1.frame7.button11
  button .frame1.frame7.button11 \
    -command {MobalFileCloseWindows} \
    -text {  Close Windows  } \
    -width {15}

  # build widget .frame1.frame7.button9
  button .frame1.frame7.button9 \
    -command {MobalFileUserGuide} \
    -state {disabled} \
    -text {  User Guide  } \
    -width {15}

  # pack widget .frame1.frame7
  pack append .frame1.frame7 \
    .frame1.frame7.button9 {left frame center padx 6 pady 6 expand} \
    .frame1.frame7.button10 {left frame center expand} \
    .frame1.frame7.button11 {left frame center expand}

  # build widget .frame1.frame8
  frame .frame1.frame8 \
    -relief {raised}

  # build widget .frame1.frame8.menubutton0
  menubutton .frame1.frame8.menubutton0 \
    -menu {.frame1.frame8.menubutton0.m} \
    -text {CKRL} \
    -width {9}

  # build widget .frame1.frame8.menubutton0.m
  menu .frame1.frame8.menubutton0.m
  .frame1.frame8.menubutton0.m add command \
    -command {MobalCKRLReadFile} \
    -label {Read CKRL File...}
  .frame1.frame8.menubutton0.m add command \
    -command {MobalCKRLWriteFile} \
    -label {Write CKRL File...}
  .frame1.frame8.menubutton0.m add separator
  .frame1.frame8.menubutton0.m add command \
    -command {MobalCKRLClearKB} \
    -label {Clear CKRL KB}
  .frame1.frame8.menubutton0.m add command \
    -command {MobalCKRLLoadKB} \
    -label {Load CKRL KB...}
  .frame1.frame8.menubutton0.m add command \
    -command {MobalCKRLSaveKBAs} \
    -label {Save CKRL KB As...}
  .frame1.frame8.menubutton0.m add command \
    -command {MobalCKRLDeleteKB} \
    -label {Delete CKRL KB File...}
  .frame1.frame8.menubutton0.m add separator
  .frame1.frame8.menubutton0.m add command \
    -command {MobalCKRLCKRLToMobal} \
    -label {CKRL -> MOBAL}
  .frame1.frame8.menubutton0.m add command \
    -command {MobalCKRLMobalToCKRL} \
    -label {MOBAL -> CKRL}
  .frame1.frame8.menubutton0.m add separator
  .frame1.frame8.menubutton0.m add command \
    -command {MobalCKRLShow all_defs} \
    -label {Show all Defs}
  .frame1.frame8.menubutton0.m add command \
    -command {MobalCKRLShow sort_defs} \
    -label {Show Sort Defs}
  .frame1.frame8.menubutton0.m add command \
    -command {MobalCKRLShow modifier_defs} \
    -label {Show Modifier Defs}
  .frame1.frame8.menubutton0.m add command \
    -command {MobalCKRLShow function_defs} \
    -label {Show Function Defs}
  .frame1.frame8.menubutton0.m add command \
    -command {MobalCKRLShow property_defs} \
    -label {Show Property Defs}
  .frame1.frame8.menubutton0.m add command \
    -command {MobalCKRLShow relation_defs} \
    -label {Show Relation Defs}
  .frame1.frame8.menubutton0.m add command \
    -command {MobalCKRLShow instance_defs} \
    -label {Show Instance Defs}
  .frame1.frame8.menubutton0.m add command \
    -command {MobalCKRLShow rule_defs} \
    -label {Show Rule Defs}
  .frame1.frame8.menubutton0.m add command \
    -command {MobalCKRLShow concept_defs} \
    -label {Show Concept Defs}
  .frame1.frame8.menubutton0.m add command \
    -command {MobalCKRLShow block_defs} \
    -label {Show Block Defs}
  .frame1.frame8.menubutton0.m add command \
    -command {MobalCKRLShow target_defs} \
    -label {Show Target Defs}
  .frame1.frame8.menubutton0.m add command \
    -command {MobalCKRLShow facts} \
    -label {Show Facts}
  .frame1.frame8.menubutton0.m add separator
  .frame1.frame8.menubutton0.m add command \
    -command {MobalCKRLShow translated} \
    -label {Show translated}
  .frame1.frame8.menubutton0.m add command \
    -command {MobalCKRLShow not_translated} \
    -label {Show not translated}
  .frame1.frame8.menubutton0.m add separator
  .frame1.frame8.menubutton0.m add command \
    -command {MobalCKRLClearKB
set mobal(CKRL) 0
MobalCallCKRL} \
    -label {Clear & Quit CKRL}

  # build widget .frame1.frame8.menubutton12
  menubutton .frame1.frame8.menubutton12 \
    -menu {.frame1.frame8.menubutton12.m} \
    -text {  File  } \
    -underline {2} \
    -width {9}

  # build widget .frame1.frame8.menubutton12.m
  menu .frame1.frame8.menubutton12.m
  .frame1.frame8.menubutton12.m add command \
    -command {MobalFileNewDomain} \
    -label {New Domain} \
    -underline {0}
  .frame1.frame8.menubutton12.m add command \
    -command {MobalFileOpenDomain} \
    -label {Open Domain...} \
    -underline {0}
  .frame1.frame8.menubutton12.m add separator
  .frame1.frame8.menubutton12.m add command \
    -command {MobalFileSaveDomain} \
    -label {Save Domain} \
    -underline {0}
  .frame1.frame8.menubutton12.m add command \
    -command {MobalFileSaveDomainAs} \
    -label {Save Domain As...} \
    -underline {12}
  .frame1.frame8.menubutton12.m add separator
  .frame1.frame8.menubutton12.m add command \
    -command {MobalFileDeleteDomain} \
    -label {Delete Domain Files...} \
    -underline {0}
  .frame1.frame8.menubutton12.m add separator
  .frame1.frame8.menubutton12.m add command \
    -command {MobalFileWriteDomain} \
    -label {Save As Text...} \
    -underline {8}
  .frame1.frame8.menubutton12.m add command \
    -command {MobalFileReadDomain} \
    -label {Read From Text...} \
    -underline {0}
  .frame1.frame8.menubutton12.m add separator
  .frame1.frame8.menubutton12.m add command \
    -command {MobalFilePrintDomain} \
    -label {Printout Of Domain...} \
    -underline {0}
  .frame1.frame8.menubutton12.m add separator
  .frame1.frame8.menubutton12.m add command \
    -command {MobalFileQuit} \
    -label {Quit} \
    -underline {0}

  # build widget .frame1.frame8.menubutton13
  menubutton .frame1.frame8.menubutton13 \
    -menu {.frame1.frame8.menubutton13.m} \
    -text {  View  } \
    -underline {2} \
    -width {9}

  # build widget .frame1.frame8.menubutton13.m
  menu .frame1.frame8.menubutton13.m
  .frame1.frame8.menubutton13.m add command \
    -command {MobalViewInputScratchPad} \
    -label {Input Scratchpad}
  .frame1.frame8.menubutton13.m add command \
    -command {MobalViewParams} \
    -label {Parameter Display}
  .frame1.frame8.menubutton13.m add command \
    -command {MobalViewPrologListener} \
    -label {Prolog Listener}
  .frame1.frame8.menubutton13.m add separator
  .frame1.frame8.menubutton13.m add command \
    -command {MobalViewView agenda} \
    -label {Agenda}
  .frame1.frame8.menubutton13.m add cascade \
    -label {Topology} \
    -menu {.frame1.frame8.menubutton13.m.m}
  .frame1.frame8.menubutton13.m add command \
    -command {MobalViewView sclass} \
    -label {Sorts}
  .frame1.frame8.menubutton13.m add separator
  .frame1.frame8.menubutton13.m add command \
    -command {MobalViewView fact} \
    -label {Facts}
  .frame1.frame8.menubutton13.m add command \
    -command {MobalViewView pred} \
    -label {Predicates}
  .frame1.frame8.menubutton13.m add command \
    -command {MobalViewView rule} \
    -label {Rules}
  .frame1.frame8.menubutton13.m add command \
    -command {MobalViewView ic} \
    -label {Constraints}
  .frame1.frame8.menubutton13.m add separator
  .frame1.frame8.menubutton13.m add command \
    -command {MobalViewView mpred} \
    -label {Metapredicates}
  .frame1.frame8.menubutton13.m add command \
    -command {MobalViewView mfact} \
    -label {Metafacts}
  .frame1.frame8.menubutton13.m add command \
    -command {MobalViewView mrule} \
    -label {Metarules}
  .frame1.frame8.menubutton13.m add separator
  .frame1.frame8.menubutton13.m add command \
    -command {MobalViewView mmpred} \
    -label {Metametapredicates}
  .frame1.frame8.menubutton13.m add command \
    -command {MobalViewView mmfact} \
    -label {Metametafacts}

  # build widget .frame1.frame8.menubutton13.m.m
  menu .frame1.frame8.menubutton13.m.m
  .frame1.frame8.menubutton13.m.m add command \
    -command {MobalViewView tnode {} list1} \
    -label {list1}
  .frame1.frame8.menubutton13.m.m add command \
    -command {MobalViewView tnode {} list2} \
    -label {list2}

  # build widget .frame1.frame8.menubutton14
  menubutton .frame1.frame8.menubutton14 \
    -menu {.frame1.frame8.menubutton14.m} \
    -text {  Windows  } \
    -underline {2} \
    -width {9}

  # build widget .frame1.frame8.menubutton14.m
  menu .frame1.frame8.menubutton14.m \
    -postcommand {MobalWindowsUpdate}

  # build widget .frame1.frame8.menubutton15
  menubutton .frame1.frame8.menubutton15 \
    -menu {.frame1.frame8.menubutton15.m} \
    -text {  Call  } \
    -underline {2} \
    -width {9}

  # build widget .frame1.frame8.menubutton15.m
  menu .frame1.frame8.menubutton15.m
  .frame1.frame8.menubutton15.m add command \
    -command {MobalCallRecomputeWindows} \
    -label {Recompute Windows}
  .frame1.frame8.menubutton15.m add separator
  .frame1.frame8.menubutton15.m add command \
    -command {MobalCallQueryFact} \
    -label {Query Fact}
  .frame1.frame8.menubutton15.m add command \
    -command {MobalCallQueryMFact} \
    -label {Query MFact}
  .frame1.frame8.menubutton15.m add command \
    -command {MobalCallQueryMMFact} \
    -label {Query MMFact}
  .frame1.frame8.menubutton15.m add separator
  .frame1.frame8.menubutton15.m add command \
    -command {MobalCallCheckConstraints} \
    -label {Check Constraints}
  .frame1.frame8.menubutton15.m add separator
  .frame1.frame8.menubutton15.m add command \
    -command {MobalCallProlog} \
    -label {Prolog}
  .frame1.frame8.menubutton15.m add separator
  .frame1.frame8.menubutton15.m add command \
    -command {MobalCallTool rdt} \
    -label {RDT}
  .frame1.frame8.menubutton15.m add command \
    -command {MobalCallTool clt} \
    -label {CLT}
  .frame1.frame8.menubutton15.m add separator
  .frame1.frame8.menubutton15.m add command \
    -command {MobalCallLoadTool} \
    -label {Load Tool...}
  .frame1.frame8.menubutton15.m add cascade \
    -label {External Tools} \
    -menu {.frame1.frame8.menubutton15.m.m}
  .frame1.frame8.menubutton15.m add separator
  .frame1.frame8.menubutton15.m add command \
    -command {MobalCallUpdateSorts} \
    -label {Update Sorts}
  .frame1.frame8.menubutton15.m add separator
  .frame1.frame8.menubutton15.m add command \
    -command {MobalCallGenerateTopology} \
    -label {Generate Topology}
  .frame1.frame8.menubutton15.m add command \
    -command {MobalCallCreateTopology} \
    -label {Create New Topology}
  .frame1.frame8.menubutton15.m add separator
  .frame1.frame8.menubutton15.m add checkbutton \
    -command {MobalCallCKRL} \
    -label {CKRL} \
    -variable {mobal(CKRL)}

  # build widget .frame1.frame8.menubutton15.m.m
  menu .frame1.frame8.menubutton15.m.m \
    -postcommand {MobalWindowsUpdate}

  # pack widget .frame1.frame8
  pack append .frame1.frame8 \
    .frame1.frame8.menubutton12 {left frame center padx 6 pady 6 expand} \
    .frame1.frame8.menubutton13 {left frame center padx 6 pady 6 expand} \
    .frame1.frame8.menubutton14 {left frame center padx 6 pady 6 expand} \
    .frame1.frame8.menubutton15 {left frame center padx 6 pady 6 expand}

  # pack widget .frame1
  pack append .frame1 \
    .frame1.frame7 {top frame center fill} \
    .frame1.frame8 {top frame center fill}

  # pack widget .
  pack append . \
    .frame0 {top frame center fill} \
    .frame1 {top frame center expand fill}

  global tkVersion
  if {$tkVersion >= 3.0} {
    tk_menuBar .frame1.frame8 .frame1.frame8.menubutton12 .frame1.frame8.menubutton13 .frame1.frame8.menubutton14 .frame1.frame8.menubutton15
  } {
    tk_menus . .frame1.frame8.menubutton12 .frame1.frame8.menubutton13 .frame1.frame8.menubutton14 .frame1.frame8.menubutton15
  }

  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree ."
    after 2 "catch {XFEditSetShowWindows}"
  }
}


# Procedure: AlertBox
proc AlertBox { {alertBoxMessage "Alert message"} {alertBoxCommand ""} {alertBoxGeometry ""} {alertBoxTitle "TkMobal: Alert box"} args} {
# xf ignore me 5
##########
# Procedure: AlertBox
# Description: show alert box
# Arguments: {alertBoxMessage} - the text to display
#            {alertBoxCommand} - the command to call after ok
#            {alertBoxGeometry} - the geometry for the window
#            {alertBoxTitle} - the title for the window
#            {args} - labels of buttons
# Returns: The number of the selected button, ot nothing
# Sideeffects: none
# Notes: there exist also functions called:
#          AlertBoxFile - to open and read a file automatically
#          AlertBoxFd - to read from an already opened filedescriptor
##########
#
# global alertBox(activeBackground) - active background color
# global alertBox(activeForeground) - active foreground color
# global alertBox(after) - destroy alert box after n seconds
# global alertBox(anchor) - anchor for message box
# global alertBox(background) - background color
# global alertBox(font) - message font
# global alertBox(foreground) - foreground color
# global alertBox(justify) - justify for message box
# global alertBox(toplevelName) - the toplevel name

  global alertBox

  PrologSetQuerying

  # prepare widget configuration strings
  set tmpButtonOpt ""
  set tmpFrameOpt ""
  set tmpMessageOpt ""
  if {"$alertBox(activeBackground)" != ""} {
    append tmpButtonOpt "-activebackground \"$alertBox(activeBackground)\" "
  }
  if {"$alertBox(activeForeground)" != ""} {
    append tmpButtonOpt "-activeforeground \"$alertBox(activeForeground)\" "
  }
  if {"$alertBox(background)" != ""} {
    append tmpButtonOpt "-background \"$alertBox(background)\" "
    append tmpFrameOpt "-background \"$alertBox(background)\" "
    append tmpMessageOpt "-background \"$alertBox(background)\" "
  }
  if {"$alertBox(font)" != ""} {
    append tmpButtonOpt "-font \"$alertBox(font)\" "
    append tmpMessageOpt "-font \"$alertBox(font)\" "
  }
  if {"$alertBox(foreground)" != ""} {
    append tmpButtonOpt "-foreground \"$alertBox(foreground)\" "
    append tmpMessageOpt "-foreground \"$alertBox(foreground)\" "
  }

  # start build of toplevel
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy $alertBox(toplevelName)}
  } {
    catch {destroy $alertBox(toplevelName)}
  }
  toplevel $alertBox(toplevelName)  -borderwidth 0
  MiscPlaceWindowPrepare $alertBox(toplevelName) alert
  catch "$alertBox(toplevelName) config $tmpFrameOpt"
  if {"$alertBoxGeometry" != ""} {
    if {[catch "wm geometry $alertBox(toplevelName) $alertBoxGeometry"]} {
      wm geometry $alertBox(toplevelName) 500x200
    }
  }
  wm title $alertBox(toplevelName) $alertBoxTitle
  # end build of toplevel

  # the alert message
  message $alertBox(toplevelName).message1 -anchor "$alertBox(anchor)" -justify "$alertBox(justify)" -relief raised -text "$alertBoxMessage"
  catch "$alertBox(toplevelName).message1 config $tmpMessageOpt"

  if {"$alertBoxGeometry" != ""} {
    set xfTmpWidth [string range $alertBoxGeometry 0 [expr [string first x $alertBoxGeometry]-1]]
    if {"$xfTmpWidth" != ""} {
      # set message size
      catch "$alertBox(toplevelName).message1 configure -width [expr $xfTmpWidth-10]"
    } {
      $alertBox(toplevelName).message1 configure -aspect 400
    }
  } {
    $alertBox(toplevelName).message1 configure -aspect 400
  }

  # the button area
  frame $alertBox(toplevelName).frame1 -borderwidth 2 -relief raised
  catch "$alertBox(toplevelName).frame1 config $tmpFrameOpt"

  # the buttons
  set alertBoxCounter 0
  set buttonNum [llength $args]
  if {$buttonNum > 0} {
    while {$alertBoxCounter < $buttonNum} {
      button $alertBox(toplevelName).frame1.button$alertBoxCounter -text "[lindex $args $alertBoxCounter]" -command "
          global alertBox
          set alertBox(button) $alertBoxCounter
          PrologSetReady 1
          if {\"\[info commands XFDestroy\]\" != \"\"} {
            catch {XFDestroy $alertBox(toplevelName)}
          } {
            catch {destroy $alertBox(toplevelName)}
          }"
      catch "$alertBox(toplevelName).frame1.button$alertBoxCounter config $tmpButtonOpt"

      pack append $alertBox(toplevelName).frame1 $alertBox(toplevelName).frame1.button$alertBoxCounter {left fillx expand}

      incr alertBoxCounter
    }
  } {
    button $alertBox(toplevelName).frame1.button0 -width 5 -text "OK" -command "
        global alertBox
        set alertBox(button) 0
        PrologSetReady 1
        if {\"\[info commands XFDestroy\]\" != \"\"} {
          catch {XFDestroy $alertBox(toplevelName)}
        } {
          catch {destroy $alertBox(toplevelName)}
        }
        $alertBoxCommand"
    catch "$alertBox(toplevelName).frame1.button0 config $tmpButtonOpt"

    pack append $alertBox(toplevelName).frame1 $alertBox(toplevelName).frame1.button0 {left expand padx 6 pady 6}
  }

  # packing
  pack append $alertBox(toplevelName) $alertBox(toplevelName).frame1 {bottom fill}  $alertBox(toplevelName).message1 {top fill expand}

  if {$alertBox(after) != 0} {
    after [expr $alertBox(after)*1000] "catch \"$alertBox(toplevelName).frame1.button0 invoke\""
  }

  XFLocalSetAppDefs $alertBox(toplevelName)

#  MiscPlaceWindow $alertBox(toplevelName) alert

  catch "$alertBox(toplevelName).message1 config -font \"$alertBox(font)\""
  foreach child [winfo children $alertBox(toplevelName).frame1] {
    catch "$child config -font \"$alertBox(font)\""
  }

  if {"$alertBoxGeometry" == ""} {
    if {[winfo width $alertBox(toplevelName)] < 504 &&
        [winfo height $alertBox(toplevelName)] >= 200} {
      wm geometry $alertBox(toplevelName) 504x[winfo height $alertBox(toplevelName)]
    } {
      if {[winfo width $alertBox(toplevelName)] >= 504 &&
          [winfo height $alertBox(toplevelName)] < 200} {
        wm geometry $alertBox(toplevelName) [winfo width $alertBox(toplevelName)]x200
      } {
        if {[winfo width $alertBox(toplevelName)] < 504 &&
            [winfo height $alertBox(toplevelName)] < 200} {
          wm geometry $alertBox(toplevelName) 504x200
        }
      }
    }
  }

  MiscPlaceWindow $alertBox(toplevelName) alert

  # wait for the box to be destroyed
  update idletask
  grab $alertBox(toplevelName)
  tkwait window $alertBox(toplevelName)

  if {[llength $args] > 0} {
    return $alertBox(button)
  }
}


# Procedure: Alias
if {"[info procs Alias]" == ""} {
proc Alias { args} {
# xf ignore me 7
##########
# Procedure: Alias
# Description: establish an alias for a procedure
# Arguments: args - no argument means that a list of all aliases
#                   is returned. Otherwise the first parameter is
#                   the alias name, and the second parameter is
#                   the procedure that is aliased.
# Returns: nothing, the command that is bound to the alias or a
#          list of all aliases - command pairs. 
# Sideeffects: internalAliasList is updated, and the alias
#              proc is inserted
##########
  global internalAliasList

  if {[llength $args] == 0} {
    return $internalAliasList
  } {
    if {[llength $args] == 1} {
      set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
      if {$xfTmpIndex != -1} {
        return [lindex [lindex $internalAliasList $xfTmpIndex] 1]
      }
    } {
      if {[llength $args] == 2} {
        eval "proc [lindex $args 0] {args} {#xf ignore me 4
return \[eval \"[lindex $args 1] \$args\"\]}"
        set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
        if {$xfTmpIndex != -1} {
          set internalAliasList [lreplace $internalAliasList $xfTmpIndex $xfTmpIndex "[lindex $args 0] [lindex $args 1]"]
        } {
          lappend internalAliasList "[lindex $args 0] [lindex $args 1]"
        }
      } {
        error "Alias: wrong number or args: $args"
      }
    }
  }
}
}


# Procedure: ButtonChoose
proc ButtonChoose { {prompt ""} {items ""}} {
  # This procedure displays a toplevel where the user
  # can select from a list of buttons.
  # prompt - the label displayed at the top of the
  #          button list.
  # items - a list of items. The items are the labels
  #         used for the buttons, and this items are
  #         returned when the appropriate button is
  #         pressed.

  # The global variables of mobal.
  global mobal

  PrologSetQuerying

  # Create the toplevel.
  toplevel .buttonChooser
  MiscPlaceWindowPrepare .buttonChooser button
  wm title .buttonChooser "TkMobal: Button chooser"

  # Create the message, that describes the dialog.
  message .buttonChooser.message -aspect 1500 -text $prompt -relief raised -borderwidth 2

  # Create the frame where the buttons will be inserted.
  frame .buttonChooser.list -relief raised -borderwidth 2

  # This counter is used to create unique names.
  set counter 0
  # The maximal width of the buttons.
  set maxWidth 1
  # Create buttons for the passed items.
  foreach element $items {
    # Create the button.
    button .buttonChooser.list.butt$counter -text $element -command "set mobal(tmpResult) \"$element\"
      PrologSetReady 1
      destroy .buttonChooser"
    # Display the button.
    pack append .buttonChooser.list .buttonChooser.list.butt$counter {top expand padx 6 pady 6}
    if {[string length $element] > $maxWidth} {
      # The width of the button is wider than the width
      # of the previous buttons... so use this width
      # for all buttons.
      set maxWidth [string length $element]
    }
    incr counter
  }

  # We want all the buttons with a nice equal width.
  incr maxWidth 3
  # We counted to far.
  incr counter -1
  # Walk through the created buttons.
  while {$counter >= 0} {
    # Set the width of the button.
    .buttonChooser.list.butt$counter conf -width $maxWidth
    incr counter -1
  }

  # Display the widget structure.
  pack append .buttonChooser .buttonChooser.message {top fill} .buttonChooser.list {top fill expand}

  # Update the X resources for the dialog.
  XFLocalSetAppDefs .buttonChooser

  MiscPlaceWindow .buttonChooser button

  # Initialize the result variable.
  set mobal(tmpResult) ""
  # only input in the chooser
  grab .buttonChooser
  # Now wait for the destruction of the toplevel.
  tkwait window .buttonChooser
  # The toplevel was destroyed, now return the
  # value of the pressed value.
  return $mobal(tmpResult)
}


# Procedure: FSBox
proc FSBox { {fsBoxMessage "Select file:"} {fsBoxFileName ""} {fsBoxActionOk ""} {fsBoxActionCancel ""}} {
# xf ignore me 5
##########
# Procedure: FSBox
# Description: show file selector box
# Arguments: fsBoxMessage - the text to display
#            fsBoxFileName - a file name that should be selected
#            fsBoxActionOk - the action that should be performed on ok
#            fsBoxActionCancel - the action that should be performed on cancel
# Returns: the filename that was selected, or nothing
# Sideeffects: none
##########
# 
# global fsBox(activeBackground) - active background color
# global fsBox(activeForeground) - active foreground color
# global fsBox(background) - background color
# global fsBox(font) - text font
# global fsBox(foreground) - foreground color
# global fsBox(extensions) - scan directory for extensions
# global fsBox(scrollActiveForeground) - scrollbar active background color
# global fsBox(scrollBackground) - scrollbar background color
# global fsBox(scrollForeground) - scrollbar foreground color
# global fsBox(scrollSide) - side where scrollbar is located

  global fsBox

  PrologSetQuerying

  set tmpButtonOpt ""
  set tmpFrameOpt ""
  set tmpMessageOpt ""
  set tmpScaleOpt ""
  set tmpScrollOpt ""
  if {"$fsBox(activeBackground)" != ""} {
    append tmpButtonOpt "-activebackground \"$fsBox(activeBackground)\" "
  }
  if {"$fsBox(activeForeground)" != ""} {
    append tmpButtonOpt "-activeforeground \"$fsBox(activeForeground)\" "
  }
  if {"$fsBox(background)" != ""} {
    append tmpButtonOpt "-background \"$fsBox(background)\" "
    append tmpFrameOpt "-background \"$fsBox(background)\" "
    append tmpMessageOpt "-background \"$fsBox(background)\" "
  }
  if {"$fsBox(font)" != ""} {
    append tmpButtonOpt "-font \"$fsBox(font)\" "
    append tmpMessageOpt "-font \"$fsBox(font)\" "
  }
  if {"$fsBox(foreground)" != ""} {
    append tmpButtonOpt "-foreground \"$fsBox(foreground)\" "
    append tmpMessageOpt "-foreground \"$fsBox(foreground)\" "
  }
  if {"$fsBox(scrollActiveForeground)" != ""} {
    append tmpScrollOpt "-activeforeground \"$fsBox(scrollActiveForeground)\" "
  }
  if {"$fsBox(scrollBackground)" != ""} {
    append tmpScrollOpt "-background \"$fsBox(scrollBackground)\" "
  }
  if {"$fsBox(scrollForeground)" != ""} {
    append tmpScrollOpt "-foreground \"$fsBox(scrollForeground)\" "
  }

  if {"$fsBoxFileName" != ""} {
    if {[MiscFileExists $fsBoxFileName] && [MiscFileIsADir $fsBoxFileName]} {
      set fsBox(path) $fsBoxFileName
      set fsBox(name) ""
    } {
      if {"[file dirname $fsBoxFileName]" != "."} {
        set fsBox(path) [file dirname $fsBoxFileName]
        set fsBox(name) [file tail $fsBoxFileName]
      }
    }
  }
  set fsBox(internalPath) $fsBox(path)
  # build widget structure

  # start build of toplevel
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy .fsBox}
  } {
    catch {destroy .fsBox}
  }
  toplevel .fsBox  -borderwidth 0
  MiscPlaceWindowPrepare .fsBox fs
  catch ".fsBox config $tmpFrameOpt"
  wm geometry .fsBox 350x450 
  wm title .fsBox {TkMobal: File select box}
  # end build of toplevel

  label .fsBox.message1  -anchor c  -relief raised  -text "$fsBoxMessage"
  catch ".fsBox.message1 config $tmpMessageOpt"

  frame .fsBox.frame1  -borderwidth 2  -relief raised
  catch ".fsBox.frame1 config $tmpFrameOpt"

  button .fsBox.frame1.ok  -text "OK"  -width 9 -command "
      global fsBox
      if {\[eval $fsBox(checkCommand) \[.fsBox.path.path get\]/\[.fsBox.file.file get\]\]} {
        set fsBox(name) \[.fsBox.file.file get\]
        if {$fsBox(showPixmap)} {
          set fsBox(path) @\[.fsBox.path.path get\]
        } {
          set fsBox(path) \[.fsBox.path.path get\]
        }
        set fsBox(internalPath) \[.fsBox.path.path get\]
        $fsBoxActionOk
        PrologSetReady 1
        if {\"\[info commands XFDestroy\]\" != \"\"} {
          catch {XFDestroy .fsBox}
        } {
          catch {destroy .fsBox}
        }
      }"
  catch ".fsBox.frame1.ok config $tmpButtonOpt"

  button .fsBox.frame1.rescan  -text "Rescan"   -width 9 -command {
      global fsBox
      FSBoxFSShow [.fsBox.path.path get]  [.fsBox.pattern.pattern get] $fsBox(all)}
  catch ".fsBox.frame1.rescan config $tmpButtonOpt"

  button .fsBox.frame1.cancel  -text "Cancel"   -width 9 -command "
      global fsBox
      set fsBox(name) {}
      set fsBox(path) {}
      $fsBoxActionCancel
      PrologSetReady 1
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .fsBox}
      } {
        catch {destroy .fsBox}
      }"
  catch ".fsBox.frame1.cancel config $tmpButtonOpt"

  if {$fsBox(showPixmap)} {
    frame .fsBox.frame2  -borderwidth 0  -relief raised
    catch ".fsBox.frame2 config $tmpFrameOpt"

    scrollbar .fsBox.frame2.scrollbar3  -command {.fsBox.frame2.canvas2 xview}  -orient {horizontal}  -relief {raised}
    catch ".fsBox.frame2.scrollbar3 config $tmpScrollOpt"

    scrollbar .fsBox.frame2.scrollbar1  -command {.fsBox.frame2.canvas2 yview}  -relief {raised}
    catch ".fsBox.frame2.scrollbar1 config $tmpScrollOpt"

    canvas .fsBox.frame2.canvas2  -confine {true}  -relief {raised}  -scrollregion {0c 0c 20c 20c}  -width {100}  -xscrollcommand {.fsBox.frame2.scrollbar3 set}  -yscrollcommand {.fsBox.frame2.scrollbar1 set}
    catch ".fsBox.frame2.canvas2 config $tmpFrameOpt"

    .fsBox.frame2.canvas2 addtag currentBitmap withtag [.fsBox.frame2.canvas2 create bitmap 5 5 -anchor nw]
  }

  frame .fsBox.path  -borderwidth 0  -relief raised
  catch ".fsBox.path config $tmpFrameOpt"

  frame .fsBox.path.paths  -borderwidth 2  -relief raised
  catch ".fsBox.path.paths config $tmpFrameOpt"

  menubutton .fsBox.path.paths.paths  -borderwidth 0  -menu ".fsBox.path.paths.paths.menu"  -relief flat  -text "Pathname:"
  catch ".fsBox.path.paths.paths config $tmpButtonOpt"

  menu .fsBox.path.paths.paths.menu
  catch ".fsBox.path.paths.paths.menu config $tmpButtonOpt"

  .fsBox.path.paths.paths.menu add command  -label "[string trimright $fsBox(internalPath) {/@}]"  -command "
       global fsBox
       FSBoxFSShow \[.fsBox.path.path get\]  \[.fsBox.pattern.pattern get\] \$fsBox(all)
       .fsBox.path.path delete 0 end
       .fsBox.path.path insert 0 [string trimright $fsBox(internalPath) {/@}]"

  entry .fsBox.path.path  -relief raised
  catch ".fsBox.path.path config $tmpMessageOpt"

  .fsBox.path.path insert 0 $fsBox(internalPath)

  frame .fsBox.pattern  -borderwidth 0  -relief raised
  catch ".fsBox.pattern config $tmpFrameOpt"

  frame .fsBox.pattern.patterns  -borderwidth 2  -relief raised
  catch ".fsBox.pattern.patterns config $tmpFrameOpt"

  menubutton .fsBox.pattern.patterns.patterns  -borderwidth 0  -menu ".fsBox.pattern.patterns.patterns.menu"  -relief flat  -text "Selection pattern:"
  catch ".fsBox.pattern.patterns.patterns config $tmpButtonOpt"

  menu .fsBox.pattern.patterns.patterns.menu
  catch ".fsBox.pattern.patterns.patterns.menu config $tmpButtonOpt"

  .fsBox.pattern.patterns.patterns.menu add checkbutton  -label "Scan extensions"  -variable fsBox(extensions)  -command {
      global fsBox
      FSBoxFSShow [.fsBox.path.path get]  [.fsBox.pattern.pattern get] $fsBox(all)}

  entry .fsBox.pattern.pattern  -relief raised
  catch ".fsBox.pattern.pattern config $tmpMessageOpt"

  .fsBox.pattern.pattern insert 0 $fsBox(pattern)
  
  frame .fsBox.files  -borderwidth 0  -relief raised
  catch ".fsBox.files config $tmpFrameOpt"

  scrollbar .fsBox.files.vscroll  -relief raised  -command ".fsBox.files.files yview"
  catch ".fsBox.files.vscroll config $tmpScrollOpt"

  scrollbar .fsBox.files.hscroll  -orient horiz  -relief raised  -command ".fsBox.files.files xview"
  catch ".fsBox.files.hscroll config $tmpScrollOpt"

  listbox .fsBox.files.files  -exportselection false  -relief raised  -xscrollcommand ".fsBox.files.hscroll set"  -yscrollcommand ".fsBox.files.vscroll set"
  catch ".fsBox.files.files config $tmpMessageOpt"

  frame .fsBox.file  -borderwidth 0  -relief raised
  catch ".fsBox.file config $tmpFrameOpt"

  label .fsBox.file.labelfile  -relief raised  -text "Filename:"
  catch ".fsBox.file.labelfile config $tmpMessageOpt"

  entry .fsBox.file.file  -relief raised
  catch ".fsBox.file.file config $tmpMessageOpt"

  frame .fsBox.describe  -borderwidth 0  -relief raised
  catch ".fsBox.describe config $tmpFrameOpt"

  label .fsBox.describe.labelfile  -relief raised  -text "Description:"
  catch ".fsBox.describe.labelfile config $tmpMessageOpt"

  scrollbar .fsBox.describe.vscroll  -relief raised  -command ".fsBox.describe.text yview"
  catch ".fsBox.files.hscroll config $tmpScrollOpt"

  text .fsBox.describe.text  -relief raised -yscrollcommand ".fsBox.describe.vscroll set" -width 20 -height 5 -borderwidth 2
  catch ".fsBox.describe.text config $tmpMessageOpt"

  .fsBox.file.file delete 0 end
  .fsBox.file.file insert 0 $fsBox(name)
  
  checkbutton .fsBox.pattern.all  -offvalue 0  -onvalue 1  -text "Show all files"  -variable fsBox(all)  -command {
      global fsBox
      FSBoxFSShow [.fsBox.path.path get]  [.fsBox.pattern.pattern get] $fsBox(all)}
  catch ".fsBox.pattern.all config $tmpButtonOpt"

  FSBoxFSShow $fsBox(internalPath) $fsBox(pattern) $fsBox(all)

  # bindings
  bind .fsBox.files.files <ButtonPress-1> "
    if {!\$fsBox(block)} {
      if {\$fsBox(clickCounter) == 1} {
        set fsBox(block) 1
        set fsBox(clickEval) 0
        set fsBox(clickCounter) 2
        FSBoxFSFileSelectDouble %W $fsBox(showPixmap) \{$fsBoxActionOk\} %y
        # prevent queed events
        after 200 set fsBox(block) 0
      } {
        set fsBox(clickCounter) 1
        set fsBox(clickEval) 1
        after \$fsBox(clickInterval) set fsBox(clickCounter) 0
        tkwait variable fsBox(clickCounter)
        if {\$fsBox(clickCounter) == 0 && \$fsBox(clickEval)} {
          FSBoxFSFileSelect %W $fsBox(showPixmap) %y
        }
      }
    }"
  bind .fsBox.files.files <Button1-Motion> "
    FSBoxFSFileSelect %W $fsBox(showPixmap) %y"
  bind .fsBox.files.files <Shift-Button1-Motion> "
    FSBoxFSFileSelect %W $fsBox(showPixmap) %y"
  bind .fsBox.files.files <Shift-ButtonPress-1> "
    FSBoxFSFileSelect %W $fsBox(showPixmap) %y"

  bind .fsBox.path.path <Return> {
    global fsBox
    FSBoxFSShow [.fsBox.path.path get] [.fsBox.pattern.pattern get] $fsBox(all)
    FSBoxFSInsertPath
    .fsBox.file.file icursor end
    focus .fsBox.file.file}
  catch "bind .fsBox.path.path <Up> {}"
  bind .fsBox.path.path <Down> {
    .fsBox.file.file icursor end
    focus .fsBox.file.file}

  bind .fsBox.file.file <Return> "
    global fsBox
    if {\[eval $fsBox(checkCommand) \[.fsBox.path.path get\]/\[.fsBox.file.file get\]\]} {
      set fsBox(name) \[.fsBox.file.file get\]
      if {$fsBox(showPixmap)} {
        set fsBox(path) @\[.fsBox.path.path get\]
      } {
        set fsBox(path) \[.fsBox.path.path get\]
      }
      set fsBox(internalPath) \[.fsBox.path.path get\]
      $fsBoxActionOk
      PrologSetReady 1
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .fsBox}
      } {
        catch {destroy .fsBox}
      }
    }"
  bind .fsBox.file.file <Up> {
    .fsBox.path.path icursor end
    focus .fsBox.path.path}
  bind .fsBox.file.file <Down> {
    .fsBox.pattern.pattern icursor end
    focus .fsBox.pattern.pattern}

  bind .fsBox.pattern.pattern <Return> {
    global fsBox
    FSBoxFSShow [.fsBox.path.path get]  [.fsBox.pattern.pattern get] $fsBox(all)}
  bind .fsBox.pattern.pattern <Up> {
    .fsBox.file.file icursor end
    focus .fsBox.file.file}
  catch "bind .fsBox.pattern.pattern <Down> {}"

  bind .fsBox.describe.text <KeyPress> "NoFunction"

  # packing
  pack append .fsBox.files  .fsBox.files.vscroll "$fsBox(scrollSide) filly"  .fsBox.files.hscroll {bottom fillx}  .fsBox.files.files {left fill expand}
  pack append .fsBox.describe  .fsBox.describe.labelfile {top fill} .fsBox.describe.vscroll "$fsBox(scrollSide) fill"  .fsBox.describe.text {left fill expand}
  pack append .fsBox.file  .fsBox.file.labelfile {left}  .fsBox.file.file {left fill expand}
  pack append .fsBox.frame1  .fsBox.frame1.ok {left expand padx 6 pady 6}  .fsBox.frame1.rescan {left expand padx 6 pady 6}  .fsBox.frame1.cancel {left expand padx 6 pady 6}
  pack append .fsBox.path.paths  .fsBox.path.paths.paths {left}
  pack append .fsBox.pattern.patterns  .fsBox.pattern.patterns.patterns {left}
  pack append .fsBox.path  .fsBox.path.paths {left}  .fsBox.path.path {left fill expand}
  pack append .fsBox.pattern  .fsBox.pattern.patterns {left}  .fsBox.pattern.all {right fill}  .fsBox.pattern.pattern {left fill expand}
  pack append .fsBox.pattern  .fsBox.pattern.patterns {left}  .fsBox.pattern.all {right fill}  .fsBox.pattern.pattern {left fill expand}
  if {$fsBox(showPixmap)} {
    pack append .fsBox.frame2  .fsBox.frame2.scrollbar1 {left filly}  .fsBox.frame2.canvas2 {top expand fill}  .fsBox.frame2.scrollbar3 {top fillx} 

    pack append .fsBox  .fsBox.message1 {top fill}  .fsBox.frame1 {bottom fill}  .fsBox.pattern {bottom fill}  .fsBox.file {bottom fill}  .fsBox.path {bottom fill}  .fsBox.frame2 {right fill}  .fsBox.files {left fill expand}
  } {
    pack append .fsBox  .fsBox.message1 {top fill}  .fsBox.frame1 {bottom fill}  .fsBox.pattern {bottom fill}  .fsBox.file {bottom fill}  .fsBox.path {bottom fill}  .fsBox.describe {bottom fill} .fsBox.files {left fill expand}
  }
  pack unpack .fsBox.pattern.all

  XFLocalSetAppDefs .fsBox

  MiscPlaceWindow .fsBox fs

  if {"$fsBoxActionOk" == "" && "$fsBoxActionCancel" == ""} {
    # wait for the box to be destroyed
    update idletask
    grab .fsBox
    tkwait window .fsBox

    if {"[string trim $fsBox(path)]" != "" ||
        "[string trim $fsBox(name)]" != ""} {
      if {"[string trimleft [string trim $fsBox(name)] /]" == ""} {
        return [string trimright [string trim $fsBox(path)] /]
      } {
        return [string trimright [string trim $fsBox(path)] /]/[string trimleft [string trim $fsBox(name)] /]
      }
    }
  }
}


# Procedure: FSBoxBindSelectOne
proc FSBoxBindSelectOne { fsBoxW fsBoxY} {
# xf ignore me 6

  set fsBoxNearest [$fsBoxW nearest $fsBoxY]
  if {$fsBoxNearest >= 0} {
    $fsBoxW select from $fsBoxNearest
    $fsBoxW select to $fsBoxNearest
  }
}


# Procedure: FSBoxFSFileSelect
proc FSBoxFSFileSelect { fsBoxW fsBoxShowPixmap fsBoxY} {
# xf ignore me 6
  global fsBox
  global mobal

  FSBoxBindSelectOne $fsBoxW $fsBoxY
  set fsBoxNearest [$fsBoxW nearest $fsBoxY]
  if {$fsBoxNearest >= 0} {
    set fsBoxTmpEntry [$fsBoxW get $fsBoxNearest]
    if {"[string index $fsBoxTmpEntry [expr [string length $fsBoxTmpEntry]-1]]" == "/" ||
        "[string index $fsBoxTmpEntry [expr [string length $fsBoxTmpEntry]-1]]" == "@" ||
        "[string index $fsBoxTmpEntry [expr [string length $fsBoxTmpEntry]-1]]" == "*"} {
      set fsBoxFileName [string range $fsBoxTmpEntry 0 [expr [string length $fsBoxTmpEntry]-2]]
    } {
      set fsBoxFileName $fsBoxTmpEntry
    }
    if {[MiscFileIsAFile $fsBox(internalPath)/$fsBoxFileName]} {
      set fsBox(name) $fsBoxFileName
      catch ".fsBox.file.file delete 0 end"
      catch ".fsBox.file.file insert 0 $fsBox(name)"
      PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
      set description [PrologSend mobal_domain_description [PrologAtom $fsBox(internalPath)] [PrologAtom $fsBoxFileName]]
      catch ".fsBox.describe.text delete 1.0 end"
      catch ".fsBox.describe.text insert end \{$description\}"
      if {$fsBoxShowPixmap} {
        catch ".fsBox.frame2.canvas2 itemconfigure currentBitmap -bitmap \"@$fsBox(internalPath)/$fsBox(name)\""
      }
    }
  }
}


# Procedure: FSBoxFSFileSelectDouble
proc FSBoxFSFileSelectDouble { fsBoxW fsBoxShowPixmap fsBoxAction fsBoxY} {
# xf ignore me 6
  global fsBox

  FSBoxBindSelectOne $fsBoxW $fsBoxY
  set fsBoxNearest [$fsBoxW nearest $fsBoxY]
  if {$fsBoxNearest >= 0} {
    set fsBoxTmpEntry [$fsBoxW get $fsBoxNearest]
    if {"$fsBoxTmpEntry" == "../"} {
      set fsBoxTmpEntry [string trimright [string trim $fsBox(internalPath)] "@/*"]
      if {"$fsBoxTmpEntry" == ""} {
        return
      }
      FSBoxFSShow [file dirname $fsBoxTmpEntry] [.fsBox.pattern.pattern get] $fsBox(all)
      .fsBox.path.path delete 0 end
      .fsBox.path.path insert 0 $fsBox(internalPath)
    } {
      if {"[string index $fsBoxTmpEntry [expr [string length $fsBoxTmpEntry]-1]]" == "/" ||
          "[string index $fsBoxTmpEntry [expr [string length $fsBoxTmpEntry]-1]]" == "@" ||
          "[string index $fsBoxTmpEntry [expr [string length $fsBoxTmpEntry]-1]]" == "*"} {
        set fsBoxFileName [string range $fsBoxTmpEntry 0  [expr [string length $fsBoxTmpEntry]-2]]
      } {
        set fsBoxFileName $fsBoxTmpEntry
      }
      if {![MiscFileIsAFile [string trimright $fsBox(internalPath)/$fsBoxFileName @]]} {
        set fsBox(internalPath) "[string trimright $fsBox(internalPath) {/@*}]/$fsBoxFileName"
        FSBoxFSShow $fsBox(internalPath) [.fsBox.pattern.pattern get] $fsBox(all)
        .fsBox.path.path delete 0 end
        .fsBox.path.path insert 0 $fsBox(internalPath)
      } {
        if {[eval $fsBox(checkCommand) $fsBox(internalPath)/$fsBoxFileName]} {
          set fsBox(name) $fsBoxFileName
          if {$fsBoxShowPixmap} {
            set fsBox(path) @$fsBox(internalPath)
          } {
            set fsBox(path) $fsBox(internalPath)
          }
          if {"$fsBoxAction" != ""} {
            eval "global fsBox; $fsBoxAction"
          }
          PrologSetReady 1
          if {"[info commands XFDestroy]" != ""} {
            catch {XFDestroy .fsBox}
          } {
            catch {destroy .fsBox}
          }
        }
      }
    }
  }
}


# Procedure: FSBoxFSInsertPath
proc FSBoxFSInsertPath {} {
# xf ignore me 6
  global fsBox

  set fsBoxLast [.fsBox.path.paths.paths.menu index last]
  set fsBoxNewEntry [string trimright [.fsBox.path.path get] "/@"]
  for {set fsBoxCounter 0} {$fsBoxCounter <= $fsBoxLast} {incr fsBoxCounter 1} {
    if {"$fsBoxNewEntry" ==  "[lindex [.fsBox.path.paths.paths.menu entryconfigure  $fsBoxCounter -label] 4]"} {
      return
    }
  }
  if {$fsBoxLast < 9} {
    .fsBox.path.paths.paths.menu add command  -label "$fsBoxNewEntry"  -command "
        global fsBox
        FSBoxFSShow $fsBoxNewEntry  \[.fsBox.pattern.pattern get\] \$fsBox(all)
        .fsBox.path.path delete 0 end
        .fsBox.path.path insert 0 $fsBoxNewEntry"
  } {
    for {set fsBoxCounter 0} {$fsBoxCounter < $fsBoxLast} {incr fsBoxCounter 1} {
      .fsBox.path.paths.paths.menu entryconfigure  $fsBoxCounter -label  [lindex [.fsBox.path.paths.paths.menu entryconfigure  [expr $fsBoxCounter+1] -label] 4]
      .fsBox.path.paths.paths.menu entryconfigure $fsBoxCounter  -command "
          global fsBox
          FSBoxFSShow [lindex [.fsBox.path.paths.paths.menu entryconfigure  [expr $fsBoxCounter+1] -label] 4]  \[.fsBox.pattern.pattern get\] \$fsBox(all)
          .fsBox.path.path delete 0 end
          .fsBox.path.path insert 0 [lindex  [.fsBox.path.paths.paths.menu entryconfigure  [expr $fsBoxCounter+1] -label] 4]"
    }
    .fsBox.path.paths.paths.menu entryconfigure $fsBoxLast  -label "$fsBoxNewEntry"
    .fsBox.path.paths.paths.menu entryconfigure $fsBoxCounter  -command "
        global fsBox
        FSBoxFSShow \[.fsBox.path.path get\]  \[.fsBox.pattern.pattern get\] \$fsBox(all)
        .fsBox.path.path delete 0 end
        .fsBox.path.path insert 0 $fsBoxNewEntry"
  }
}


# Procedure: FSBoxFSShow
proc FSBoxFSShow { fsBoxPath fsBoxPattern fsBoxAll} {
# xf ignore me 6
  global fsBox
  global mobal

  set tmpButtonOpt ""
  if {"$fsBox(activeBackground)" != ""} {
    append tmpButtonOpt "-activebackground \"$fsBox(activeBackground)\" "
  }
  if {"$fsBox(activeForeground)" != ""} {
    append tmpButtonOpt "-activeforeground \"$fsBox(activeForeground)\" "
  }
  if {"$fsBox(background)" != ""} {
    append tmpButtonOpt "-background \"$fsBox(background)\" "
  }
  if {"$fsBox(font)" != ""} {
    append tmpButtonOpt "-font \"$fsBox(font)\" "
  }
  if {"$fsBox(foreground)" != ""} {
    append tmpButtonOpt "-foreground \"$fsBox(foreground)\" "
  }

  if {[.fsBox.files.files size] > 0} {
    .fsBox.files.files delete 0 end
    update
  }
  set fsBox(pattern) $fsBoxPattern
  if {[MiscFileIsADir $fsBoxPath]} {
    set fsBox(internalPath) $fsBoxPath
    .fsBox.file.file delete 0 end
  } {
    if {[MiscFileReadable $fsBoxPath] && [MiscFileIsAFile $fsBoxPath]} {
      set fsBox(internalPath) [file dirname $fsBoxPath]
      .fsBox.file.file delete 0 end
      .fsBox.file.file insert 0 [file tail $fsBoxPath]
      set fsBoxPath $fsBox(internalPath)
    } {
      set fsBox(internalPath) "/"
      while {"$fsBoxPath" != "" && "$fsBoxPath" != "/" &&
             ![MiscFileIsADir $fsBoxPath]} {
        set fsBox(internalPath) [file dirname $fsBoxPath]
        set fsBoxPath $fsBox(internalPath)
      }
      set fsBoxPath $fsBox(internalPath)
    }
  }
  if {"$fsBoxPath" == ""} {
    set fsBoxPath "/"
    set fsBox(internalPath) "/"
  }
  .fsBox.path.path delete 0 end
  .fsBox.path.path insert 0 $fsBox(internalPath)

  if {[catch "$fsBox(list,$fsBoxAll)" fsBoxElementList]} {
    puts stderr "$fsBoxElementList"
  }

  foreach fsBoxCounter [winfo children .fsBox.pattern.patterns.patterns] {
    if {[string length [info commands XFDestroy]] > 0} {
      catch {XFDestroy $fsBoxCounter}
    } {
      catch {destroy $fsBoxCounter}
    }
  }
  menu .fsBox.pattern.patterns.patterns.menu
  catch ".fsBox.pattern.patterns.patterns.menu config $tmpButtonOpt"

  if {$fsBox(extensions)} {
    .fsBox.pattern.patterns.patterns.menu add command  -label "*"  -command {
        global fsBox
        set fsBox(pattern) "*"
        .fsBox.pattern.pattern delete 0 end
        .fsBox.pattern.pattern insert 0 $fsBox(pattern)
        FSBoxFSShow [.fsBox.path.path get] $fsBox(pattern)  $fsBox(all)}
  }

  if {"$fsBoxPath" != "/"} {
    .fsBox.files.files insert end "../"
  }
  foreach fsBoxCounter $fsBoxElementList {
    if {$mobal(localFS)} {
      if {[string match $fsBoxPattern $fsBoxCounter] ||
          [MiscFileIsADir [string trimright $fsBoxPath/$fsBoxCounter "/@*"]]} {
        if {"$fsBoxCounter" != "../" &&
            "$fsBoxCounter" != "./"} {
          .fsBox.files.files insert end $fsBoxCounter
        }
      }
    } {
      if {[string match $fsBoxPattern $fsBoxCounter] ||
          "[string index $fsBoxCounter [expr [string length $fsBoxCounter]-1]]" == "/"} {
        if {"$fsBoxCounter" != "../" &&
            "$fsBoxCounter" != "./"} {
          .fsBox.files.files insert end $fsBoxCounter
        }
      }
    }

    if {$fsBox(extensions)} {
      catch "file rootname $fsBoxCounter" fsBoxRootName
      catch "file extension $fsBoxCounter" fsBoxExtension
      set fsBoxExtension [string trimright $fsBoxExtension "/*@"]
      if {"$fsBoxExtension" != "" && "$fsBoxRootName" != ""} {
        set fsBoxInsert 1
        set fsBoxLast [.fsBox.pattern.patterns.patterns.menu index last]
        for {set fsBoxCounter1 0} {$fsBoxCounter1 <= $fsBoxLast} {incr fsBoxCounter1 1} {
          if {"*$fsBoxExtension" ==  "[lindex [.fsBox.pattern.patterns.patterns.menu entryconfigure  $fsBoxCounter1 -label] 4]"} {
            set fsBoxInsert 0
          }
        }
	if {$fsBoxInsert} {
          .fsBox.pattern.patterns.patterns.menu add command  -label "*$fsBoxExtension"  -command "
              global fsBox
              set fsBox(pattern) \"*$fsBoxExtension\"
              .fsBox.pattern.pattern delete 0 end
              .fsBox.pattern.pattern insert 0 \$fsBox(pattern)
              FSBoxFSShow \[.fsBox.path.path get\] \$fsBox(pattern)  \$fsBox(all)"
        }
      }
    }
  }
  if {$fsBox(extensions)} {
    .fsBox.pattern.patterns.patterns.menu add separator
  }
  if {$fsBox(extensions) || 
      "[.fsBox.pattern.patterns.patterns.menu index last]" == "none"} {
    .fsBox.pattern.patterns.patterns.menu add checkbutton  -label "Scan extensions"  -variable "fsBox(extensions)"  -command {
        global fsBox
        FSBoxFSShow [.fsBox.path.path get]  [.fsBox.pattern.pattern get] $fsBox(all)}
  }
}


# Procedure: FontBox
proc FontBox { {fontBoxFileFont "/usr/local/lib/xf/lib/Fonts"} {fontBoxResource "Font"} {fontBoxEntryW ""} {fontBoxTargetW ""}} {
# xf ignore me 5
##########
# Procedure: FontBox
# Description: select a font
# Arguments: {fontBoxFileFont} - the font file with all fontnames
#            {fontBoxResource} - the resource to modify
#            {fontBoxEntryW} - the widget name for the resulting font name
#            {fontBoxTargetW} - the widget we configure
# Returns: fontname, or nothing
# Sideeffects: none
##########
# 
# global fontBox(activeBackground) - active background color
# global fontBox(activeForeground) - active foreground color
# global fontBox(background) - background color
# global fontBox(font) - text font
# global fontBox(foreground) - foreground color
# global fontBox(resource) - resource name
# global fontBox(scrollActiveForeground) - scrollbar active background color
# global fontBox(scrollBackground) - scrollbar background color
# global fontBox(scrollForeground) - scrollbar foreground color
# global fontBox(scrollSide) - side where scrollbar is located

  global fontBox

  PrologSetQuerying

  # initialize the selection variables
  set fontBox(fontName) ""
  set fontBox(fontFamily) *
  set fontBox(fontPixels) *
  set fontBox(fontSlant) *
  set fontBox(fontSWidth) *
  set fontBox(fontWeight) *

  # prepare widget configuration strings
  set tmpButtonOpt ""
  set tmpFrameOpt ""
  set tmpMessageOpt ""
  set tmpScrollOpt ""
  if {"$fontBox(activeBackground)" != ""} {
    append tmpButtonOpt "-activebackground \"$fontBox(activeBackground)\" "
  }
  if {"$fontBox(activeForeground)" != ""} {
    append tmpButtonOpt "-activeforeground \"$fontBox(activeForeground)\" "
  }
  if {"$fontBox(background)" != ""} {
    append tmpButtonOpt "-background \"$fontBox(background)\" "
    append tmpFrameOpt "-background \"$fontBox(background)\" "
    append tmpMessageOpt "-background \"$fontBox(background)\" "
  }
  if {"$fontBox(font)" != ""} {
    append tmpButtonOpt "-$fontBox(resource) \"$fontBox(font)\" "
    append tmpMessageOpt "-$fontBox(resource) \"$fontBox(font)\" "
  }
  if {"$fontBox(foreground)" != ""} {
    append tmpButtonOpt "-foreground \"$fontBox(foreground)\" "
    append tmpMessageOpt "-foreground \"$fontBox(foreground)\" "
  }
  if {"$fontBox(scrollActiveForeground)" != ""} {
    append tmpScrollOpt "-activeforeground \"$fontBox(scrollActiveForeground)\" "
  }
  if {"$fontBox(scrollBackground)" != ""} {
    append tmpScrollOpt "-background \"$fontBox(scrollBackground)\" "
  }
  if {"$fontBox(scrollForeground)" != ""} {
    append tmpScrollOpt "-foreground \"$fontBox(scrollForeground)\" "
  }

  set fontBoxTmpFileFont $fontBoxFileFont 
  # get font file name
  if {!([file exists $fontBoxFileFont] &&
        [file readable $fontBoxFileFont])} {
    set fontBoxFileFont ""
  }
  if {"$fontBoxFileFont" == ""} {
    global env
    if {[info exists env(XF_FONT_FILE)]} {
      if {[file exists $env(XF_FONT_FILE)] &&
          [file readable $env(XF_FONT_FILE)]} {
        set fontBoxFileFont $env(XF_FONT_FILE)
      }
    }
  }
  if {"$fontBoxResource" == ""} {
    set fontBoxResource "Font"
  }
  set fontBox(resource) [string tolower $fontBoxResource]

  # save the the current widget font
  if {"$fontBoxTargetW" != ""} {
    if {[catch "$fontBoxTargetW config -$fontBox(resource)" result]} {
      set fontBoxSavedFont ""
    } {
      set fontBoxSavedFont [lindex $result 4]
    }
  } {
    set fontBoxSavedFont ""
  }

  # look if there is already a font window
  if {"[info commands .fontBox]" == ""} {
    # build widget structure

    # start build of toplevel
    if {"[info commands XFDestroy]" != ""} {
      catch {XFDestroy .fontBox}
    } {
      catch {destroy .fontBox}
    }
    toplevel .fontBox -borderwidth 0
    MiscPlaceWindowPrepare .fontBox font
    catch ".fontBox config $tmpFrameOpt"
    wm geometry .fontBox 600x300
    wm title .fontBox {TkMobal: Font box}
    # end build of toplevel

    set fontBox(oldWidget) $fontBoxEntryW

    frame .fontBox.frame1 -borderwidth 2 -relief raised
    catch ".fontBox.frame1 config $tmpFrameOpt"

    frame .fontBox.frame2 -borderwidth 2 -relief raised
    catch ".fontBox.frame2 config $tmpFrameOpt"

    button .fontBox.frame1.ok -text "OK" -width 14
    catch ".fontBox.frame1.ok config $tmpButtonOpt"

    button .fontBox.frame1.rescan -text "Rescan fonts" -width 14 -command "
        if {\"$fontBoxTmpFileFont\" != \"\"} {
          catch \"exec xlsfonts > $fontBoxTmpFileFont\"
          if {\[.fontBox.fonts.fonts size\] > 0} {
            .fontBox.fonts.fonts delete 0 end
          }
          if {\[catch \"open $fontBoxTmpFileFont r\" fontInFile\]} {
            if {\"\[info commands AlertBox\]\" != \"\"} {
              AlertBox \"\$fontInFile\"
            } {
              puts stderr \"\$fontInFile\"
            }
          } {
            set fontReadList \[read \$fontInFile\]
            close \$fontInFile
            foreach fontLine \[split \$fontReadList \"\\n\"\] {
              if {\"\[string trim \$fontLine\]\" != \"\"} {
                .fontBox.fonts.fonts insert end \$fontLine
              }
            }
          }
        }"
    catch ".fontBox.frame1.rescan config $tmpButtonOpt"

    button .fontBox.frame1.cancel -text "Cancel" -width 14
    catch ".fontBox.frame1.cancel config $tmpButtonOpt"

    if {[info exists fontBox($fontBox(resource)-demo)]} {
      label .fontBox.demo -relief raised -text $fontBox($fontBox(resource)-demo)
    } {
      label .fontBox.demo -relief raised -text "This text shows the results :-)"
    }
    catch ".fontBox.demo config $tmpMessageOpt"

    frame .fontBox.current -borderwidth 0 -relief raised
    catch ".fontBox.current config $tmpFrameOpt"

    label .fontBox.current.labelcurrent -relief raised
    catch ".fontBox.current.labelcurrent config $tmpMessageOpt"

    entry .fontBox.current.current -relief raised
    catch ".fontBox.current.current config $tmpMessageOpt"

    frame .fontBox.fonts -borderwidth 0 -relief raised
    catch ".fontBox.fonts config $tmpFrameOpt"

    scrollbar .fontBox.fonts.vscroll -relief raised -command ".fontBox.fonts.fonts yview"
    catch ".fontBox.fonts.vscroll config $tmpScrollOpt"

    scrollbar .fontBox.fonts.hscroll -orient horiz -relief raised -command ".fontBox.fonts.fonts xview"
    catch ".fontBox.fonts.hscroll config $tmpScrollOpt"

    listbox .fontBox.fonts.fonts -exportselection false -relief raised -xscrollcommand ".fontBox.fonts.hscroll set" -yscrollcommand ".fontBox.fonts.vscroll set"
    catch ".fontBox.fonts.fonts config $tmpMessageOpt"

    # family menu
    menubutton .fontBox.frame2.family -text "Family" -menu ".fontBox.frame2.family.m"
    catch ".fontBox.frame2.family config $tmpButtonOpt"

    menu .fontBox.frame2.family.m
    catch ".fontBox.frame2.family.m config $tmpButtonOpt"

    .fontBox.frame2.family.m add radiobutton -label "*" -value "*" -variable fontBox(fontFamily) -command "FontBoxComposeFont"
    .fontBox.frame2.family.m add radiobutton -label "charter" -value "charter" -variable fontBox(fontFamily) -command "FontBoxComposeFont"
    .fontBox.frame2.family.m add radiobutton -label "courier" -value "courier" -variable fontBox(fontFamily) -command "FontBoxComposeFont"
    .fontBox.frame2.family.m add radiobutton -label "fixed" -value "fixed" -variable fontBox(fontFamily) -command "FontBoxComposeFont"
    .fontBox.frame2.family.m add radiobutton -label "helvetica" -value "helvetica" -variable fontBox(fontFamily) -command "FontBoxComposeFont"
    .fontBox.frame2.family.m add radiobutton -label "jis" -value "jis" -variable fontBox(fontFamily) -command "FontBoxComposeFont"
    .fontBox.frame2.family.m add radiobutton -label "lucida" -value "lucida" -variable fontBox(fontFamily) -command "FontBoxComposeFont"
    .fontBox.frame2.family.m add radiobutton -label "terminal" -value "terminal" -variable fontBox(fontFamily) -command "FontBoxComposeFont"
    .fontBox.frame2.family.m add radiobutton -label "times" -value "times" -variable fontBox(fontFamily) -command "FontBoxComposeFont"

    # weight menu
    menubutton .fontBox.frame2.weight -text "Weight" -menu ".fontBox.frame2.weight.m"
    catch ".fontBox.frame2.weight config $tmpButtonOpt"

    menu .fontBox.frame2.weight.m
    catch ".fontBox.frame2.weight.m config $tmpButtonOpt"

    .fontBox.frame2.weight.m add radiobutton -label "*" -value "*" -variable fontBox(fontWeight) -command "FontBoxComposeFont"
    .fontBox.frame2.weight.m add radiobutton -label "bold" -value "bold" -variable fontBox(fontWeight) -command "FontBoxComposeFont"
    .fontBox.frame2.weight.m add radiobutton -label "demibold" -value "demibold" -variable fontBox(fontWeight) -command "FontBoxComposeFont"
    .fontBox.frame2.weight.m add radiobutton -label "medium" -value "medium" -variable fontBox(fontWeight) -command "FontBoxComposeFont"

    # Slant menu
    menubutton .fontBox.frame2.slant -text "Slant" -menu ".fontBox.frame2.slant.m"
    catch ".fontBox.frame2.slant config $tmpButtonOpt"

    menu .fontBox.frame2.slant.m
    catch ".fontBox.frame2.slant.m config $tmpButtonOpt"

    .fontBox.frame2.slant.m add radiobutton -label "*" -value "*" -variable fontBox(fontSlant) -command "FontBoxComposeFont"
    .fontBox.frame2.slant.m add radiobutton -label "i" -value "i" -variable fontBox(fontSlant) -command "FontBoxComposeFont"
    .fontBox.frame2.slant.m add radiobutton -label "o" -value "o" -variable fontBox(fontSlant) -command "FontBoxComposeFont"
    .fontBox.frame2.slant.m add radiobutton -label "r" -value "r" -variable fontBox(fontSlant) -command "FontBoxComposeFont"

    # Set width menu
    menubutton .fontBox.frame2.swidth -text "Set width" -menu ".fontBox.frame2.swidth.m"
    catch ".fontBox.frame2.swidth config $tmpButtonOpt"

    menu .fontBox.frame2.swidth.m
    catch ".fontBox.frame2.swidth.m config $tmpButtonOpt"

    .fontBox.frame2.swidth.m add radiobutton -label "*" -value "*" -variable fontBox(fontSWidth) -command "FontBoxComposeFont"
    .fontBox.frame2.swidth.m add radiobutton -label "normal" -value "normal" -variable fontBox(fontSWidth) -command "FontBoxComposeFont"
    .fontBox.frame2.swidth.m add radiobutton -label "semicondensed" -value "semicondensed" -variable fontBox(fontSWidth) -command "FontBoxComposeFont"

    # pixels menu
    menubutton .fontBox.frame2.pixels -text "Pixels" -menu ".fontBox.frame2.pixels.m"
    catch ".fontBox.frame2.pixels config $tmpButtonOpt"

    menu .fontBox.frame2.pixels.m
    catch ".fontBox.frame2.pixels.m config $tmpButtonOpt"

    .fontBox.frame2.pixels.m add radiobutton -label "*" -value "*" -variable fontBox(fontPixels) -command "FontBoxComposeFont"
    .fontBox.frame2.pixels.m add radiobutton -label "6 pixels" -value "6" -variable fontBox(fontPixels) -command "FontBoxComposeFont"
    .fontBox.frame2.pixels.m add radiobutton -label "8 pixels" -value "8" -variable fontBox(fontPixels) -command "FontBoxComposeFont"
    .fontBox.frame2.pixels.m add radiobutton -label "10 pixels" -value "10" -variable fontBox(fontPixels) -command "FontBoxComposeFont"
    .fontBox.frame2.pixels.m add radiobutton -label "12 pixels" -value "12" -variable fontBox(fontPixels) -command "FontBoxComposeFont"
    .fontBox.frame2.pixels.m add radiobutton -label "13 pixels" -value "13" -variable fontBox(fontPixels) -command "FontBoxComposeFont"
    .fontBox.frame2.pixels.m add radiobutton -label "14 pixels" -value "14" -variable fontBox(fontPixels) -command "FontBoxComposeFont"
    .fontBox.frame2.pixels.m add radiobutton -label "16 pixels" -value "16" -variable fontBox(fontPixels) -command "FontBoxComposeFont"
    .fontBox.frame2.pixels.m add radiobutton -label "18 pixels" -value "18" -variable fontBox(fontPixels) -command "FontBoxComposeFont"
    .fontBox.frame2.pixels.m add radiobutton -label "24 pixels" -value "24" -variable fontBox(fontPixels) -command "FontBoxComposeFont"
    .fontBox.frame2.pixels.m add radiobutton -label "28 pixels" -value "28" -variable fontBox(fontPixels) -command "FontBoxComposeFont"
    .fontBox.frame2.pixels.m add radiobutton -label "30 pixels" -value "30" -variable fontBox(fontPixels) -command "FontBoxComposeFont"

    # read font file
    if {"$fontBoxFileFont" != ""} {
      if {[catch "open $fontBoxFileFont r" fontInFile]} {
        set fontBoxFileFont ""
        if {"[info commands AlertBox]" != ""} {
          AlertBox "$fontInFile"
        } {
          puts stderr "$fontInFile"
        }
      } {
        set fontReadList [read $fontInFile]
        close $fontInFile
        foreach fontLine [split $fontReadList "\n"] {
          if {"[string trim $fontLine]" != ""} {
            .fontBox.fonts.fonts insert end $fontLine
          }
        }
      }
    }
  } {
    if {"[winfo class $fontBox(oldWidget)]" == "Text"} {
      catch "$fontBox(oldWidget) delete 1.0 end"
      catch "$fontBox(oldWidget) insert 1.0 [.fontBox.current.current get]"
    } {
      if {"[winfo class $fontBox(oldWidget)]" == "Entry"} {
        catch "$fontBox(oldWidget) delete 0 end"
        catch "$fontBox(oldWidget) insert 0 [.fontBox.current.current get]"
      }
    }

    set fontBox(oldWidget) $fontBoxEntryW
  }

  .fontBox.frame1.ok config -command "
      global fontBox
      set fontBox(fontName) \[.fontBox.current.current get\]
      if {\"$fontBoxEntryW\" != \"\"} {
        if {\"\[winfo class $fontBoxEntryW\]\" == \"Text\"} {
          catch \"$fontBoxEntryW delete 1.0 end\"
          catch \"$fontBoxEntryW insert 1.0 \\\"\$fontBox(fontName)\\\"\"
        } {
          if {\"\[winfo class $fontBoxEntryW\]\" == \"Entry\"} {
            catch \"$fontBoxEntryW delete 0 end\"
            catch \"$fontBoxEntryW insert 0 \\\"\$fontBox(fontName)\\\"\"
          }
        }
      }
      PrologSetReady 1
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .fontBox}
      } {
        catch {destroy .fontBox}
      }"

  .fontBox.frame1.cancel config -command "
      global fontBox
      set fontBox(fontName) {}
      if {\"$fontBoxTargetW\" != \"\"} {
        catch \"$fontBoxTargetW config -$fontBox(resource) $fontBoxSavedFont\"
      }
      PrologSetReady 1
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .fontBox}
      } {
        catch {destroy .fontBox}
      }"

  .fontBox.current.labelcurrent config -text "$fontBoxResource:"

  # bindings
  bind .fontBox.current.current <Return> "
    FontBoxSetFont \"$fontBoxTargetW\""

  bind .fontBox.fonts.fonts <Double-1> "
    FontBoxSelectFont %W \"$fontBoxTargetW\" %y
    global fontBox
    set fontBox(fontName) \[.fontBox.current.current get\]
    if {\"$fontBoxEntryW\" != \"\"} {
      if {\"\[winfo class $fontBoxEntryW\]\" == \"Text\"} {
        catch \"$fontBoxEntryW delete 1.0 end\"
        catch \"$fontBoxEntryW insert 1.0 \\\"\$fontBox(fontName)\\\"\"
      } {
        if {\"\[winfo class $fontBoxEntryW\]\" == \"Entry\"} {
          catch \"$fontBoxEntryW delete 0 end\"
          catch \"$fontBoxEntryW insert 0 \\\"\$fontBox(fontName)\\\"\"
        }
      }
    }
    if {\"\[info commands XFDestroy\]\" != \"\"} {
      catch {XFDestroy .fontBox}
    } {
      catch {destroy .fontBox}
    }"
  bind .fontBox.fonts.fonts <ButtonPress-1> "
    FontBoxSelectFont %W \"$fontBoxTargetW\" %y"
  bind .fontBox.fonts.fonts <Button1-Motion> "
    FontBoxSelectFont %W \"$fontBoxTargetW\" %y"
  bind .fontBox.fonts.fonts <Shift-ButtonPress-1> "
    FontBoxSelectFont %W \"$fontBoxTargetW\" %y"
  bind .fontBox.fonts.fonts <Shift-Button1-Motion> "
    FontBoxSelectFont %W \"$fontBoxTargetW\" %y"

  # set up current value
  .fontBox.current.current delete 0 end
  if {"$fontBoxEntryW" != ""} {
    if {"[winfo class $fontBoxEntryW]" == "Text"} {
      .fontBox.current.current insert 0 [$fontBoxEntryW get 1.0 end]
    } {
      if {"[winfo class $fontBoxEntryW]" == "Entry"} {
        .fontBox.current.current insert 0 [$fontBoxEntryW get]
      }
    }
  }

  # packing
  pack append .fontBox.frame1 .fontBox.frame1.ok {left expand padx 6 pady 6} .fontBox.frame1.rescan {left expand padx 6 pady 6} .fontBox.frame1.cancel {left expand padx 6 pady 6}
  pack append .fontBox.frame2 .fontBox.frame2.family {left} .fontBox.frame2.weight {left} .fontBox.frame2.slant {left} .fontBox.frame2.swidth {left} .fontBox.frame2.pixels {left}
  pack append .fontBox.current .fontBox.current.labelcurrent {left} .fontBox.current.current {left fill expand}
  pack append .fontBox.fonts .fontBox.fonts.vscroll "$fontBox(scrollSide) filly" .fontBox.fonts.hscroll {bottom fillx} .fontBox.fonts.fonts {left fill expand}

  if {"$fontBoxFileFont" != ""} {
    pack append .fontBox .fontBox.frame1 {bottom fillx} .fontBox.current {bottom fillx} .fontBox.demo {bottom fillx} .fontBox.frame2 {top fill} .fontBox.fonts {left expand fill}
  } {
    wm geometry .fontBox 400x110
    pack append .fontBox .fontBox.frame1 {bottom fillx} .fontBox.current {bottom fillx} .fontBox.frame2 {top fill} .fontBox.demo {bottom fill expand}
  }

  XFLocalSetAppDefs .fontBox

  MiscPlaceWindow .fontBox font

  if {"$fontBoxEntryW" == ""} {
    # wait for the box to be destroyed
    update idletask
    grab .fontBox
    tkwait window .fontBox

    return $fontBox(fontName)
  }
}


# Procedure: FontBoxComposeFont
proc FontBoxComposeFont {} {
# xf ignore me 6
  global fontBox
  
  if {"$fontBox(fontFamily)" != "*"} {
    append fontNewFont * $fontBox(fontFamily)
  } {
    append fontNewFont *
  }
  if {"$fontBox(fontWeight)" != "*"} {
    append fontNewFont - $fontBox(fontWeight)
  } {
    append fontNewFont - *
  }
  if {"$fontBox(fontSlant)" != "*"} {
    append fontNewFont - $fontBox(fontSlant)
  } {
    append fontNewFont - *
  }
  if {"$fontBox(fontSWidth)" != "*"} {
    append fontNewFont - $fontBox(fontSWidth)
  } {
    append fontNewFont - *
  }
  append fontNewFont - *
  if {"$fontBox(fontPixels)" != "*"} {
    append fontNewFont - $fontBox(fontPixels)
  } {
    append fontNewFont -
  }
  append fontNewFont *

  .fontBox.current.current delete 0 end
  .fontBox.current.current insert 0 $fontNewFont
  catch ".fontBox.demo config -$fontBox(resource) $fontNewFont"
}


# Procedure: FontBoxSelectFont
proc FontBoxSelectFont { fontBoxW fontBoxTargetW fontBoxY} {
# xf ignore me 6

  set fontBoxNearest [$fontBoxW nearest $fontBoxY]
  if {$fontBoxNearest >= 0} {
    $fontBoxW select from $fontBoxNearest
    $fontBoxW select to $fontBoxNearest
    .fontBox.current.current delete 0 end
    .fontBox.current.current insert 0 [$fontBoxW get $fontBoxNearest]
    FontBoxSetFont "$fontBoxTargetW"
  }
}


# Procedure: FontBoxSetFont
proc FontBoxSetFont { fontBoxTargetW} {
# xf ignore me 6
  global fontBox

  if {"[.fontBox.current.current get]" != ""} {
    catch ".fontBox.demo config -$fontBox(resource) [.fontBox.current.current get]"
    if {"$fontBoxTargetW" != ""} {
      catch "$fontBoxTargetW config -$fontBox(resource) [.fontBox.current.current get]"
    }
  }
}


# Procedure: GetSelection
if {"[info procs GetSelection]" == ""} {
proc GetSelection {} {
# xf ignore me 7
##########
# Procedure: GetSelection
# Description: get current selection
# Arguments: none
# Returns: none
# Sideeffects: none
##########

  # the save way
  set xfSelection ""
  catch "selection get" xfSelection
  if {"$xfSelection" == "selection doesn't exist or form \"STRING\" not defined"} {
    return ""
  } {
    return $xfSelection
  }
}
}


# Procedure: GraphCreateWindow
proc GraphCreateWindow { type ids {embedPath ""} {edgeList ""} {graphName ""}} {
  # This procedure creates a graph display window, to
  # represent a mobal information.
  # type - the type of the view
  # ids - the node list to display
  # embedPath - this path is used to embed the graph
  #             window into a existing dialog
  # edgeList - the list of all edges

  # The global variables of mobal.
  global mobal
  # This array contains the configurated pathnames
  # used by TkMobal.
  global mobalPath
  # All graph nodes and edges are stored in this array.
  global mobalGraph

  set mobal(graphIdList) $ids
  if {"$graphName" == ""} {
    if {"$embedPath" == ""} {
      # Create a new toplevel

      set result [MiscMakeWindowName .xfmobalStack graphic]
      set pathName [lindex $result 0]
      set tmpTitle "[lindex $result 1] ($type)"
      set mobal(graphViewCounter) [lindex $result 2]

      # Create the toplevel.
      toplevel $pathName 
      MiscPlaceWindowPrepare $pathName graphic
      wm protocol $pathName WM_DELETE_WINDOW "ViewDestroy $pathName graphic $mobal(graphViewCounter)"
      wm title $pathName $tmpTitle
      wm geometry $pathName 400x400

      # The toplevel was destroyed. So clean up the stack.
      bind $pathName <Destroy> "ViewDestroy $pathName graphic $mobal(graphViewCounter)"
    } {
      # The pathname of the created widget.
      set pathName $embedPath
      set tmpTitle $embedPath
    }

    # Clear global array.
    foreach name [array names mobalGraph] {
      if {[string match "$pathName,*" $name]} {
        unset mobalGraph($name)
      }
    }

    if {"$type" == "fact" || "$type" == "pred"} {
      set mobal(graphArrowDirection,$pathName.graph) 0
      set mobal(graphCurrentArrowDirection,$pathName.graph) 0
    } {
      set mobal(graphArrowDirection,$pathName.graph) 1
      set mobal(graphCurrentArrowDirection,$pathName.graph) 1
    }
    if {"$type" == "mpred" || "$type" == "tnode"} {
      set mobal(layout,graphorder,$pathName.graph) 1
    } {
      set mobal(layout,graphorder,$pathName.graph) 0
    }
    set mobal(layout,method,$pathName.graph) Default

    # Create the iconpane.
    if {"$embedPath" == ""} {
      tkiconpane $pathName.graph -name $tmpTitle -menupath $mobalPath(menu) -edgemenupath $mobalPath(edgeMenu) -iconmenupath $mobalPath(iconMenu) -iconpixmappath $mobalPath(iconPixmap) -iconstatuspath $mobalPath(iconStatus) -menu2 standard -toplevel 0 -placing 1 -layout 0 -iconspaceh 30 -iconspacev 30 -layoutcommand GraphLayoutMethod_Default -toolbarbottom standard -menu1 $pathName.graph.xfGraphLayoutMenu -dragdrop 0 -edgeorder 1 -graphorder 0 -bindtype 0
    } {
      if {"[info commands $pathName.graph]" == ""} {
        tkiconpane $pathName.graph -name $tmpTitle -menupath $mobalPath(menu) -edgemenupath $mobalPath(edgeMenu) -iconmenupath $mobalPath(iconMenu) -iconpixmappath $mobalPath(iconPixmap) -iconstatuspath $mobalPath(iconStatus) -menu2 standard -toplevel 0 -placing 1 -layout 0 -iconspaceh 30 -iconspacev 30 -layoutcommand GraphLayoutMethod_Default -toolbarbottom embedded -menu1 $pathName.graph.xfGraphLayoutMenu -dragdrop 0 -edgeorder 1 -graphorder 0 -bindtype 1
      } {
        $pathName.graph icondelete
      }
    }
    # Create the layouter menu.
    if {"[info commands $pathName.graph.xfGraphLayoutMenu]" == ""} {
      menu $pathName.graph.xfGraphLayoutMenu
      foreach algorithm [lsort [info procs GraphLayoutMethod_*]] {
        $pathName.graph.xfGraphLayoutMenu add radiobutton -label "[string range $algorithm 18 end]" -variable mobal(layout,method,$pathName.graph) -command "$pathName.graph config -layoutcommand $algorithm; $pathName.graph layout"
      }
      $pathName.graph.xfGraphLayoutMenu add separator
      $pathName.graph.xfGraphLayoutMenu add radiobutton -label "Top-down" -variable mobal(layout,graphorder,$pathName.graph) -value 1 -command "$pathName.graph config -graphorder 1; $pathName.graph layout"
      $pathName.graph.xfGraphLayoutMenu add radiobutton -label "Left-right" -variable mobal(layout,graphorder,$pathName.graph) -value 0 -command "$pathName.graph config -graphorder 1; $pathName.graph layout"
      $pathName.graph.xfGraphLayoutMenu add separator
      $pathName.graph.xfGraphLayoutMenu add command -label "Dump to PS..." -command "
set fsBox(checkCommand) MiscPrologWritable
set fsBox(all) 1
set result \[FSBox \"Dump to PS...\" \$mobalFile(dumpPSPath)\]
if {\"\$result\" != \"\"} {
  set bbox \[[lindex [$pathName.graph config -canvaspath] 4] bbox all\]
  [lindex [$pathName.graph config -canvaspath] 4] postscript  -file \$result  -height \[expr \[lindex \$bbox 3\]-\[lindex \$bbox 1\]\]  -width \[expr \[lindex \$bbox 2\]-\[lindex \$bbox 0\]\]  -x \[lindex \$bbox 0\]  -y \[lindex \$bbox 1\]
}"
    }

    # Retrieve the edges
    if {"$edgeList" == ""} {
      set edgeList [PrologSendForce mobal_graph_get [PrologAtom $type] [eval PrologStringList $mobal(graphIdList)]]
      if {"$mobal(outFd)" == "stdout"} {
#        set edgeList {{edge1 {r1-[aa]} normal {r2-[a,1]} virtual} {edge2 {r1-[a,2]} normal {1: Input} virtual} {edge3 {1: Input} normal {r2-[a,1]} virtual} {edge4 {r1-[a,2]} normal test virtual}}
      }
    }
  } {
    set pathName $graphName
  }
  
  tkmobal_graphparse $pathName $embedPath $type $ids $edgeList $mobal(graphCurrentArrowDirection,$pathName.graph)

  if {"$graphName" == ""} {
    pack append $pathName $pathName.graph {top fill expand}

    # Update the X resources.
    XFLocalSetAppDefs $pathName

    if {"$embedPath" == ""} {
      MiscPlaceWindow $pathName graphic
    }
  }
  # Return the created pathname.
  return $pathName
}


# Procedure: GraphExpandNode
proc GraphExpandNode { pathName type embedPath id} {
  # Expand and deexpand nodes.
  # pathName - the tkiconpane widget
  # type - the type of the graph
  # embedPath - the embedded path name
  # id - the new id

  # The global variables of mobal.
  global mobal
  # All graph nodes and edges are stored in this array.
  global mobalGraph    

  # Get the nodes to expand/deexpand
  PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
  set result [PrologSend mobal_graph_get [PrologAtom $type] [eval PrologStringList [$pathName iconinfo name $id]]]

  if {"$mobal(outFd)" == "stdout"} {
    set result {{edgeexpand4 Node1 normal Node3 normal} {edgeexpand5 Node3 normal Node2 virtual} {edgeexpand6 Node3 normal Node5 normal} {edgeexpand7 Node3 normal Node5 normal} {edgeexpand Node1 normal Node2 virtual} {edgeexpand9 Node5 normal Node6 normal}}
  }

  if {"normal" == "[lindex [$pathName iconconf $id -status] 4]"} {
    # Expand the node.
    $pathName iconconf $id -status expanded -text [lindex [$pathName iconconf $id -text] 4]*
    GraphCreateWindow $type [list $id] $embedPath $result [winfo parent $pathName]
  } {
    # Deexpand the node.
    $pathName iconconf $id -status normal -text [string trimright [lindex [$pathName iconconf $id -text] 4] *]
    # Delete edges.
    foreach canvEdge [$pathName edgeinfo ids mygraph] {
      set fromId [lindex [$pathName edgeconf mygraph $canvEdge -from] 4]
      set toId [lindex [$pathName edgeconf mygraph $canvEdge -to] 4]
      set fromName [$pathName iconinfo name $fromId]
      set toName [$pathName iconinfo name $toId]
      set tmpLength1 0
      set tmpLength2 0
      foreach edge $result {
        set edgeName [lindex $edge 0]
        set fromNode [lindex $edge 1]
        set toNode [lindex $edge 3]
        if {"$fromName" == "$fromNode" && "$toName" == "$toNode" ||
            "$fromName" == "$toNode" && "$toName" == "$fromNode"} {
          if {[info exists mobalGraph([winfo parent $pathName],$fromNode,$toNode)]} {
            set tmpIndex [lsearch $mobalGraph([winfo parent $pathName],$fromNode,$toNode) $edgeName]
            if {$tmpIndex != -1} {
              set mobalGraph([winfo parent $pathName],$fromNode,$toNode) [lreplace $mobalGraph([winfo parent $pathName],$fromNode,$toNode) $tmpIndex $tmpIndex]
            }
            set tmpLength1 [llength $mobalGraph([winfo parent $pathName],$fromNode,$toNode)]
          }
          if {[info exists mobalGraph([winfo parent $pathName],$toNode,$fromNode)]} {
            set tmpIndex [lsearch $mobalGraph([winfo parent $pathName],$toNode,$fromNode) $edgeName]
            if {$tmpIndex != -1} {
              set mobalGraph([winfo parent $pathName],$toNode,$fromNode) [lreplace $mobalGraph([winfo parent $pathName],$toNode,$fromNode) $tmpIndex $tmpIndex]
            }
            set tmpLength2 [llength $mobalGraph([winfo parent $pathName],$toNode,$fromNode)]
          }
          if {$tmpLength1 == 0 && $tmpLength2 == 0} {
            $pathName edgedelete mygraph $canvEdge
            if {[info exists mobalGraph([winfo parent $pathName],$fromNode,$toNode)]} {
              unset mobalGraph([winfo parent $pathName],$fromNode,$toNode)
	    }
            if {[info exists mobalGraph([winfo parent $pathName],$toNode,$fromNode)]} {
              unset mobalGraph([winfo parent $pathName],$toNode,$fromNode)
	    }
          } {
            if {$tmpLength1 == 0} {
              if {[info exists mobalGraph([winfo parent $pathName],$fromNode,$toNode)]} {
                unset mobalGraph([winfo parent $pathName],$fromNode,$toNode)
	      }
              $pathName edgeconf mygraph [$pathName edgeinfo edge mygraph $toId $fromId] -arrow first
            } {
              if {$tmpLength2 == 0} {
                if {[info exists mobalGraph([winfo parent $pathName],$toNode,$fromNode)]} {
                  unset mobalGraph([winfo parent $pathName],$toNode,$fromNode)
		}
                $pathName edgeconf mygraph [$pathName edgeinfo edge mygraph $toId $fromId] -arrow last
	      }
            }
          }
        }
      }
    }
    # Delete free nodes.
    foreach canvIcon [$pathName iconinfo ids] {
      if {"[lindex [$pathName iconconf $canvIcon -edges] 4]" == ""} {
        $pathName icondelete $canvIcon
      }
    }
    # Layout the graph.
    $pathName layout
  }
  return ""
}


# Procedure: GraphLayoutMethod_Default
proc GraphLayoutMethod_Default { pathName args} {
  # Layouting of the graph.

  # The global variables of mobal.
  global mobal

  eval $pathName layout isi -graphorder $mobal(layout,graphorder,[winfo parent [winfo parent [winfo parent $pathName]]]) -edgeorder 1 -computeiconsize 1 -iconspaceh 40 -iconspacev 40 -xoffset 10 -yoffset 10 $args
}


# Procedure: GraphSelectNode
proc GraphSelectNode { pathName type embedPath id} {
  # Select / deselect the node.
  # pathName - the tkiconpane widget
  # type - the type of the graph
  # embedPath - the embedded path name
  # id - the new id

  # The global variables of mobal.
  global mobal
  # All graph nodes and edges are stored in this array.
  global mobalGraph    

  if {[string match {*: Input} [lindex [$pathName iconconf $id -name] 4]] ||
      [string match {r*-*\[*\]} [lindex [$pathName iconconf $id -name] 4]]} {
    if {"[lindex [$pathName iconconf $id -state] 4]" == "" ||
        "[lindex [$pathName iconconf $id -state] 4]" == "normal"} {
      $pathName iconconf $id -state selected
    } {
      $pathName iconconf $id -state normal
    }
  }
}


# Procedure: GraphUpdateArrowDirection
proc GraphUpdateArrowDirection { pathName type embedPath} {
  # This procedure updates the edge direction.
  # pathName - the pathname of the view
  # type - the type of the view
  # embedPath - this path is used to embed the graph
  #             window into a existing dialog

  # The global variables of mobal.
  global mobal
  # All graph nodes and edges are stored in this array.
  global mobalGraph

  if {$mobal(graphArrowDirection,$pathName.graph) != $mobal(graphCurrentArrowDirection,$pathName.graph)} {
    set mobal(graphCurrentArrowDirection,$pathName.graph) $mobal(graphArrowDirection,$pathName.graph)
    PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
    set result [PrologSend mobal_graph_get [PrologAtom $type] [eval PrologStringList $mobal(graphIdList)]]
    if {"$mobal(outFd)" == "stdout"} {
      set result {{edge1 {r1-[aa]} normal {r2-[a,1]} virtual} {edge2 {r1-[a,2]} normal {1: Input} virtual} {edge3 {1: Input} normal {r2-[a,1]} virtual} {edge4 {r1-[a,2]} normal test virtual}}
    }
    foreach name [array names mobalGraph] {
      if {[string match "$pathName,*" $name]} {
        unset mobalGraph($name)
      }
    }
    $pathName.graph icondelete
    $pathName.graph edgedelete
    tkmobal_graphparse $pathName $embedPath $type $mobal(graphIdList) $result $mobal(graphCurrentArrowDirection,$pathName.graph)
  }
}


# Procedure: GraphUpdateEdgeMenu
proc GraphUpdateEdgeMenu { menuPath} {
  # This procedure updates the edge menus. The information 
  # is retrived from the prolog interpreter.
  # pathName - the pathname of the view

  # All graph nodes and edges are stored in this array.
  global mobalGraph

  # get the iconpane path name
  set pathName [tkiconpane_info name]
  set fromName [$pathName iconinfo name [lindex [$pathName edgeconf mygraph [$pathName edgeinfo id mygraph] -from] 4]]
  set toName [$pathName iconinfo name [lindex [$pathName edgeconf mygraph [$pathName edgeinfo id mygraph] -to] 4]]

  # Clear the current edge menu.
  catch "$menuPath delete 0 last"

  set previousName ""
  # Walk through the menu items.
  foreach element [lsort $mobalGraph([winfo parent $pathName],$fromName,$toName)] {
    if {"$element" != "$previousName" && "$element" != ""} {
      set previousName $element
      # Create the command item.
      $menuPath add command -label $element -command "
\[tkiconpane_info canvaspath\] itemconfig \[tkiconpane_info edgeinfo id mygraph\] -label \{$element\}
\[tkiconpane_info tkiconpane\] layout"
    }
  }
  if {[info exists mobalGraph([winfo parent $pathName],$toName,$fromName)]} {
    $menuPath add separator
    foreach element [lsort $mobalGraph([winfo parent $pathName],$toName,$fromName)] {
      if {"$element" != "$previousName"} {
        set previousName $element
        # Create the command item.
        $menuPath add command -label $element -command "
\[tkiconpane_info canvaspath\] itemconfig \[tkiconpane_info edgeinfo id mygraph\] -label \{$element\}
\[tkiconpane_info tkiconpane\] layout"
      }
    }
  }
}


# Procedure: GraphUpdateNodeMenu
proc GraphUpdateNodeMenu { menuPath} {
  # This procedure updates the node menus. The information 
  # is retrived from the prolog interpreter.
  # pathName - the pathname of the view

  # The global variables of mobal.
  global mobal

  # get the iconpane path name
  set pathName [tkiconpane_info name]

  # Clear the current node menu.
  catch "$menuPath delete 0 last"

  # get the iconpane path name
  set pathName [tkiconpane_info name]
  set nodeName [$pathName iconinfo name]
  set nodeType [lindex [lindex [$pathName iconconf [$pathName iconinfo id] -tag] 4] 0]
  # Retrieve the node menu definition.

  PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
  set nodeInfo [PrologSend mobal_graph_node_info_get [PrologAtom $nodeType] [eval PrologString $nodeName]]
  if {"$mobal(outFd)" == "stdout"} {
    set nodeInfo {{Predicate:} {Name1} {Name2}}
  }

  # Walk through the menu items.
  foreach element $nodeInfo {
    # Create the command item.
    if {"$element" == "-"} {
      $menuPath add separator
    } {
      $menuPath add command -label $element -command "
if {\"normal\" == \"\[lindex \[\[tkiconpane_info canvaspath\] itemconfig \[tkiconpane_info iconinfo id\] -status\] 4\]\"} {
  \[tkiconpane_info canvaspath\] itemconfig \[tkiconpane_info iconinfo id\] -text \{$element\}
} {
  \[tkiconpane_info canvaspath\] itemconfig \[tkiconpane_info iconinfo id\] -text \{$element*\}
\[tkiconpane_info tkiconpane\] layout}"
    }
    $menuPath entryconfig 0 -state disabled
  }
  if {[MiscGetDebugging]} {
    $menuPath add separator
    $menuPath add command -label "Node Id" -command "puts stdout [tkiconpane_info iconinfo id]"
  }
}


# Procedure: InputBoxInternal
proc InputBoxInternal { inputBoxMessage inputBoxCommandOk inputBoxCommandCancel inputBoxGeometry inputBoxTitle lineNum} {
# xf ignore me 6
  global inputBox

  # prepare widget configuration strings
  set tmpButtonOpt ""
  set tmpFrameOpt ""
  set tmpMessageOpt ""
  set tmpScaleOpt ""
  set tmpScrollOpt ""
  if {"$inputBox(activeBackground)" != ""} {
    append tmpButtonOpt "-activebackground \"$inputBox(activeBackground)\" "
  }
  if {"$inputBox(activeForeground)" != ""} {
    append tmpButtonOpt "-activeforeground \"$inputBox(activeForeground)\" "
  }
  if {"$inputBox(background)" != ""} {
    append tmpButtonOpt "-background \"$inputBox(background)\" "
    append tmpFrameOpt "-background \"$inputBox(background)\" "
    append tmpMessageOpt "-background \"$inputBox(background)\" "
  }
  if {"$inputBox(font)" != ""} {
    append tmpButtonOpt "-font \"$inputBox(font)\" "
    append tmpMessageOpt "-font \"$inputBox(font)\" "
  }
  if {"$inputBox(foreground)" != ""} {
    append tmpButtonOpt "-foreground \"$inputBox(foreground)\" "
    append tmpMessageOpt "-foreground \"$inputBox(foreground)\" "
  }
  if {"$inputBox(scrollActiveForeground)" != ""} {
    append tmpScrollOpt "-activeforeground \"$inputBox(scrollActiveForeground)\" "
  }
  if {"$inputBox(scrollBackground)" != ""} {
    append tmpScrollOpt "-background \"$inputBox(scrollBackground)\" "
  }
  if {"$inputBox(scrollForeground)" != ""} {
    append tmpScrollOpt "-foreground \"$inputBox(scrollForeground)\" "
  }

  # start build of toplevel
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy $inputBox(toplevelName)}
  } {
    catch {destroy $inputBox(toplevelName)}
  }
  toplevel $inputBox(toplevelName)  -borderwidth 0
  MiscPlaceWindowPrepare $inputBox(toplevelName) input
  catch "$inputBox(toplevelName) config $tmpFrameOpt"
  if {"$inputBoxGeometry" != ""} {
    if {[catch "wm geometry $inputBox(toplevelName) $inputBoxGeometry"]} {
      wm geometry $inputBox(toplevelName) 400x250
    }
  }
  wm title $inputBox(toplevelName) $inputBoxTitle
  # end build of toplevel

  message $inputBox(toplevelName).message1  -anchor "$inputBox(anchor)"  -justify "$inputBox(justify)"  -relief raised  -text "$inputBoxMessage"
  catch "$inputBox(toplevelName).message1 config $tmpMessageOpt"

  set xfTmpWidth  [string range $inputBoxGeometry 0 [expr [string first x $inputBoxGeometry]-1]]
  if {"$xfTmpWidth" != ""} {
    # set message size
    catch "$inputBox(toplevelName).message1 configure  -width [expr $xfTmpWidth-10]"
  } {
    $inputBox(toplevelName).message1 configure  -aspect 400
  }

  frame $inputBox(toplevelName).frame0  -borderwidth 2  -relief raised
  catch "$inputBox(toplevelName).frame0 config $tmpFrameOpt"

  frame $inputBox(toplevelName).frame1  -borderwidth 0  -relief raised
  catch "$inputBox(toplevelName).frame1 config $tmpFrameOpt"

  if {$lineNum == 1} {
    scrollbar $inputBox(toplevelName).frame1.hscroll  -orient "horizontal"  -relief raised  -command "$inputBox(toplevelName).frame1.input view"
    catch "$inputBox(toplevelName).frame1.hscroll config $tmpScrollOpt"

    entry $inputBox(toplevelName).frame1.input  -relief raised  -scrollcommand "$inputBox(toplevelName).frame1.hscroll set"
    catch "$inputBox(toplevelName).frame1.input config $tmpMessageOpt"

    $inputBox(toplevelName).frame1.input insert 0  $inputBox($inputBox(toplevelName),inputOne)
    
    # bindings
    bind $inputBox(toplevelName).frame1.input <Return> "
      global inputBox
      set inputBox($inputBox(toplevelName),canceled) 0
      if {\"$inputBox(checkCommand)\" != \"\"} {
        if {!\[eval \{$inputBox(checkCommand)\} \{\[$inputBox(toplevelName).frame1.input get\]\}\]} {
          set inputBox($inputBox(toplevelName),canceled) -1
        }
      }
      if {\$inputBox($inputBox(toplevelName),canceled) != -1} {
        set inputBox($inputBox(toplevelName),inputOne) \[$inputBox(toplevelName).frame1.input get\]
        if {\"\[info commands XFDestroy\]\" != \"\"} {
          catch \{XFDestroy $inputBox(toplevelName)\}
        } {
          catch \{destroy $inputBox(toplevelName)\}
        }
        $inputBoxCommandOk
      }"
    
    # packing
    pack append $inputBox(toplevelName).frame1  $inputBox(toplevelName).frame1.hscroll {bottom fill}  $inputBox(toplevelName).frame1.input {top fill expand}
  } {
#    text $inputBox(toplevelName).frame1.input  -height 5 -width 50 -relief raised  -wrap none  -borderwidth 2  -yscrollcommand "$inputBox(toplevelName).frame1.vscroll set"
    text $inputBox(toplevelName).frame1.input -height 0 -width 0 -relief raised  -wrap none  -borderwidth 2  -yscrollcommand "$inputBox(toplevelName).frame1.vscroll set"
    catch "$inputBox(toplevelName).frame1.input config $tmpMessageOpt"

    scrollbar $inputBox(toplevelName).frame1.vscroll  -relief raised  -command "$inputBox(toplevelName).frame1.input yview"
    catch "$inputBox(toplevelName).frame1.vscroll config $tmpScrollOpt"

    $inputBox(toplevelName).frame1.input insert 1.0  $inputBox($inputBox(toplevelName),inputMulti)

    # bindings
    bind $inputBox(toplevelName).frame1.input <Control-Return> "
      global inputBox
      set inputBox($inputBox(toplevelName),canceled) 0
      if {\"$inputBox(checkCommand)\" != \"\"} {
        if {!\[eval \{$inputBox(checkCommand)\} \{\[$inputBox(toplevelName).frame1.input get 1.0 end\]\}\]} {
          set inputBox($inputBox(toplevelName),canceled) -1
        }
      }
      if {\$inputBox($inputBox(toplevelName),canceled) != -1} {
        set inputBox($inputBox(toplevelName),inputMulti) \[$inputBox(toplevelName).frame1.input get 1.0 end\]
        if {\"\[info commands XFDestroy\]\" != \"\"} {
          catch \{XFDestroy $inputBox(toplevelName)\}
        } {
          catch \{destroy $inputBox(toplevelName)\}
        }
        $inputBoxCommandOk
      }"
    bind $inputBox(toplevelName).frame1.input <Meta-Return> "
      global inputBox
      set inputBox($inputBox(toplevelName),canceled) 0
      if {\"$inputBox(checkCommand)\" != \"\"} {
        if {!\[eval \{$inputBox(checkCommand)\} \{\[$inputBox(toplevelName).frame1.input get 1.0 end\]\}\]} {
          set inputBox($inputBox(toplevelName),canceled) -1
        }
      }
      if {\$inputBox($inputBox(toplevelName),canceled) != -1} {
        set inputBox($inputBox(toplevelName),inputMulti) \[$inputBox(toplevelName).frame1.input get 1.0 end\]
        if {\"\[info commands XFDestroy\]\" != \"\"} {
          catch \{XFDestroy $inputBox(toplevelName)\}
        } {
          catch \{destroy $inputBox(toplevelName)\}
        }
        $inputBoxCommandOk
      }"

    # packing
    pack append $inputBox(toplevelName).frame1  $inputBox(toplevelName).frame1.vscroll "$inputBox(scrollSide) filly"  $inputBox(toplevelName).frame1.input {left fill expand}
  }
  
  button $inputBox(toplevelName).frame0.button0  -width 7 -text "OK"  -command "
      global inputBox
      set inputBox($inputBox(toplevelName),canceled) 0
      if {$lineNum == 1} {
        if {\"$inputBox(checkCommand)\" != \"\"} {
          if {!\[eval \{$inputBox(checkCommand)\} \{\[$inputBox(toplevelName).frame1.input get\]\}\]} {
            set inputBox($inputBox(toplevelName),canceled) -1
          }
        }
        if {!\[catch \"$inputBox(toplevelName).frame1.input get\" result\]} {
          set inputBox($inputBox(toplevelName),inputOne) \$result
         }
      } {
        if {\"$inputBox(checkCommand)\" != \"\"} {
          if {!\[eval \{$inputBox(checkCommand)\} \{\[$inputBox(toplevelName).frame1.input get 1.0 end\]\}\]} {
            set inputBox($inputBox(toplevelName),canceled) -1
          }
        }
        if {!\[catch \"$inputBox(toplevelName).frame1.input get 1.0 end\" result\]} {
          set inputBox($inputBox(toplevelName),inputMulti) \$result
        }
      }
      if {\$inputBox($inputBox(toplevelName),canceled) != -1} {
        if {\"\[info commands XFDestroy\]\" != \"\"} {
          catch \{XFDestroy $inputBox(toplevelName)\}
        } {
          catch \{destroy $inputBox(toplevelName)\}
        }
        $inputBoxCommandOk
      }"
  catch "$inputBox(toplevelName).frame0.button0 config $tmpButtonOpt"

  if {$inputBox(cancel)} {
    button $inputBox(toplevelName).frame0.button1  -width 7 -text "Cancel"  -command "
        global inputBox
        set inputBox($inputBox(toplevelName),canceled) 1
        if {$lineNum == 1} {
          set inputBox($inputBox(toplevelName),inputOne) \"\"
        } {
          set inputBox($inputBox(toplevelName),inputMulti) \"\"
        }
        if {\"\[info commands XFDestroy\]\" != \"\"} {
          catch \{XFDestroy $inputBox(toplevelName)\}
        } {
          catch \{destroy $inputBox(toplevelName)\}
        }
        $inputBoxCommandCancel"
    catch "$inputBox(toplevelName).frame0.button1 config $tmpButtonOpt"
    pack append $inputBox(toplevelName).frame0  $inputBox(toplevelName).frame0.button0 {left expand padx 6 pady 6}  $inputBox(toplevelName).frame0.button1 {left expand padx 6 pady 6}
  } {
    pack append $inputBox(toplevelName).frame0  $inputBox(toplevelName).frame0.button0 {left expand padx 6 pady 6}
  }

  pack append $inputBox(toplevelName)  $inputBox(toplevelName).frame0 {bottom fill}  $inputBox(toplevelName).frame1 {bottom fill expand}  $inputBox(toplevelName).message1 {top fill}

  XFLocalSetAppDefs

#  MiscPlaceWindow $inputBox(toplevelName) input

  if {"$inputBoxGeometry" == ""} {
    if {[winfo width $inputBox(toplevelName)] < 400 &&
        [winfo height $inputBox(toplevelName)] >= 250} {
      wm geometry $inputBox(toplevelName) 400x[winfo height $inputBox(toplevelName)]
    } {
      if {[winfo width $inputBox(toplevelName)] >= 400 &&
          [winfo height $inputBox(toplevelName)] < 250} {
        wm geometry $inputBox(toplevelName) [winfo width $inputBox(toplevelName)]x250
      } {
        if {[winfo width $inputBox(toplevelName)] < 400 &&
            [winfo height $inputBox(toplevelName)] < 250} {
          wm geometry $inputBox(toplevelName) 400x250
        }
      }
    }
  }

  MiscPlaceWindow $inputBox(toplevelName) input
}


# Procedure: InputBoxMulti
proc InputBoxMulti { {inputBoxMessage "Input box:"} {inputBoxCommandOk ""} {inputBoxCommandCancel ""} {inputBoxGeometry ""} {inputBoxTitle "Input box"}} {
# xf ignore me 5
##########
# Procedure: InputBoxMulti
# Description: show input box with one text line
# Arguments: {inputBoxMessage} - message to display
#            {inputBoxCommandOk} - the command to call after ok
#            {inputBoxCommandCancel} - the command to call after cancel
#            {inputBoxGeometry} - the geometry for the window
#            {inputBoxTitle} - the title for the window
# Returns: The entered text
# Sideeffects: none
# Notes: there exist also a function called:
#          InputBoxOne - to enter one line text
##########
#
# global inputBox(activeBackground) - active background color
# global inputBox(activeForeground) - active foreground color
# global inputBox(anchor) - anchor for message box
# global inputBox(background) - background color
# global inputBox(cancel) - show a cancel button
# global inputBox(erase) - erase previous text
# global inputBox(font) - message font
# global inputBox(foreground) - foreground color
# global inputBox(justify) - justify for message box
# global inputBox(scrollActiveForeground) - scrollbar active background color
# global inputBox(scrollBackground) - scrollbar background color
# global inputBox(scrollForeground) - scrollbar foreground color
# global inputBox(scrollSide) - side where scrollbar is located
# global inputBox(toplevelName) - the toplevel name
# global inputBox(toplevelName,inputMulti) - the text in the text widget

  global inputBox

  PrologSetQuerying

  if {"$inputBoxGeometry" == ""} {
    set inputBoxGeometry 400x250
  }
  if {$inputBox(erase)} {
    set inputBox($inputBox(toplevelName),inputMulti) ""
  } {
    if {![info exists inputBox($inputBox(toplevelName),inputMulti)]} {
      set inputBox($inputBox(toplevelName),inputMulti) ""
    }
  }
  set inputBox($inputBox(toplevelName),canceled) 0
  InputBoxInternal $inputBoxMessage $inputBoxCommandOk $inputBoxCommandCancel $inputBoxGeometry $inputBoxTitle 2

  # wait for the box to be destroyed
  update idletask
  grab $inputBox(toplevelName)
  tkwait window $inputBox(toplevelName)

  PrologSetReady 1

  return $inputBox($inputBox(toplevelName),inputMulti)
}


# Procedure: InputBoxOne
proc InputBoxOne { {inputBoxMessage "Input box:"} {inputBoxCommandOk ""} {inputBoxCommandCancel ""} {inputBoxGeometry ""} {inputBoxTitle "Input box"}} {
# xf ignore me 5
##########
# Procedure: InputBoxOne
# Description: show input box with one text line
# Arguments: {inputBoxMessage} - message to display
#            {inputBoxCommandOk} - the command to call after ok
#            {inputBoxCommandCancel} - the command to call after cancel
#            {inputBoxGeometry} - the geometry for the window
#            {inputBoxTitle} - the title for the window
# Returns: The entered text
# Sideeffects: none
# Notes: there exist also a function called:
#          InputBoxMulti - to enter multiline text
##########
#
# global inputBox(activeBackground) - active background color
# global inputBox(activeForeground) - active foreground color
# global inputBox(anchor) - anchor for message box
# global inputBox(background) - background color
# global inputBox(erase) - erase previous text
# global inputBox(font) - message font
# global inputBox(foreground) - foreground color
# global inputBox(justify) - justify for message box
# global inputBox(scrollActiveForeground) - scrollbar active background color
# global inputBox(scrollBackground) - scrollbar background color
# global inputBox(scrollForeground) - scrollbar foreground color
# global inputBox(scrollSide) - side where scrollbar is located
# global inputBox(toplevelName) - the toplevel name
# global inputBox(toplevelName,inputOne) - the text in the entry widget

  global inputBox

  PrologSetQuerying

  if {$inputBox(erase)} {
    set inputBox($inputBox(toplevelName),inputOne) ""
  } {
    if {![info exists inputBox($inputBox(toplevelName),inputOne)]} {
      set inputBox($inputBox(toplevelName),inputOne) ""
    }
  }
  set inputBox($inputBox(toplevelName),canceled) 0
  InputBoxInternal $inputBoxMessage $inputBoxCommandOk $inputBoxCommandCancel $inputBoxGeometry $inputBoxTitle 1

  # wait for the box to be destroyed
  update idletask
  grab $inputBox(toplevelName)
  tkwait window $inputBox(toplevelName)

  PrologSetReady 1

  return $inputBox($inputBox(toplevelName),inputOne)
}


# Procedure: InputScratchPad
proc InputScratchPad {} {
# xf ignore me 5
##########
# Procedure: ScratchPad
# Description: show a box where mobal commands can be evaluated
# Arguments: none
# Returns: none
# Sideeffects: may be everything...
##########
#
# global scratchPad(activeBackground) - active background color
# global scratchPad(activeForeground) - active foreground color
# global scratchPad(background) - background color
# global scratchPad(font) - text font
# global scratchPad(foreground) - foreground color
# global scratchPad(scrollActiveForeground) - scrollbar active background color
# global scratchPad(scrollBackground) - scrollbar background color
# global scratchPad(scrollForeground) - scrollbar foreground color
# global scratchPad(scrollSide) - side where scrollbar is located

  global scratchPad
  # The global variables of mobal.
  global mobal

  # initialize parameters
  set result [MiscMakeWindowName .xfmobalStack scratchpad]
  set pathName [lindex $result 0]
  set tmpTitle [lindex $result 1]
  set tmpCounter [lindex $result 2]

  # prepare widget configuration strings
  set tmpButtonOpt ""
  set tmpFrameOpt ""
  set tmpMessageOpt ""
  set tmpScrollOpt ""
  if {"$scratchPad(activeBackground)" != ""} {
    append tmpButtonOpt "-activebackground \"$scratchPad(activeBackground)\" "
  }
  if {"$scratchPad(activeForeground)" != ""} {
    append tmpButtonOpt "-activeforeground \"$scratchPad(activeForeground)\" "
  }
  if {"$scratchPad(background)" != ""} {
    append tmpButtonOpt "-background \"$scratchPad(background)\" "
    append tmpFrameOpt "-background \"$scratchPad(background)\" "
    append tmpMessageOpt "-background \"$scratchPad(background)\" "
  }
  if {"$scratchPad(font)" != ""} {
    append tmpButtonOpt "-font \"$scratchPad(font)\" "
    append tmpMessageOpt "-font \"$scratchPad(font)\" "
  }
  if {"$scratchPad(foreground)" != ""} {
    append tmpButtonOpt "-foreground \"$scratchPad(foreground)\" "
    append tmpMessageOpt "-foreground \"$scratchPad(foreground)\" "
  }
  if {"$scratchPad(scrollActiveForeground)" != ""} {
    append tmpScrollOpt "-activeforeground \"$scratchPad(scrollActiveForeground)\" "
  }
  if {"$scratchPad(scrollBackground)" != ""} {
    append tmpScrollOpt "-background \"$scratchPad(scrollBackground)\" "
  }
  if {"$scratchPad(scrollForeground)" != ""} {
    append tmpScrollOpt "-foreground \"$scratchPad(scrollForeground)\" "
  }

  # start build of toplevel
  if {"[info commands XFDestroy]" != ""} {
    catch "XFDestroy $pathName"
  } {
    catch "destroy $pathName"
  }
  toplevel $pathName  -borderwidth 0
  MiscPlaceWindowPrepare $pathName scratchpad
  catch "$pathName config $tmpFrameOpt"
  wm protocol $pathName WM_DELETE_WINDOW "ViewDestroy $pathName scratchpad $tmpCounter"
  wm geometry $pathName 420x300
  wm title $pathName $tmpTitle
  # end build of toplevel

  frame $pathName.frame1 -borderwidth 2 -relief raised
  catch "$pathName.frame1 config $tmpFrameOpt"
 
  button $pathName.frame1.ok -text "Close" -width 9 -command "
    ViewDestroy $pathName scratchpad $tmpCounter"
  catch "$pathName.frame1.ok config $tmpButtonOpt"

  button $pathName.frame1.send -text "Enter" -width 9 -command "
    set mobal(lastScratch) \[string trim \[$pathName.text1.text1 get 1.0 end\]\]
    if {\[catch \"PrologSend mobal_scratchpad \{\[PrologString \$mobal(lastScratch)\]\}\" result\]} {
      if {\"\[info commands AlertBox\]\" != \"\"} {
        AlertBox \"\$result\"
      } {
        puts stderr \"\$result\"
      }
    }"
  catch "$pathName.frame1.send config $tmpButtonOpt"

  button $pathName.frame1.help -text "Help" -width 9 -command {TextBox [PrologSend mobal_get_scratchpad_help]}
  catch "$pathName.frame1.help config $tmpButtonOpt"

  button $pathName.frame1.clear -text "Clear" -width 9 -command "$pathName.text1.text1 delete 1.0 end"
  catch "$pathName.frame1.clear config $tmpButtonOpt"

  frame $pathName.text1  -borderwidth 0 -relief raised
  catch "$pathName.text1 config $tmpFrameOpt"
 
  label $pathName.text1.label -relief raised -text {Enter knowledge items:}
  catch "$pathName.text1.label config $tmpMessageOpt"

  scrollbar $pathName.text1.scrollbar1 -command "$pathName.text1.text1 yview"  -relief "raised"
  catch "$pathName.text1.scrollbar1 config $tmpScrollOpt"

  text $pathName.text1.text1 -borderwidth "2" -exportselection "true" -insertbackground "blue" -height 2 -relief "raised" -yscrollcommand "$pathName.text1.scrollbar1 set"
  catch "$pathName.text1.text1 config $tmpMessageOpt"

  $pathName.text1.text1 insert end $mobal(lastScratch)

  bind $pathName.text1.text1 <Control-Return> "
    set mobal(lastScratch) \[string trim \[$pathName.text1.text1 get 1.0 end\]\]
    if {\[catch \"PrologSend mobal_scratchpad \{\[PrologString \$mobal(lastScratch)\]\}\" result\]} {
      if {\"\[info commands AlertBox\]\" != \"\"} {
        AlertBox \"\$result\"
      } {
        puts stderr \"\$result\"
      }
    }"

  # packing
  pack append $pathName.frame1 $pathName.frame1.send {left expand padx 6 pady 6}  $pathName.frame1.help {left expand padx 6 pady 6} $pathName.frame1.clear {left expand padx 6 pady 6} $pathName.frame1.ok {left expand padx 6 pady 6} 
  pack append $pathName.text1 $pathName.text1.label {top fill} $pathName.text1.scrollbar1 "$scratchPad(scrollSide) filly" $pathName.text1.text1 {top expand fill}
  pack append $pathName $pathName.frame1 {bottom fill} $pathName.text1 {bottom fill expand}

  XFLocalSetAppDefs $pathName

  MiscPlaceWindow $pathName scratchpad
}


# Procedure: Knowledge
proc Knowledge { {removalSets ""} {graphDefinition ""}} {
  # Display the knowledge revision dialog.
  # removalSets - the current removal set

  # The global variables of mobal.
  global mobal

  # Show the dialog.
  ShowWindow.knowledge

  # Add the item popup.
  if {"[info commands [SN KnowledgeItems].m]" == ""} {
    menu [SN KnowledgeItems].m -postcommand KnowledgeItemPopup
    [SN KnowledgeItems].m add command
    [SN KnowledgeItems].m add command
    [SN KnowledgeItems].m add command
    [SN KnowledgeItems].m add command
  } {
    [SN KnowledgeItems].m config -postcommand KnowledgeItemPopup
  }
  MenuPopupAdd [SN KnowledgeItems] 3 [SN KnowledgeItems].m
  bind [SN KnowledgeItems] <Button-3> {%W select from [%W nearest %y]; KnowledgeSelectItem; MenuPopupPost [SN KnowledgeItems].m %X %Y}

  # Create and display the graph.
  frame [SN KnowledgeGraph].xfgraph -borderwidth 0
  pack append [SN KnowledgeGraph] [SN KnowledgeGraph].xfgraph {top fill expand}
  set tmpIds ""
  foreach element [lindex $removalSets 0] {
    lappend tmpIds [lindex $element 0]
  }

  # Update the lists.
  KnowledgeRecompute $removalSets $graphDefinition
  catch "grab .knowledge"
  tkwait window .knowledge
}


# Procedure: KnowledgeAdd
proc KnowledgeAdd {} {
  # Add a new fact.

  # The global variables of mobal.
  global mobal
  # This array contains the temporary informations related
  # to the knowledge revision.
  global mobalKnowledge

  set newElement ""
  foreach tmpElement [MobalGetAllItems fact] {
    lappend newElement "[lindex $tmpElement 1] - [lindex $tmpElement 0]"
  }
  set result [ListChoose "Select the fact:" $newElement]
  if {"$result" != ""} {
    if {[string match {not(*).} [lindex $result 1]]} {
      set tmpBuffer [string range [lrange $result 2 end] 4 [expr [string length [lrange $result 2 end]]-2]]
      set tmpSide neg
    } {
      set tmpBuffer [lrange $result 2 end]
      set tmpSide pos
    }
    lappend mobal(knowledge) [list [lindex $result 0] $tmpSide 0 0]
#    lappend mobal(knowledgeList) "[set tmpSide]([lindex $result 0])"
    lappend mobal(knowledgeList) "[set tmpSide]([PrologAtom [lindex $result 0]])"
    [SN KnowledgeItems] insert end "$tmpBuffer ([set tmpSide])"
  }
}


# Procedure: KnowledgeCancel
proc KnowledgeCancel {} {

  DestroyWindow.knowledge
}


# Procedure: KnowledgeDoIt
proc KnowledgeDoIt {} {
  # Perform the action.

  # The global variables of mobal.
  global mobal

  set removalSet ""
  foreach element [[SN KnowledgeGraph].xfgraph.graph iconinfo ids] {
    if {![string compare [lindex [[SN KnowledgeGraph].xfgraph.graph iconconf $element -state] 4] selected]} {
      eval set tmpName [eval [SN KnowledgeGraph].xfgraph.graph iconinfo name $element]
      if {[string match "*: Input" $tmpName]} {
        lappend removalSet [lindex [split $tmpName :] 0]
      } {
        if {[string match {r*-*\[*\]} $tmpName]} {
          lappend removalSet $tmpName
        }
      }
    }
  }
  DestroyWindow.knowledge
  PrologSend mobal_remove_removal_set [eval PrologList $mobal(knowledgeList)] [eval PrologList $removalSet]
}


# Procedure: KnowledgeFlipSign
proc KnowledgeFlipSign {} {
  # Flip the sign of the fact.

  # The global variables of mobal.
  global mobal

  set currentId [[SN KnowledgeItems] curselect]
  if {"$currentId" != ""} {
    set currentItem [[SN KnowledgeItems] get $currentId]
    set currentFactId ""
    foreach tmpElement [MobalGetAllItems fact] {
      if {"[lrange $currentItem 0 [expr [llength $currentItem]-2]]" == "[lindex $tmpElement 0]"} {
        set currentFactId [lindex $tmpElement 1]
      }
    }
#    set tmpIndex [lsearch $mobal(knowledgeList) "[string trim [lindex $currentItem [expr [llength $currentItem]-1]] {()}]($currentFactId)"]
    set tmpIndex [lsearch $mobal(knowledgeList) "[string trim [lindex $currentItem [expr [llength $currentItem]-1]] {()}]([PrologAtom $currentFactId])"]
    if {$tmpIndex != -1} {
      if {"[lindex [lindex $mobal(knowledge) $tmpIndex] 1]" == "pos"} {
        set mobal(knowledge) [lreplace $mobal(knowledge) $tmpIndex $tmpIndex [list [lindex [lindex $mobal(knowledge) $tmpIndex] 0] neg [lindex [lindex $mobal(knowledge) $tmpIndex] 2] [lindex [lindex $mobal(knowledge) $tmpIndex] 3]]]
#        set mobal(knowledgeList) [lreplace $mobal(knowledgeList) $tmpIndex $tmpIndex "neg([lindex [lindex $mobal(knowledge) $tmpIndex] 0])"]
        set mobal(knowledgeList) [lreplace $mobal(knowledgeList) $tmpIndex $tmpIndex "neg([PrologAtom [lindex [lindex $mobal(knowledge) $tmpIndex] 0]])"]
      } {
        if {"[lindex [lindex $mobal(knowledge) $tmpIndex] 1]" == "neg"} {
          set mobal(knowledge) [lreplace $mobal(knowledge) $tmpIndex $tmpIndex [list [lindex [lindex $mobal(knowledge) $tmpIndex] 0] both [lindex [lindex $mobal(knowledge) $tmpIndex] 2] [lindex [lindex $mobal(knowledge) $tmpIndex] 3]]]
#          set mobal(knowledgeList) [lreplace $mobal(knowledgeList) $tmpIndex $tmpIndex "both([lindex [lindex $mobal(knowledge) $tmpIndex] 0])"]
          set mobal(knowledgeList) [lreplace $mobal(knowledgeList) $tmpIndex $tmpIndex "both([PrologAtom [lindex [lindex $mobal(knowledge) $tmpIndex] 0]])"]
	} {
          set mobal(knowledge) [lreplace $mobal(knowledge) $tmpIndex $tmpIndex [list [lindex [lindex $mobal(knowledge) $tmpIndex] 0] pos [lindex [lindex $mobal(knowledge) $tmpIndex] 2] [lindex [lindex $mobal(knowledge) $tmpIndex] 3]]]
#          set mobal(knowledgeList) [lreplace $mobal(knowledgeList) $tmpIndex $tmpIndex "pos([lindex [lindex $mobal(knowledge) $tmpIndex] 0])"]
          set mobal(knowledgeList) [lreplace $mobal(knowledgeList) $tmpIndex $tmpIndex "pos([PrologAtom [lindex [lindex $mobal(knowledge) $tmpIndex] 0]])"]
	}
      }
      [SN KnowledgeItems] delete $currentId
      [SN KnowledgeItems] insert $currentId "[lrange $currentItem 0 [expr [llength $currentItem]-2]] ([lindex [lindex $mobal(knowledge) $tmpIndex] 1])"
      [SN KnowledgeItems] select from $currentId
      [SN KnowledgeItems] select to $currentId
    }
  }
}


# Procedure: KnowledgeItemPopup
proc KnowledgeItemPopup {} {
  # This procedure updates the menu attached to the
  # item list. The menu will then contain

  # The global variables of mobal.
  global mobal

  [SN KnowledgeItems].m entryconfig 0 -label ""
  set currentId [[SN KnowledgeItems] curselect]
  if {"$currentId" != ""} {
    set currentItem [[SN KnowledgeItems] get $currentId]
    foreach tmpElement [MobalGetAllItems fact] {
      if {"[lrange $currentItem 0 [expr [llength $currentItem]-2]]" == "[lindex $tmpElement 0]"} {
        set currentFactId [lindex $tmpElement 1]
        [SN KnowledgeItems].m entryconfig 0 -label $currentItem
        [SN KnowledgeItems].m entryconfig 1 -label "Id: $currentFactId"
        break
      }
    }
    foreach element $mobal(knowledge) {
      if {"$currentFactId [lindex $currentItem [expr [llength $currentItem]-1]]" == "[lindex $element 0] ([lindex $element 1])"} {
        [SN KnowledgeItems].m entryconfig 2 -label "K:  [lindex $element 2]"
        [SN KnowledgeItems].m entryconfig 3 -label "c:  [lindex $element 3]"
      }
    }
  }
}


# Procedure: KnowledgeRecompute
proc KnowledgeRecompute { {removalSets ""} {edgeList ""}} {
  # Recompute the values.

  # The global variables of mobal.
  global mobal
  # This array contains the temporary informations related
  # to the knowledge revision.
  global mobalKnowledge

  if {"$removalSets" == ""} {
    set removalSets [PrologSend mobal_get_removal_sets [eval PrologList $mobal(knowledgeList)]]
    if {"$mobal(outFd)" == "stdout"} {
      set removalSets {{{{1} {neg} {2} {0.3}} {{3} {pos} {3} {0.4}}} 0 {
        {1 1.65 {{{{2}} 2.2 2.5} {{{r2} {{[a,1]} {[a,2]}} 0 2.65}}}}
        {2 2.65 {{{{3}} 2.3 5.5} {{{r1} {{1} {5}} 6.6 4.4}}}}
        {2 3.65 {{{{1}} 2.3 5.5} {{{r1} {{1} {5}} 6.6 4.4}}}}
      }}
    }
  }
  # Remove old array.
  if {[info exists mobalKnowledge]} {
    foreach name [array names mobalKnowledge] {
      catch "unset mobalKnowledge($name)"
    }
  }
  # Free the lists.
  catch "[SN KnowledgeItems] delete 0 end"
  catch "[SN KnowledgeSets] delete 0 end"
  catch "[SN KnowledgeChosen] delete 0 end"
  catch "[SN KnowledgeInfo] delete 0 end"

  # Create the temporary data.
  set mobal(knowledge) [lindex $removalSets 0]
  set mobal(knowledgeList) ""
  foreach element $mobal(knowledge) {
#    lappend mobal(knowledgeList) "[lindex $element 1]([lindex $element 0])"
    lappend mobal(knowledgeList) "[lindex $element 1]([PrologAtom [lindex $element 0]])"
  }
  if {"[lindex $removalSets 1]" == "0"} {
    [SN KnowledgeSetsLabel] config -text {Minimal Removal Sets}
  } {
    [SN KnowledgeSetsLabel] config -text {Minimal Removal Sets (b)}
  }
  foreach item $mobal(knowledge) {
    foreach tmpElement [MobalGetAllItems fact] {
      if {![string compare [lindex $item 0] [lindex $tmpElement 1]]} {
        [SN KnowledgeItems] insert end "[lindex $tmpElement 0] ([lindex $item 1])"
      }
    }
  }
  set tmpSets [lindex $removalSets 2]
  for {set counter 0} {$counter < [llength $tmpSets]} {incr counter} {
    set mobalKnowledge($counter) [lindex $tmpSets $counter]
    set tmpBuffer ""
    set tmpElement [lindex $mobalKnowledge($counter) 2]
    for {set counter2 0} {$counter2 < [llength $tmpElement]} {incr counter2} {
      if {$counter2 < [expr [llength $tmpElement]-1]} {
        append tmpBuffer "[lindex [lindex [lindex $tmpElement $counter2] 0] 0], "
      } {
        append tmpBuffer "[lindex [lindex [lindex $tmpElement $counter2] 0] 0]"
      }
    }
    [SN KnowledgeSets] insert end $tmpBuffer
  }

  # create the graph
  GraphCreateWindow derivation $mobal(knowledgeList) [SN KnowledgeGraph].xfgraph $edgeList
  [SN KnowledgeGraph].xfgraph.graph.xfcanvas.xfcanvas.xfcanvas conf -height 200

  # select the correct items
  [SN KnowledgeItems] select from 0
  [SN KnowledgeItems] select to 0
  KnowledgeSelectItem
  [SN KnowledgeSets] select from 0
  [SN KnowledgeSets] select to 0
  KnowledgeSelectSet
}


# Procedure: KnowledgeRemove
proc KnowledgeRemove {} {
  # Remove a fact from the removal set

  # The global variables of mobal.
  global mobal

  set currentId [[SN KnowledgeItems] curselect]
  if {"$currentId" != ""} {
    set currentItem [lrange [[SN KnowledgeItems] get $currentId] 0 [expr [llength [[SN KnowledgeItems] get $currentId]]-2]]
    set currentSide [lrange [[SN KnowledgeItems] get $currentId] [expr [llength [[SN KnowledgeItems] get $currentId]]-1] end]
    set currentFactId ""
    foreach tmpElement [MobalGetAllItems fact] {
      if {"$currentItem" == "[lindex $tmpElement 0]"} {
        set currentFactId [lindex $tmpElement 1]
      }
    }
#    set tmpIndex [lsearch $mobal(knowledgeList) "[string trim $currentSide {()}]($currentFactId)"]
    set tmpIndex [lsearch $mobal(knowledgeList) "[string trim $currentSide {()}]([PrologAtom $currentFactId])"]
    if {$tmpIndex != -1} {
      set mobal(knowledge) [lreplace $mobal(knowledge) $tmpIndex $tmpIndex]
      set mobal(knowledgeList) [lreplace $mobal(knowledgeList) $tmpIndex $tmpIndex]
    }
    [SN KnowledgeItems] delete $currentId
    [SN KnowledgeItems] select from $currentId
    [SN KnowledgeItems] select to $currentId
  }
}


# Procedure: KnowledgeSelectItem
proc KnowledgeSelectItem {} {
  # Select a new revision fact.
}


# Procedure: KnowledgeSelectSet
proc KnowledgeSelectSet {} {
  # Select a new set.

  # This array contains the temporary informations related
  # to the knowledge revision.
  global mobalKnowledge

  # deselect currently selected graph nodes
  foreach element [[SN KnowledgeGraph].xfgraph.graph iconinfo ids] {
    [SN KnowledgeGraph].xfgraph.graph iconconf $element -state normal
  }

  catch "[SN KnowledgeChosen] delete 0 end"
  catch "[SN KnowledgeInfo] delete 0 end"
  set currentId [[SN KnowledgeSets] curselect]
  if {"$currentId" != ""} {
    set currentItem [[SN KnowledgeSets] get $currentId]
    foreach item [lindex $mobalKnowledge($currentId) 2] {
      if {[llength [lindex $item 0]] == 1} {
        set tmpItem ""
        [SN KnowledgeChosen] insert end "[lindex [lindex $item 0] 0]"
        foreach tmpElement [MobalGetAllItems fact] {
          if {![string compare [lindex [lindex $item 0] 0] [lindex $tmpElement 1]]} {
            [SN KnowledgeInfo] insert end "[lindex $tmpElement 0]"
#            set tmpItem [lindex [split [string trimright [lindex $tmpElement 0] .] -] 0]
            set tmpItem [lindex $tmpElement 1]
          }
        }
        # select graph node
        foreach element [[SN KnowledgeGraph].xfgraph.graph iconinfo names] {
          if {[string match "$tmpItem: *" $element]} {
            [SN KnowledgeGraph].xfgraph.graph iconconf [[SN KnowledgeGraph].xfgraph.graph iconinfo id $element] -state selected
          }
        }
      } {
        set tmpItem ""
        set tmpResult "[lindex [lindex $item 0] 0] - \["
        for {set counter 0} {$counter < [llength [lindex [lindex $item 0] 1]]} {incr counter} {
          foreach tmpElement [MobalGetAllItems rule] {
            if {![string compare [lindex [lindex $item 0] 0] [lindex $tmpElement 1]]} {
              set tmpItem [lindex $tmpElement 1]
              break
            }
          }
          # select graph node
          set tmpBuffer [lindex [lindex [lindex $item 0] 1] $counter]
          regsub -all {\[} $tmpBuffer {\[} tmpBuffer
          regsub -all {\]} $tmpBuffer {\]} tmpBuffer
          append tmpItem "*-*" $tmpBuffer
          foreach element [[SN KnowledgeGraph].xfgraph.graph iconinfo names] {
            if {[string match $tmpItem $element]} {
              [SN KnowledgeGraph].xfgraph.graph iconconf [[SN KnowledgeGraph].xfgraph.graph iconinfo id $element] -state selected
            }
          }
          if {$counter == [expr [llength [lindex [lindex $item 0] 1]]-1]} {
            append tmpResult "[lindex [lindex [lindex $item 0] 1] $counter]\]"
          } {
            append tmpResult "[lindex [lindex [lindex $item 0] 1] $counter],"
          }
        }
        [SN KnowledgeChosen] insert end $tmpResult
      }
    }
    [SN KnowledgeN] config -text [llength [lindex $mobalKnowledge($currentId) 2]]
    [SN KnowledgeKappa1] config -text [lindex $mobalKnowledge($currentId) 0]
    [SN KnowledgeChi1] config -text [lindex $mobalKnowledge($currentId) 1]
  }

  [SN KnowledgeChosen] select from 0
  [SN KnowledgeChosen] select to 0
  KnowledgeSelectSetItem
}


# Procedure: KnowledgeSelectSetItem
proc KnowledgeSelectSetItem {} {
  # Select a new set.

  # This array contains the temporary informations related
  # to the knowledge revision.
  global mobalKnowledge

  catch "[SN KnowledgeInfo] delete 0 end"
  set currentItemId [[SN KnowledgeSets] curselect]
  set currentId [[SN KnowledgeChosen] curselect]
  if {"$currentId" != ""} {
    set currentItem [[SN KnowledgeChosen] get $currentId]
    if {[string match {* - \[*} $currentItem]} {
      set currentRule [string range $currentItem 0 [expr [string first {[} $currentItem]-4]]
      foreach item [lindex $mobalKnowledge($currentItemId) 2] {
        if {[llength [lindex $item 0]] > 1} {
          if {"$currentRule" == "[lindex [lindex $item 0] 0]"} {
            [SN KnowledgeKappa2] config -text [lindex $item 1]
            [SN KnowledgeChi2] config -text [lindex $item 2]
            break
          }
        }
      }
      foreach tmpElement [MobalGetAllItems rule] {
        if {[string match $currentRule [lindex $tmpElement 1]]} {
          [SN KnowledgeInfo] insert end [lindex $tmpElement 0]
        }
      }
    } {
      foreach item [lindex $mobalKnowledge($currentItemId) 2] {
        if {[llength [lindex $item 0]] == 1} {
          if {"$currentItem" == "[lindex [lindex $item 0] 0]"} {
            [SN KnowledgeKappa2] config -text [lindex $item 1]
            [SN KnowledgeChi2] config -text [lindex $item 2]
            break
          }
        }
      }
      foreach tmpElement [MobalGetAllItems fact] {
        if {![string compare $currentItem [lindex $tmpElement 1]]} {
          [SN KnowledgeInfo] insert end [lindex $tmpElement 0]
        }
      }
    }
  }
}


# Procedure: ListChoose
proc ListChoose { {prompt ""} {items ""} {default ""}} {
  # This procedure displays a toplevel where the user
  # can select from a listbox.
  # prompt - the label displayed at the top of the
  #          listbox.
  # items - a list of items. The items are inserted
  #         into the listbox.
  # default - the default item.

  # The global variables of mobal.
  global mobal

  PrologSetQuerying

  # Create the toplevel.
  toplevel .listChooser
  MiscPlaceWindowPrepare .listChooser list
  wm title .listChooser "TkMobal: List chooser"

  # Create the message, that describes the dialog.
  message .listChooser.message -aspect 1500 -text $prompt -relief raised -borderwidth 2

  # Create the frame where the listbox will be inserted.
  frame .listChooser.list -relief raised -borderwidth 2

  # Create the listbox.
  listbox .listChooser.list.list  -geometry 35x10 -xscrollcommand ".listChooser.list.hscroll set" -yscrollcommand ".listChooser.list.vscroll set"

  scrollbar .listChooser.list.hscroll  -command ".listChooser.list.list xview"  -orient horizontal

  scrollbar .listChooser.list.vscroll  -command ".listChooser.list.list yview"

  # Create the frame where the buttons are inserted.
  frame .listChooser.buttons -relief raised -borderwidth 2

  # Create the "Done" button. Pressing this button means
  # that the selected item is returned.
  button .listChooser.buttons.done -text {Done} -width 7 -command {
    set curSelect [.listChooser.list.list curselect]
    if {"$curSelect" != "" && "$curSelect" != "-1"} {
      set mobal(tmpResult) [.listChooser.list.list get $curSelect]
    }
    PrologSetReady 1
    destroy .listChooser}

  # Create the "Cancel" button. Pressing this button means
  # that the selected item is returned.
  button .listChooser.buttons.cancel -text {Cancel} -width 7 -command {
    set mobal(tmpResult) ""
    PrologSetReady 1
    destroy .listChooser}

  # We only want to select one item at once.
  tk_listboxSingleSelect .listChooser.list.list
  bind .listChooser.list.list <Double-Button-1> {
    set curSelect [.listChooser.list.list curselect]
    if {"$curSelect" != "" && "$curSelect" != "-1"} {
      set mobal(tmpResult) [.listChooser.list.list get $curSelect]
    }
    PrologSetReady 1
    destroy .listChooser
  }

  # Display the widget structure.
  pack append .listChooser.buttons .listChooser.buttons.done {left expand padx 6 pady 6} .listChooser.buttons.cancel {left expand padx 6 pady 6}
  pack append .listChooser.list .listChooser.list.hscroll {bottom fill} .listChooser.list.vscroll {right fill} .listChooser.list.list {top fill expand}
  pack append .listChooser .listChooser.message {top fill} .listChooser.buttons {bottom fill} .listChooser.list {top fill expand}

  # Update the X resources for the dialog.
  XFLocalSetAppDefs .listChooser

  set counter 0
  set selectValue 0
  # Insert all the passed items into the listbox.
  foreach element $items {
    .listChooser.list.list insert end $element
    if {"$default" == "$element"} {
      set selectValue $counter
    }
    incr counter
  }

  # Select the first list item by default.
  .listChooser.list.list select from $selectValue
  .listChooser.list.list select to $selectValue
  catch ".listChooser.list.list yview [expr $selectValue-1]"

  MiscPlaceWindow .listChooser list

  # Initialize the result variable.
  set mobal(tmpResult) ""
  # only input in the chooser
  grab .listChooser
  # Now wait for the destruction of the toplevel.
  tkwait window .listChooser
  # The toplevel was destroyed, now return the
  # value of the pressed value.
  return $mobal(tmpResult)
}


# Procedure: MenuPopupAdd
if {"[info procs MenuPopupAdd]" == ""} {
proc MenuPopupAdd { xfW xfButton xfMenu {xfModifier ""} {xfCanvasTag ""}} {
# xf ignore me 7
# the popup menu handling is from (I already gave up with popup handling :-):
#
# Copyright 1991,1992 by James Noble.
# Everyone is granted permission to copy, modify and redistribute.
# This notice must be preserved on all copies or derivates.
#
##########
# Procedure: MenuPopupAdd
# Description: attach a popup menu to widget
# Arguments: xfW - the widget
#            xfButton - the button we use
#            xfMenu - the menu to attach
#            {xfModifier} - a optional modifier
#            {xfCanvasTag} - a canvas tagOrId
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  set tk_popupPriv($xfMenu,focus) ""
  set tk_popupPriv($xfMenu,grab) ""
  if {"$xfModifier" != ""} {
    set press "$xfModifier-"
    set motion "$xfModifier-"
    set release "Any-"
  } {
    set press ""
    set motion ""
    set release ""
  }

  bind $xfMenu "<${motion}B${xfButton}-Motion>"  "MenuPopupMotion $xfMenu %W %X %Y"
  bind $xfMenu "<${release}ButtonRelease-${xfButton}>"  "MenuPopupRelease $xfMenu %W"
  if {"$xfCanvasTag" == ""} {
    bind $xfW "<${press}ButtonPress-${xfButton}>"  "MenuPopupPost $xfMenu %X %Y"
    bind $xfW "<${release}ButtonRelease-${xfButton}>"  "MenuPopupRelease $xfMenu %W"
  } {
    $xfW bind $xfCanvasTag "<${press}ButtonPress-${xfButton}>"  "MenuPopupPost $xfMenu %X %Y"
    $xfW bind $xfCanvasTag "<${release}ButtonRelease-${xfButton}>"  "MenuPopupRelease $xfMenu %W"
  }
}
}


# Procedure: MenuPopupMotion
if {"[info procs MenuPopupMotion]" == ""} {
proc MenuPopupMotion { xfMenu xfW xfX xfY} {
# xf ignore me 7
##########
# Procedure: MenuPopupMotion
# Description: handle the popup menu motion
# Arguments: xfMenu - the topmost menu
#            xfW - the menu
#            xfX - the root x coordinate
#            xfY - the root x coordinate
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  if {"[info commands $xfW]" != "" && [winfo ismapped $xfW] &&
      "[winfo class $xfW]" == "Menu" &&
      [info exists tk_popupPriv($xfMenu,focus)] &&
      "$tk_popupPriv($xfMenu,focus)" != "" &&
      [info exists tk_popupPriv($xfMenu,grab)] &&
      "$tk_popupPriv($xfMenu,grab)" != ""} {
    set xfPopMinX [winfo rootx $xfW]
    set xfPopMaxX [expr $xfPopMinX+[winfo width $xfW]]
    if {$xfX >= $xfPopMinX && $xfX <= $xfPopMaxX} {
      $xfW activate @[expr $xfY-[winfo rooty $xfW]]
      if {![catch "$xfW entryconfig @[expr $xfY-[winfo rooty $xfW]] -menu" result]} {
        if {"[lindex $result 4]" != ""} {
          foreach binding [bind $xfMenu] {
            bind [lindex $result 4] $binding [bind $xfMenu $binding]
          }
        }
      }
    } {
      $xfW activate none
    }
  }
}
}


# Procedure: MenuPopupPost
if {"[info procs MenuPopupPost]" == ""} {
proc MenuPopupPost { xfMenu xfX xfY} {
# xf ignore me 7
##########
# Procedure: MenuPopupPost
# Description: post the popup menu
# Arguments: xfMenu - the menu
#            xfX - the root x coordinate
#            xfY - the root x coordinate
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  if {"[info commands $xfMenu]" != ""} {
    if {![info exists tk_popupPriv($xfMenu,focus)]} {
      set tk_popupPriv($xfMenu,focus) [focus]
    } {
      if {"$tk_popupPriv($xfMenu,focus)" == ""} {
        set tk_popupPriv($xfMenu,focus) [focus]
      }
    }
    set tk_popupPriv($xfMenu,grab) $xfMenu

    catch "$xfMenu activate none"
    catch "$xfMenu post $xfX $xfY"
    catch "focus $xfMenu"
    catch "grab -global $xfMenu"
  }
}
}


# Procedure: MenuPopupRelease
if {"[info procs MenuPopupRelease]" == ""} {
proc MenuPopupRelease { xfMenu xfW} {
# xf ignore me 7
##########
# Procedure: MenuPopupRelease
# Description: remove the popup menu
# Arguments: xfMenu - the topmost menu widget
#            xfW - the menu widget
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv
  global tkVersion

  if {"[info commands $xfW]" != "" && [winfo ismapped $xfW] &&
      "[winfo class $xfW]" == "Menu" &&
      [info exists tk_popupPriv($xfMenu,focus)] &&
      "$tk_popupPriv($xfMenu,focus)" != "" &&
      [info exists tk_popupPriv($xfMenu,grab)] &&
      "$tk_popupPriv($xfMenu,grab)" != ""} {
    if {$tkVersion >= 3.0} {
      catch "grab release $tk_popupPriv($xfMenu,grab)"
    } {
      catch "grab none"
    }
    catch "focus $tk_popupPriv($xfMenu,focus)"
    set tk_popupPriv($xfMenu,focus) ""
    set tk_popupPriv($xfMenu,grab) ""
    if {"[$xfW index active]" != "none"} {
      $xfW invoke active; catch "$xfMenu unpost"
    }
  }
  catch "$xfMenu unpost"
}
}


# Procedure: MetaPred
proc MetaPred { metaPredicate {restrictions ""}} {
  # Display the meta predicate revision dialog.
  # metaPredicate - the meta predicate to revise
  # restrictions - the current restrictions

  # The global variables of mobal.
  global mobal
  # This array contains the temporary informations related
  # to the meta predicate revision.
  global mobalRestrictions

  ShowWindow.metaPred
  set mobal(metaPred) $metaPredicate
  if {"$restrictions" == ""} {
    set restrictions [PrologSend mobal_get_predvar_restrictions [PrologAtom $metaPredicate]]
  }
  # Remove old array.
  if {[info exists mobalRestrictions]} {
    foreach name [array names mobalRestrictions] {
      catch "unset mobalRestrictions($name)"
    }
  }
  # Free the lists.
  catch "[SN MetaPredItems] delete 0 end"
  catch "[SN MetaPredRestrictions] delete 0 end"
  catch "[SN MetaPredPredicates] delete 0 end"

  # Load the known predicates.
  foreach tmpElement [MobalGetAllItems pred] {
    # Get the current item.
    [SN MetaPredPredicates] insert end [lindex $tmpElement 0]
  }
  # Build new temporary data array.
  foreach item $restrictions {
    set mobalRestrictions([lindex $item 0]) [lindex $item 1]
    [SN MetaPredItems] insert end [lindex $item 0]
  }
  [SN MetaPredItems] select from 0
  [SN MetaPredItems] select to 0
  MetaPredSelectItem
  grab .metaPred
  tkwait window .metaPred
}


# Procedure: MetaPredAdd
proc MetaPredAdd {} {
  # Add a predicate to the restrictions

  # This array contains the temporary informations related
  # to the meta predicate revision.
  global mobalRestrictions

  set currentItem [[SN MetaPredItems] get [[SN MetaPredItems] curselect]]
  foreach selectItem [[SN MetaPredPredicates] curselect] {
    set tmpValue [[SN MetaPredPredicates] get $selectItem]
    foreach tmpElement [MobalGetAllItems pred] {
      if {![string compare $tmpValue [lindex $tmpElement 0]]} {
        if {[lsearch $mobalRestrictions($currentItem) [lindex $tmpElement 1]] == -1} {
          lappend mobalRestrictions($currentItem) [lindex $tmpElement 1]
        }
      }
    }
  }
  catch "[SN MetaPredRestrictions] delete 0 end"
  foreach element $mobalRestrictions($currentItem) {
    foreach tmpElement [MobalGetAllItems pred] {
      if {![string compare $element [lindex $tmpElement 1]]} {
        [SN MetaPredRestrictions] insert end [lindex $tmpElement 0]
      }
    }
  }
}


# Procedure: MetaPredCancel
proc MetaPredCancel {} {
  # Abort the changing.

  DestroyWindow.metaPred
}


# Procedure: MetaPredDoIt
proc MetaPredDoIt {} {
  # Apply the changes and quit.

  # The global variables of mobal.
  global mobal
  # This array contains the temporary informations related
  # to the meta predicate revision.
  global mobalRestrictions

  set tmpVarList ""
  foreach name [array names mobalRestrictions] {
    set tmpPredList ""
    foreach element [set mobalRestrictions($name)] {
      foreach tmpElement [MobalGetAllItems pred] {
        if {![string compare $element [lindex $tmpElement 1]]} {
          lappend tmpPredList [lindex $tmpElement 1]
        }
      }
    }
    lappend tmpVarList [PrologList $name [eval PrologList $tmpPredList]]
  }
  PrologSend mobal_set_predvar_restrictions $mobal(metaPred) [eval PrologList $tmpVarList]
  DestroyWindow.metaPred
}


# Procedure: MetaPredRemove
proc MetaPredRemove {} {
  # Remove a predicate from the restrictions

  # This array contains the temporary informations related
  # to the meta predicate revision.
  global mobalRestrictions

  set currentItem [[SN MetaPredItems] get [[SN MetaPredItems] curselect]]
  foreach selectItem [[SN MetaPredRestrictions] curselect] {
    set tmpValue [[SN MetaPredRestrictions] get $selectItem]
    foreach tmpElement [MobalGetAllItems pred] {
      if {![string compare $tmpValue [lindex $tmpElement 0]]} {
        set tmpIndex [lsearch $mobalRestrictions($currentItem) [lindex $tmpElement 1]]
        if {$tmpIndex != -1} {
          set mobalRestrictions($currentItem) [lreplace $mobalRestrictions($currentItem) $tmpIndex $tmpIndex]
        }
      }
    }
  }
  catch "[SN MetaPredRestrictions] delete 0 end"
  foreach element $mobalRestrictions($currentItem) {
    foreach tmpElement [MobalGetAllItems pred] {
      if {![string compare $element [lindex $tmpElement 1]]} {
        [SN MetaPredRestrictions] insert end [lindex $tmpElement 0]
      }
    }
  }
}


# Procedure: MetaPredSelectItem
proc MetaPredSelectItem {} {
  # Select a new predicate.

  # This array contains the temporary informations related
  # to the meta predicate revision.
  global mobalRestrictions

  catch "[SN MetaPredRestrictions] delete 0 end"
  set currentItem [[SN MetaPredItems] get [[SN MetaPredItems] curselect]]
  foreach element $mobalRestrictions($currentItem) {
    foreach tmpElement [MobalGetAllItems pred] {
      if {![string compare $element [lindex $tmpElement 1]]} {
        [SN MetaPredRestrictions] insert end [lindex $tmpElement 0]
      }
    }
  }
}


# Procedure: MiscBell
proc MiscBell {} {
  catch "xaccess xbell"
}


# Procedure: MiscCompare
proc MiscCompare { string1 string2} {
  return [string compare [string trim $string1 {"'}] [string trim $string2 {"'}]]
}


# Procedure: MiscDirnamePrepare
proc MiscDirnamePrepare { dirName} {
  # Prepare a directory name for prolog. This
  # mainly means removing multiple //.

  regsub -all "//" $dirName "/" result
  return [string trimright $result "/@*"]
}


# Procedure: MiscDomainNameUpdate
proc MiscDomainNameUpdate {} {
  # This procedure updates the menu attached to the main
  # window menubutton showing the current domain name
  # in short form.

  # The global variables of mobal.
  global mobal

  .frame0.frame2.frame5.frame18.mobalDomain.m entryconfig 0 -label $mobal(domain)
}


# Procedure: MiscFileExecutable
proc MiscFileExecutable { fileName} {
##########
# Procedure: MiscFileExecutable
# Description: check if filename is executable
# Arguments: fileName - the filename to check
# Returns: 1 if file is executable, otherwise 0
# Sideeffects: none
##########

  # File selector box parameters.
  global fsBox
  # The global variables of mobal.
  global mobal

  set fileName [MiscDirnamePrepare $fileName]
  if {$mobal(localFS)} {
    if {[MiscFileIsAFile $fileName]} {
      if {$fsBox(all) == 1} {
        set result [file executable $fileName]
      } {
        if {$fsBox(all) == 2} {
          set result [expr [file executable $fileName.qof] || [file executable $fileName.pl]]
        } {
          set result [file executable $fileName.ie]
        }
      }
    } {
      set result [file executable $fileName]
    }
  } {
    if {[MiscFileIsAFile $fileName]} {
      PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
      if {$fsBox(all) == 1} {
        set result [PrologSend file_executable [PrologAtom $fileName]]
      } {
        if {$fsBox(all) == 2} {
          set result [PrologSend tool_executable [PrologAtom $fileName]]
        } {
          set result [PrologSend domain_executable [PrologAtom $fileName]]
        }
      }
    } {
      PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
      set result [PrologSend directory_searchable [PrologAtom $fileName]]
    }
  }
  if {"$result" == "1" || "[string tolower $result]" == "yes"} {
    return 1
  } {
    return 0
  }
}


# Procedure: MiscFileExists
proc MiscFileExists { fileName} {
##########
# Procedure: MiscFileExists
# Description: check if filename exists
# Arguments: fileName - the filename to check
# Returns: 1 if file exists, otherwise 0
# Sideeffects: none
##########

  # File selector box parameters.
  global fsBox
  # The global variables of mobal.
  global mobal

  set fileName [MiscDirnamePrepare $fileName]
  if {$mobal(localFS)} {
    if {[MiscFileIsAFile $fileName]} {
      if {$fsBox(all) == 1} {
        set result [file exists $fileName]
      } {
        if {$fsBox(all) == 2} {
          set result [expr [file exists $fileName.qof] || [file exists $fileName.pl]]
        } {
          set result [file exists $fileName.ie]
        }
      }
    } {
      set result [file exists $fileName]
    }
  } {
    if {[MiscFileIsAFile $fileName]} {
      PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
      if {$fsBox(all) == 1} {
        set result [PrologSend file_exists [PrologAtom $fileName]]
      } {
        if {$fsBox(all) == 2} {
          set result [PrologSend tool_exists [PrologAtom $fileName]]
        } {
          set result [PrologSend domain_exists [PrologAtom $fileName]]
        }
      }
    } {
      PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
      set result [PrologSend directory_searchable [PrologAtom $fileName]]
    }
  }
  if {"$result" == "1" || "[string tolower $result]" == "yes"} {
    return 1
  } {
    return 0
  }
}


# Procedure: MiscFileIsADir
proc MiscFileIsADir { pathName} {
##########
# Procedure: MiscFileIsADir
# Description: check if name is a directory (including symbolic links)
# Arguments: pathName - the path to check
# Returns: 1 if its a directory, otherwise 0
# Sideeffects: none
##########

  # File selector box parameters.
  global fsBox
  # The global variables of mobal.
  global mobal

  set pathName [MiscDirnamePrepare $pathName]
  if {$mobal(localFS)} {
    if {$fsBox(all) == 1} {
      set result [file isdirectory $pathName]
    } {
      if {$fsBox(all) == 2} {
        if {[file exists $pathName.qof]} {
          set result [file isdirectory $pathName.qof]
        } {
          if {[file exists $pathName.pl]} {
            set result [file isdirectory $pathName.pl]
          } {
            set result [file isdirectory $pathName]
          }
        }
      } {
        if {[file exists $pathName.ie]} {
          set result [file isdirectory $pathName.ie]
        } {
          set result [file isdirectory $pathName]
        }
      }
    }
    if {"$result" == "1" || "[string tolower $result]" == "yes"} {
      return 1
    } {
      return 0
    }
  } {
    PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
    if {$fsBox(all) == 1} {
      set result [PrologSend file_isfile [PrologAtom $pathName]]
    } {
      if {$fsBox(all) == 2} {
        set result [PrologSend tool_isfile [PrologAtom $pathName]]
      } {
        set result [PrologSend domain_isfile [PrologAtom $pathName]]
      }
    }
    if {"$result" == "1" || "[string tolower $result]" == "yes"} {
      return 0
    } {
      PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
      set result [PrologSend directory_searchable [PrologAtom $pathName]]
      if {"$result" == "1" || "[string tolower $result]" == "yes"} {
        return 1
      } {
        return 0
      }
    }
  }
  return 0
}


# Procedure: MiscFileIsAFile
proc MiscFileIsAFile { fileName} {
##########
# Procedure: MiscFileIsAFile
# Description: check if filename is a file (including symbolic links)
# Arguments: fileName - the filename to check
# Returns: 1 if its a file, otherwise 0
# Sideeffects: none
##########

  # File selector box parameters.
  global fsBox
  # The global variables of mobal.
  global mobal

  set fileName [MiscDirnamePrepare $fileName]
  if {$mobal(localFS)} {
    if {$fsBox(all) == 1} {
      set result [file isfile $fileName]
    } {
      if {$fsBox(all) == 2} {
        if {[file exists $fileName.qof]} {
          set result [file isfile $fileName.qof]
        } {
          if {[file exists $fileName.pl]} {
            set result [file isfile $fileName.pl]
          } {
            set result [file isfile $fileName]
          }
        }
      } {
        if {[file exists $fileName.ie]} {
          set result [file isfile $fileName.ie]
        } {
          set result [file isfile $fileName]
        }
      }
    }
  } {
    PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
    if {$fsBox(all) == 1} {
      set result [PrologSend file_isfile [PrologAtom $fileName]]
    } {
      if {$fsBox(all) == 2} {
        set result [PrologSend tool_isfile [PrologAtom $fileName]]
      } {
        set result [PrologSend domain_isfile [PrologAtom $fileName]]
      }
    }
  }
  if {"$result" == "1" || "[string tolower $result]" == "yes"} {
    return 1
  } {
    return 0
  }
}


# Procedure: MiscFileIsASymlink
proc MiscFileIsASymlink { fileName} {
##########
# Procedure: MiscFileIsASymlink
# Description: check if filename is a symbolic link
# Arguments: fileName - the path/filename to check
# Returns: none
# Sideeffects: none
##########

  # File selector box parameters.
  global fsBox
  # The global variables of mobal.
  global mobal

  set fileName [MiscDirnamePrepare $fileName]
  if {$mobal(localFS)} {
    if {"[string index [expr [string length $fileName]-1]]" == "@"} {
      return 1
    } {
      return 0
    }
    if {"$result" == "1" || "[string tolower $result]" == "yes"} {
      return 1
    } {
      return 0
    }
  } {
    if {"[string index [expr [string length $fileName]-1]]" == "@"} {
      return 1
    } {
      return 0
    }
    if {"$result" == "1" || "[string tolower $result]" == "yes"} {
      return 1
    } {
      return 0
    }
  }
  return 0
}


# Procedure: MiscFileList
proc MiscFileList { pathName type} {
##########
# Procedure: MiscFileList
# Description: read a directory
# Arguments: pathName - the directory to read
#            type - the files to read
# Returns: the list of filenames
# Sideeffects: none
##########

  set tmpDirResult ""
  set tmpFileResult ""
  case $type in {
    {domain} {
      catch "exec ls -1F $pathName" tmpResult
      foreach element $tmpResult {
        if {[string match "*/" $element]} {
          lappend tmpDirResult $element
        } {
          if {[string match "*@" $element]} {
            if {[MiscFileIsADir $pathName/[string trimright $element @]]} {
              lappend tmpDirResult $element
            } {
              if {[string match "*.ie@" $element]} {
                lappend tmpFileResult [file rootname $element]@
              }
            }
          } {
            if {[string match "*.ie" $element]} {
              lappend tmpFileResult [file rootname $element]
            }
          }
        }
      }
    }
    {tool} {
      catch "exec ls -1F $pathName" tmpResult
      foreach element $tmpResult {
        if {[string match "*/" $element]} {
          lappend tmpDirResult $element
        } {
          if {[string match "*@" $element]} {
            if {[MiscFileIsADir $pathName/[string trimright $element @]]} {
              lappend tmpDirResult $element
            } {
              if {([string match "*.qof@" $element] ||
                  [string match "*.pl@" $element]) &&
                  [lsearch $tmpFileResult [file rootname $element]] == -1} {
                lappend tmpFileResult [file rootname $element]@
              }
            }
          } {
            if {([string match "*.qof" $element] ||
                [string match "*.pl" $element]) &&
                [lsearch $tmpFileResult [file rootname $element]] == -1} {
              lappend tmpFileResult [file rootname $element]
            }
          }
        }
      }
    }
    {default} {
      catch "exec ls -a1F $pathName" tmpResult
      foreach element $tmpResult {
        if {[string match "*/" $element]} {
          lappend tmpDirResult $element
        } {
          if {[string match "*@" $element]} {
            if {[MiscFileIsADir $pathName/[string trimright $element @]]} {
              lappend tmpDirResult $element
            } {
              lappend tmpFileResult $element
            }
          } {
            lappend tmpFileResult $element
          }
        }
      }
    }
  }
  set tmpDirResult [lsort $tmpDirResult]
  set tmpFileResult [lsort $tmpFileResult]
  if {[llength $tmpFileResult] > 0} {
    eval lappend tmpDirResult $tmpFileResult
  }
  return $tmpDirResult
}


# Procedure: MiscFileReadable
proc MiscFileReadable { fileName} {
##########
# Procedure: MiscFileReadable
# Description: check if filename is readable
# Arguments: fileName - the filename to check
# Returns: 1 if file is readable, otherwise 0
# Sideeffects: none
##########

  # File selector box parameters.
  global fsBox
  # The global variables of mobal.
  global mobal

  set fileName [MiscDirnamePrepare $fileName]
  if {$mobal(localFS)} {
    if {[MiscFileIsAFile $fileName]} {
      if {$fsBox(all) == 1} {
        set result [file readable $fileName]
      } {
        if {$fsBox(all) == 2} {
          set result [expr [file readable $fileName.qof] || [file readable $fileName.pl]]
        } {
          set result [file readable $fileName.ie]
        }
      }
    } {
      set result [file readable $fileName]
    }
  } {
    if {[MiscFileIsAFile $fileName]} {
      PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
      if {$fsBox(all) == 1} {
        set result [PrologSend file_readable [PrologAtom [file dirname $fileName]] [PrologAtom [file tail $fileName]]]
      } {
        if {$fsBox(all) == 2} {
          set result [PrologSend tool_readable [PrologAtom [file dirname $fileName]] [PrologAtom [file tail $fileName]]]
        } {
          set result [PrologSend domain_readable [PrologAtom [file dirname $fileName]] [PrologAtom [file tail $fileName]]]
        }
      }
    } {
      PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
      set result [PrologSend directory_searchable [PrologAtom $fileName]]
    }
  }
  if {"$result" == "1" || "[string tolower $result]" == "yes"} {
    return 1
  } {
    return 0
  }
}


# Procedure: MiscGetCurrentSelection
proc MiscGetCurrentSelection { offset bytes} {
  # This procedure is called when an external program
  # requests the seelction.
  # offset - the offset from the current selection
  # bytes - the number of bytes to return

  # The global variables of mobal.
  global mobal

  # Return the selected range.
  return [string range $mobal(listSelection) $offset [expr $offset+$bytes]]
}


# Procedure: MiscGetDebugging
proc MiscGetDebugging {} {
  # Retrive the current debugging status.

  # The global variables of mobal.
  global mobal

  return $mobal(debuggingPrint)
}


# Procedure: MiscMakeWindowName
proc MiscMakeWindowName { mainPathName type {name ""} {counter "-1"}} {
  # Create correct TkMobal toplevel window names.
  # mainPathName - the beginning of the pathname
  # type - the type of the window
  # name - a optional name/title to use
  # counter - force the counter of the window to this value

  # A list off all counters attached to the views.
  # These counters make the views unique.
  global mobalWindowCounters
  # A list off all focus specifications attached
  # to the views.
  global mobalWindowFocus
  # A list off all window names attached to the views.
  global mobalWindowNames
  # A list off all titles attached to the views.
  global mobalWindowTitles

  # The counter is used to make the view unique.
  if {"$counter" != "-1"} {
    set tmpCounter $counter
    set titleString "Settings"
    # The pathname of the created widget.
    set pathName ${mainPathName}${type}settings-$name-$tmpCounter
    # The pathname of the created widget.
    set viewPathName $mainPathName$type-$name-$tmpCounter
    # Register the new view.
    set mobalWindowNames($pathName) "settings,$name,$tmpCounter"
    # Calculate the window counter.
    set mobalWindowCounters(settings) $tmpCounter
  } {
    if {"$mobalWindowCounters($type)" == ""} {
      set tmpCounter 1
      set mobalWindowCounters($type) 1
    } {
      set tmpCounter 1
      while {1} {
        if {[lsearch $mobalWindowCounters($type) $tmpCounter] == -1 &&
            "[info commands $mainPathName$type-$name-$tmpCounter]" == ""} {
          lappend mobalWindowCounters($type) $tmpCounter
          break
        }
        incr tmpCounter
      }
    }
    set titleString ""
    # The pathname of the created widget.
    set pathName $mainPathName$type-$name-$tmpCounter
    # The pathname of the created widget.
    set viewPathName $mainPathName$type-$name-$tmpCounter
    # Register the new view.
    set mobalWindowNames($pathName) "$type,$name,$tmpCounter"
  }
  # The title of the view.
  if {"$name" != ""} {
    if {[info exists mobalWindowFocus($viewPathName)]} {
      if {"$mobalWindowFocus($viewPathName)" != ""} {
        set tmpTitle "$mobalWindowTitles($type):$name-$tmpCounter $titleString ($mobalWindowFocus($viewPathName)"
      } {
        set tmpTitle "$mobalWindowTitles($type):$name-$tmpCounter $titleString"
      }
    } {
      set tmpTitle "$mobalWindowTitles($type):$name-$tmpCounter $titleString"
    }
  } {
    if {[info exists mobalWindowFocus($viewPathName)]} {
      if {"$mobalWindowFocus($viewPathName)" != ""} {
        set tmpTitle "$mobalWindowTitles($type)-$tmpCounter $titleString ($mobalWindowFocus($viewPathName)"
      } {
        set tmpTitle "$mobalWindowTitles($type)-$tmpCounter $titleString"
      }
    } {
      set tmpTitle "$mobalWindowTitles($type)-$tmpCounter $titleString"
    }
  }

  if {"$counter" != "-1"} {
    return [list $pathName $viewPathName $tmpCounter $tmpTitle]
  } {
    return [list $pathName $tmpTitle $tmpCounter]
  }
}


# Procedure: MiscPlaceWindow
proc MiscPlaceWindow { pathName {type ""}} {
  # Place a new window, and prepare everything
  # for tracking of the windows position.
  # pathName - the pathname of the window
  # type - the window type

  # This array contains the last position of the windows
  # for all window types.
  global mobalWindowPositions

  # Is there an old position ?
  if {[info exists mobalWindowPositions($type)]} {
    if {"$mobalWindowPositions($type)" != "" &&
        ![string match ".alert*" $pathName] &&
        ![string match ".fsBox*" $pathName] &&
        ![string match ".yesNo*" $pathName]} {
      eval wm geometry $pathName $mobalWindowPositions($type)
    } {
      # Make the window exist.
      update idletask
      wm geometry $pathName +[expr ([winfo screenwidth $pathName]/2)-([winfo width $pathName]/2)]+[expr ([winfo screenheight $pathName]/2)-([winfo height $pathName]/2)]
    }
  } {
    # Make the window exist.
    update idletask
    wm geometry $pathName +[expr ([winfo screenwidth $pathName]/2)-([winfo width $pathName]/2)]+[expr ([winfo screenheight $pathName]/2)-([winfo height $pathName]/2)]
  }

  # Keep track of the window position.
  bind $pathName <Configure> "
    if {\[info exists mobalWindowPositions($type)\]} {
      scan \[wm geometry $pathName\] %%dx%%d%%d%%d xfA xfB xfC xfD
      if {\[info exists xfC\] && \[info exists xfD\]} {
        set mobalWindowPositions($type) +\$xfC+\$xfD
      }
    }
  "
  # Actually display the window.
  wm deiconify $pathName
  update idletask
}


# Procedure: MiscPlaceWindowPrepare
proc MiscPlaceWindowPrepare { pathName {type ""}} {
  # Prepare everything for a automated placing of
  # the toplevel window. Hide it, and give a maximal
  # size.
  # pathName - the pathname of the window to place
  # type - the type of the window

# Setting maxsize causes strange behaviour under olwm
#  wm maxsize $pathName [expr [winfo screenwidth $pathName]-50] [expr [winfo screenheight $pathName]-50]
  wm minsize $pathName 10 10
  wm positionfrom $pathName user
  wm sizefrom $pathName user

  if {[info exists mobalWindowPositions($type)]} {
    if {"$mobalWindowPositions($type)" == ""} {
      wm withdraw $pathName
      update idletask
    }
  } {
    wm withdraw $pathName
    update idletask
  }
}


# Procedure: MiscPrologDeletable
proc MiscPrologDeletable { fileName} {
##########
# Procedure: MiscPrologDeletable
# Description: check if filename is deletable
# Arguments: fileName - the filename to check
# Returns: 1 if file is deletable, otherwise 0
# Sideeffects: none
##########

  # File selector box parameters.
  global fsBox
  # The global variables of mobal.
  global mobal

  set fileName [MiscDirnamePrepare $fileName]
  if {$mobal(localFS)} {
    if {$fsBox(all) == 1} {
      set result [file writable $fileName]
    } {
      if {$fsBox(all) == 2} {
        set result [expr [file writable $fileName.qof] || [file writable $fileName.pl]]
      } {
        set result [file writable $fileName.ie]
      }
    }
  } {
    PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
    if {$fsBox(all) == 1} {
      set result [PrologSend file_deletable [PrologAtom [file dirname $fileName]] [PrologAtom [file tail $fileName]]]
    } {
      if {$fsBox(all) == 2} {
        set result [PrologSend tool_deletable [PrologAtom [file dirname $fileName]] [PrologAtom [file tail $fileName]]]
      } {
        set result [PrologSend domain_deletable [PrologAtom [file dirname $fileName]] [PrologAtom [file tail $fileName]]]
      }
    }
  }
  if {"$result" == "1" || "[string tolower $result]" == "yes"} {
    return 1
  } {
    return 0
  }
}


# Procedure: MiscPrologReadable
proc MiscPrologReadable { fileName} {
##########
# Procedure: MiscPrologReadable
# Description: check if filename is readable
# Arguments: fileName - the filename to check
# Returns: 1 if file is readable, otherwise 0
# Sideeffects: none
##########

  # File selector box parameters.
  global fsBox
  # The global variables of mobal.
  global mobal

  set fileName [MiscDirnamePrepare $fileName]
  if {$mobal(localFS)} {
    if {$fsBox(all) == 1} {
      set result [file readable $fileName]
    } {
      if {$fsBox(all) == 2} {
        set result [expr [file readable $fileName.qof] || [file readable $fileName.pl]]
      } {
        set result [file readable $fileName.ie]
      }
    }
  } {
    PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
    if {$fsBox(all) == 1} {
      set result [PrologSend file_readable [PrologAtom [file dirname $fileName]] [PrologAtom [file tail $fileName]]]
    } {
      if {$fsBox(all) == 2} {
        set result [PrologSend tool_readable [PrologAtom [file dirname $fileName]] [PrologAtom [file tail $fileName]]]
      } {
        set result [PrologSend domain_readable [PrologAtom [file dirname $fileName]] [PrologAtom [file tail $fileName]]]
      }
    }
  }
  if {"$result" == "1" || "[string tolower $result]" == "yes"} {
    return 1
  } {
    return 0
  }
}


# Procedure: MiscPrologSearchable
proc MiscPrologSearchable { fileName} {
##########
# Procedure: MiscPrologSearchable
# Description: check if filename is searchable
# Arguments: fileName - the filename to check
# Returns: 1 if file is readable, otherwise 0
# Sideeffects: none
##########

  # File selector box parameters.
  global fsBox
  # The global variables of mobal.
  global mobal

  set fileName [MiscDirnamePrepare $fileName]
  if {$mobal(localFS)} {
    set result [file readable $fileName]
  } {
    PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
    set result [PrologSend directory_searchable [PrologAtom $fileName]]
  }
  if {"$result" == "1" || "[string tolower $result]" == "yes"} {
    return 1
  } {
    return 0
  }
}


# Procedure: MiscPrologWritable
proc MiscPrologWritable { fileName} {
##########
# Procedure: MiscPrologWritable
# Description: check if filename is writable
# Arguments: fileName - the filename to check
# Returns: 1 if file is writable, otherwise 0
# Sideeffects: none
##########

  # File selector box parameters.
  global fsBox
  # The global variables of mobal.
  global mobal

  set fileName [MiscDirnamePrepare $fileName]
  if {$mobal(localFS)} {
    if {$fsBox(all) == 1} {
      if {[file exists $fileName]} {
        set result [file writable $fileName]
      } {
        set result [file writable [file dirname $fileName]]
      }
    } {
      if {$fsBox(all) == 2} {
        if {[file exists $fileName.qof] || [file exists $fileName.pl]} {
          set result [expr [file writable $fileName.qof] || [file writable $fileName.pl]]
        } {
          set result [file writable [file dirname $fileName]]
        }
      } {
        if {[file exists $fileName.ie]} {
          set result [file writable $fileName.ie]
        } {
          set result [file writable [file dirname $fileName]]
        }
      }
    }
  } {
    PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
    if {$fsBox(all) == 1} {
      set result [PrologSend file_writable [PrologAtom [file dirname $fileName]] [PrologAtom [file tail $fileName]]]
    } {
      if {$fsBox(all) == 2} {
        set result [PrologSend tool_writable [PrologAtom [file dirname $fileName]] [PrologAtom [file tail $fileName]]]
      } {
        set result [PrologSend domain_writable [PrologAtom [file dirname $fileName]] [PrologAtom [file tail $fileName]]]
      }
    }
  }
  if {"$result" == "1" || "[string tolower $result]" == "yes"} {
    return 1
  } {
    return 0
  }
}


# Procedure: MiscReadAndPromptCheck
proc MiscReadAndPromptCheck { command {string ""}} {
  # This command is called to verify the value entered in
  # the input box.
  # command - the check command
  # string - the current value in the input box

  set result [PrologSendForce $command [PrologString $string]]
  if {"$result" == "1" || "$result" == "Yes"} {
    return 1
  } {
    return 0
  }
}


# Procedure: MiscScaleEntry
proc MiscScaleEntry { variable value} {
  # This procedure us used by the combination of Scale
  # and Entrys. The procedure is attatched to the scale,
  # and updates the variable representing the scales
  # value (attached to the entry via -textvariable).
  # variable - the name of the scale variable
  # value - the new value of the scale

  global mobalParameters
  if {"[set $variable]" != "$value"}  {
    set $variable $value
  }
}


# Procedure: MiscSetDebugging
proc MiscSetDebugging { {newDebugging ""}} {
  # Set the debugging status to the new value.
  # Debugging is enabled/disabled by a <Tripple-Button-1>
  # event on the GMD label. Debugging gives access to an
  # additional menubutton.
  # newDebugging - the new value for the debugging status

  # The global variables of mobal.
  global mobal

  if {"$newDebugging" != ""} {
    set mobal(debugging) $newDebugging
  } {
    set mobal(debugging) [expr !$mobal(debugging)]
  }
  if {$mobal(debugging)} {
    if {"[info commands .frame1.frame8.xfmenubuttonDbg]" == ""} {
      menubutton .frame1.frame8.xfmenubuttonDbg -text "Debug" -menu ".frame1.frame8.xfmenubuttonDbg.xfm"

      menu .frame1.frame8.xfmenubuttonDbg.xfm
      .frame1.frame8.xfmenubuttonDbg.xfm add command -label "Enter TCL code" -command "ReadBox"
      .frame1.frame8.xfmenubuttonDbg.xfm add command -label "Print errorInfo" -command "puts stdout \$errorInfo"
      .frame1.frame8.xfmenubuttonDbg.xfm add command -label "Set Ready" -command "PrologSetReady"
      .frame1.frame8.xfmenubuttonDbg.xfm add checkbutton -label "Print debug" -variable mobal(debuggingPrint)
      .frame1.frame8.xfmenubuttonDbg.xfm add separator
      .frame1.frame8.xfmenubuttonDbg.xfm add cascade -label "AlertBox" -menu .frame1.frame8.xfmenubuttonDbg.xfm.xfm1
      .frame1.frame8.xfmenubuttonDbg.xfm add cascade -label "YesNoBox" -menu .frame1.frame8.xfmenubuttonDbg.xfm.xfm2
      .frame1.frame8.xfmenubuttonDbg.xfm add cascade -label "TextBox" -menu .frame1.frame8.xfmenubuttonDbg.xfm.xfm3
      .frame1.frame8.xfmenubuttonDbg.xfm add cascade -label "Button choose" -menu .frame1.frame8.xfmenubuttonDbg.xfm.xfm4
      .frame1.frame8.xfmenubuttonDbg.xfm add cascade -label "List choose" -menu .frame1.frame8.xfmenubuttonDbg.xfm.xfm5
      .frame1.frame8.xfmenubuttonDbg.xfm add command -label "FontBox" -command "FontBox"
      .frame1.frame8.xfmenubuttonDbg.xfm add separator
      .frame1.frame8.xfmenubuttonDbg.xfm add cascade -label "Protocol" -menu .frame1.frame8.xfmenubuttonDbg.xfm.xfm6
      .frame1.frame8.xfmenubuttonDbg.xfm add separator
      .frame1.frame8.xfmenubuttonDbg.xfm add command -label "Restart" -command "exit 0"

      menu .frame1.frame8.xfmenubuttonDbg.xfm.xfm1
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm1 add command -label "AlertBox 1" -command "AlertBox {This is an alert box!}"
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm1 add command -label "AlertBox 2" -command "AlertBox {This is an alert box with a very very very very very very very ver y very very very long line!}"
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm1 add command -label "AlertBox 3" -command "AlertBox {This is an alert box
with multiple lines
in the message window!}"
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm1 add command -label "AlertBox 4" -command "AlertBox {This is an alert box
with multiple lines
in the message window, and a very very very (but not SO very :-) long line!}"

      menu .frame1.frame8.xfmenubuttonDbg.xfm.xfm2
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm2 add command -label "YesNoBox 1" -command "puts stdout \"Pressed: \[YesNoBox {This is a yes/no box!}\]\""
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm2 add command -label "YesNoBox 2" -command "puts stdout \"Pressed: \[YesNoBox {This is a yes/no box with a very very very very very very very ver y very very very long line!}\]\""
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm2 add command -label "YesNoBox 3" -command "puts stdout \"Pressed: \[YesNoBox {This is a yes/no box
with multiple lines
in the message window!}\]\""
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm2 add command -label "YesNoBox 4" -command "puts stdout \"Pressed: \[YesNoBox {This is a yes/no box
with multiple lines
in the message window, and a very very very (but not SO very :-) long line!}\]\""

      menu .frame1.frame8.xfmenubuttonDbg.xfm.xfm3
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm3 add command -label "TextBox 1" -command "TextBox {This is a text box!}"
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm3 add command -label "TextBox 2" -command "TextBox {This is a text box with a very very very very very very very ver y very very very long line!}"
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm3 add command -label "TextBox 3" -command "TextBox {This is a text box
with multiple lines
in the text window!}"
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm3 add command -label "TextBox 4" -command "TextBox {This is a text box
with multiple lines
in the message window, and a very very very (but not SO very :-) long line!}"

      menu .frame1.frame8.xfmenubuttonDbg.xfm.xfm4
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm4 add command -label "Button choose 1" -command "puts stdout \"Selected: \[ButtonChoose {Select from buttons} {Value1 Value2 Value3 Value4}\]\""
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm4 add command -label "Button choose 2" -command "puts stdout \"Selected: \[ButtonChoose {Select from buttons} {Value1 Value2 Value3 {Relatively long value for a button}}\]\""

      menu .frame1.frame8.xfmenubuttonDbg.xfm.xfm5
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm5 add command -label "List choose 1" -command "puts stdout \"Selected: \[ListChoose {Select from list} {Value1 Value2 Value3 Value4}\]\""
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm5 add command -label "List choose 2" -command "puts stdout \"Selected: \[ListChoose {Select from list} {Value1 Value2 Value3 {Relatively long value for a list}}\]\""
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm5 add command -label "List choose 3" -command "puts stdout \"Selected: \[ListChoose {Select from list} {Value1 Value2 Value3 Value4 Value5 Valu6 Value7 Value8 Value9 Value10 Value11} {Value11}\]\""

      menu .frame1.frame8.xfmenubuttonDbg.xfm.xfm6
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm6 add command -label "Ring Bell" -command "MiscBell"
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm6 add command -label "Add fact item" -command "MobalAddItem fact aabbbb 6"
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm6 add command -label "Add tnode item" -command "MobalAddItem tnodelist1 aabbbbccc 6"
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm6 add command -label "Delete fact item" -command "MobalDeleteItem fact 3"
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm6 add command -label "Delete tnode item" -command "MobalDeleteItem tnodelist1 3"
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm6 add command -label "hci_prompt_and_read" -command {
          set mobal(result) {{Input box:} {Title} {default} {check_param}}
          set {inputBox(erase)} {0}
          set inputBox($inputBox(toplevelName),inputMulti) "" 
          if {[llength $mobal(result)] >= 3} {
            set inputBox($inputBox(toplevelName),inputMulti) [lindex $mobal(result) 2]
	  }
          if {[llength $mobal(result)] == 4} {
            set inputBox(checkCommand) "MiscReadAndPromptCheck [lindex $mobal(result) 3]"
          }
          after 1 "
            InputBoxMulti \"[lindex $mobal(result) 0]\" 
            set inputBox(checkCommand) {}
            if {\$inputBox($inputBox(toplevelName),canceled)} {
              puts $\mobal(outFd) {term(hci_prompt_and_read([PrologAtom cancel])).}
            }"}
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm6 add command -label "hci_graph" -command {
          set mobal(result) {{rule} { {'may-operate'}} { { {}  {'may-operate'} {normal} {r168} {virtual} }  { {}  {'may-operate'} {normal} {r170} {virtual} }  { {}  {'may-operate'} {normal} {r172} {virtual} }  { {}  {'may-operate'} {normal} {r177} {virtual} }  { {}  {r168} {virtual} {manager} {normal} }  { {}  {r168} {virtual} {'manages_works-in'} {normal} }  { {}  {r168} {virtual} {optype} {normal} }  { {}  {r168} {virtual} {sw} {normal} }  { {}  {r170} {virtual} {'manages_works-in'} {normal} }  { {}  {r170} {virtual} {operator} {normal} }  { {}  {r170} {virtual} {optype} {normal} }  { {}  {r172} {virtual} {'manages_works-in'} {normal} }  { {}  {r172} {virtual} {operator} {normal} }  { {}  {r172} {virtual} {optype} {normal} }  { {}  {r172} {virtual} {stat} {normal} }  { {}  {r172} {virtual} {sw} {normal} }  { {}  {r177} {virtual} {'manages_works-in'} {normal} }  { {}  {r177} {virtual} {operator} {normal} }  { {}  {r177} {virtual} {optype_group} {normal} }  { {}  {r177} {virtual} {sw} {normal} } }}
          GraphCreateWindow [lindex $mobal(result) 0] [lindex $mobal(result) 1] "" [lindex $mobal(result) 2]}
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm6 add command -label "hci_graph" -command {
          set mobal(result) {{fact} {{Node3[11]} {Node4[22]}} {}}
          GraphCreateWindow [lindex $mobal(result) 0] [lindex $mobal(result) 1] "" [lindex $mobal(result) 2]}
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm6 add command -label "hci_graph" -command {
          set mobal(result) {{fact} {Node3[1.2]} {{edge1 Node1 normal Node2 virtual} {edge2 Node1 normal Node2 virtual} {{edge3 with a very long label} {Node3[1.2]} normal Node2 virtual} {edge4 {Node3[1.2]} normal Node2 virtual}}}
          GraphCreateWindow [lindex $mobal(result) 0] [lindex $mobal(result) 1] "" [lindex $mobal(result) 2]}
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm6 add command -label "hci_graph new" -command {set mobal(result) {{fact} { {'bonn-dept'} {'wichtig-co'} }  { {} { {'contradictory(has-dept)'} {'wichtig-co'} {normal} {foo2} {normal} }  { {covers} {'wichtig-co'} {normal} {bonn} {normal} }  { {covers} {'wichtig-co'} {normal} {hannover} {normal} }  { {'has-dept'} {'wichtig-co'} {normal} {'bonn-dept'} {normal} }  { {'has-dept'} {'wichtig-co'} {normal} {'hannover-dept'} {normal} }  { {'has-dept'} {'wichtig-co'} {normal} {tod} {normal} }  { {manages} {'bonn-dept'} {normal} {'pabxb-17'} {normal} }  { {'not(has-dept)'} {'wichtig-co'} {normal} {foo} {normal} }  { {owner} {'pabxa-42'} {normal} {'wichtig-co'} {normal} }  { {owner} {'pabxb-17'} {normal} {'wichtig-co'} {normal} }  { {owner} {'pabxe-42'} {normal} {'wichtig-co'} {normal} }  { {owner} {'pabxf-69'} {normal} {'wichtig-co'} {normal} }  { {owner} {'sabxb-01'} {normal} {'wichtig-co'} {normal} }  { {owner} {'sabxe-01'} {normal} {'wichtig-co'} {normal} }  { {'works-for'} {adams} {normal} {'wichtig-co'} {normal} }  { {'works-for'} {baal} {normal} {'wichtig-co'} {




normal} }  { {'works-for'} {bode} {normal} {'wichtig-co'} {normal} }  { {'works-for'} {castro} {normal} {'wichtig-co'} {normal} }  { {'works-for'} {collier} {normal} {'wichtig-co'} {normal} }  { {'works-for'} {dante} {normal} {'wichtig-co'} {normal} }  { {'works-for'} {dole} {normal} {'wichtig-co'} {normal} }  { {'works-in'} {castro} {normal} {'bonn-dept'} {normal} }  { {'works-in'} {collier} {normal} {'bonn-dept'} {normal} } }}
          GraphCreateWindow [lindex $mobal(result) 0] [lindex $mobal(result) 1] "" [lindex $mobal(result) 2]}
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm6 add command -label "hci_graph" -command {
          set mobal(result) {{sclass} {dfgdfg} {{edge1 Node1 normal Node2 virtual} {edge2 Node1 normal Node2 virtual} {{edge3 with a very long label} Node3 normal Node2 virtual} {edge4 Node3 normal Node2 virtual}}}
          GraphCreateWindow [lindex $mobal(result) 0] [lindex $mobal(result) 1] "" [lindex $mobal(result) 2]}
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm6 add command -label "hci_graph" -command {
          set mobal(result) {{rule} { {no_parking} }  { { {} {no_parking} {normal} {r12} {virtual} }  { {} {no_parking} {normal} {r13} {virtual} }  { {} {no_parking} {normal} {r14} {virtual} }  { {} {no_parking} {normal} {r15} {virtual} }  { {} {no_parking} {normal} {r16} {virtual} }  { {} {parking_violation} {normal} {r17} {virtual} }  { {} {r12} {virtual} {sidewalk} {normal} }  { {} {r13} {virtual} {second_row} {normal} }  { {} {r14} {virtual} {bus_lane} {normal} }  { {} {r15} {virtual} {fire_hydrant} {normal} }  { {} {r16} {virtual} {level_crossing} {normal} }  { {} {r17} {virtual} {car_parked} {normal} }  { {} {r17} {virtual} {no_parking} {normal} }  }}
          GraphCreateWindow [lindex $mobal(result) 0] [lindex $mobal(result) 1] "" [lindex $mobal(result) 2]}
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm6 add command -label "hci_graph" -command {
          set mobal(result) {{fact} { {event1} {sw} }  { {} { {car_parked} {event1} {normal} {place1} {normal} }  { {car_towed} {event1} {normal} {b_au_6773} {normal} } { {fine} {event1} {normal} {20} {normal} }  { {involved_vehicle} {event1} {normal} {b_au_6773} {normal} }  { {not(appeals)} {sw} {normal} {event1} {normal} }  { {not(court_citation)} {sw} {normal} {event1} {normal} }  { {not(responsible)} {sw} {normal} {loan_event} {normal} }  { {owner} {sw} {normal} {b_au_6773} {normal} }  { {pays_fine} {event1} {normal} {sw} {normal} }  { {responsible} {sw} {normal} {event1} {normal} }  }}
          GraphCreateWindow [lindex $mobal(result) 0] [lindex $mobal(result) 1] "" [lindex $mobal(result) 2]}
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm6 add command -label "hci_graph" -command {
          set mobal(result) {{fact} { {dj} {event1} {event2} {event3} {mo} {sw} } {{} { {appeals} {dj} {normal} {event2} {normal} } { {appeals} {mo} {normal} {event3} {normal} } { {car_parked} {event1} {normal} {place1} {normal} } { {car_parked} {event2} {normal} {place2} {normal} } {{car_parked} {event3} {normal} {place3} {normal} } { {car_towed} {event1} {normal} {b_au_6773} {normal} } {{contradictory(responsible)} {sw} {normal} {loan_event} {normal} } {{court_citation} {dj} {normal} {event2} {normal} } { {court_citation} {mo} {normal} {event3} {normal} } { {fine} {event1} {normal} {20} {normal} } { {involved_vehicle} {event1} {normal} {b_au_6773} {normal} } { {involved_vehicle} {event2} {normal} {b_dx_1385} {normal} } {{involved_vehicle} {event3} {normal} {hh_mo_195} {normal} } {{not(appeals)} {sw} {normal} {event1} {normal} } {{not(court_citation)} {sw} {normal} {event1} {normal} } { {owner} {dj} {normal} {b_dx_1385} {normal} } { {owner} {mo} {normal} {hh_mo_195} {normal} } { {owner} {sw} {normal} {b_au_6773} {normal} } { {owner} {sw} {normal} {b_xs_400} {normal} } { {pays_fine} {event1} {normal} {sw} {normal} } { {responsible} {dj} {normal} {event2} {normal} } {{responsible} {mo} {normal} {event3} {normal} } { {responsible} {sw} {normal} {event1} {normal} } }}
          GraphCreateWindow [lindex $mobal(result) 0] [lindex $mobal(result) 1] "" [lindex $mobal(result) 2]}
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm6 add command -label "hci_graph" -command {
          set mobal(result) {{mpred} {dfgdfg} {{edge1 Node1 normal Node2 virtual} {edge2 Node1 normal Node2 virtual} {{edge3 with a very long label} Node3 normal Node2 virtual} {edge4 Node3 normal Node2 virtual}}}
          GraphCreateWindow [lindex $mobal(result) 0] [lindex $mobal(result) 1] "" [lindex $mobal(result) 2]}
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm6 add command -label "hci_graph" -command {
          set mobal(result) {{fact} {dfgdfg} {{edge1 Node1 normal Node2 virtual} {edge2 Node1 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {{edge4 with a relatively long name} Node4 normal Node2 virtual} {edge5 Node5 normal Node2 virtual} {edge6 Node6 normal Node2 virtual} {edge7 Node7 normal Node2 virtual} {edge8 {Node8 with a relatively long name} normal Node7 virtual} {edge9 Node9 normal Node7 virtual} {edge10 Node10 normal Node7 virtual} {edge11 Node11 normal Node7 virtual} {edge12 Node12 normal Node7 virtual} {edge13 Node13 normal Node7 virtual} {edge14 Node14 normal Node9 virtual} {edge15 Node15 normal Node9 virtual} {edge16 Node15 normal Node9 virtual} {edge17 Node15 normal Node9 virtual} {edge18 Node15 normal Node9 virtual} {edge19 Node19 normal Node12 virtual} {edge20 Node20 normal Node12 virtual} {edge21 Node21 normal Node12 virtual} {edge22 Node22 normal Node12 virtual} {edge23 Node23 normal Node12 virtual} {edge24 Node24 normal Node12 virtual} {edge25 Node25 normal Node12 virtual} {edge25 Node25 normal Node16 virtual} {edge26 Node26 normal Node16 virtual} {edge27 Node27 normal Node16 virtual} {edge28 Node28 normal Node16 virtual} {edge29 Node29 normal Node16 virtual} {edge30 Node30 normal Node16 virtual} {edge31 Node31 normal Node16 virtual} {edge32 Node32 normal Node16 virtual} {edge33 Node33 normal Node16 virtual} {edge34 Node34 normal Node16 virtual} {edge35 Node35 normal Node16 virtual} {edge36 Node36 normal Node16 virtual} {edge37 Node37 normal Node16 virtual} {edge38 Node38 normal Node16 virtual} {edge39 Node39 normal Node16 virtual} {edge40 Node40 normal Node19 virtual} {edge41 Node41 normal Node19 virtual} {edge42 Node42 normal Node19 virtual} {edge43 Node43 normal Node19 virtual} {edge44 Node44 normal Node19 virtual} {edge45 Node45 normal Node19 virtual} {edge46 Node46 normal Node19 virtual} {edge47 Node47 normal Node19 virtual} {edge48 Node48 normal Node19 virtual} {edge49 Node49 normal Node19 virtual} {edge50 Node50 normal Node20 virtual} {edge51 Node51 normal Node20 virtual} {edge52 Node52 normal Node20 virtual} {edge53 Node53 normal Node20 virtual} {edge54 Node54 normal Node20 virtual} {edge55 Node55 normal Node20 virtual} {edge56 Node56 normal Node20 virtual} {edge57 Node57 normal Node20 virtual} {edge58 Node58 normal Node20 virtual} {edge59 Node59 normal Node20 virtual} {edge60 Node60 normal Node20 virtual} {edge61 Node61 normal Node20 virtual} {edge62 Node62 normal Node22 virtual} {edge63 Node63 normal Node22 virtual} {edge64 Node64 normal Node22 virtual} {edge65 Node65 normal Node22 virtual} {edge66 Node66 normal Node22 virtual} {edge67 Node67 normal Node22 virtual} {edge68 Node68 normal Node22 virtual} {edge69 Node69 normal Node22 virtual} {edge70 Node70 normal Node22 virtual} {edge71 Node71 normal Node22 virtual} {edge72 Node72 normal Node22 virtual} {edge73 Node73 normal Node22 virtual} {edge74 Node74 normal Node22 virtual} {edge75 Node75 normal Node22 virtual} {edge76 Node76 normal Node22 virtual} {edge77 Node77 normal Node22 virtual} {edge78 Node78 normal Node22 virtual} {edge79 Node79 normal Node22 virtual} {edge80 Node80 normal Node22 virtual} {edge81 Node81 normal Node22 virtual} {edge82 Node82 normal Node25 virtual} {edge83 Node83 normal Node25 virtual} {edge84 Node84 normal Node25 virtual} {edge85 Node85 normal Node25 virtual} {edge86 Node86 normal Node25 virtual} {edge87 Node87 normal Node25 virtual} {edge88 Node88 normal Node25 virtual} {edge89 Node89 normal Node25 virtual} {edge90 Node90 normal Node25 virtual} {edge91 Node91 normal Node25 virtual} {edge92 Node92 normal Node25 virtual} {edge93 Node93 normal Node25 virtual} {edge94 Node94 normal Node25 virtual} {edge95 Node95 normal Node25 virtual} {edge96 Node96 normal Node25 virtual} {edge97 Node97 normal Node25 virtual} {edge98 Node98 normal Node25 virtual} {edge99 Node99 normal Node25 virtual} {edge100 Node100 normal Node25 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node3 normal Node2 virtual} {edge3 Node4 normal Node2 virtual}}}
          GraphCreateWindow [lindex $mobal(result) 0] [lindex $mobal(result) 1] "" [lindex $mobal(result) 2]}
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm6 add command -label "hci_knowledge_revision" -command {
          set mobal(result1) {{{{1} {neg} {2} {0.3}} {{3} {pos} {3} {0.4}}} 0 {
            {1 1.65 {{{{2}} 2.2 2.5} {{{r2} {{[a,1]} {[a,2]}} 0 2.65}}}}
            {2 2.65 {{{{3}} 2.3 5.5} {{{r1} {{1} {5}} 6.6 4.4}}}}
            {2 3.65 {{{{1}} 2.3 5.5} {{{r2} {{1} {5}} 6.6 4.4}} {{{r3} {{1} {5}} 6.6 4.4}}}}
          }}
          set mobal(result2) {{fact} {Node3[1.2]} {{edge1 Node1 normal Node2 virtual} {edge2 Node1 normal Node2 virtual} {{edge3 with a very long label} {Node3[1.2]} normal Node2 virtual} {edge4 {Node3[1.2]} normal Node2 virtual}}}
          MobalViewKnowledge $mobal(result1) $mobal(result2)}
      .frame1.frame8.xfmenubuttonDbg.xfm.xfm6 add command -label "hci_edit_predvar_restrictions" -command {
          set mobal(result) {meta1 {{{pred1} {{1} {2} {3}}} {{pred2} {{}}} {{pred3} {{1}}}}}
          MobalViewMetaPredicate [lindex $mobal(result) 0] [lindex $mobal(result) 1]}
    }
    pack .frame1.frame8.xfmenubuttonDbg -side right
  } {
    catch "pack forget .frame1.frame8.xfmenubuttonDbg"
  }
}


# Procedure: MiscSetStatus
proc MiscSetStatus { value} {
  # Set the status label to a new value.
  # value - the new label

  # The global variables of mobal.
  global mobal

  # Set the status label.
  set mobal(status) $value
}


# Procedure: MiscToggleParameterState
proc MiscToggleParameterState { variable args} {
  # This procedure set the widget status according
  # to the current unrestricted selection.

  # This variable contains the current unrestricted selection
  # for the tool parameters.
  global mobalUnrestricted

  if {[set $variable]} {
    foreach widget $args {
      pack unpack $widget
    }
  } {
    foreach widget $args {
      if {[string match *button* $widget]} {
        pack append [winfo parent $widget] $widget {left}
      } {
        pack append [winfo parent $widget] $widget {left fill expand}
      }
    }
  }
}


# Procedure: MiscViewItemIds
proc MiscViewItemIds { pathName type} {
  # This procedure is used to return the currently
  # selected items.
  # pathName - the name of the view
  # type - the type of the view

  set result ""
  # Walk through the current selection.
  foreach selectItem [$pathName.list.list curselect] {
    lappend result [$pathName.list.listId get $selectItem]
  }
  # Return the result.
  return $result
}


# Procedure: MobalAddItem
proc MobalAddItem { {type ""} {string ""} {id ""}} {
  # This procedure is called when mobal sends a trigger
  # that indicates that a new mobal item was created.
  # type - this is the type of the new mobal item (e.g.
  #        facts, rules etc.)
  # string - the value of the new mobal item
  # id - the mobal id of the new item

  # A list off all focus specifications attatched
  # to the views.
  global mobalWindowFocus
  # A list off all window names attatched to the views.
  global mobalWindowNames
  # A list off all sorting specifications attatched
  # to the views.
  global mobalWindowSortings
  # A list where all topology views are mapped
  # to their correspinding topology type.
  global mobalTopology
  # get the global list
  global xfMobalItems_$type

  # Append the new item to the correct global list.
  set xfMobalItems_${type}($id) $string

  # make the correct type if this is a tnode.
  if {[string match tnode* $type]} {
    set tmpType tnode
    set tmpTNodeName [string range $type 5 end]
  } {
    set tmpType $type
    set tmpTNodeName ""
  }
  # Walk through all open views, to see whether or
  # not it is necessary to update that view.
  if {![info exists mobalWindowNames]} {
    return
  }
  foreach pathName [array names mobalWindowNames] {
    if {[info exists mobalTopology($pathName)] &&
        "$mobalTopology($pathName)" != "$tmpTNodeName"} {
      continue
    }
    if {[string match "$tmpType,*" [set mobalWindowNames($pathName)]]} {
      # The new mobal item has the same type as the
      # displayed view.
      if {"$mobalWindowSortings($pathName)" == "unsorted"} {
        # As the list is unsorted just append the new element.
        if {"$mobalWindowFocus($pathName)" != ""} {
          # We have a focus, so test whether or not 
          # the new item is visible or not.
          if {[regexp $mobalWindowFocus($pathName) $string]} {
            # The item is visible, so insert it.
            $pathName.list.listId insert end $id
            $pathName.list.list insert end $string
          }
        } {
          # There is no focus, so insert it.
          $pathName.list.listId insert end $id
          $pathName.list.list insert end $string
        }
      } {
        # For sorted views we have to do more... first
        # we delete the current contents of the views.
        catch "$pathName.list.list delete 0 end"
        catch "$pathName.list.listId delete 0 end"
        if {"$mobalWindowFocus($pathName)" != ""} {
          # We have a focus, so test whether or not 
          # the new item is visible or not. Walk through
          # all elements currently displayed in the view.
          foreach tmpElement [MobalGetAllItems $type] {
            # We have a focus, so test whether or not 
            # the new item is visible or not.
            if {[regexp $mobalWindowFocus($pathName) [lindex $tmpElement 0]]} {
              # The item is visible, so append it to the result.
              lappend elementList $tmpElement
            }
          }
        } {
          # Walk through all elements currently displayed
          # in the view.
          set elementList [MobalGetAllItems $type]
        }
        # Walk through all elements in the result. The result
        # is sorted befor the elements are inserted.
        foreach element [lsort $mobalWindowSortings($pathName) $elementList] {
          # Insert the item into the two view lists.
          $pathName.list.list insert end [lindex $element 0]
          $pathName.list.listId insert end [lindex $element 1]
        }
      }
    }
  }
}


# Procedure: MobalAddTool
proc MobalAddTool {} {
  # This procedure is called when a new tool is loaded. It
  # adds the toolname to the list, and the menus

  # The global variables of mobal.
  global mobal

  if {"[info commands .frame1.frame8.menubutton15.m.m]" == ""} {
    menu .frame1.frame8.menubutton15.m.m  -postcommand {MobalWindowsUpdate}
  }
  catch ".frame1.frame8.menubutton15.m.m delete 0 last"
  set mobal(toolList) [PrologSendForce mobal_open_tools]
  # toolList is a list of tool names together with their item type specifications
  # e.g. toolList might be set to
  #    { {foil} {} } { 
  #      {grdt} { { {grule} {Grammar Rules} { {Details} {Delete} } } } 
  #                  }
  foreach tool $mobal(toolList) {
    set toolName [lindex $tool 0]
    set toolItemTypes [lindex $tool 1]
    .frame1.frame8.menubutton15.m.m add command -command "MobalCallTool $toolName" -label $toolName
    foreach itemType $toolItemTypes {
      if {"$itemType" != ""} {
        MobalAddViewType $itemType
      }
    }
  }
  foreach children [winfo children .] {
    if {[string match ".xfmobalStackparameter*" $children]} {
      ViewParamsDisplayTools $children
    }
  }
}


# Procedure: MobalAddViewType
proc MobalAddViewType { definition} {
  # This procedure adds a new view type to TkMobal. 
  # definition - the view type definition. A list with
  #              the internal type name, the window title,
  #              and the list of menu items.
  
  # This array contains the definitions for all
  # known view types. First comes the title for
  # the view, and then the popup menu definition.
  global mobalViewType
  # This array contains the list of window counters
  # for all posssible view types (and other window types).
  global mobalWindowCounters
  # This array contains all title strings for the
  # possible window types.
  global mobalWindowTitles
  # This array contains the last position of the windows
  # for all window types.
  global mobalWindowPositions

  set element [lindex $definition 0]

  if {![info exists mobalViewType($element)]} {
    # Initialize the mobal view parameters
    set mobalViewType($element) [list [lindex $definition 1] [lindex $definition 2]]
    set mobalWindowCounters($element) ""
    set mobalWindowPositions($element) ""
    set mobalWindowTitles($element) [lindex [set mobalViewType($element)] 0]

    if {"[lindex [.frame1.frame8.menubutton13.m entryconf [.frame1.frame8.menubutton13.m index last] -label] 4]" == "Metametafacts"} {
      .frame1.frame8.menubutton13.m add separator
    }
    .frame1.frame8.menubutton13.m add command  -command "MobalViewView $element"  -label $mobalWindowTitles($element)
  }
  MobalUpdateLocalLists $element
}


# Procedure: MobalCKRLCKRLToMobal
proc MobalCKRLCKRLToMobal {} {
  # Convert CKRL KB to Mobal.

  PrologSend ckrl_ckrl_mobal
}


# Procedure: MobalCKRLClearKB
proc MobalCKRLClearKB {} {
  # Clear CKRL KB.

  PrologSend ckrl_clear_ckrl_kb
}


# Procedure: MobalCKRLDeleteKB
proc MobalCKRLDeleteKB {} {
  # Delete a CKRL KB.

  # File selector box parameters.
  global fsBox
  # The global variables of mobal.
  global mobal
  # This array conatins all path names for the
  # various file selector boxes.
  global mobalFile

  # List all files.
  set fsBox(all) 1
  # This command is called to verify the selected file.
  set fsBox(checkCommand) MiscPrologDeletable
  # wait for a ready mobal
  PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
  # Call file selector.
  set result [FSBox "Delete CKRL KB File..." $mobalFile(loadCKRL)]
  if {"$result" != ""} {
    set mobalFile(loadCKRL) $result
    PrologSend ckrl_delete_ckrl_kb_file [PrologAtom [file dirname $mobalFile(loadCKRL)]] [PrologAtom [file tail $mobalFile(loadCKRL)]]
  }
}


# Procedure: MobalCKRLLoadKB
proc MobalCKRLLoadKB {} {
  # Load a CKRL KB

  # File selector box parameters.
  global fsBox
  # The global variables of mobal.
  global mobal
  # This array conatins all path names for the
  # various file selector boxes.
  global mobalFile

  # List all files.
  set fsBox(all) 1
  # This command is called to verify the selected file.
  set fsBox(checkCommand) MiscPrologReadable
  # wait for a ready mobal
  PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
  # Call file selector.
  set result [FSBox "Load CKRL KB..." $mobalFile(loadCKRL)]
  if {"$result" != ""} {
    set mobalFile(loadCKRL) $result
    PrologSend ckrl_load_ckrl_kb [PrologAtom [file dirname $mobalFile(loadCKRL)]] [PrologAtom [file tail $mobalFile(loadCKRL)]]
  }
}


# Procedure: MobalCKRLMobalToCKRL
proc MobalCKRLMobalToCKRL {} {
  # Convert a Mobal to a CKRL KB

  PrologSend ckrl_mobal_ckrl
}


# Procedure: MobalCKRLReadFile
proc MobalCKRLReadFile {} {
  # Read a plain file as CKRL KB.

  # File selector box parameters.
  global fsBox
  # The global variables of mobal.
  global mobal
  # This array conatins all path names for the
  # various file selector boxes.
  global mobalFile

  # List all files.
  set fsBox(all) 1
  # This command is called to verify the selected file.
  set fsBox(checkCommand) MiscPrologWritable
  # wait for a ready mobal
  PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
  # Call file selector.
  set result [FSBox "Read CKRL File..." $mobalFile(loadCKRL)]
  if {"$result" != ""} {
    set mobalFile(loadCKRL) $result
    PrologSend ckrl_read_ckrl_file [PrologAtom [file dirname $mobalFile(loadCKRL)]] [PrologAtom [file tail $mobalFile(loadCKRL)]]
  }
}


# Procedure: MobalCKRLSaveKBAs
proc MobalCKRLSaveKBAs {} {
  # Save a CKRL KB as...

  # File selector box parameters.
  global fsBox
  # The global variables of mobal.
  global mobal
  # This array conatins all path names for the
  # various file selector boxes.
  global mobalFile

  # List all files.
  set fsBox(all) 1
  # This command is called to verify the selected file.
  set fsBox(checkCommand) MiscPrologWritable
  # wait for a ready mobal
  PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
  # Call file selector.
  set result [FSBox "Save CKRL KB As..." $mobalFile(loadCKRL)]
  if {"$result" != ""} {
    set mobalFile(loadCKRL) $result
    PrologSend ckrl_save_ckrl_kb_as [PrologAtom [file dirname $mobalFile(loadCKRL)]] [PrologAtom [file tail $mobalFile(loadCKRL)]]
  }
}


# Procedure: MobalCKRLShow
proc MobalCKRLShow { type} {
  # Show CKRL informations.

  PrologSend ckrl_show_$type
}


# Procedure: MobalCKRLWriteFile
proc MobalCKRLWriteFile {} {
  # Write a CKRL plain file.

  # File selector box parameters.
  global fsBox
  # The global variables of mobal.
  global mobal
  # This array conatins all path names for the
  # various file selector boxes.
  global mobalFile

  # List all files.
  set fsBox(all) 1
  # This command is called to verify the selected file.
  set fsBox(checkCommand) MiscPrologWritable
  # wait for a ready mobal
  PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
  # Call file selector.
  set result [FSBox "Write CKRL File..." $mobalFile(loadCKRL)]
  if {"$result" != ""} {
    set mobalFile(loadCKRL) $result
    PrologSend ckrl_write_ckrl_file [PrologAtom [file dirname $mobalFile(loadCKRL)]] [PrologAtom [file tail $mobalFile(loadCKRL)]]
  }
}


# Procedure: MobalCallCKRL
proc MobalCallCKRL {} {
  # This procedure displays or removes the CKRL menubutton,
  # depending on the value of mobal(CKRL)

  # The global variables of mobal.
  global mobal

  if {$mobal(CKRL)} {
    # Display the menubutton.
    pack append .frame1.frame8 .frame1.frame8.menubutton0 {left expand padx 6 pady 6}
  } {
    # Remove the menubutton.
    pack unpack .frame1.frame8.menubutton0
  }
}


# Procedure: MobalCallCheckConstraints
proc MobalCallCheckConstraints {} {
  # Check the constraints.

  PrologSend mobal_check_constraints
}


# Procedure: MobalCallCreateTopology
proc MobalCallCreateTopology {} {
  # Create a new topology.

  # Get the new topology name.
  set result [InputBoxMulti "Please enter new topology name:"]
  # Is there a new name ?
  if {"$result" != ""} {
    PrologSend mobal_create_topology [PrologAtom $result]
    MobalUpdateLocalLists tnode
  }
}


# Procedure: MobalCallCustomInterface
proc MobalCallCustomInterface {} {
  puts stdout "Not yet implemented."
}


# Procedure: MobalCallGenerateTopology
proc MobalCallGenerateTopology {} {
  # Generat the topology.

  PrologSend mobal_generate_topology
}


# Procedure: MobalCallKluster
proc MobalCallKluster {} {
  puts stdout "Not yet implemented."
}


# Procedure: MobalCallLoadTool
proc MobalCallLoadTool {} {
  global fsBox

  # The global variables of mobal.
  global mobal
  # The directory names for the file selector.
  global mobalFile

  # List all files.
  set fsBox(all) 2
  # This command is called to verify the selected file.
  set fsBox(checkCommand) MiscPrologReadable
  # Call file selector.
  set result [FSBox "Load Tool..." $mobalFile(loadTool)]
  if {"$result" != ""} {
    set mobalFile(loadTool) $result
    set result [PrologSend load_tool [PrologAtom [file dirname $mobalFile(loadTool)]] [PrologAtom [file tail $mobalFile(loadTool)]]]
    if {"$result" == "1" || "[string tolower $result]" == "yes"} {
      MobalAddTool
      foreach name [winfo children .] {
        if {[string match .xfmobalStackparameter* $name] &&
            "$mobal(tool)" == "hci"} {
          ViewParamsGet $name
        }
      }
    }
  }
}


# Procedure: MobalCallProlog
proc MobalCallProlog {} {
  # Call prolog directly.

  PrologSend mobal_call_prolog
}


# Procedure: MobalCallQueryFact
proc MobalCallQueryFact {} {
  # Query a fact.

  PrologSend mobal_query_fact
}


# Procedure: MobalCallQueryMFact
proc MobalCallQueryMFact {} {
  # Query a meta fact.

  PrologSend mobal_query_mfact
}


# Procedure: MobalCallQueryMMFact
proc MobalCallQueryMMFact {} {
  # Query a meta meta fact.

  PrologSend mobal_query_mmfact
}


# Procedure: MobalCallRecomputeWindows
proc MobalCallRecomputeWindows {} {
  # This procedure recomputes the contents of the local
  # data structures and redisplays the view windows.

  puts stdout "Recomputing windows ... "
  flush stdout
  MobalUpdateLocalLists
  puts stdout "Done."
}


# Procedure: MobalCallTool
proc MobalCallTool { tool} {
  # Call a tool.

  PrologSend mobal_call_tool $tool
}


# Procedure: MobalCallUpdateSorts
proc MobalCallUpdateSorts {} {
  # Update the sorts.

  PrologSend mobal_update_sorts
}


# Procedure: MobalDeleteItem
proc MobalDeleteItem { {type ""} {id ""}} {
  # This procedure is called when mobal sends a trigger
  # that indicates that a mobal item was deleted.
  # type - this is the type of the new mobal item (e.g.
  #        facts, rules etc.)
  # id - the mobal id of the new item

  # A list off all window names attatched to the views.
  global mobalWindowNames
  # A list where all topology views are mapped
  # to their correspinding topology type.
  global mobalTopology
  # get the global list
  global xfMobalItems_$type

  # Walk through the global listbox containing
  # the local mobal items.
  catch "unset xfMobalItems_${type}($id)"

  # make the correct type if this is a tnode.
  if {[string match tnode* $type]} {
    set tmpType tnode
    set tmpTNodeName [string range $type 5 end]
  } {
    set tmpType $type
    set tmpTNodeName ""
  }
  # Walk through all open views, to see whether or
  # not it is necessary to update that view.
  if {[catch "array names mobalWindowNames"]} {
    return
  }
  foreach pathName [array names mobalWindowNames] {
    if {[info exists mobalTopology($pathName)] &&
        "$mobalTopology($pathName)" != "$tmpTNodeName"} {
      continue
    }
    if {[string match "$tmpType,*" [set mobalWindowNames($pathName)]]} {
      # The deleted mobal item has the same type as the
      # displayed view. Now walk through all items in the
      # view listbox, and remove the items.
      for {set counter 0} {$counter < [$pathName.list.listId size]} {incr counter} {
        if {"$id" == "[$pathName.list.listId get $counter]"} {
          # This is the deleted item... so remove it from
          # the view listboxes and break.
          $pathName.list.listId delete $counter
          $pathName.list.list delete $counter
          break
        }
      }
    }
  }
}


# Procedure: MobalFileCloseWindows
proc MobalFileCloseWindows {} {
  # Close all currently open windows.

  # This variable contains a list of all
  # open mobal windows.
  global mobalWindowNames

  # Are there any open windows ?
  if {[info exists mobalWindowNames]} {
    # Walk through all open windows.
    foreach name [array names mobalWindowNames] {
      # Remove the window named $name.
      ViewDestroy $name
    }
  }
  foreach name [winfo children .] {
    if {[string match .xfmobalStack* $name]} {
      # Destroy the toplevel.
      catch "destroy $name"
    }
  }
}


# Procedure: MobalFileDeleteDomain
proc MobalFileDeleteDomain {} {
  # Delete all files belonging to a certain domain.

  # File selector box parameters.
  global fsBox
  # The global variables of mobal.
  global mobal
  # This array conatins all path names for the
  # various file selector boxes.
  global mobalFile

  # Only list domains.
  set fsBox(all) 0
  # This command is called to verify the selected file.
  set fsBox(checkCommand) MiscPrologDeletable
  # wait for a ready mobal
  PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
  # Call file selector.
  set result [FSBox "Delete Domain Files..." $mobalFile(openDomain)]
  # Was a file selected ?
  if {"$result" != ""} {
    set mobalFile(openDomain) $result
    PrologSend mobal_delete_domain [PrologAtom [file dirname $mobalFile(openDomain)]] [PrologAtom [file tail $mobalFile(openDomain)]]
  }
}


# Procedure: MobalFileHelp
proc MobalFileHelp { {node ""}} {
  # Display help pages.

  # This array contains the configurated pathnames
  # used by TkMobal.
  global mobalPath

  if {[auto_execok tkinfo]} {
    catch "exec tkinfo $mobalPath(tkinfo) $node &"
  } {
    puts stdout "exec tkinfo $mobalPath(tkinfo) $node &"
  }
}


# Procedure: MobalFileNewDomain
proc MobalFileNewDomain {} {
  # Clear current domain.

  # The global variables of mobal.
  global mobal

  # Ask the user whether he wants to erase the domain ?
  if {[YesNoBox "Really erase current Domain ?"]} {
    # Initialize domain
    set mobal(domain) ""
    set mobal(domainShort) ""
    puts stdout "Clearing knowledge base ..."
    PrologSend mobal_clear_domain
    # Reread mobal lists.
    MobalUpdateLocalLists
    puts stdout "Knowledge base cleared."	
  }
}


# Procedure: MobalFileOpenDomain
proc MobalFileOpenDomain {} {
  # Load a domain.

  # File selector box parameters.
  global fsBox
  # The global variables of mobal.
  global mobal
  # This array conatins all path names for the
  # various file selector boxes.
  global mobalFile

  # Only list domains.
  set fsBox(all) 0
  # This command is called to verify the selected file.
  set fsBox(checkCommand) MiscPrologReadable
  # wait for a ready mobal
  PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
  # Call file selector.
  set result [FSBox "Open Domain..." $mobalFile(openDomain)]
  # Was a file selected ?
  if {"$result" != ""} {
    # Ask the user whether he wants to erase the domain ?
    if {![YesNoBox "Really erase current Domain ?"]} {
      return
    }
    set mobalFile(openDomain) $result
    set mobal(domain) $result
    set mobal(domainShort) [file tail $mobal(domain)]
    PrologSend mobal_load_domain [PrologAtom [file dirname $mobalFile(openDomain)]] [PrologAtom [file tail $mobalFile(openDomain)]]
    MobalUpdateLocalLists
    foreach children [winfo children .] {
      if {[string match ".xfmobalStackparameter*" $children]} {
        ViewParamsGet $children
      }
    }
    puts stdout "$mobal(domainShort) loaded.  Have fun."
  }
}


# Procedure: MobalFilePrintDomain
proc MobalFilePrintDomain {} {
  # Print a domain.

  # File selector box parameters.
  global fsBox
  # The global variables of mobal.
  global mobal
  # This array conatins all path names for the
  # various file selector boxes.
  global mobalFile

  # List all files.
  set fsBox(all) 1
  # This command is called to verify the selected file.
  set fsBox(checkCommand) MiscPrologWritable
  # wait for a ready mobal
  PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
  # Call file selector.
  set result [FSBox "Printout Of Domain..." $mobalFile(openDomain)]
  if {"$result" != ""} {
    set mobalFile(openDomain) $result
    PrologSend mobal_print_domain [PrologAtom [file dirname $mobalFile(openDomain)]] [PrologAtom [file tail $mobalFile(openDomain)]]
  }
}


# Procedure: MobalFileQuit
proc MobalFileQuit {} {
  # Quit TkMobal.

  # Ask the user whether he wants to quit or not.
  if {[YesNoBox "Do you really want to quit mobal ?"]} {
    # He wants to quit. So terminate prolog, and
    # leave the interface.
    catch "PrologSend quit"
    exit 0
  }
}


# Procedure: MobalFileReadDomain
proc MobalFileReadDomain {} {
  # Read a domain from a raw file.

  # File selector box parameters.
  global fsBox
  # The global variables of mobal.
  global mobal
  # This array conatins all path names for the
  # various file selector boxes.
  global mobalFile

  # List all files.
  set fsBox(all) 1
  # This command is called to verify the selected file.
  set fsBox(checkCommand) MiscPrologReadable
  # wait for a ready mobal
  PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
  # Call file selector.
  set result [FSBox "Read From Text.." $mobalFile(readText)]
  # Was a file selected ?
  if {"$result" != ""} {
    set mobalFile(readText) $result
    PrologSend mobal_read_textfile [PrologAtom [file dirname $mobalFile(readText)]] [PrologAtom [file tail $mobalFile(readText)]]
  }
}


# Procedure: MobalFileSaveDomain
proc MobalFileSaveDomain {} {
  # Save a domain.

  # The global variables of mobal.
  global mobal

  if {"$mobal(domain)" != ""} {
    # Retrieve the description informations.
    set description [PrologSend mobal_domain_description [PrologAtom [file dirname $mobal(domain)]] [PrologAtom [file tail $mobal(domain)]]]
    # Is the domain writable ?
    if {[MiscPrologWritable $mobal(domain)]} {
      PrologSend mobal_save_domain [PrologAtom [file dirname $mobal(domain)]] [PrologAtom [file tail $mobal(domain)]] [PrologString $description]
    }
  }
}


# Procedure: MobalFileSaveDomainAs
proc MobalFileSaveDomainAs {} {
  # Save a domain to a new file.

  # The input box parameters.
  global inputBox
  # File selector box parameters.
  global fsBox
  # The global variables of mobal.
  global mobal
  # This array conatins all path names for the
  # various file selector boxes.
  global mobalFile

  # Only list domains.
  set fsBox(all) 0
  # This command is called to verify the selected file.
  set fsBox(checkCommand) MiscPrologWritable
  # wait for a ready mobal
  PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
  # Call file selector.
  set result [FSBox "Save Domain As..." $mobalFile(openDomain)]
  # Was a file selected ?
  if {"$result" != ""} {
    set mobal(domain) $result
    set mobal(domainShort) [file tail $mobal(domain)]
    set mobalFile(openDomain) $result
    # Ask the user for a description.
    set description ""
    set {inputBox(erase)} {0}
    # Is there already a description ?
    if {![catch "open $mobalFile(openDomain).desc" result]} {
      set inputBox($inputBox(toplevelName),inputMulti) [read $result]
      close $result
    } {
      set inputBox($inputBox(toplevelName),inputMulti) ""
    }
    set {inputBox(cancel)} {0}
    set description [InputBoxMulti "Please enter the description:"]
    set {inputBox(erase)} {1}
    set {inputBox(cancel)} {1}
    PrologSend mobal_save_domain [PrologAtom [file dirname $mobalFile(openDomain)]] [PrologAtom [file tail $mobalFile(openDomain)]] [PrologString $description]
  }
}


# Procedure: MobalFileUserGuide
proc MobalFileUserGuide {} {
  # Display the user guide.

  # This array contains the configurated pathnames
  # used by TkMobal.
  global mobalPath

  if {[auto_execok dontFindGhostview]} {
    catch "exec ghostview $mobalPath(tutorial) &"
  } {
    puts stdout "exec ghostview $mobalPath(tutorial) &"
  }
}


# Procedure: MobalFileWriteDomain
proc MobalFileWriteDomain {} {
  # Write a domain to a raw file.

  # File selector box parameters.
  global fsBox
  # The global variables of mobal.
  global mobal
  # This array conatins all path names for the
  # various file selector boxes.
  global mobalFile

  # List all files.
  set fsBox(all) 1
  # This command is called to verify the selected file.
  set fsBox(checkCommand) MiscPrologWritable
  # wait for a ready mobal
  PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
  # Call file selector.
  set result [FSBox "Save As Text..." $mobalFile(readText)]
  # Was a file selected ?
  if {"$result" != ""} {
    set mobalFile(readText) $result
    PrologSend mobal_write_textfile [PrologAtom [file dirname $mobalFile(readText)]] [PrologAtom [file tail $mobalFile(readText)]]
  }
}


# Procedure: MobalGetAllItems
proc MobalGetAllItems { {type ""}} {
  # This procedure returns all items of the specified type.
  # type - this is the type of the new mobal item (e.g.
  #        facts, rules etc.)

  # get the global list
  global xfMobalItems_$type

  set itemList ""
  # Does the list exist ?
  if {"[info globals xfMobalItems_$type]" != ""} {
    foreach tmpElement [array names xfMobalItems_$type] {
      lappend itemList [list [set xfMobalItems_${type}($tmpElement)] $tmpElement]
    }
  }
  return $itemList
}


# Procedure: MobalUpdateLocalLists
proc MobalUpdateLocalLists { {listName ""} {currentList ""}} {
  # This procedure is called to update one, or all
  # Tcl/Tk local item lists. All informations are
  # stored in listboxes named after the type of the
  # mobal item (facts, rule etc.).
  # listName - update only this list
  # currentList - the new list conntents

  # The global variables of mobal.
  global mobal
  # This variable contains a list of all
  # open mobal windows.
  global mobalWindowNames
  # This array contains the definitions for all
  # known view types. First comes the title for
  # the view, and then the popup menu definition.
  global mobalViewType

  if {"$listName" == ""} {
    # Update all lists.
    set listName [array names mobalViewType]
  }

  PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
  # Walk through the list of the mobal item types.
  foreach name $listName {
    if {"$name" == "tnode"} {
      # Retrieve the mobal items for topology items. This
      # is a little more complicated than for the
      # other mobal items.
      if {"$currentList" == ""} {
        PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
        set result [lindex [PrologSend mobal_get_$name] 1]
      } {
        set result $currentList
      }
      if {"$mobal(outFd)" == "stdout"} {
        # Debugging...
        set result {{list1 {{{aaaaa} {1}} {{bbbbb} {2}} {{ccccc} {3}} {{ddddd} {4}} {{eeeee} {5}}}} {list2 {{{aaaaa} {1}} {{bbbbb} {2}} {{ccccc} {3}} {{ddddd} {4}} {{eeeee} {5}}}}}
      }

      # Clear the cascade menu which contains the
      # available Toplology items.
      catch ".frame1.frame8.menubutton13.m.m delete 0 last"

      # The returned list of topology items follows the following
      # rules. It is a list of topology type lists. The topology
      # type lists contain the type name followed by the list
      # of items. Scan through all topology type lists.
      foreach tnodeList $result {
        # Get the type name.
        set tnode [lindex $tnodeList 0]
        # get the global list
        global xfMobalItems_$name$tnode
        catch "unset xfMobalItems_$name$tnode"

        # Insert a new command item for the topology
        # type into the cascade menu holding all
        # topology types.
        .frame1.frame8.menubutton13.m.m add command -label $tnode -command "MobalViewView $name {} $tnode"
        # Walk through the list of the mobal items.
        tkmobal_listparse xfMobalItems_$name$tnode [lindex $tnodeList 1]
        # Walk through all open windows.
        if {[info exists mobalWindowNames]} {
          foreach element [array names mobalWindowNames] {
            # Update the Stack window named $element
            ViewUpdateStack $element $name$tnode
          }
        }
      }
    } {
      # get the global list
      global xfMobalItems_$name
      catch "unset xfMobalItems_$name"

      # Retrieve the mobal items.
      if {"$currentList" == ""} {
        PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
        set result [lindex [PrologSend mobal_get_$name] 1]
      } {
        set result $currentList
      }
      if {"$mobal(outFd)" == "stdout"} {
        # Debugging...
        if {"$name" == "rule"} {
          set result {{{aaa aa} {r1}} {{bb bb b} {r2}} {{ccccc} {r3}} {{ddddd} {r4}} {{eeeee} {r5}}}
        } {
          set result {{{aaa aa} {1}} {{bb bb b} {2}} {{ccccc} {3}} {{ddddd} {4}} {{eeeee} {5}}}
        }
      }
      # Walk through the list of the mobal items.
      tkmobal_listparse xfMobalItems_$name $result
      # Walk through all open windows.
      if {[info exists mobalWindowNames]} {
        foreach element [array names mobalWindowNames] {
          # Update the Stack window named $element
          ViewUpdateStack $element $name
        }
      }
    }
  }
}


# Procedure: MobalViewInputScratchPad
proc MobalViewInputScratchPad {} {
  # This procedure pops up a scratchpad.

  # Display the scratchpad.
  InputScratchPad
}


# Procedure: MobalViewKnowledge
proc MobalViewKnowledge { {removalSets ""} {edgeList ""}} {
  # Display the knowledge revision dialog.

  if {[llength $edgeList] == 3} {
    Knowledge $removalSets [lindex $edgeList 2]
  } {
    Knowledge $removalSets $edgeList
  }
}


# Procedure: MobalViewMetaPredicate
proc MobalViewMetaPredicate { metaPredicate {restrictions ""}} {
  # Display the meta predicate revision dialog.

  MetaPred $metaPredicate $restrictions
}


# Procedure: MobalViewParams
proc MobalViewParams {} {
  # This procedure pops up a parameter display.

  # Display the parameter display.
  ViewParams
}


# Procedure: MobalViewPrologListener
proc MobalViewPrologListener {} {
  # This procedure pops up a prolog listener.

  # Display the prolog listener.
  PrologListener
}


# Procedure: MobalViewView
proc MobalViewView { {type ""} {name ""} {tnodeName ""}} {
  # This procedure pops up a stack.

  # Display the view.
  View $type $name $tnodeName
}


# Procedure: MobalViewViewSettings
proc MobalViewViewSettings { {type ""} {name ""} {tnodeName ""} {counter "0"}} {
  # This procedure displays the setting dialog.

  # Display the dialog.
  ViewSettings $type $name $tnodeName $counter
}


# Procedure: MobalWindowsUpdate
proc MobalWindowsUpdate {} {
  # This procedure updates the menu that contains
  # all the currently displayed views. The procedure
  # is attached to the menu via -postcommand.

  # A list off all window names attatched to the views.
  global mobalWindowNames

  # Remove all current view names from the menu.
  catch ".frame1.frame8.menubutton14.m delete 0 last"
  # Are there any views ?
  if {[info exists mobalWindowNames]} {
    # Walk through all views
    foreach name [array names mobalWindowNames] {
      # Create an appropriate command item in the menu.
      .frame1.frame8.menubutton14.m add command -command "wm withdraw $name; wm deiconify $name" -label "[wm title $name]"
    }
  }
}


# Procedure: NoFunction
if {"[info procs NoFunction]" == ""} {
proc NoFunction { args} {
# xf ignore me 7
##########
# Procedure: NoFunction
# Description: do nothing (especially with scales and scrollbars)
# Arguments: args - a number of ignored parameters
# Returns: none
# Sideeffects: none
##########
}
}


# Procedure: PrologAtom
proc PrologAtom { string} {
  # Prepare a string for sending to prolog.
  # This string is handled as a prolog atom.
  # string - the string to convert

  return '[PrologAtomPrepare $string]'
}


# Procedure: PrologAtomList
proc PrologAtomList { args} {
  # Prepare a string for sending to prolog.
  # This string is handled as a prolog list.
  # args - the list elements to convert

  set result "\["
  # Walk through all list elements, and append them.
  for {set counter 0} {$counter < [llength $args]} {incr counter} {
    if {$counter == [expr [llength $args]-1]} {
      append result "[PrologAtom [lindex $args $counter]]"
    } {
      append result "[PrologAtom [lindex $args $counter]],"
    }
  }
  append result "\]"
  return $result
}


# Procedure: PrologAtomPrepare
proc PrologAtomPrepare { string} {
  # Escape special characters for the
  # given atom.
  # string - the string to convert

  regsub -all ' $string '' result
  return $result
}


# Procedure: PrologInit
proc PrologInit { {host ""} {port ""}} {
  # Initialization of the TkMobal <-> prolog connection.
  # host - the hostname where the prolog interpreter is
  #        running (passed via the commandline).
  # port - the port where the prolog interperter
  #        is listening.

  # The global variables of mobal.
  global mobal

  # Which tcp package are we using ?
  if {"[info commands dp_connect]" != "" &&
      "[info commands dp_filehandler]" != ""} {
    # we are using tcl-DP 2.?

    # Tcl-DP uses the dp_ prefix to prevent name clashes
    set mobal(socketPrefix) dp_
    # Connect to the already waiting prolog interpreter.
    # The prolog interpreter opened a listening socket,
    # where we can connect. We use the host and port
    # names that where passed to TkMobal by the prolog
    # interpreter.
    if {[catch "dp_connect \"$host\" $port" result]} {
      error $result
    }
  } {
    # We are using tclRawTCP

    # tclRawTCP uses no prefix
    set mobal(socketPrefix) ""
    # Connect to the already waiting prolog interpreter.
    # The prolog interpreter opened a listening socket,
    # where we can connect. We use the host and port
    # names that where passed to TkMobal by the prolog
    # interpreter.
    if {[catch "connect \"$host\" $port" result]} {
      error $result
    }
  }

  # The global variable mobal(outFd) contains the file
  # descriptor that we use to communicate.
  set mobal(outFd) $result

  # This establishes a Tcl procedure that is called when
  # receive something at the communication channel. The
  # procedure that is called is named PrologRead.
  #  This is the old (unused version)
  #  eval $mobal(socketPrefix)filehandler $mobal(outFd) r PrologRead
  eval $mobal(socketPrefix)filehandler $mobal(outFd) r tkmobal_tcpreceive

  # Talk to the prolog interpreter and tell him we are here.
  puts $mobal(outFd) "interface."
}


# Procedure: PrologList
proc PrologList { args} {
  # Prepare a string for sending to prolog.
  # This string is handled as a prolog list.
  # args - the list elements to convert

  set result "\["
  # Walk through all list elements, and append them.
  for {set counter 0} {$counter < [llength $args]} {incr counter} {
    if {$counter == [expr [llength $args]-1]} {
      append result "[lindex $args $counter]"
    } {
      append result "[lindex $args $counter],"
    }
  }
  # Enclose list into []
  append result "\]"
  return $result
}


# Procedure: PrologListener
proc PrologListener {} {
# xf ignore me 5
##########
# Procedure: PrologListener
# Description: show a box where prolog commands can be evaluated
# Arguments: none
# Returns: none
# Sideeffects: may be everything...
##########
#
# global prologListener(activeBackground) - active background color
# global prologListener(activeForeground) - active foreground color
# global prologListener(background) - background color
# global prologListener(font) - text font
# global prologListener(foreground) - foreground color
# global prologListener(scrollActiveForeground) - scrollbar active background color
# global prologListener(scrollBackground) - scrollbar background color
# global prologListener(scrollForeground) - scrollbar foreground color
# global prologListener(scrollSide) - side where scrollbar is located

  global prologListener
  # The global variables of mobal.
  global mobal

  # initialize parameters
  set result [MiscMakeWindowName .xfmobalStack prologlistener]
  set pathName [lindex $result 0]
  set tmpTitle [lindex $result 1]
  set tmpCounter [lindex $result 2]

  # prepare widget configuration strings
  set tmpButtonOpt ""
  set tmpFrameOpt ""
  set tmpMessageOpt ""
  set tmpScrollOpt ""
  if {"$prologListener(activeBackground)" != ""} {
    append tmpButtonOpt "-activebackground \"$prologListener(activeBackground)\" "
  }
  if {"$prologListener(activeForeground)" != ""} {
    append tmpButtonOpt "-activeforeground \"$prologListener(activeForeground)\" "
  }
  if {"$prologListener(background)" != ""} {
    append tmpButtonOpt "-background \"$prologListener(background)\" "
    append tmpFrameOpt "-background \"$prologListener(background)\" "
    append tmpMessageOpt "-background \"$prologListener(background)\" "
  }
  if {"$prologListener(font)" != ""} {
    append tmpButtonOpt "-font \"$prologListener(font)\" "
    append tmpMessageOpt "-font \"$prologListener(font)\" "
  }
  if {"$prologListener(foreground)" != ""} {
    append tmpButtonOpt "-foreground \"$prologListener(foreground)\" "
    append tmpMessageOpt "-foreground \"$prologListener(foreground)\" "
  }
  if {"$prologListener(scrollActiveForeground)" != ""} {
    append tmpScrollOpt "-activeforeground \"$prologListener(scrollActiveForeground)\" "
  }
  if {"$prologListener(scrollBackground)" != ""} {
    append tmpScrollOpt "-background \"$prologListener(scrollBackground)\" "
  }
  if {"$prologListener(scrollForeground)" != ""} {
    append tmpScrollOpt "-foreground \"$prologListener(scrollForeground)\" "
  }

  # start build of toplevel
  if {"[info commands XFDestroy]" != ""} {
    catch "XFDestroy $pathName"
  } {
    catch "destroy $pathName"
  }
  toplevel $pathName  -borderwidth 0
  MiscPlaceWindowPrepare $pathName prologlistener
  catch "$pathName config $tmpFrameOpt"
  wm protocol $pathName WM_DELETE_WINDOW "ViewDestroy $pathName prologlistener $tmpCounter"
  wm geometry $pathName 420x300
  wm title $pathName $tmpTitle
  # end build of toplevel

  frame $pathName.frame1 -borderwidth 2 -relief raised
  catch "$pathName.frame1 config $tmpFrameOpt"
 
  button $pathName.frame1.ok -text "Close" -width 9 -command "
    ViewDestroy $pathName prologlistener $tmpCounter"
  catch "$pathName.frame1.ok config $tmpButtonOpt"

  button $pathName.frame1.send  -text "Enter"  -width 9 -command "
    set mobal(lastProlog) \[string trim \[$pathName.text1.text1 get 1.0 end\]\]
    $pathName.text1.text1 delete 1.0 end
    $pathName.log.log insert end \"?- \$mobal(lastProlog)\\n\"
    set mobal(lastProlog) \[PrologStringPrepare \$mobal(lastProlog)\]
    append mobal(lastLog) \"?- \$mobal(lastProlog)\\n\"
    if {\[catch \"PrologSendInternal \{term(mobal_prolog_listener(\\\"\$mobal(lastProlog)\\\")).\}\" result\]} {
      if {\"\[info commands AlertBox\]\" != \"\"} {
        AlertBox \"\$result\"
      } {
        puts stderr \"\$result\"
      }
    } {
      catch \"$pathName.log.log insert end \{:- \[lindex \$result 0\]\\n\}\"
      append mobal(lastLog) \":- \[lindex \$result 0\]\\n\"
    }"
  catch "$pathName.frame1.send config $tmpButtonOpt"
 
  button $pathName.frame1.clearLog -text "Clear Log" -width 9 -command "set mobal(lastLog) \"\"; $pathName.log.log delete 1.0 end"
  catch "$pathName.frame1.clearLog config $tmpButtonOpt"

  button $pathName.frame1.help -text "Help" -width 9 -command {MobalFileHelp prologListener}
  catch "$pathName.frame1.help config $tmpButtonOpt"

  button $pathName.frame1.clear -text "Clear" -width 9 -command "set mobal(lastProlog) \"\"; $pathName.text1.text1 delete 1.0 end"
  catch "$pathName.frame1.clear config $tmpButtonOpt"

  frame $pathName.log -borderwidth 0 -relief raised
  catch "$pathName.log config $tmpFrameOpt"
 
  frame $pathName.log.title -borderwidth 0 -relief raised
  catch "$pathName.log.title config $tmpFrameOpt"
 
  label $pathName.log.title.label -relief raised -text {Logging:}
  catch "$pathName.log.title.label config $tmpMessageOpt"

  button $pathName.log.title.small -relief raised  -text {Smaller} -command "$pathName.log.log config -height \[expr \[lindex \[$pathName.log.log config -height\] 4\]-1\]"
  catch "$pathName.log.title.small config $tmpButtonOpt"

  button $pathName.log.title.big -relief raised  -text {Bigger} -command "$pathName.log.log config -height \[expr \[lindex \[$pathName.log.log config -height\] 4\]+1\]"
  catch "$pathName.log.title.big config $tmpButtonOpt"

  scrollbar $pathName.log.scrollbar1 -command "$pathName.log.log yview" -relief "raised"
  catch "$pathName.log.scrollbar1 config $tmpScrollOpt"

  text $pathName.log.log -borderwidth "2" -exportselection "true" -insertbackground "blue" -height 5 -relief "raised" -yscrollcommand "$pathName.log.scrollbar1 set"
  catch "$pathName.log.log config $tmpMessageOpt"

  bind $pathName.log.log <Any-KeyPress> "NoFunction"
  bind $pathName.log.log <Double-Button-1> "
    set xfPosition \[$pathName.log.log index @%x,%y\]
    set xfLog \[$pathName.log.log get 1.0 end\]
    set xfCounter 0
    set xfLine 1
    while {\$xfLine < \[lindex \[split \$xfPosition .\] 0\]} {
      if {\"\[string index \$xfLog \$xfCounter\]\" == \"\\n\"} {
        incr xfLine
      }
      incr xfCounter
    }
    incr xfCounter \[lindex \[split \$xfPosition .\] 1\]
    set xfFrom \$xfCounter
    while {\$xfFrom > 0 &&
           !(\"\[string index \$xfLog \$xfFrom\]\" == \"?\" &&
             \"\[string index \$xfLog \[expr \$xfFrom+1\]\]\" == \"-\")} {
      incr xfFrom -1
    }
    set xfTo \$xfCounter
    while {\$xfTo < \[string length \$xfLog\] &&
           !(\"\[string index \$xfLog \[expr \$xfTo-1\]\]\" == \":\" &&
             \"\[string index \$xfLog \$xfTo\]\" == \"-\")} {
      incr xfTo
    }
    set mobal(lastProlog) \[string range \$xfLog \[expr \$xfFrom+2\] \[expr \$xfTo-2\]\]
    $pathName.text1.text1 delete 1.0 end
    $pathName.text1.text1 insert end \"\[string trim \$mobal(lastProlog)\]\\n\""

  frame $pathName.text1 -borderwidth 0 -relief raised
  catch "$pathName.text1 config $tmpFrameOpt"
 
  label $pathName.text1.label -relief raised -text {Enter prolog command:}
  catch "$pathName.text1.label config $tmpMessageOpt"

  scrollbar $pathName.text1.scrollbar1 -command "$pathName.text1.text1 yview" -relief "raised"
  catch "$pathName.text1.scrollbar1 config $tmpScrollOpt"

  text $pathName.text1.text1 -borderwidth "2" -exportselection "true" -insertbackground "blue" -height 2 -relief "raised" -yscrollcommand "$pathName.text1.scrollbar1 set"
  catch "$pathName.text1.text1 config $tmpMessageOpt"

  $pathName.log.log insert end $mobal(lastLog)
  $pathName.text1.text1 insert end $mobal(lastProlog)

  bind $pathName.text1.text1 <Control-Return> "
    set mobal(lastProlog) \[string trim \[$pathName.text1.text1 get 1.0 end\]\]
    $pathName.text1.text1 delete 1.0 end
    $pathName.log.log insert end \"?- \$mobal(lastProlog)\\n\"
    set mobal(lastProlog) \[PrologStringPrepare \$mobal(lastProlog)\]
    append mobal(lastLog) \"?- \$mobal(lastProlog)\\n\"
    if {\[catch \"PrologSendInternal \{term(mobal_prolog_listener(\\\"\$mobal(lastProlog)\\\")).\}\" result\]} {
      if {\"\[info commands AlertBox\]\" != \"\"} {
        AlertBox \"\$result\"
      } {
        puts stderr \"\$result\"
      }
    } {
      catch \"$pathName.log.log insert end \{:- \[lindex \$result 0\]\\n\}\"
      append mobal(lastLog) \":- \[lindex \$result 0\]\\n\"
    }"

  # packing
  pack append $pathName.log.title $pathName.log.title.label {left fill expand} $pathName.log.title.small {left} $pathName.log.title.big {left}
  pack append $pathName.log $pathName.log.title {top fill} $pathName.log.scrollbar1 "$prologListener(scrollSide) filly" $pathName.log.log {top expand fill}
  pack append $pathName.frame1 $pathName.frame1.send {left expand padx 6 pady 6} $pathName.frame1.help {left expand padx 6 pady 6} $pathName.frame1.clear {left expand padx 6 pady 6} $pathName.frame1.clearLog {left expand padx 6 pady 6} $pathName.frame1.ok {left expand padx 6 pady 6} 
  pack append $pathName.text1 $pathName.text1.label {top fill} $pathName.text1.scrollbar1 "$prologListener(scrollSide) filly" $pathName.text1.text1 {top expand fill}
  pack append $pathName $pathName.frame1 {bottom fill} $pathName.text1 {bottom fill expand} $pathName.log {bottom fill}

  XFLocalSetAppDefs $pathName

  MiscPlaceWindow $pathName prologlistener
}


# Procedure: PrologRead
proc PrologRead { condition fileId} {
  # This procedure is called when there is pending data.
  # condition - this is alway "r", because we 
  #             created this filehandler for
  #             reading only
  # fileId - the file id where the data is pending

  # Input box parameters.
  global inputBox
  # The global variables of mobal.
  global mobal

  # The hci command.
  set hci_command 0

  # Read the first line from the file descriptor.
  if {[catch "gets $fileId" readData]} {
    # Ohh... an error... we abort the communication!
    # this means we remove the filehandler, and close 
    # the filedescriptor.
    catch "$mobal(socketPrefix)filehandler $fileId"
    catch "close $fileId"
    return
  }
  if {"$readData" == ""} {
    # We got an empty line... probably the end of the
    # communication.
    if {[eof $fileId]} {
      # It is the eof! this means we remove the 
      # filehandler, and close the filedescriptor.
      catch "$mobal(socketPrefix)filehandler $fileId"
      catch "close $fileId"
    }
    # A single empty line is ignored.
    return
  }

  # Until we get nothing new on the file descriptor
  # read all the lines and parse them.
  while {1} {
    if {[MiscGetDebugging]} {
      puts stderr "read: $readData"
    }
    if {"$readData" != ""} {
      # Something interesting was received. The
      # following case statement maps the received
      # string to the supported commands. This means
      # we set hci_command to the correct value to
      # remember the received command, and then
      # append the received string to the command/data
      # buffer (mobal(result)).
      case $readData in {
        {mobal_ready*} {
          set hci_command 1
        }
        {hci_yes_or_no_p*} {
          set hci_command 2
          append mobal(tmpReadResult) $readData
        }
        {hci_alert*} {
          set hci_command 3
          append mobal(tmpReadResult) $readData
        }
        {hci_button_menu_choose*} {
          set hci_command 4
          append mobal(tmpReadResult) $readData
        }
        {hci_list_menu_choose*} {
          set hci_command 5
          append mobal(tmpReadResult) $readData
        }
        {hci_prompt_and_read*} {
          set hci_command 6
          append mobal(tmpReadResult) $readData
        }
        {hci_add_item*} {
          set hci_command 7
          append mobal(tmpReadResult) $readData
        }
        {hci_delete_item*} {
          set hci_command 8
          append mobal(tmpReadResult) $readData
        }
        {hci_graph*} {
          set hci_command 9
          append mobal(tmpReadResult) $readData
        }
        {hci_knowledge*} {
          set hci_command 10
          append mobal(tmpReadResult) $readData
        }
        {hci_edit_predvar_restriction*} {
          set hci_command 11
          append mobal(tmpReadResult) $readData
        }
        {hci_recompute_type*} {
          set hci_command 12
          append mobal(tmpReadResult) $readData
        }
        {hci_bell*} {
          set hci_command 13
          append mobal(tmpReadResult) $readData
        }
        {default} {
          append mobal(tmpReadResult) "$readData\n"
        }
      }
    } {
      # The end of the transmission is reached. Now we 
      # can perform the requested action (according to
      # hci_command). If no command was specified, we
      # are currently receiving the result of a prolog
      # command evaluated in the prolog interpreter.
      if {[MiscGetDebugging]} {
        puts stderr "command $hci_command read data $mobal(tmpReadResult)"
      }
      if {$hci_command != 1} {
        if {$hci_command == 0} {
          set mobal(result) [lreplace $mobal(tmpReadResult) 0 0]
	} {
          set mobal(request) [lreplace $mobal(tmpReadResult) 0 0]
	}
        set mobal(tmpReadResult) ""
      }
      case $hci_command in {
        {1} {
          # Set TkMobal status back to ready.
          if {[MiscGetDebugging]} {
            puts stderr "set ready"
          }
          PrologSetReady
        }
        {2} {
          # Display a yes/no box, and write the result
          # to the prolog interpreter. The first parameter
          # is the label of the box, the second parameter
          # is the yes button label, and the last parameter
          # is the no button label.
          set hci_return [YesNoBox [lindex $mobal(request) 0] "" [lindex $mobal(request) 1] [lindex $mobal(request) 2]]
          puts $mobal(outFd) "term(hci_yes_or_no_p([PrologAtom $hci_return]))."
	}
        {3} {
          # Display a alert box, and write the result
          # to the prolog interpreter. The first parameter
          # is the label of the box.
          AlertBox [lindex $mobal(request) 0]
          puts $mobal(outFd) "term(hci_alert([PrologAtom ok]))."
	}
        {4} {
          # Display a button choose box, and write the result
          # to the prolog interpreter. The first parameter
          # is the label of the box, the second parameter
          # is a list of selectable items. The item is displayed
          # as button text, and is returned on press.
          set hci_return [ButtonChoose [lindex $mobal(request) 0] [lindex $mobal(request) 1]]
          puts $mobal(outFd) "term(hci_button_menu_choose([PrologString $hci_return]))."
	}
        {5} {
          # Display a list choose box, and write the result
          # to the prolog interpreter. The first parameter
          # is the label of the box, the second parameter
          # is a list of selectable items. The item is displayed
          # as list item, and is returned on press.
          if {[llength $mobal(request)] ==  2} {
            set hci_return [ListChoose [lindex $mobal(request) 0] [lindex $mobal(request) 1]]
	  } {
            set hci_return [ListChoose [lindex $mobal(request) 0] [lindex $mobal(request) 1] [lindex $mobal(request) 2]]
	  }
          puts $mobal(outFd) "term(hci_list_menu_choose([PrologString $hci_return]))."
	}
        {6} {
          # Display a input box, and write the result
          # to the prolog interpreter. The first parameter
          # is the label of the box, the second parameter
          # is a optional default value. The third parameter 
          # is the optional prolog check command.
          set {inputBox(erase)} {0}
          set {inputBox(toplevelName)} .inputBox$mobal(inputCounter)
          incr mobal(inputCounter)
          set inputBox($inputBox(toplevelName),inputMulti) "" 
          if {[llength $mobal(request)] >= 2} {
            set inputBox($inputBox(toplevelName),inputMulti) [lindex $mobal(request) 1]
	  }
          if {[llength $mobal(request)] == 3} {
            set inputBox(checkCommand) "MiscReadAndPromptCheck [lindex $mobal(request) 2]"
          }
          after 1 "
            InputBoxMulti \{[lindex $mobal(request) 0]\} 
            set inputBox(checkCommand) {}
            if {\$inputBox($inputBox(toplevelName),canceled)} {
              puts $\mobal(outFd) {term(hci_prompt_and_read([PrologAtom cancel])).}
            }"
	}
        {7} {
          # A new item was added to the knowledge base. This
          # event is created by mobal. The first parameter
          # specifies the type of the new item (rule, fact etc.).
          # The second parameter is the value of the new item,
          # and the last parameter is the mobal id of this item.
          MobalAddItem [lindex $mobal(request) 0] [lindex $mobal(request) 1] [lindex $mobal(request) 2]
	}
        {8} {
          # A item was deleted from the knowledge base. This
          # event is created by mobal. The first parameter
          # specifies the type of the new item (rule, fact etc.).
          # The second parameter is the mobal id of this item.
          MobalDeleteItem [lindex $mobal(request) 0] [lindex $mobal(request) 1]
	}
        {9} {
          # A item has to be displayed as a graph. The first
          # parameter is the type of the view, and the second
          # argument is the item id to display. The third is
          # the list of edges.
          if {"[lindex $mobal(request) 1]" != "" &&
              "[lindex $mobal(request) 2]" != ""} {
            GraphCreateWindow [lindex $mobal(request) 0] [lindex $mobal(request) 1] "" [lindex $mobal(request) 2]
	  }
	}
        {10} {
          # A knowledge revision was requested. The first
          # parameter is the list of items to revise. The
          # second parameter is the removal set.
          after 1 "MobalViewKnowledge \{$mobal(request)\}"
	}
        {11} {
          # A meta predicate revision was requested. The first
          # parameter is the meta predicate to revise. The
          # second parameter is the predicate restriction list.
          MobalViewMetaPredicate [lindex $mobal(request) 0] [lindex $mobal(request) 1]
	}
        {12} {
          # Update the specified view type.
          MobalUpdateLocalLists [lindex $mobal(request) 0] [lindex $mobal(request) 1]
        }
        {13} {
          # Ring the bell.
          MiscBell
        }
      }
      if {$hci_command == 0 || $hci_command == 1} {
        # Continue the blocked processing in PrologSend.
        set mobal(blocking) 0
      }
      # Ok we are finished with this command... return.
      return
    }
    # Read the next message line.
    if {[catch "gets $fileId" readData]} {
      # Ohh... an error... we abort the communication!
      # this means we remove the filehandler, and close 
      # the filedescriptor.
      catch "$mobal(socketPrefix)filehandler $fileId"
      catch "close $fileId"
      return
    }
  }
}


# Procedure: PrologSend
proc PrologSend { command args} {
  # This procedure prepares a command for sending.
  # command - the command to evaluate
  # args - the prolog command

  # Are there any parameters ?
  if {[llength $args] == 0} {
    set result "term($command)."
  } {
    # Append the required prefix.
    set result "term(${command}("
    # Walk through parameters, and append them.
    for {set counter 0} {$counter < [llength $args]} {incr counter} {
      if {$counter == [expr [llength $args]-1]} {
        append result "[lindex $args $counter]"
      } {
        append result "[lindex $args $counter],"
      }
    }
    # Append the required postfix.
    append result "))."
  }

  # Send the prolog command.
  return [string trim [PrologSendInternal $result]]
}


# Procedure: PrologSendForce
proc PrologSendForce { command args} {
  # This procedure prepares a command for sending.
  # command - the command to evaluate
  # args - the prolog command

  # Are there any parameters ?
  if {[llength $args] == 0} {
    set result "term($command)."
  } {
    # Append the required prefix.
    set result "term(${command}("
    # Walk through parameters, and append them.
    for {set counter 0} {$counter < [llength $args]} {incr counter} {
      if {$counter == [expr [llength $args]-1]} {
        append result "[lindex $args $counter]"
      } {
        append result "[lindex $args $counter],"
      }
    }
    # Append the required postfix.
    append result "))."
  }

  # Send the prolog command.
  return [string trim [PrologSendInternal $result 1]]
}


# Procedure: PrologSendInternal
proc PrologSendInternal { string {options "0"}} {
  # This procedure sends a prolog command to the
  # prolog interpreter.
  # string - the prolog command
  # forceSending - send to a running prolog.

  # The global variables of mobal.
  global mobal

  if {[MiscGetDebugging]} {
    puts stderr "send command $string"
  }
  if {"$mobal(sendStatus)" == "Running" && $options != 1} {
    # There is a running send... ignore the send request.
    return
  }
  if {[MiscGetDebugging]} {
    puts stderr "really send command"
  }

  # Set the application to status "Running".
  PrologSetRunning

  # We want to wait for a result... this variable
  # means that we will wait.
  set mobal(blocking) 1

  # Initialize the result string. 
  set mobal(result) ""

  # Send the command to the prolog interpreter.
  puts $mobal(outFd) $string
  flush $mobal(outFd)

  if {"$mobal(outFd)" != "stdout"} {
    # Here we wait for the variable "mobal(blocking)" to
    # change. The variable is changed when the complete
    # result was received in PrologRead.
    tkwait variable mobal(blocking)
  } {
    # Set the application to status "Ready". This
    # is required for debugging.
    PrologSetReady
  }
  update

  # return the result of the command evaluation.
  return $mobal(result)
}


# Procedure: PrologSetQuerying
proc PrologSetQuerying {} {
  # This procedure is setting the interface elements
  # representing the current status of the system to the
  # status "querying". This means that the system is
  # running, and the interface is in a modal state.

  # The global variables of mobal.
  global mobal

  # Set the status label.
  set mobal(status) "Querying"

  # Enable the menubuttons that give access to the
  # prolog interpreters functionality.
  .frame1.frame8.menubutton12 config -state normal
  .frame1.frame8.menubutton15 config -state normal
}


# Procedure: PrologSetReady
proc PrologSetReady { {querySet "0"}} {
  # This procedure is setting the interface elements
  # representing the current status of the system to the
  # status "ready". This means that the system is
  # running, and expects user input.
  # querySet - unset a querying mode.

  # The global variables of mobal.
  global mobal

  # Set the status label.
  if {$querySet} {
    set mobal(status) $mobal(sendStatus)
  } {
    set mobal(status) "Ready"
    set mobal(sendStatus) "Ready"
  }

  # Enable the menubuttons that give access to the
  # prolog interpreters functionality.
  .frame1.frame8.menubutton12 config -state normal
  .frame1.frame8.menubutton15 config -state normal
}


# Procedure: PrologSetRunning
proc PrologSetRunning {} {
  # This procedure is setting the interface elements
  # representing the current status of the system to the
  # status "running". This means that the system is
  # working, and the user is not allowed to interact
  # with the prolog interpreter.

  # The global variables of mobal.
  global mobal

  # Set the status label.
  set mobal(status) "Running"
  set mobal(sendStatus) "Running"

  # Disable the menubuttons that give access to the
  # prolog interpreters functionality.
  .frame1.frame8.menubutton12 config -state disabled
  .frame1.frame8.menubutton15 config -state disabled
  update idletask
}


# Procedure: PrologString
proc PrologString { string} {
  # Prepare a string for sending to prolog.
  # This string is handled as a prolog string.
  # string - the string to convert

  return \"[PrologStringPrepare $string]\"
}


# Procedure: PrologStringList
proc PrologStringList { args} {
  # Prepare a string for sending to prolog.
  # This string is handled as a prolog list.
  # args - the list elements to convert

  set result "\["
  # Walk through all list elements, and append them.
  for {set counter 0} {$counter < [llength $args]} {incr counter} {
    if {$counter == [expr [llength $args]-1]} {
      append result "[PrologString [lindex $args $counter]]"
    } {
      append result "[PrologString [lindex $args $counter]],"
    }
  }
  append result "\]"
  return $result
}


# Procedure: PrologStringPrepare
proc PrologStringPrepare { string} {
  # Escape special characters for the
  # given string.

  regsub -all \" $string \"\" result
  return $result
}


# Procedure: PrologStructure
proc PrologStructure { string} {
  # Prepare a structure for sending to prolog.
  # This string is handled as a prolog token.
  # string - the string to convert

  return $string
}


# Procedure: PrologStructureList
proc PrologStructureList { args} {
  # Prepare a structure for sending to prolog.
  # This string is handled as a prolog list.
  # args - the list elements to convert

  set result "\["
  # Walk through all list elements, and append them.
  for {set counter 0} {$counter < [llength $args]} {incr counter} {
    if {$counter == [expr [llength $args]-1]} {
      append result "[PrologStructure [lindex $args $counter]]"
    } {
      append result "[PrologStructure [lindex $args $counter]],"
    }
  }
  append result "\]"
  return $result
}


# Procedure: PrologWaitBeforeSend
proc PrologWaitBeforeSend { counter} {
  # This procedure waits until sending is done, and returns
  # after that. This implements a simple queue. Right now
  # I am not sure whether or not I have to implement a real
  # queue... so I first try without...
  # queue - the queue id for this command

  # The global variables of mobal.
  global mobal

  while {"$mobal(sendStatus)" == "Running"} {
    # There is a running send... loop until the request
    # is finished.
    update
  }
  return
}


# Procedure: ReadBox
proc ReadBox {} {
# xf ignore me 5
##########
# Procedure: ReadBox
# Description: show a box where tcl code can be entered and
#              evaluated
# Arguments: none
# Returns: none
# Sideeffects: may be everything...
##########
#
# global readBox(activeBackground) - active background color
# global readBox(activeForeground) - active foreground color
# global readBox(background) - background color
# global readBox(font) - text font
# global readBox(foreground) - foreground color
# global readBox(scrollActiveForeground) - scrollbar active background color
# global readBox(scrollBackground) - scrollbar background color
# global readBox(scrollForeground) - scrollbar foreground color
# global readBox(scrollSide) - side where scrollbar is located

  global readBox

  # prepare widget configuration strings
  set tmpButtonOpt ""
  set tmpFrameOpt ""
  set tmpMessageOpt ""
  set tmpScrollOpt ""
  if {"$readBox(activeBackground)" != ""} {
    append tmpButtonOpt "-activebackground \"$readBox(activeBackground)\" "
  }
  if {"$readBox(activeForeground)" != ""} {
    append tmpButtonOpt "-activeforeground \"$readBox(activeForeground)\" "
  }
  if {"$readBox(background)" != ""} {
    append tmpButtonOpt "-background \"$readBox(background)\" "
    append tmpFrameOpt "-background \"$readBox(background)\" "
    append tmpMessageOpt "-background \"$readBox(background)\" "
  }
  if {"$readBox(font)" != ""} {
    append tmpButtonOpt "-font \"$readBox(font)\" "
    append tmpMessageOpt "-font \"$readBox(font)\" "
  }
  if {"$readBox(foreground)" != ""} {
    append tmpButtonOpt "-foreground \"$readBox(foreground)\" "
    append tmpMessageOpt "-foreground \"$readBox(foreground)\" "
  }
  if {"$readBox(scrollActiveForeground)" != ""} {
    append tmpScrollOpt "-activeforeground \"$readBox(scrollActiveForeground)\" "
  }
  if {"$readBox(scrollBackground)" != ""} {
    append tmpScrollOpt "-background \"$readBox(scrollBackground)\" "
  }
  if {"$readBox(scrollForeground)" != ""} {
    append tmpScrollOpt "-foreground \"$readBox(scrollForeground)\" "
  }

  # build widget structure

  # start build of toplevel
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy .readBox}
  } {
    catch {destroy .readBox}
  }
  toplevel .readBox -borderwidth 0
  MiscPlaceWindowPrepare .readBox read
  catch ".readBox config $tmpFrameOpt"
  wm title .readBox {Read TCL commands}
  wm geometry .readBox 400x250
  # end build of toplevel

  frame .readBox.frame1 -borderwidth 2 -relief raised
  catch ".readBox.frame1 config $tmpFrameOpt"
 
  button .readBox.frame1.send -text "Send" -width 8 -command {
      if {[catch "[string trim [.readBox.text1.text1 get 1.0 end]]" result]} {
        if {"[info commands AlertBox]" != ""} {
          AlertBox "$result"
        } {
          puts stderr "$result"
        }
      }
      flush stderr
      flush stdout}
  catch ".readBox.frame1.send config $tmpButtonOpt"

  button .readBox.frame1.sendAndClear -text "Send + Clear" -width 14 -command {
      if {[catch "[string trim [.readBox.text1.text1 get 1.0 end]]" result]} {
        if {"[info commands AlertBox]" != ""} {
          AlertBox "$result"
        } {
          puts stderr "$result"
        }
      }
      flush stderr
      flush stdout
      .readBox.text1.text1 delete 1.0 end}
  catch ".readBox.frame1.sendAndClear config $tmpButtonOpt"

  button .readBox.frame1.clear -text "Clear" -width 8 -command {.readBox.text1.text1 delete 1.0 end}
  catch ".readBox.frame1.clear config $tmpButtonOpt"

  button .readBox.frame1.ok -text "Close" -width 8 -command {
      if {"[info commands XFDestroy]" != ""} {
        catch {XFDestroy .readBox}
      } {
        catch {destroy .readBox}
      }}
  catch ".readBox.frame1.ok config $tmpButtonOpt"

  frame .readBox.text1  -borderwidth 0  -relief raised
  catch ".readBox.text1 config $tmpFrameOpt"
 
  scrollbar .readBox.text1.scrollbar1 -command {.readBox.text1.text1 yview} -relief "raised"
  catch ".readBox.text1.scrollbar1 config $tmpScrollOpt"

  text .readBox.text1.text1 -borderwidth "2" -exportselection "true" -insertbackground "blue" -relief "raised" -yscrollcommand ".readBox.text1.scrollbar1 set"
  catch ".readBox.text1.text1 config $tmpMessageOpt"

  # packing
  pack append .readBox.frame1 .readBox.frame1.send {left expand padx 6 pady 6}  .readBox.frame1.sendAndClear {left expand padx 6 pady 6} .readBox.frame1.clear {left expand padx 6 pady 6} .readBox.frame1.ok {left expand padx 6 pady 6}
  pack append .readBox.text1 .readBox.text1.scrollbar1 "$readBox(scrollSide) filly"  .readBox.text1.text1 {top expand fill}
  pack append .readBox .readBox.frame1 {bottom fill} .readBox.text1 {bottom fill expand}

  XFLocalSetAppDefs .readBox

  MiscPlaceWindow .readBox read
}


# Procedure: SN
if {"[info procs SN]" == ""} {
proc SN { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SN
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  SymbolicName $xfName
}
}


# Procedure: SymbolicName
if {"[info procs SymbolicName]" == ""} {
proc SymbolicName { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SymbolicName
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  global symbolicName

  if {"$xfName" != ""} {
    set xfArrayName ""
    append xfArrayName symbolicName ( $xfName )
    if {![catch "set \"$xfArrayName\"" xfValue]} {
      return $xfValue
    } {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "Unknown symbolic name:\n$xfName"
      } {
        puts stderr "XF error: unknown symbolic name:\n$xfName"
      }
    }
  }
  return ""
}
}


# Procedure: TextBox
proc TextBox { {textBoxMessage "Text message"} {textBoxCommand ""} {textBoxGeometry ""} {textBoxTitle "Text box"} args} {
# xf ignore me 5
##########
# Procedure: TextBox
# Description: show text box
# Arguments: {textBoxMessage} - the text to display
#            {textBoxCommand} - the command to call after ok
#            {textBoxGeometry} - the geometry for the window
#            {textBoxTitle} - the title for the window
#            {args} - labels of buttons
# Returns: The number of the selected button, or nothing
# Sideeffects: none
# Notes: there exist also functions called:
#          TextBoxFile - to open and read a file automatically
#          TextBoxFd - to read from an already opened filedescriptor
##########
#
# global textBox(activeBackground) - active background color
# global textBox(activeForeground) - active foreground color
# global textBox(background) - background color
# global textBox(font) - text font
# global textBox(foreground) - foreground color
# global textBox(scrollActiveForeground) - scrollbar active background color
# global textBox(scrollBackground) - scrollbar background color
# global textBox(scrollForeground) - scrollbar foreground color
# global textBox(scrollSide) - side where scrollbar is located

  global textBox

  # Initialize the parameters
  set result [MiscMakeWindowName .xfmobalStack text]
  set textBox(toplevelName) [lindex $result 0]
  set tmpTitle [lindex $result 1]
  set tmpCounter [lindex $result 2]

  # prepare widget configuration strings
  set tmpButtonOpt ""
  set tmpFrameOpt ""
  set tmpMessageOpt ""
  set tmpScrollOpt ""
  if {"$textBox(activeBackground)" != ""} {
    append tmpButtonOpt "-activebackground \"$textBox(activeBackground)\" "
  }
  if {"$textBox(activeForeground)" != ""} {
    append tmpButtonOpt "-activeforeground \"$textBox(activeForeground)\" "
  }
  if {"$textBox(background)" != ""} {
    append tmpButtonOpt "-background \"$textBox(background)\" "
    append tmpFrameOpt "-background \"$textBox(background)\" "
    append tmpMessageOpt "-background \"$textBox(background)\" "
  }
  if {"$textBox(font)" != ""} {
    append tmpButtonOpt "-font \"$textBox(font)\" "
    append tmpMessageOpt "-font \"$textBox(font)\" "
  }
  if {"$textBox(foreground)" != ""} {
    append tmpButtonOpt "-foreground \"$textBox(foreground)\" "
    append tmpMessageOpt "-foreground \"$textBox(foreground)\" "
  }
  if {"$textBox(scrollActiveForeground)" != ""} {
    append tmpScrollOpt "-activeforeground \"$textBox(scrollActiveForeground)\" "
  }
  if {"$textBox(scrollBackground)" != ""} {
    append tmpScrollOpt "-background \"$textBox(scrollBackground)\" "
  }
  if {"$textBox(scrollForeground)" != ""} {
    append tmpScrollOpt "-foreground \"$textBox(scrollForeground)\" "
  }

  # start build of toplevel
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy $textBox(toplevelName)}
  } {
    catch {destroy $textBox(toplevelName)}
  }
  toplevel $textBox(toplevelName)  -borderwidth 0
  MiscPlaceWindowPrepare $textBox(toplevelName) text
  catch "$textBox(toplevelName) config $tmpFrameOpt"
  wm protocol $textBox(toplevelName) WM_DELETE_WINDOW "ViewDestroy $textBox(toplevelName) text $tmpCounter"
  if {"$textBoxGeometry" != ""} {
    if {[catch "wm geometry $textBox(toplevelName) $textBoxGeometry"]} {
      wm geometry $textBox(toplevelName) 400x200
    }
  }
  wm title $textBox(toplevelName) "$tmpTitle"
  # end build of toplevel

  # the text area
  frame $textBox(toplevelName).frame0 -borderwidth 0 -relief raised
  catch "$textBox(toplevelName).frame0 config $tmpFrameOpt"

  text $textBox(toplevelName).frame0.text1 -relief raised -wrap char -borderwidth 2 -yscrollcommand "$textBox(toplevelName).frame0.vscroll set" -width 0 -heigh 0
  catch "$textBox(toplevelName).frame0.text1 config $tmpMessageOpt"

  scrollbar $textBox(toplevelName).frame0.vscroll -relief raised -command "$textBox(toplevelName).frame0.text1 yview"
  catch "$textBox(toplevelName).frame0.vscroll config $tmpScrollOpt"

  # the button area
  frame $textBox(toplevelName).frame1 -borderwidth 2 -relief raised
  catch "$textBox(toplevelName).frame1 config $tmpFrameOpt"

  # the buttons
  set textBoxCounter 0
  set buttonNum [llength $args]
  if {$buttonNum > 0} {
    while {$textBoxCounter < $buttonNum} {
      button $textBox(toplevelName).frame1.button$textBoxCounter -text "[lindex $args $textBoxCounter]" -command "
          global textBox
          set textBox(button) $textBoxCounter
          set textBox(contents) \[$textBox(toplevelName).frame0.text1 get 1.0 end\]
          ViewDestroy $textBox(toplevelName) text $tmpCounter"
      catch "$textBox(toplevelName).frame1.button$textBoxCounter config $tmpButtonOpt"

      pack append $textBox(toplevelName).frame1 $textBox(toplevelName).frame1.button$textBoxCounter {left expand padx 6 pady 6}

      incr textBoxCounter
    }
  } {
    button $textBox(toplevelName).frame1.button0 -text "OK" -width 5 -command "
        global textBox
        set textBox(button) 0
        set textBox(contents) \[$textBox(toplevelName).frame0.text1 get 1.0 end\]
        ViewDestroy $textBox(toplevelName) text $tmpCounter
        $textBoxCommand"
    catch "$textBox(toplevelName).frame1.button0 config $tmpButtonOpt"

    pack append $textBox(toplevelName).frame1 $textBox(toplevelName).frame1.button0 {left expand padx 6 pady 6}
  }

  $textBox(toplevelName).frame0.text1 insert end "$textBoxMessage"

  $textBox(toplevelName).frame0.text1 config -state $textBox(state)

  # packing
  pack append $textBox(toplevelName).frame0 $textBox(toplevelName).frame0.vscroll "$textBox(scrollSide) filly" $textBox(toplevelName).frame0.text1 {left fill expand}
  pack append $textBox(toplevelName) $textBox(toplevelName).frame1 {bottom fill}  $textBox(toplevelName).frame0 {top fill expand}

  XFLocalSetAppDefs $textBox(toplevelName)

#  MiscPlaceWindow $textBox(toplevelName) text

  if {"$textBoxGeometry" == ""} {
    if {[winfo width $textBox(toplevelName)] < 404 &&
        [winfo height $textBox(toplevelName)] >= 200} {
      wm geometry $textBox(toplevelName) 404x[winfo height $textBox(toplevelName)]
    } {
      if {[winfo width $textBox(toplevelName)] >= 404 &&
          [winfo height $textBox(toplevelName)] < 200} {
        wm geometry $textBox(toplevelName) [winfo width $textBox(toplevelName)]x200
      } {
        if {[winfo width $textBox(toplevelName)] < 404 &&
            [winfo height $textBox(toplevelName)] < 200} {
          wm geometry $textBox(toplevelName) 404x200
        }
      }
    }
  }

  MiscPlaceWindow $textBox(toplevelName) text

  if {[llength $args] > 0} {
    # wait for the box to be destroyed
    update idletask
    grab $textBox(toplevelName)
    tkwait window $textBox(toplevelName)

    return $textBox(button)
  } {
    return $textBox(toplevelName)
  }
}


# Procedure: Unalias
if {"[info procs Unalias]" == ""} {
proc Unalias { aliasName} {
# xf ignore me 7
##########
# Procedure: Unalias
# Description: remove an alias for a procedure
# Arguments: aliasName - the alias name to remove
# Returns: none
# Sideeffects: internalAliasList is updated, and the alias
#              proc is removed
##########
  global internalAliasList

  set xfIndex [lsearch $internalAliasList "$aliasName *"]
  if {$xfIndex != -1} {
    rename $aliasName ""
    set internalAliasList [lreplace $internalAliasList $xfIndex $xfIndex]
  }
}
}


# Procedure: View
proc View { {type ""} {name ""} {tnodeName ""}} {
  # This procedure is used to display a new view.
  # type - the type of the view (e.g. rules, facts etc.)
  # name - the name of the view
  # tnodeName - the name of a topology view.

  # A list off all focus specifications attached
  # to the views.
  global mobalWindowFocus
  # A list off all sorting specifications attached
  # to the views.
  global mobalWindowSortings
  # A list where all topology views are mapped
  # to their correspinding topology type.
  global mobalTopology
  # This array contains the definitions for all
  # known view types. First comes the title for
  # the view, and then the popup menu definition.
  global mobalViewType

  set result [MiscMakeWindowName .xfmobalStack $type $name]
  set pathName [lindex $result 0]
  set tmpTitle [lindex $result 1]
  set tmpCounter [lindex $result 2]

  # Initialize the focus.
  set mobalWindowFocus($pathName) ""
  # Initialize the sorting.
  set mobalWindowSortings($pathName) "unsorted"
  # Initialize Topology mapping
  if {"$tnodeName" != ""} {
    set mobalTopology($pathName) $tnodeName
  }

  # Create the toplevel.
  toplevel $pathName
  MiscPlaceWindowPrepare $pathName type
  wm protocol $pathName WM_DELETE_WINDOW "ViewDestroy $pathName $type $tmpCounter"
  wm title $pathName $tmpTitle

  # This frame contains the list.
  frame $pathName.list -borderwidth 2 -relief raised

  # This listbox is used internally. It allows the mapping
  # of the mobal item to the mobal id.
  listbox $pathName.list.listId

  listbox $pathName.list.list  -xscrollcommand "$pathName.list.hscroll set" -yscrollcommand "$pathName.list.vscroll set"

  scrollbar $pathName.list.hscroll  -command "$pathName.list.list xview"  -orient horizontal

  scrollbar $pathName.list.vscroll  -command "$pathName.list.list yview"

  # This frame contains the controls
  frame $pathName.buttons -borderwidth 2 -relief raised

  button $pathName.buttons.newView  -command "MobalViewView $type \"$name\" \"$tnodeName\""  -text {Open New View} -width 15

  button $pathName.buttons.closeView  -command "ViewDestroy $pathName $type $tmpCounter"  -text {Close View} -width 15

  button $pathName.buttons.settings  -command "MobalViewViewSettings $type \"$name\" \"$tnodeName\" $tmpCounter"  -text {Settings...} -width 15

  # Create the view specific menu.
  menu $pathName.list.list.m

  foreach element [lindex [set mobalViewType($type)] 1] {
    $pathName.list.list.m add command  -command "ViewMenuItemCommand $pathName $type \{$element\}"  -label $element
  }

  if {"$type" != "agenda" && "$type" != "sclass"} {
    $pathName.list.list.m add separator
    $pathName.list.list.m add command  -command "ViewMenuEditItem $pathName $type"  -label Edit
  }

  # Display widget structure.
  pack append $pathName.list  $pathName.list.hscroll {bottom fill}  $pathName.list.vscroll {right fill}  $pathName.list.list {top fill expand}
  pack append $pathName.buttons  $pathName.buttons.newView {left padx 6 pady 6 expand}  $pathName.buttons.closeView {left padx 6 pady 6 expand}  $pathName.buttons.settings {left padx 6 pady 6 expand}
  pack append $pathName  $pathName.buttons {bottom fill}  $pathName.list {top fill expand}

  # Attatch the popup menu.
  MenuPopupAdd $pathName.list.list 3 $pathName.list.list.m

  # Initialize the selection handling. The procedure 
  # MiscGetCurrentSelection is called when the
  # selection is requested.
  selection handle $pathName.list.list "MiscGetCurrentSelection"

  # Handle the focus for the list. This is required to
  # allow cut&paste
  bind $pathName.list.list <Enter> "
    set mobal(listFocus) \[focus\]
    focus $pathName.list.list"
  bind $pathName.list.list <Leave> "
    focus \$mobal(listFocus)"
  # Copy current selection to selection.
  bind $pathName.list.list <Control-c> "
    set mobal(listSelection) {}
    foreach element \[%W curselect\] {
      append mobal(listSelection) \"\[$pathName.list.list get \$element\]\"
      append mobal(listSelection) \"\\n\"
    }
    set mobal(listSelection) \[string trim \$mobal(listSelection)\]
    selection own $pathName.list.list"
  bind $pathName.list.list <Meta-c> "
    set mobal(listSelection) {}
    foreach element \[%W curselect\] {
      append mobal(listSelection) \"\[$pathName.list.list get \$element\]\"
      append mobal(listSelection) \"\\n\"
    }
    set mobal(listSelection) \[string trim \$mobal(listSelection)\]
    selection own $pathName.list.list"
  # Attatch the popup menu to mouse button 3.
  bind $pathName.list.list <ButtonPress-3> "
    set curSelect \[%W curselect\]
    set nearest \[%W nearest %y\]
    if {\"\$nearest\" != \"\" && \$nearest != -1} {
      if {\"\$curSelect\" != \"\"} {
        if {\$nearest < \[lindex \$curSelect 0\] ||
            \$nearest > \[lindex \$curSelect \[expr \[llength \$curSelect\]-1\]\]} {
          %W select from \$nearest
          %W select to \$nearest
        }
      } {
        %W select from \$nearest
        %W select to \$nearest
      }
    }
    MenuPopupPost $pathName.list.list.m %X %Y"

  # Apply the X resources.
  XFLocalSetAppDefs $pathName

  # Display the appropriate view items.
  ViewReadStack $type $pathName $tnodeName

  MiscPlaceWindow $pathName $type
}


# Procedure: ViewDestroy
proc ViewDestroy { {name ""} {type ""} {counter "-1"}} {
  # This procedure remove a specified view.
  # name - the name of the view to destroy
  # type - the type of the stack
  # counter - the window number of the stack

  # A list off all counters attached to the views.
  # These counters make the views unique.
  global mobalWindowCounters
  # A list off all window names attached to the views.
  global mobalWindowNames

  # Unregister the view.
  catch "unset mobalWindowNames($name)"
  catch "unset mobalTopology($name)"
  
  # reinitialize the global counter
  if {"$counter" == "-1"} {
    foreach type [array names mobalWindowCounters] {
      set mobalWindowCounters($type) ""
    }
  } {
    set tmpElement [lsearch $mobalWindowCounters($type) $counter]
    if {$tmpElement != -1} {
      set mobalWindowCounters($type)  [lreplace $mobalWindowCounters($type) $tmpElement $tmpElement]
    }
  }

  # Destroy the toplevel.
  catch "destroy $name"
}


# Procedure: ViewMenuEditItem
proc ViewMenuEditItem { pathName type {current ""} {ids ""}} {
  # Activate a input box to edit the current object.

  # The input box configuration.
  global inputBox

  if {"$current" == "" || "$ids" == ""} {
     # Get the selected ids.
     set ids [MiscViewItemIds $pathName $type]
     set current ""
     # Walk through the current selection.
     foreach selectItem [$pathName.list.list curselect] {
       append current "[$pathName.list.list get $selectItem]\n"
     }
     set {inputBox(erase)} {0}
     set inputBox($inputBox(toplevelName),inputMulti) $current
  }

  # Are there selected ids or was the procedure called to do a redisplay ?
  if {"$current" != ""} {
       set result [InputBoxMulti "Change item:"]
       if {!$inputBox($inputBox(toplevelName),canceled)} {
         if {"$current" != "$result"} {
           set syntax [PrologSend mobal_check_scratchpad [PrologString "$type:\n$result"]]
   	if {"$syntax" == "1"} {
           PrologSend mobal_edit_items [PrologAtom $type] [eval PrologStructureList $ids] [PrologString "$type:\n$result"]
        } {
          ViewMenuEditItem $pathName $type $current $ids
        }
      }
    }
  }
}

# Procedure: ViewMenuItemCommand
proc ViewMenuItemCommand { {pathName ""} {type ""} {command ""}} {

  # Get the selected ids.
  set ids [MiscViewItemIds $pathName $type]

  # Are there selected ids ?
  if {"$ids" != ""} {
#    PrologSend mobal_menu_item_command [PrologAtom $type] [PrologAtom $command] [eval PrologStructureList $ids]
    after 1 "PrologSend mobal_menu_item_command \{[PrologAtom $type]\} \{[PrologAtom $command]\} \{[eval PrologStructureList $ids]\}"
  }
}


# Procedure: ViewParams
proc ViewParams {} {
  # This procedure is called to set tool parameters.
  # The parameters are retrieved from the prolog
  # interpreter. The dialog is automatically created.

  # The global variables of mobal.
  global mobal

  set result [MiscMakeWindowName .xfmobalStack parameter]
  set pathName [lindex $result 0]
  set tmpTitle [lindex $result 1]
  set tmpCounter [lindex $result 2]
  ViewParamsSetChanged $pathName "parameters ok"

  # Destroy previously created dialogboxes.
  if {"[info commands XFDestroy]" != ""} {
    catch "XFDestroy $pathName"
  } {
    catch "destroy $pathName"
  }
  # Create the toplevel.
  toplevel $pathName -borderwidth 0
  MiscPlaceWindowPrepare $pathName parameter
  wm protocol $pathName WM_DELETE_WINDOW "ViewDestroy $pathName parameter $tmpCounter"
  wm title $pathName "TkMobal: Parameters"

  # Create the menubar.
  frame $pathName.menu -borderwidth  2 -relief raised

  # Create the menubutton.
  menubutton $pathName.menu.menu1 -text {System Tools} -menu $pathName.menu.menu1.m

  # Create the menubutton.
  menubutton $pathName.menu.menu2 -text {Extension Tools} -menu $pathName.menu.menu2.m

  # Create the menubutton.
  menubutton $pathName.menu.menu3 -text {Settings} -menu $pathName.menu.menu3.m

  # Create the label for the parameter status
  label $pathName.menu.changed -textvariable mobal(paramsChanged)

  set mobal(background) [lindex [$pathName.menu.changed config -background] 4]
  set mobal(foreground) [lindex [$pathName.menu.changed config -foreground] 4]

  # Create the label for the toolname
  label $pathName.menu.toolName -textvariable mobal(tool)

  # Create the menu.
  menu $pathName.menu.menu1.m

  # Add the tools to the menubar. These radiobuttons toggle
  # the parameter list.
  $pathName.menu.menu1.m add radiobutton -label {hci} -variable mobal(tool) -command "ViewParamsGet $pathName"
  $pathName.menu.menu1.m add radiobutton -label {cie} -variable mobal(tool) -command "ViewParamsGet $pathName"
  $pathName.menu.menu1.m add radiobutton -label {mat} -variable mobal(tool) -command "ViewParamsGet $pathName"
  $pathName.menu.menu1.m add radiobutton -label {stt} -variable mobal(tool) -command "ViewParamsGet $pathName"
  $pathName.menu.menu1.m add radiobutton -label {pst} -variable mobal(tool) -command "ViewParamsGet $pathName"
  $pathName.menu.menu1.m add radiobutton -label {rdt} -variable mobal(tool) -command "ViewParamsGet $pathName"
  $pathName.menu.menu1.m add radiobutton -label {krt} -variable mobal(tool) -command "ViewParamsGet $pathName"
  $pathName.menu.menu1.m add radiobutton -label {clt} -variable mobal(tool) -command "ViewParamsGet $pathName"
  $pathName.menu.menu1.m add radiobutton -label {rrt} -variable mobal(tool) -command "ViewParamsGet $pathName"

  # Create the menu.
  menu $pathName.menu.menu2.m

  # Add the tools to the menubar.
  ViewParamsDisplayTools $pathName

  # Create the menu.
  menu $pathName.menu.menu3.m

  # Add the paramters to the menubar.
  $pathName.menu.menu3.m add checkbutton -label {Advanced parameters} -variable mobal(paramsLevel) -command "ViewParamsGet $pathName" -onvalue "advanced" -offvalue "basic"

  # This frame contains the parameters.
  frame $pathName.params -borderwidth  2 -relief raised

  # This label contains the name of the current parameter.
  label $pathName.label -borderwidth  2 -relief raised -text "Parameter description:"

  # This frame contains the text widget with
  # the description for the parameter.
  frame $pathName.descr -borderwidth  2 -relief raised

  scrollbar $pathName.descr.vscroll -command "$pathName.descr.descr yview"

  text $pathName.descr.descr -width 60 -height 5 -yscrollcommand "$pathName.descr.vscroll set" -wrap word

  # This frame contains the controls.
  frame $pathName.buttons -borderwidth  2 -relief raised

  button $pathName.buttons.set -text {Set Values} -width 13 -command "ViewParamsSet $pathName"

  button $pathName.buttons.default -text {Default} -width 13

  button $pathName.buttons.close -text {Close} -width 13 -command "ViewDestroy $pathName parameter $tmpCounter"

  # Display the widget tree.
  pack append $pathName.menu $pathName.menu.menu1 {left} $pathName.menu.menu2 {left} $pathName.menu.menu3 {left} $pathName.menu.changed {right} $pathName.menu.toolName {right} 
  pack append $pathName.buttons $pathName.buttons.set {left expand padx 6 pady 6} $pathName.buttons.default {left expand padx 6 pady 6} $pathName.buttons.close {left expand padx 6 pady 6}
  pack append $pathName.descr $pathName.descr.vscroll {right fill} $pathName.descr.descr {top fill expand}
  pack append $pathName $pathName.menu {top fill} $pathName.params {top fill} $pathName.label {top fill} $pathName.buttons {bottom fill} $pathName.descr {top fill expand}

  # Apply the X resources.
  XFLocalSetAppDefs $pathName

  # Clear the unresricted list
  if {[info exists mobalUnrestricted]} {
    foreach name [array names mobalUnrestricted] {
      catch "unset mobalUnrestricted($name)"
    }
  }

  # Retrieve the tool parameters.
  ViewParamsGet $pathName

  MiscPlaceWindow $pathName parameter
}


# Procedure: ViewParamsChanged
proc ViewParamsChanged { pathName name1 name2 op} {
  # This procedure is used to set the changed status
  # to reflect the current status of the parameters.
  # pathName - the parameter box pathname
  # name1 - the variable name
  # name2 - the array index
  # op - the operation

  ViewParamsSetChanged $pathName "parameters changed"
}


# Procedure: ViewParamsDisplayTools
proc ViewParamsDisplayTools { pathName} {
  # This procedure is called to set the menu for the
  # external tools. This procedure uses the global array
  # named mobal(toolList) to find the loaded tools.
  # pathName - the pathname of the parameter dialog

  # The global variables of mobal.
  global mobal

  # remove old menu items.
  catch "$pathName.menu.menu2.m delete 0 last"

  # Add the tools to the menubar. These radiobuttons toggle
  # the parameter list.
  foreach tool $mobal(toolList) {
    set toolName [lindex $tool 0]
    $pathName.menu.menu2.m add radiobutton -label $toolName -variable mobal(tool) -command "ViewParamsGet $pathName"
  }
}


# Procedure: ViewParamsGet
proc ViewParamsGet { {pathName ""}} {
  # This procedure is used to create the widgets used
  # to set the parameters for the different tools.
  # pathName - the pathname of the parameter dialog

  # The global variables of mobal.
  global mobal
  # All tool parameters are temporarily stored here.
  global mobalParameters
  # All tool parameter types are temporarily stored here.
  global mobalParameterTypes
  # This variable contains the current unrestricted selection
  # for the tool parameters.
  global mobalUnrestricted

  if {"[info commands $pathName]" == ""} {
    return
  }

  # Retrieve the list of tool parameters.
  set parameterList [PrologSend mobal_get_params [PrologAtom $mobal(tool)]]

  if {"$mobal(outFd)" == "stdout"} {
    # Debugging...
    set parameterList {{{cie} {check_constraints} {yes} {no} {oneof 1 {yes} {no}} {this is the description} {basic}} {{cie} {check_mpred_redundancy} {unrestricted} {unrestricted} {formula 1} {this is the description of the second item} {basic}} {{cie} {check_mpred_interval} {10} {20} {integer_from_to 1} {this is the description of the third item} {basic}} {{cie} {check_mpred_repeat} {100} {120} {integer_from_to 0 {100} {200}} {this is the description of the third item} {basic}} {{cie} {check_mpred_opt} {bbbbbb} {bbbbbb} {optionbutton 1 {aaaa sfsdf} {ccccc} {bbbbbb}} {bbbbbb} {this is the description of the third item} {basic}} {{cie} {check_mpred_text} {asdfsdf
sdfsdfsdf
sdfsdfsdf} {asdfsdf
sdfsdfsdf
sdfsdfsdf} {text 1} {this is the description of the text item} {advanced}} {{cie} {check_mpred_atom} {aaaa} {aaaa} {prolog_atom 1} {this is the description of the prolog item} {basic}} {{cie} {check_mpred_atom_list} {aaaa} {aaaa} {list_of_names 1} {this is the description of the atom list} {basic}} {{cie} {check_mpred_integer_ge} {10} {10} {integer_ge 0 20} {this is the description of the integer ge} {basic}} {{cie} {check_mpred_real_gt} {20.2} {20.3} {real_ge 0 19.1} {this is the description of the real ge} {basic}}}
  }

  # Walk through all currently existing tool parameter
  # setting widgets to destroy them.
  foreach child [winfo children $pathName.params] {
    # Destroy the widget.
    if {"[info commands XFDestroy]" != ""} {
      catch "XFDestroy $child"
    } {
      catch "destroy $child"
    }
  }
  # Are there any old tool parameters ?
  if {[info exists mobalParameters]} {
    # Walk through all all existing tool parameters,
    # and unset the parameters.
    foreach name [array names mobalParameters] {
      unset mobalParameters($name)
    }
    foreach name [array names mobalParameterTypes] {
      unset mobalParameterTypes($name)
    }
  }

  # This variable is used to make the widgetnames unique.
  set counter 0
  # This variable will contain all label names for later alignment.
  set labelList ""
  # This variable will contain all text fields.
  set valueList ""
  # This variable will contain the greatest label width.
  set maxLabelWidth ""
  # This string contains the command to set all parameters to default.
  set defaultCommand ""

  # Initialize the parameter description.
  $pathName.label config -text "Parameter description:"
  $pathName.descr.descr delete 1.0 end

  # Walk through all tool parameters.
  foreach parameter $parameterList {
    # Get the values describing the tool parameter.
    set parameterTool [lindex $parameter 0]
    set parameterName [lindex $parameter 1]
    set parameterValue [lindex $parameter 2]
    set parameterDefault [lindex $parameter 3]
    set parameterTypeDef [lindex $parameter 4]
    set parameterType [lindex [lindex $parameter 4] 0]
    set parameterTypeUnrestricted [lindex [lindex $parameter 4] 1]
    set parameterTypeParams [lrange [lindex $parameter 4] 2 end]
    set parameterDescr [lindex $parameter 5]
    set parameterLevel [lindex $parameter 6]

    if {"$mobal(paramsLevel)" == "basic" && "$parameterLevel" != "basic"} {
      continue
    }
    # Set the label for the parameter description
    # to the tool parameter name.
    $pathName.label config -text "Parameter description: $parameterName ($parameterType)"
    # Set the description text to the current
    # parameter description.
    $pathName.descr.descr delete 1.0 end
    $pathName.descr.descr insert end $parameterDescr

    # The pathname used for the parameter widgets.
    set tmpPathName $pathName.params.param$counter
    # Create the frame for the parameter widget.
    frame $tmpPathName
    # Create the label for the parameter.
    label $tmpPathName.label -text "$parameterName:" -anchor ne
    # When the label is entered, the parameter
    # description is set to the corresponding text.
    bind $tmpPathName.label <Enter> "
      $pathName.label config -text \{Parameter description: $parameterName ($parameterType)\}
      $pathName.descr.descr delete 1.0 end; $pathName.descr.descr insert end \{$parameterDescr\}"
    # Create the unrestricted button.
    if {"$parameterTypeUnrestricted" == "1"} {
      checkbutton $tmpPathName.unrestricted -text "Any" -variable mobalUnrestricted($parameterTool,$parameterName) -relief flat
      if {"$parameterValue" == "unrestricted"} {
        set mobalUnrestricted($parameterTool,$parameterName) 1
      } {
        set mobalUnrestricted($parameterTool,$parameterName) 0
      }
    }
    trace variable mobalUnrestricted($parameterTool,$parameterName) w "ViewParamsChanged $pathName"
    # Display the widget structure.
    pack append $tmpPathName $tmpPathName.label {left fill}
    if {"$parameterTypeUnrestricted" == "1"} {
      pack append $tmpPathName $tmpPathName.unrestricted {left frame n}
    }
    pack append $pathName.params $tmpPathName {top fill}
    lappend labelList $tmpPathName.label
    if {[string length "$parameterName:"] > $maxLabelWidth} {
      set maxLabelWidth [string length "$parameterName:"]
    }
    set mobalParameterTypes($parameterName) $parameterTypeDef

    # Decide which type is used for the parameter widget.
    case $parameterType in {
      {optionbutton} {
        # Create an optionbutton. This is a label with an
        # menu attached to a small knobble.
        frame $tmpPathName.button -relief raised -borderwidth 2
        label $tmpPathName.button.value -textvariable mobalParameters($parameterName) -anchor w -borderwidth 0
        frame $tmpPathName.button.knobble -borderwidth 2 -height 7 -relief raised -width 15
        menu $tmpPathName.button.knobble.m
        pack append $tmpPathName.button $tmpPathName.button.value {left fill expand} $tmpPathName.button.knobble {left}
        if {"$parameterValue" != "unrestricted"} {
          pack append $tmpPathName $tmpPathName.button {left}
          # Insert the possible selections into the menu.
          set mobalParameters($parameterName) $parameterValue
        } {
          set mobalParameters($parameterName) [lindex $parameterTypeParams 0]
        }
        set maxLength [string length $parameterValue]
        foreach button $parameterTypeParams {
          if {[string length $button] > $maxLength} {
            set maxLength [string length $button]
          }
          $tmpPathName.button.knobble.m add command -label $button -command "set mobalParameters($parameterName) \"$button\""
        }
        $tmpPathName.button.value config -width [expr $maxLength+1]
        MenuPopupAdd $tmpPathName.button.knobble 1 $tmpPathName.button.knobble.m
        append defaultCommand "set mobalParameters($parameterName) \{$parameterDefault\}\n"
        trace variable mobalParameters($parameterName) w "ViewParamsChanged $pathName"
        if {"$parameterTypeUnrestricted" == "1"} {
          $tmpPathName.unrestricted config -command "MiscToggleParameterState mobalUnrestricted($parameterTool,$parameterName) $tmpPathName.button"
        }
      }
      {oneof} {
        # Create an radiobutton list. The radiobuttons 
        # represent the selection of one value among
        # several possible values.
        set counter2 0
        set tmpButtonList ""
        foreach button $parameterTypeParams {
          radiobutton $tmpPathName.button$counter2 -text $button -value $button -variable mobalParameters($parameterName)
          if {"$parameterValue" != "unrestricted"} {
            pack append $tmpPathName $tmpPathName.button$counter2 {left}
          }
          append tmpButtonList "$tmpPathName.button$counter2 "
          incr counter2
        }
        # Register the parameter.
        if {"$parameterValue" != "unrestricted"} {
          if {[lsearch $parameterTypeParams $parameterValue] != -1} {
            set mobalParameters($parameterName) $parameterValue
          } {
            set mobalParameters($parameterName) [lindex $parameterTypeParams 0]
          }
        } {
          set mobalParameters($parameterName) [lindex $parameterTypeParams 0]
        }
        append defaultCommand "set mobalParameters($parameterName) \{$parameterDefault\}\n"
        trace variable mobalParameters($parameterName) w "ViewParamsChanged $pathName"
        if {"$parameterTypeUnrestricted" == "1"} {
          $tmpPathName.unrestricted config -command "MiscToggleParameterState mobalUnrestricted($parameterTool,$parameterName) $tmpButtonList"
        }
      }
      {integer_from_to} {
        # Create an integer scale. The scale allows the
        # setting of an integer value via a scale or
        # an entry.
        set from 0
        set to 1000
        if {[llength $parameterTypeParams] == 2} {
          set from [lindex $parameterTypeParams 0]
          set to [lindex $parameterTypeParams 1]
        }
        frame $tmpPathName.frame
        scale $tmpPathName.frame.scale -from $from -to $to -orient horizontal -sliderlength 20 -width 10 -showvalue 0 -command "MiscScaleEntry mobalParameters($parameterName)"
        entry $tmpPathName.frame.entry -relief sunken -textvariable mobalParameters($parameterName)
        bind $tmpPathName.frame.entry <Key-Return> "catch \"$tmpPathName.frame.scale set \[%W get\]\""
        pack append $tmpPathName.frame $tmpPathName.frame.scale {top fill} $tmpPathName.frame.entry {top fill}
        if {"$parameterValue" != "unrestricted"} {
          pack append $tmpPathName $tmpPathName.frame {left fill expand}
        }
        # Register the parameter.
        if {"$parameterValue" != "unrestricted"} {
          set mobalParameters($parameterName) $parameterValue
          $tmpPathName.frame.scale set $parameterValue
        } {
          set mobalParameters($parameterName) $from
          $tmpPathName.frame.scale set $from
        }
        append defaultCommand "$tmpPathName.frame.scale set \{$parameterDefault\}\n"
        trace variable mobalParameters($parameterName) w "ViewParamsChanged $pathName"
        append valueList "$tmpPathName.frame.entry "
        if {"$parameterTypeUnrestricted" == "1"} {
          $tmpPathName.unrestricted config -command "MiscToggleParameterState mobalUnrestricted($parameterTool,$parameterName) $tmpPathName.frame"
        }
      }
      {text} {
        # Create a text parameter field. The user can
        # enter mult line text into a text widget.
        frame $tmpPathName.frame
        scrollbar $tmpPathName.frame.vscroll -command "$tmpPathName.frame.text yview"
        text $tmpPathName.frame.text -relief sunken -borderwidth 2 -width 50 -height 5 -yscrollcommand "$tmpPathName.frame.vscroll set"
        pack append $tmpPathName.frame $tmpPathName.frame.vscroll {right fill} $tmpPathName.frame.text {top fill expand}
        if {"$parameterValue" != "unrestricted"} {
          pack append $tmpPathName $tmpPathName.frame {top fill expand}
        }
        # Register the parameter.
        if {"$parameterValue" != "unrestricted"} {
          $tmpPathName.frame.text insert end $parameterValue
        }
        set mobalParameters($parameterName) "XFMOBAL$tmpPathName.frame.text"
        append defaultCommand "$tmpPathName.frame.text delete 1.0 end
$tmpPathName.frame.text insert end \{$parameterDefault\}
set mobalParameters($parameterName) \{$parameterDefault\}\n"
        trace variable mobalParameters($parameterName) w "ViewParamsChanged $pathName"
        append valueList "$tmpPathName.frame.text "
        if {"$parameterTypeUnrestricted" == "1"} {
          $tmpPathName.unrestricted config -command "MiscToggleParameterState mobalUnrestricted($parameterTool,$parameterName) $tmpPathName.frame"
        }
        bind $tmpPathName.frame.text <Left> {# xf ignore me 8
          %W mark set insert insert-1c; %W yview -pickplace insert}
        bind $tmpPathName.frame.text <Right> {# xf ignore me 8
          %W mark set insert insert+1c; %W yview -pickplace insert}
        bind $tmpPathName.frame.text <Up> {# xf ignore me 8
          %W mark set insert insert-1l; %W yview -pickplace insert}
        bind $tmpPathName.frame.text <Down> {# xf ignore me 8
          %W mark set insert insert+1l; %W yview -pickplace insert}
        bind $tmpPathName.frame.text <Control-a> {# xf ignore me 8
          %W mark set insert "insert linestart"; %W yview -pickplace insert}
        bind $tmpPathName.frame.text <Control-b> {# xf ignore me 8
          %W mark set insert insert-1c; %W yview -pickplace insert}
        bind $tmpPathName.frame.text <Control-e> {# xf ignore me 8
          %W mark set insert "insert lineend"; %W yview -pickplace insert}
        bind $tmpPathName.frame.text <Control-f> {# xf ignore me 8
          %W mark set insert insert+1c; %W yview -pickplace insert}
        bind $tmpPathName.frame.text <Control-n> {# xf ignore me 8
          %W mark set insert insert+1l; %W yview -pickplace insert}
        bind $tmpPathName.frame.text <Control-p> {# xf ignore me 8
          %W mark set insert insert-1l; %W yview -pickplace insert}
        bind $tmpPathName.frame.text <Home> {# xf ignore me 8 
          %W mark set insert 1.0; %W yview -pickplace insert}
        bind $tmpPathName.frame.text <End> {# xf ignore me 8
          %W mark set insert end; %W yview -pickplace insert}
        bind $tmpPathName.frame.text <Prior> {# xf ignore me 8
          set xfCounter [lindex [%W config -height] 4]
          while {$xfCounter > 0} {
            %W mark set insert insert-1l
            incr xfCounter -1
          }
          %W yview -pickplace insert}
        bind $tmpPathName.frame.text <Next> {# xf ignore me 8
          set xfCounter [lindex [%W config -height] 4]
          while {$xfCounter > 0} {
            %W mark set insert insert+1l
            incr xfCounter -1
          }
          %W yview -pickplace insert}
        bind $tmpPathName.frame.text <Control-Key-d> {# xf ignore me 8
          ViewParamsSetChanged [winfo parent [winfo parent [winfo parent [winfo parent %W]]]] "parameters changed"
          %W delete insert insert+1c; %W yview -pickplace insert}
        bind $tmpPathName.frame.text <Control-Key-i> {# xf ignore me 8
          ViewParamsSetChanged [winfo parent [winfo parent [winfo parent [winfo parent %W]]]] "parameters changed"
          %W inser insert \t; %W yview -pickplace insert}
        bind $tmpPathName.frame.text <Control-Key-j> {# xf ignore me 8
          ViewParamsSetChanged [winfo parent [winfo parent [winfo parent [winfo parent %W]]]] "parameters changed"
          %W inser insert \n; %W yview -pickplace insert}
        bind $tmpPathName.frame.text <Control-Key-k> {# xf ignore me 8
          ViewParamsSetChanged [winfo parent [winfo parent [winfo parent [winfo parent %W]]]] "parameters changed"
          if {[%W compare insert == "insert lineend"]} {
            %W delete insert "insert lineend +1c"
            %W yview -pickplace insert
          } {
            %W delete insert "insert lineend"
            %W yview -pickplace insert}}
        bind $tmpPathName.frame.text <Control-Key-m> {# xf ignore me 8
          ViewParamsSetChanged [winfo parent [winfo parent [winfo parent [winfo parent %W]]]] "parameters changed"
          %W inser insert \n; %W yview -pickplace insert}
        bind $tmpPathName.frame.text <Control-Key-o> {# xf ignore me 8
          ViewParamsSetChanged [winfo parent [winfo parent [winfo parent [winfo parent %W]]]] "parameters changed"
          %W inser insert \n; %W yview -pickplace insert}
        bind $tmpPathName.frame.text <Control-Key-y> {# xf ignore me 8
          ViewParamsSetChanged [winfo parent [winfo parent [winfo parent [winfo parent %W]]]] "parameters changed"
          %W insert insert "[GetSelection]"; %W yview -pickplace insert}
        bind $tmpPathName.frame.text <Key-Delete> {# xf ignore me 8
          ViewParamsSetChanged [winfo parent [winfo parent [winfo parent [winfo parent %W]]]] "parameters changed"
          tk_textBackspace %W; %W yview -pickplace insert}
        bind $tmpPathName.frame.text <Mod1-Key-c> {# xf ignore me 8
          global tk_priv(xfTextCutBuffer)
          ViewParamsSetChanged [winfo parent [winfo parent [winfo parent [winfo parent %W]]]] "parameters changed"
          if {![catch "%W get sel.first sel.last" select]} {
            if {"$select" != ""} {
              set tk_priv(xfTextCutBuffer) $select
            }
        }}
        bind $tmpPathName.frame.text <Mod1-Key-h> {# xf ignore me 8
          ViewParamsSetChanged [winfo parent [winfo parent [winfo parent [winfo parent %W]]]] "parameters changed"
          %W delete "insert linestart" insert; %W yview -pickplace insert}
        bind $tmpPathName.frame.text <Mod1-Key-v> {# xf ignore me 8
          global tk_priv(xfTextCutBuffer)
          ViewParamsSetChanged [winfo parent [winfo parent [winfo parent [winfo parent %W]]]] "parameters changed"
          if {[info exists tk_priv(xfTextCutBuffer)]} {
            if {![catch "%W get sel.first sel.last" select]} {
              set index [%W index sel.first]
              %W delete sel.first sel.last
              %W insert $index "$tk_priv(xfTextCutBuffer)"
            } {
              %W insert insert "$tk_priv(xfTextCutBuffer)"
            }
          } {
            %W insert insert "[GetSelection]"
          }
          %W yview -pickplace insert}
        bind $tmpPathName.frame.text <Mod1-Key-x> {# xf ignore me 8
          global tk_priv(xfTextCutBuffer)
          if {![catch "%W get sel.first sel.last" select]} {
            if {"$select" != ""} {
              ViewParamsSetChanged [winfo parent [winfo parent [winfo parent [winfo parent %W]]]] "parameters changed"
              set tk_priv(xfTextCutBuffer) $select
            }
          }
          catch "%W delete sel.first sel.last"}
        bind $tmpPathName.frame.text <Any-KeyPress> {
          if {"%A" != ""} {
            ViewParamsSetChanged [winfo parent [winfo parent [winfo parent [winfo parent %W]]]] "parameters changed"
            %W insert insert %A
            %W yview -pickplace insert
          }
        }
        bind $tmpPathName.frame.text <Return> {
          ViewParamsSetChanged [winfo parent [winfo parent [winfo parent [winfo parent %W]]]] "parameters changed"
          %W insert insert \n; %W yview -pickplace insert}
        bind $tmpPathName.frame.text <BackSpace> {
          ViewParamsSetChanged [winfo parent [winfo parent [winfo parent [winfo parent %W]]]] "parameters changed"
          tk_textBackspace %W; %W yview -pickplace insert}
      }
      {default} {
        # Create a entry parameter field. The user can
        # enter one line text into a entry widget.
        entry $tmpPathName.entry -relief sunken -textvariable mobalParameters($parameterName)
        if {"$parameterValue" != "unrestricted"} {
          pack append $tmpPathName $tmpPathName.entry {left fill expand}
        }
        # Register the parameter.
        if {"$parameterValue" != "unrestricted"} {
          set mobalParameters($parameterName) $parameterValue
        } {
          set mobalParameters($parameterName) ""
        }
        append defaultCommand "set mobalParameters($parameterName) \{$parameterDefault\}\n"
        trace variable mobalParameters($parameterName) w "ViewParamsChanged $pathName"
        append valueList "$tmpPathName.entry "
        if {"$parameterTypeUnrestricted" == "1"} {
          $tmpPathName.unrestricted config -command "MiscToggleParameterState mobalUnrestricted($parameterTool,$parameterName) $tmpPathName.entry"
        }
        bind $tmpPathName.entry <Delete> {tk_entryBackspace %W; tk_entrySeeCaret %W}
        bind $tmpPathName.entry <BackSpace> {tk_entryBackspace %W; tk_entrySeeCaret %W}
        bind $tmpPathName.entry <Right> {# xf ignore me 8
          %W icursor [expr [%W index insert]+1]; tk_entrySeeCaret %W }
        bind $tmpPathName.entry <Left> {# xf ignore me 8
          %W icursor [expr [%W index insert]-1]; tk_entrySeeCaret %W }
        bind $tmpPathName.entry <Control-a> {# xf ignore me 8
          %W icursor 0; %W view 0}
        bind $tmpPathName.entry <Control-b> {# xf ignore me 8
          %W icursor [expr [%W index insert]-1]; tk_entrySeeCaret %W}
        bind $tmpPathName.entry <Control-d> {# xf ignore me 8
          %W delete [%W index insert]; tk_entrySeeCaret %W }
        bind $tmpPathName.entry <Control-e> {# xf ignore me 8
          %W icursor end; tk_entrySeeCaret %W}
        bind $tmpPathName.entry <Control-f> {# xf ignore me 8
          %W icursor [expr [%W index insert]+1]; tk_entrySeeCaret %W}
        bind $tmpPathName.entry <Control-h> {# xf ignore me 8
          tk_entryBackspace %W; tk_entrySeeCaret %W}
        bind $tmpPathName.entry <Meta-h> {# xf ignore me 8
          %W delete 0 insert; %W view insert}
        bind $tmpPathName.entry <Control-i> {# xf ignore me 8
          %W insert insert \t; tk_entrySeeCaret %W}
        bind $tmpPathName.entry <Control-k> {# xf ignore me 8
          %W delete insert end; tk_entrySeeCaret %W}
        bind $tmpPathName.entry <Control-l> {# xf ignore me 8
          tk_entrySeeCaret %W}
        bind $tmpPathName.entry <Control-v> {# xf ignore me 8
          %W insert insert "[GetSelection]"; tk_entrySeeCaret %W}
        bind $tmpPathName.entry <Control-w> {# xf ignore me 8
          catch "%W delete sel.first sel.last"; tk_entrySeeCaret %W}
        bind $tmpPathName.entry <Control-y> {# xf ignore me 8
          %W insert insert "[GetSelection]"; tk_entrySeeCaret %W}
        bind $tmpPathName.entry <Meta-c> {# xf ignore me 8
          global tk_priv(xfEntryCutBuffer)
          if {![catch "%W index sel.first"]} {
            set select [string range [%W get] [%W index sel.first] [%W index sel.last]]
            if {"$select" != ""} {
              set tk_priv(xfEntryCutBuffer) $select
            }
          }
          tk_entrySeeCaret %W}
        bind $tmpPathName.entry <Meta-v> {# xf ignore me 8
          global tk_priv(xfEntryCutBuffer)
          if {[info exists tk_priv(xfEntryCutBuffer)]} {
            if {![catch "%W index sel.first"]} {
              set index [%W index sel.first]
              %W delete sel.first sel.last
              %W insert $index "$tk_priv(xfEntryCutBuffer)"
            } {
              %W insert insert "$tk_priv(xfEntryCutBuffer)"
            }
          } {
            %W insert insert "[GetSelection]"
          }
          tk_entrySeeCaret %W}
        bind $tmpPathName.entry <Meta-x> {# xf ignore me 8
          global tk_priv(xfEntryCutBuffer)
          if {![catch "%W index sel.first"]} {
            set select [string range [%W get] [%W index sel.first] [%W index sel.last]]
            if {"$select" != ""} {
              set tk_priv(xfEntryCutBuffer) $select
            }
          }
          catch "%W delete sel.first sel.last"
          tk_entrySeeCaret %W}
        case $parameterType {
          {prolog_atom} {
            bind $tmpPathName.entry <Any-KeyPress> {
              if {"%A" != ""} {
                %W insert insert %A
                if {![regexp {^([a-z]+)([a-zA-Z0-9_])*$} [%W get]]} {
                  %W delete [expr [%W index insert]-1]
                }
                tk_entrySeeCaret %W
              }
            }
          }
          {list_of_names} {
            bind $tmpPathName.entry <Any-KeyPress> {
              if {"%A" != ""} {
                %W insert insert %A
                if {![regexp {^(\[)?(([a-z]+)([a-zA-Z0-9_])*(,)?( )?)*(\])?$} [%W get]]} {
                  %W delete [expr [%W index insert]-1]
                }
                tk_entrySeeCaret %W
              }
            }
          }
          {integer_ge integer_gt integer_le integer_lt} {
            $tmpPathName.entry config -width 7
            if {"$parameterValue" != "unrestricted"} {
              pack append $tmpPathName $tmpPathName.entry {left expand frame w}
            }
            bind $tmpPathName.entry <Any-KeyPress> {
              if {"%A" != ""} {
                %W insert insert %A
                if {![regexp {^(-)?([0-9])*$} [%W get]]} {
                  %W delete [expr [%W index insert]-1]
                }
                tk_entrySeeCaret %W
              }
            }
          }
          {real_from_to real_ge real_gt real_le real_lt} {
            $tmpPathName.entry config -width 9
            if {"$parameterValue" != "unrestricted"} {
              pack append $tmpPathName $tmpPathName.entry {left expand frame w}
            }
            bind $tmpPathName.entry <Any-KeyPress> {
              if {"%A" != ""} {
                %W insert insert %A
                if {![regexp {^(-)?([0-9])*(\.)?([0-9])*$} [%W get]]} {
                  %W delete [expr [%W index insert]-1]
                }
                tk_entrySeeCaret %W
              }
            }
          }
        }
      }
    }
    incr counter
  }

  # set the default command
  $pathName.buttons.default config -command "
    $defaultCommand
    update
    ViewParamsSetChanged $pathName \"parameters changed\""

  # Set labels to equal width.
  foreach element $labelList {
    $element config -width $maxLabelWidth
  }

  # Connect all value fields for keyboard traversal.
  if {"[info commands XFLocalFormConnect]" != ""} {
    XFLocalFormConnect $valueList
  }

  ViewParamsSetChanged $pathName "parameters ok"
}


# Procedure: ViewParamsSet
proc ViewParamsSet { {pathName ""}} {
  # This procedure sets the currently specified tool
  # parameters into the prolog interpreter.
  # pathName - the pathname of the parameter dialog

  # The global variables of mobal.
  global mobal
  # All tool parameters are temporarily stored here.
  global mobalParameters
  # All tool parameter types are temporarily stored here.
  global mobalParameterTypes
  # This variable contains the current unrestricted selection
  # for the tool parameters.
  global mobalUnrestricted

  # Are there any tool parameters ?
  if {[info exists mobalParameters]} {
    # Walk through all existing parameters.
    foreach name [array names mobalParameters] {
      set value ""
      if {[info exists mobalUnrestricted($mobal(tool),$name)]} {
        if {$mobalUnrestricted($mobal(tool),$name)} {
          set value unrestricted
        }
      }
      if {"$value" == ""} {
        if {[string match "XFMOBAL*" [set mobalParameters($name)]]} {
          # The parameter is a multi line text parameter.
          # We have to deal with this parameter special.
          set value [[string range [set mobalParameters($name)] 7 end] get 1.0 end]
        } {
          # Retrieve the current value for the parameter.
          set value [set mobalParameters($name)]
        }
        # verify the paramters
        case [lindex $mobalParameterTypes($name) 0] {
          {formula} {
            set value [PrologString $value]
          }
          {text} {
            set value [PrologString $value]
          }
          {optionbutton} {
            if {[lsearch [lindex $mobalParameterTypes($name) 1] $value] == -1} {
              continue
            }
            set value [PrologAtom $value]
          }
          {one_of} {
            if {[lsearch [lindex $mobalParameterTypes($name) 1] $value] == -1} {
              continue
            }
            set value [PrologAtom $value]
          }
          {prolog_atom} {
            if {![regexp {^([a-z]+)([a-zA-Z0-9_])*$} $value]} {
              continue
            }
            set value [PrologAtom $value]
          }
          {list_of_names} {
            set value [PrologString $value] 
          }
          {integer_from_to} {
            if {![regexp {^(-)?([0-9])*$} $value]} {
              continue
            }
            if {[llength $mobalParameterTypes($name)] == 4} {
              if {$value < [lindex $mobalParameterTypes($name) 2] ||
                  $value > [lindex $mobalParameterTypes($name) 3]} {
                AlertBox "Value for: $name: $value is not between [lindex $mobalParameterTypes($name) 2] and [lindex $mobalParameterTypes($name) 3]"
                continue
              }
            } {
              if {$value < 0 || $value > 1000} {
                AlertBox "Value for: $name: $value is not between 0 and 1000"
                continue
              }
            }
            set value [PrologStructure $value]
          }
          {integer_ge} {
            if {![regexp {^(-)?([0-9])*$} $value]} {
              continue
            }
            if {$value < [lindex $mobalParameterTypes($name) 2]} {
              AlertBox "Value for: $name: $value is smaller than [lindex $mobalParameterTypes($name) 2]"
              continue
            }
            set value [PrologStructure $value]
          }
          {integer_gt} {
            if {![regexp {^(-)?([0-9])*$} $value]} {
              continue
            }
            if {$value <= [lindex $mobalParameterTypes($name) 2]} {
              AlertBox "Value for: $name: $value is smaller/equal than [lindex $mobalParameterTypes($name) 2]"
              continue
            }
            set value [PrologStructure $value]
          }
          {integer_le} {
            if {![regexp {^(-)?([0-9])*$} $value]} {
              continue
            }
            if {$value > [lindex $mobalParameterTypes($name) 2]} {
              AlertBox "Value for: $name: $value is greater than [lindex $mobalParameterTypes($name) 2]"
              continue
            }
            set value [PrologStructure $value]
          } 
          {integer_lt} {
            if {![regexp {^(-)?([0-9])*$} $value]} {
              continue
            }
            if {$value >= [lindex $mobalParameterTypes($name) 2]} {
              AlertBox "Value for: $name: $value is smaller/equal than [lindex $mobalParameterTypes($name) 2]"
              continue
            }
            set value [PrologStructure $value]
          }
          {real_from_to} {
            if {![regexp {^(-)?([0-9])*(\.)?([0-9])*$} $value]} {
              continue
            }
            if {[llength $mobalParameterTypes($name)] == 4} {
              if {$value < [lindex $mobalParameterTypes($name) 2] ||
                  $value > [lindex $mobalParameterTypes($name) 3]} {
                AlertBox "Value for: $name: $value is not between [lindex $mobalParameterTypes($name) 2] and[lindex $mobalParameterTypes($name) 3]"
                continue
              }
            } {
              if {$value < 0 || $value > 1000} {
                AlertBox "Value for: $name: $value is not between 0 and 1000"
                continue
              }
            }
            set value [PrologStructure $value]
          }
          {real_ge} {
            if {![regexp {^(-)?([0-9])*(\.)?([0-9])*$} $value]} {
              continue
            }
            if {$value < [lindex $mobalParameterTypes($name) 2]} {
              AlertBox "Value for: $name: $value is smaller than [lindex $mobalParameterTypes($name) 2]"
              continue
            }
            set value [PrologStructure $value]
          }
          {real_gt} {
            if {![regexp {^(-)?([0-9])*(\.)?([0-9])*$} $value]} {
              continue
            }
            if {$value <= [lindex $mobalParameterTypes($name) 2]} {
              AlertBox "Value for: $name: $value is smaller/equal than [lindex $mobalParameterTypes($name) 2]"
              continue
            }
            set value [PrologStructure $value]
          }
          {real_le} {
            if {![regexp {^(-)?([0-9])*(\.)?([0-9])*$} $value]} {
              continue
            }
            if {$value > [lindex $mobalParameterTypes($name) 2]} {
              AlertBox "Value for: $name: $value is greater than [lindex $mobalParameterTypes($name) 2]"
              continue
            }
            set value [PrologStructure $value]
          } 
          {real_lt} {
            if {![regexp {^(-)?([0-9])*(\.)?([0-9])*$} $value]} {
              continue
            }
            if {$value >= [lindex $mobalParameterTypes($name) 2]} {
              AlertBox "Value for: $name: $value is greater/equal than [lindex $mobalParameterTypes($name) 2]"
              continue
            }
            set value [PrologStructure $value]
          }
        }
      }
      if {"$mobal(outFd)" == "stdout"} {
        # Transmit the parameter to the prolog interpreter.
        puts stdout "set $name to $value"
      } {
        PrologWaitBeforeSend [expr $mobal(queueCounter) + 1]
        PrologSend mobal_set_param [PrologAtom $mobal(tool)] [PrologAtom $name] $value
      }
    }
  }
  # Retrieve the tool parameters.
  ViewParamsGet $pathName
}


# Procedure: ViewParamsSetChanged
proc ViewParamsSetChanged { pathName newValue} {
  # This procedure is used to set the changed status
  # to reflect the current status of the parameters.
  # pathName - the parameter box pathname
  # newValue - the new value

  # The global variables of mobal.
  global mobal

  if {"[info commands $pathName.menu.changed]" != ""} {
    if {[string match "*changed*" $newValue]} {
      $pathName.menu.changed config -foreground $mobal(background) -background $mobal(foreground)
    } {
      $pathName.menu.changed config -background $mobal(background) -foreground $mobal(foreground)
    }
  }
  set mobal(paramsChanged) $newValue
}


# Procedure: ViewReadStack
proc ViewReadStack { {type ""} {name ""} {tnodeName ""}} {
  # This procedure is used to update the displayed
  # mobal items in the specified view.
  # type - the type of the view (e.g. rules, facts etc.)
  # name - the name of the view
  # tnodeName - the name of a topology view.

  # A list off all focus specifications attatched
  # to the views.
  global mobalWindowFocus
  # A list off all sorting specifications attatched
  # to the views.
  global mobalWindowSortings

  # Initialize the element list.
  set elementList ""
  # Clear the view lists.
  catch "$name.list.list delete 0 end"
  catch "$name.list.listId delete 0 end"

  if {"$mobalWindowFocus($name)" != ""} {
    # There is a focus. We walk through all items in the array.
    foreach tmpElement [MobalGetAllItems [string tolower $type]$tnodeName] {
      if {[catch "regexp \{$mobalWindowFocus($name)\} \{[lindex $tmpElement 0]\}" result]} {
        set tmpName [string range $name [expr [string first - $name]+1] [expr [string last - $name]-1]]
        set tmpCounter [string range $name [expr [string last - $name]+1] end]
        AlertBox "Irregular regular expression:\n$mobalWindowFocus($name)"
        MobalViewViewSettings $type $tmpName $tnodeName $tmpCounter 
        return 0
      }
      if {$result} {
        # The current item matches the focus. So we add
        # id to the element list.
        lappend elementList $tmpElement
      }
    }
  } {
    # There is no focus. We walk through all items in
    # the global listbox and simply append it to the
    # element list.
    set elementList [MobalGetAllItems [string tolower $type]$tnodeName]
  }

  if {"$mobalWindowSortings($name)" != "unsorted"} {
    # We have to sort the elements. So walk through
    # the sorted element list, and insert the items.
    foreach element [lsort -command MiscCompare $mobalWindowSortings($name) $elementList] {
      $name.list.list insert end [lindex $element 0]
      $name.list.listId insert end [lindex $element 1]
    }
  } {
    # We have not to sort the elements. So walk through
    # the unsorted element list, and insert the items.
    foreach element $elementList {
      $name.list.list insert end [lindex $element 0]
      $name.list.listId insert end [lindex $element 1]
    }
  }
  return 1
}


# Procedure: ViewSettings
proc ViewSettings { {type ""} {name ""} {tnodeName ""} {counter "0"}} {
  # This procedure is used to display the parameter
  # setting dialog for a certain frame.
  # type - the type of the view (e.g. rules, facts etc.)
  # name - the name of the view
  # counter - the unique counter of the view

  # A list off all focus specifications attatched
  # to the views.
  global mobalWindowFocus
  # A list off all sorting specifications attatched
  # to the views.
  global mobalWindowSortings

  set result [MiscMakeWindowName .xfmobalStack $type $name $counter]
  set pathName [lindex $result 0]
  set viewPathName [lindex $result 1]
  set tmpCounter [lindex $result 2]
  set tmpTitle [lindex $result 3]

  # Create toplevel
  if {"[info commands $pathName]" != ""} {
    return
  }
  toplevel $pathName
  MiscPlaceWindowPrepare $pathName $type
  wm protocol $pathName WM_DELETE_WINDOW "ViewDestroy $pathName settings $tmpCounter"
  wm title $pathName $tmpTitle

  # This frame contains the parameters.
  frame $pathName.params -borderwidth 2 -relief raised

  # The sorting parameter. Views are sorted according to
  # this parameter.
  frame $pathName.params.sorting

  label $pathName.params.sorting.label -text "Sort:" -width 8

  radiobutton $pathName.params.sorting.unsorted -text "Unsorted" -variable xfmobalStackSettings-$name-$counter-sorting -value "unsorted"

  radiobutton $pathName.params.sorting.ascending -text "Ascending" -variable xfmobalStackSettings-$name-$counter-sorting -value "-increasing"

  radiobutton $pathName.params.sorting.descending -text "Descending" -variable xfmobalStackSettings-$name-$counter-sorting -value "-decreasing"

  # The focus of the view. This is a regular expression
  # that is matched against the mobal items.
  frame $pathName.params.focus

  label $pathName.params.focus.label -text "Focus:" -width 8 -anchor n

  entry $pathName.params.focus.focus -borderwidth 2 -relief sunken
#  text $pathName.params.focus.focus -yscrollcommand "$pathName.params.focus.scroll set" -borderwidth 2 -relief sunken -width 60 -height 10

#  scrollbar $pathName.params.focus.scroll -command "$pathName.params.focus.focus yview"

  # The title for the view.
  frame $pathName.params.title

  label $pathName.params.title.label -text "Title:" -width 8

  entry $pathName.params.title.title -borderwidth 2 -relief sunken

  # Calculate the tile.
  if {[string last {(} [wm title $viewPathName]] != -1} {
    set tmpSaveTitle [string range $tmpTitle 0 [string first { } $tmpTitle]]
    set tmpTitle [string range [wm title $viewPathName] 0 [expr [string last {(} [wm title $viewPathName]]-2]]
  } {
    set tmpSaveTitle [string range $tmpTitle 0 [string first { } $tmpTitle]]
    set tmpTitle [wm title $viewPathName]
  }

  # The font for the view.
  frame $pathName.params.font

  label $pathName.params.font.label -text "Font:" -width 8

  entry $pathName.params.font.font -borderwidth 2 -relief sunken

  # This bindings calls the font selection box when
  # mousebutton 3 is doubleclicked.
  bind $pathName.params.font.font <Double-3> "FontBox \"/usr/local/lib/xf/lib/Fonts\" \"Font\" $pathName.params.font.font"
  bind $pathName.params.focus.focus <Return> "NoFunction"
  bind $pathName.params.font.font <Return> "NoFunction"
  bind $pathName.params.title.title <Return> "NoFunction"

  # This frame contains the controls-
  frame $pathName.buttons -borderwidth 2 -relief raised

  button $pathName.buttons.setValues  -command "
    set mobalWindowSortings($viewPathName) \[set xfmobalStackSettings-$name-$counter-sorting\]
    set mobalWindowFocus($viewPathName) \[$pathName.params.focus.focus get\]
    if {\[ViewReadStack $type $viewPathName $tnodeName\]} {
      if {\"\$mobalWindowFocus($viewPathName)\" != \"\"} {
        wm title $viewPathName \"\[$pathName.params.title.title get\] (\$mobalWindowFocus($viewPathName))\"
      } {
        wm title $viewPathName \"\[$pathName.params.title.title get\]\"
      }
      catch \"$viewPathName.list.list config -font \[$pathName.params.font.font get\]\"
      unset xfmobalStackSettings-$name-$counter-sorting
      ViewDestroy $pathName settings $tmpCounter
    }" -text {Set Values} -width 15

  button $pathName.buttons.defaults -command "
    set xfmobalStackSettings-$name-$counter-sorting unsorted
    $pathName.params.focus.focus delete 0 end
    $pathName.params.focus.focus insert end \{\}
    $pathName.params.title.title delete 0 end
    $pathName.params.title.title insert end \{$tmpSaveTitle\}
    $pathName.params.font.font delete 0 end
    $pathName.params.font.font insert end \{[lindex [$viewPathName.list.list config -font] 4]\}"  -text {Defaults} -width 15

  button $pathName.buttons.cancel  -command "
    unset xfmobalStackSettings-$name-$counter-sorting
    ViewDestroy $pathName settings $tmpCounter"  -text {Cancel} -width 15

  # Display widget structure
  pack append $pathName.params.sorting  $pathName.params.sorting.label {left fill}  $pathName.params.sorting.unsorted {left} $pathName.params.sorting.ascending {left}  $pathName.params.sorting.descending {left}
  pack append $pathName.params.focus  $pathName.params.focus.label {left fill}  $pathName.params.focus.focus {left expand fill}
  pack append $pathName.params.title  $pathName.params.title.label {left fill}  $pathName.params.title.title {left fill expand} 
  pack append $pathName.params.font  $pathName.params.font.label {left fill}  $pathName.params.font.font {left fill expand}
  pack append $pathName.params  $pathName.params.sorting {top fill} $pathName.params.focus {top fill} $pathName.params.font {top fill} $pathName.params.title {top fill}
  pack append $pathName.buttons  $pathName.buttons.setValues {left padx 6 pady 6 expand}  $pathName.buttons.defaults {left padx 6 pady 6 expand}  $pathName.buttons.cancel {left padx 6 pady 6 expand}
  pack append $pathName  $pathName.buttons {bottom fill}  $pathName.params {top fill expand}

  # Set the temporary parameters.
  global xfmobalStackSettings-$name-$counter-sorting
  set xfmobalStackSettings-$name-$counter-sorting $mobalWindowSortings($viewPathName)
  $pathName.params.focus.focus insert end $mobalWindowFocus($viewPathName)
  $pathName.params.title.title insert end $tmpTitle
  $pathName.params.font.font insert end [lindex [$viewPathName.list.list config -font] 4]

  # Apply the X resources.
  XFLocalSetAppDefs $pathName

  MiscPlaceWindow $pathName $type
  wm geometry $pathName [wm geometry $viewPathName]
}


# Procedure: ViewUpdateStack
proc ViewUpdateStack { {name ""} {type ""}} {
  # This procedure updates a specified view.
  # name - the name of the view to destroy
  # type - the type of the stack

  # A list where all topology views are mapped
  # to their correspinding topology type.
  global mobalTopology

  # We have to handle topology views a little bit special.
  if {[string match "tnode*" $type]} {
    if {![info exists mobalTopology($name)]} {
      return
    }
    if {"tnode$mobalTopology($name)" != "$type"} {
      return
    }
    ViewReadStack tnode $name [string range $type 5 end]
  } {
    if {"[string range $name 13 [expr [string first - $name]-1]]" != "$type"} {
      return
    }
    ViewReadStack $type $name
  }
}


# Procedure: YesNoBox
proc YesNoBox { {yesNoBoxMessage "Yes/no message"} {yesNoBoxGeometry ""} {yesNoBoxYes "Yes"} {yesNoBoxNo "No"}} {
# xf ignore me 5
##########
# Procedure: YesNoBox
# Description: show yesno box
# Arguments: {yesNoBoxMessage} - the text to display
#            {yesNoBoxGeometry} - the geometry for the window
#            {yesNoBoxYes} - the yes label
#            {yesNoBoxNo} - the no label
# Returns: none
# Sideeffects: none
##########
#
# global yesNoBox(activeBackground) - active background color
# global yesNoBox(activeForeground) - active foreground color
# global yesNoBox(anchor) - anchor for message box
# global yesNoBox(background) - background color
# global yesNoBox(font) - message font
# global yesNoBox(foreground) - foreground color
# global yesNoBox(justify) - justify for message box
# global yesNoBox(afterNo) - destroy yes-no box after n seconds.
#                            The no button is activated
# global yesNoBox(afterYes) - destroy yes-no box after n seconds.
#                             The yes button is activated

  global yesNoBox

  PrologSetQuerying

  # prepare widget configuration strings
  set tmpButtonOpt ""
  set tmpFrameOpt ""
  set tmpMessageOpt ""
  if {"$yesNoBox(activeBackground)" != ""} {
    append tmpButtonOpt "-activebackground \"$yesNoBox(activeBackground)\" "
  }
  if {"$yesNoBox(activeForeground)" != ""} {
    append tmpButtonOpt "-activeforeground \"$yesNoBox(activeForeground)\" "
  }
  if {"$yesNoBox(background)" != ""} {
    append tmpButtonOpt "-background \"$yesNoBox(background)\" "
    append tmpFrameOpt "-background \"$yesNoBox(background)\" "
    append tmpMessageOpt "-background \"$yesNoBox(background)\" "
  }
  if {"$yesNoBox(font)" != ""} {
    append tmpButtonOpt "-font \"$yesNoBox(font)\" "
    append tmpMessageOpt "-font \"$yesNoBox(font)\" "
  }
  if {"$yesNoBox(foreground)" != ""} {
    append tmpButtonOpt "-foreground \"$yesNoBox(foreground)\" "
    append tmpMessageOpt "-foreground \"$yesNoBox(foreground)\" "
  }

  # start build of toplevel
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy .yesNoBox}
  } {
    catch {destroy .yesNoBox}
  }
  toplevel .yesNoBox  -borderwidth 0
  MiscPlaceWindowPrepare .yesNoBox yesno
  catch ".yesNoBox config $tmpFrameOpt"
  if {"$yesNoBoxGeometry" != ""} {
    if {[catch "wm geometry .yesNoBox $yesNoBoxGeometry"]} {
      wm geometry .yesNoBox 500x200
    }
  }
  wm title .yesNoBox {TkMobal: Yes/No box}
  # end build of toplevel

  # the message
  message .yesNoBox.message1 -anchor "$yesNoBox(anchor)" -justify "$yesNoBox(justify)" -relief raised -text "$yesNoBoxMessage"
  catch ".yesNoBox.message1 config $tmpMessageOpt"

  if {"$yesNoBoxGeometry" != ""} {
    set xfTmpWidth [string range $yesNoBoxGeometry 0 [expr [string first x $yesNoBoxGeometry]-1]]
    if {"$xfTmpWidth" != ""} {
      # set message size
      catch ".yesNoBox.message1 configure -width [expr $xfTmpWidth-10]"
    } {
      .yesNoBox.message1 configure -aspect 400
    }
  } {
    .yesNoBox.message1 configure -aspect 400
  }

  # the button area
  frame .yesNoBox.frame1 -borderwidth 2 -relief raised
  catch ".yesNoBox.frame1 config $tmpFrameOpt"

  # the buttons
  button .yesNoBox.frame1.button0 -text $yesNoBoxYes -command "
      global yesNoBox
      set yesNoBox(button) 1
      PrologSetReady 1
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .yesNoBox}
      } {
        catch {destroy .yesNoBox}
      }"
  catch ".yesNoBox.frame1.button0 config $tmpButtonOpt"

  button .yesNoBox.frame1.button1 -text $yesNoBoxNo -command "
      global yesNoBox
      set yesNoBox(button) 0
      PrologSetReady 1
      if {\"\[info commands XFDestroy\]\" != \"\"} {
        catch {XFDestroy .yesNoBox}
      } {
        catch {destroy .yesNoBox}
      }"
  catch ".yesNoBox.frame1.button1 config $tmpButtonOpt"

  if {[string length $yesNoBoxYes] > [string length $yesNoBoxNo]} {
    .yesNoBox.frame1.button0 config -width [expr [string length $yesNoBoxYes]+3]
    .yesNoBox.frame1.button1 config -width [expr [string length $yesNoBoxYes]+3]
  } {
    .yesNoBox.frame1.button0 config -width [expr [string length $yesNoBoxNo]+3]
    .yesNoBox.frame1.button1 config -width [expr [string length $yesNoBoxNo]+3]
  }
  pack append .yesNoBox.frame1 .yesNoBox.frame1.button0 {left expand padx 6 pady 6} .yesNoBox.frame1.button1 {left expand padx 6 pady 6}

  # packing
  pack append .yesNoBox .yesNoBox.frame1 {bottom fill} .yesNoBox.message1 {top fill expand}

  if {$yesNoBox(afterYes) != 0} {
    after [expr $yesNoBox(afterYes)*1000] "catch \".yesNoBox.frame1.button0 invoke\""
  }
  if {$yesNoBox(afterNo) != 0} {
    after [expr $yesNoBox(afterNo)*1000] "catch \".yesNoBox.frame1.button1 invoke\""
  }

  XFLocalSetAppDefs .yesNoBox
  catch ".yesNoBox.message1 config -font \"$yesNoBox(font)\""
  catch ".yesNoBox.frame1.button0 config -font \"$yesNoBox(font)\""
  catch ".yesNoBox.frame1.button1 config -font \"$yesNoBox(font)\""

#  MiscPlaceWindow .yesNoBox yesno

  if {"$yesNoBoxGeometry" == ""} {
    if {[winfo width .yesNoBox] < 504 &&
        [winfo height .yesNoBox] >= 200} {
      wm geometry .yesNoBox 504x[winfo height .yesNoBox]
    } {
      if {[winfo width .yesNoBox] >= 504 &&
          [winfo height .yesNoBox] < 200} {
        wm geometry .yesNoBox [winfo width .yesNoBox]x200
      } {
        if {[winfo width .yesNoBox] < 504 &&
            [winfo height .yesNoBox] < 200} {
          wm geometry .yesNoBox 504x200
        }
      }
    }
  }

  MiscPlaceWindow .yesNoBox yesno

  # wait for the box to be destroyed
  update idletask
  grab .yesNoBox
  tkwait window .yesNoBox

  return $yesNoBox(button)
}


# Procedure: auto_load_ouster_index
proc auto_load_ouster_index { fn} {
    global auto_index
    set dir [file dirname $fn]

    if [catch {set f [open $dir/tclIndex]}] {
        return
    }
    set error [catch {
        set id [gets $f]
        if {$id == "# Tcl autoload index file, version 2.0"} {
            eval [read $f]
        } elseif {$id == "# Tcl autoload index file: each line identifies a Tcl"} {
            while {[gets $f line] >= 0} {
                if {([string index $line 0] == "#")
                        || ([llength $line] != 2)} {
                    continue
                }
                set name [lindex $line 0]
                if {![info exists auto_index($name)]} {
                    set auto_index($name) "source $dir/[lindex $line 1]"
                }
            }
        } else {
            error "$dir/tclIndex isn't a proper Tcl index file"
        }
    } msg]
    if {$f != ""} {
        close $f
    }
    if $error {
        global errorInfo errorCode
        error $msg $errorInfo $errorCode
    }
}


# Procedure: tkiconpane
proc tkiconpane { pathName args} {
# xf ignore me 7
  global auto_path env ip_priv

  set ip_priv(mega) ""

  # can we use mega widgets
  if {![string compare "" [info commands megawidget]]} {
    error "the megawidget widget is not available!"
  }

  # raise iconpane if it already exists and is a toplevel
  if {[string compare "" [info commands $pathName]]} {
    if {![string compare "toplevel" [winfo type $pathName]]} {
      raise $pathName
    }
    return
  }

  # find the library file for tkiconpane
  set initMegaName ""
  set initIconName ""
  set searchList ""
  if {[info exists env(XF_LOAD_PATH)]} {
    foreach dirName [split $env(XF_LOAD_PATH) :] {
      lappend searchList $dirName
    }
  }
  foreach dirName $auto_path {
    lappend searchList $dirName
  }
  lappend searchList "."

  foreach name $searchList {
    if {[file exists $name/tkMegaWidget.tcl]} {
      set initMegaName $name/tkMegaWidget.tcl
    }
    if {[file exists $name/tkIconPaneInt.tcl]} {
      set initIconName $name/tkIconPaneInt.tcl
    }
  }
  if {![string compare "" $initMegaName]} {
    error "Cannot locate internal tkMegaWidget.tcl file"
  }
  if {![string compare "" $initIconName]} {
    error "Cannot locate internal tkIconPaneInt.tcl file"
  }

  # initialize the data
  set ip_priv(clickCounter) 0
  set ip_priv(currentPane) $pathName 
  set ip_priv(drag&dropIconId) ""
  set ip_priv(drag&dropInterpreter) ""
  set ip_priv(drag&dropPath) ""
  set ip_priv(drag&dropType) 0

  # create the widget
  if {![string compare "-toplevel" [lindex $args 0]] &&
      ![string compare "1" [lindex $args 1]]} {
    if {[catch "topmegawidget $pathName -createcommand tkiconpane_create -libfile $initMegaName -userfile $initIconName" result]} {
      error $result
    }
    wm minsize $pathName 10 10
    wm maxsize $pathName 2000 2000
    raise $pathName
  } {
    if {[catch "megawidget $pathName -createcommand tkiconpane_create -libfile $initMegaName -userfile $initIconName" result]} {
      error $result
    }
  }
  eval $pathName config $args
}


# Procedure: tkiconpane_create
proc tkiconpane_create { pathName args} {
# xf ignore me 7
  global ip_priv

  # initialize variables
  if {"[$ip_priv(mega)$pathName interpeval info commands blt_drag&drop]" != ""} {
    set ip_priv(drag&dropType) 1
    $ip_priv(mega)$pathName interpset ip_priv(drag&dropType) 1
  } {
    set ip_priv(drag&dropType) 0
    $ip_priv(mega)$pathName interpset ip_priv(drag&dropType) 0
  }

  # internal options
  $ip_priv(mega)$pathName optionadd  -clickeval clickEval ClickEval 0 0 hidden {}
  $ip_priv(mega)$pathName optionadd  -currentid currentId CurrentId {} {} hidden {}
  $ip_priv(mega)$pathName optionadd  -dragdrophideicon dragDropHideIcon DragDropHideIcon "" "" hidden {}
  $ip_priv(mega)$pathName optionadd  -dragdropicon dragDropIcon DragDropIcon "" "" hidden {}
  $ip_priv(mega)$pathName optionadd  -edgefont edgeFont Font -*-Courier-Medium-R-Normal--12-120-*  -*-Courier-Medium-R-Normal--12-120-* hidden {}
  $ip_priv(mega)$pathName optionadd  -eventtype eventType EventType -1 -1 hidden {}
  $ip_priv(mega)$pathName optionadd  -focus focus Focus {} {} hidden {}
  $ip_priv(mega)$pathName optionadd  -grab grab Grab {} {} hidden {}
  $ip_priv(mega)$pathName optionadd  -iconfont iconFont Font -*-Courier-Medium-R-Normal--12-120-*  -*-Courier-Medium-R-Normal--12-120-* hidden {}
  $ip_priv(mega)$pathName optionadd  -iconsmoved iconsMoved IconsMoved 0 0 hidden {}
  $ip_priv(mega)$pathName optionadd  -initialized initialized Initialized 0 0 hidden {}
  $ip_priv(mega)$pathName optionadd  -moveitems moveItems MoveItems {} {} hidden {}
  $ip_priv(mega)$pathName optionadd  -selectededge selectedEdge SelectedEdge {} {} hidden {}
  $ip_priv(mega)$pathName optionadd  -selectededgelist selectedEdgeList SelectedEdgeList {} {} hidden {}
  $ip_priv(mega)$pathName optionadd  -selectedicon selectedIcon SelectedIcon {} {} hidden {}
  $ip_priv(mega)$pathName optionadd  -selectediconlist selectedIconList SelectedIconList {} {} hidden {}
  $ip_priv(mega)$pathName optionadd  -selectedid selectedId SelectedId {} {} hidden {}
  $ip_priv(mega)$pathName optionadd  -startx startX X {} {} hidden {}
  $ip_priv(mega)$pathName optionadd  -starty startY Y {} {} hidden {}
  $ip_priv(mega)$pathName optionadd  -stretch stretch Stretch {} {} hidden {}
  $ip_priv(mega)$pathName optionadd  -stretchxroot stretchXRoot StretchXRoot {} {} hidden {}
  $ip_priv(mega)$pathName optionadd  -stretchyroot stretchYRoot StretchYRoot {} {} hidden {}
  $ip_priv(mega)$pathName optionadd  -stretchx stretchX StretchX {} {} hidden {}
  $ip_priv(mega)$pathName optionadd  -stretchy stretchY StretchY {} {} hidden {}
  $ip_priv(mega)$pathName optionadd  -x x X {} {} hidden {}
  $ip_priv(mega)$pathName optionadd  -y y Y {} {} hidden {}

  # standard options
  $ip_priv(mega)$pathName optionadd  -activebackground activeBackground Foreground #eed5b7 #eed5b7  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -activeforeground activeForeground Background black black  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -background background Background #ffe4c4 #ffe4c4  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -cursor cursor Cursor xterm xterm  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -font font Font -Adobe-Helvetica-Bold-R-Normal--*-120-*  -Adobe-Helvetica-Bold-R-Normal--*-120-*  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -foreground foreground Foreground black black  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -geometry geometry Geometry {} {}  normal {}
  $ip_priv(mega)$pathName optionadd  -padx padX PadX 2 2  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -pady padY PadY 2 2  normal {tkiconpane_internalConf}

  # special options
  $ip_priv(mega)$pathName optionadd  -bindtype bindType BindType 0 0  normal {}
  $ip_priv(mega)$pathName optionadd  -canvasboxtag canvasBoxTag Tag {} {}  normal {}
  $ip_priv(mega)$pathName optionadd  -canvaspath canvasPath Path {} {}  normal {}
  $ip_priv(mega)$pathName optionadd  -canvasstatustag canvasstatustag Tag {} {}  normal {}
  $ip_priv(mega)$pathName optionadd  -changed changed Changed 0 0  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -clickinterval clickInterval ClickInterval 300 300  normal {}
  $ip_priv(mega)$pathName optionadd  -compressiconconf compressIconConf CompressIconConf 0 0  normal {}
  $ip_priv(mega)$pathName optionadd  -computeiconsize computeIconSize ComputeIconSize 1 1  normal {}
  $ip_priv(mega)$pathName optionadd  -dragdrop dragDrop DragDrop 0 0  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -dropcommand dropCommand Command {} {}  normal {}
  $ip_priv(mega)$pathName optionadd  -edgeorder edgeOrder EdgeOrder 0 0  normal {}
  $ip_priv(mega)$pathName optionadd  -edgefont1 edgeFont1 Font -*-Courier-Medium-R-Normal--8-80-*  -*-Courier-Medium-R-Normal--8-80-*  normal {}
  $ip_priv(mega)$pathName optionadd  -edgefont2 edgeFont2 Font -*-Courier-Medium-R-Normal--10-100-*  -*-Courier-Medium-R-Normal--10-100-*  normal {}
  $ip_priv(mega)$pathName optionadd  -edgefont3 edgeFont3 Font -*-Courier-Medium-R-Normal--12-120-*  -*-Courier-Medium-R-Normal--12-120-*  normal {}
  $ip_priv(mega)$pathName optionadd  -edgefont4 edgeFont4 Font -*-Courier-Medium-R-Normal--17-120-*  -*-Courier-Medium-R-Normal--17-120-*  normal {}
  $ip_priv(mega)$pathName optionadd  -edgefont5 edgeFont5 Font -*-Courier-Medium-R-Normal--24-240-*  -*-Courier-Medium-R-Normal--24-240-*  normal {}
  $ip_priv(mega)$pathName optionadd  -edgemenupath edgeMenuPath EdgeMenuPath {} {}  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -graphorder graphOrder graphOrder 0 0  normal {}
  $ip_priv(mega)$pathName optionadd  -iconfont1 iconFont1 Font -*-Courier-Medium-R-Normal--8-80-*  -*-Courier-Medium-R-Normal--8-80-*  normal {}
  $ip_priv(mega)$pathName optionadd  -iconfont2 iconFont2 Font -*-Courier-Medium-R-Normal--10-100-*  -*-Courier-Medium-R-Normal--10-100-*  normal {}
  $ip_priv(mega)$pathName optionadd  -iconfont3 iconFont3 Font -*-Courier-Medium-R-Normal--12-120-*  -*-Courier-Medium-R-Normal--12-120-* normal {}
  $ip_priv(mega)$pathName optionadd  -iconfont4 iconFont4 Font -*-Courier-Medium-R-Normal--17-120-*  -*-Courier-Medium-R-Normal--17-120-* normal {}
  $ip_priv(mega)$pathName optionadd  -iconfont5 iconFont5 Font -*-Courier-Medium-R-Normal--24-240-*  -*-Courier-Medium-R-Normal--24-240-* normal {}
  $ip_priv(mega)$pathName optionadd  -iconheight iconHeight IconHeight 40 40  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -iconmenupath iconMenuPath IconMenuPath {} {}  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -iconpixmappath iconPixmapPath IconPixmapPath {} {}  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -iconspaceh iconSpaceH IconSpace 4 4  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -iconspacev iconSpaceV IconSpace 4 4  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -iconstatuspath iconStatusPath IconStatusPath {} {}  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -iconwidth iconWidth IconWidth 40 40  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -layout layout Layout 1 1  normal {}
  $ip_priv(mega)$pathName optionadd  -layoutcommand layoutCommand Command {} {}  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -layoutupdate layoutUpdate LayoutUpdate 0 0  normal {}
  $ip_priv(mega)$pathName optionadd  -menu1 menu1 Menu {} {}  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -menu2 menu2 Menu {} {}  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -menu3 menu3 Menu {} {}  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -menubar menuBar Menu {} {}  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -menupath menuPath MenuPath {} {}  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -movefuzzy moveFuzzy MoveFuzzy 0 0  normal {}
  $ip_priv(mega)$pathName optionadd  -name name Name {} {}  normal {}
  $ip_priv(mega)$pathName optionadd  -placing placing Placing 1 1  normal {}
  $ip_priv(mega)$pathName optionadd  -scale scale Scale 1 1  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -scrollactiveforeground activeForeground Background #ffaeb9 #ffaeb9  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -scrollside scrollSide ScrollSide right right  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -sortcommand sortCommand Command {} {}  normal {}
  $ip_priv(mega)$pathName optionadd  -statusafter statusAfter StatusAfter 0 0  normal {}
  $ip_priv(mega)$pathName optionadd  -statusvariable statusVariable StatusVariable {} {}  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -title title Title {} {}  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -toolbarbottom toolbarBottom Toolbar {} {}  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -toolbarleft toolbarLeft Toolbar {} {}  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -toolbarright toolbarRight Toolbar {} {}  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -toolbartop toolbarTop Toolbar {} {}  normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd  -toplevel toplevel Toplevel 0 0  normal {}
  $ip_priv(mega)$pathName optionadd  -updateedges updateEdges UpdateEdges 1 1 normal {}

  # global commands
  $ip_priv(mega)$pathName minoradd  edgeconf {tkiconpane_minorEdgeConfig}
  $ip_priv(mega)$pathName minoradd  edgeconfig {tkiconpane_minorEdgeConfig}
  $ip_priv(mega)$pathName minoradd  edgeconfigure {tkiconpane_minorEdgeConfig}
  $ip_priv(mega)$pathName minoradd  edgecreate {tkiconpane_minorEdgeCreate}
  $ip_priv(mega)$pathName minoradd  edgedelete {tkiconpane_minorEdgeDelete}
  $ip_priv(mega)$pathName minoradd  edgeinfo {tkiconpane_minorEdgeInfo}
  $ip_priv(mega)$pathName minoradd  iconconf {tkiconpane_minorIconConfig}
  $ip_priv(mega)$pathName minoradd  iconconfig {tkiconpane_minorIconConfig}
  $ip_priv(mega)$pathName minoradd  iconconfigure {tkiconpane_minorIconConfig}
  $ip_priv(mega)$pathName minoradd  iconcreate {tkiconpane_minorIconCreate}
  $ip_priv(mega)$pathName minoradd  icondelete {tkiconpane_minorIconDelete}
  $ip_priv(mega)$pathName minoradd  iconinfo {tkiconpane_minorIconInfo}
  $ip_priv(mega)$pathName minoradd  layout {tkiconpane_minorLayout}
  $ip_priv(mega)$pathName minoradd  status {tkiconpane_minorStatus}
  $ip_priv(mega)$pathName minoradd  internal {tkiconpane_minorInternal}

  # create the widget structure
  frame $pathName.xfcanvas  -borderwidth 2  -relief groove

  frame $pathName.xfcanvas.xfcanvas  -borderwidth 0

  frame $pathName.xfcanvas.xfcanvas.xfscrolly  -borderwidth 0

  frame $pathName.xfcanvas.xfcanvas.xfscrolly.xfoffset  -borderwidth 0  -geometry 17x17

  scrollbar $pathName.xfcanvas.xfcanvas.xfscrolly.xfscrolly  -borderwidth 1  -command "$pathName.xfcanvas.xfcanvas.xfcanvas yview"  -relief sunken  -width 15

  scrollbar $pathName.xfcanvas.xfcanvas.xfscrollx  -borderwidth 1  -command "$pathName.xfcanvas.xfcanvas.xfcanvas xview"  -orient horizontal  -relief sunken  -width 15

  canvas $pathName.xfcanvas.xfcanvas.xfcanvas  -borderwidth 1  -confine {true}  -height 2  -relief sunken  -scrollregion {0c 0c 100c 100c}  -width 2  -xscrollcommand "$pathName.xfcanvas.xfcanvas.xfscrollx set"  -yscrollcommand "$pathName.xfcanvas.xfcanvas.xfscrolly.xfscrolly set"

  pack $pathName.xfcanvas.xfcanvas.xfscrolly.xfscrolly  -side top  -fill both  -expand 1
  pack $pathName.xfcanvas.xfcanvas.xfscrolly  -side right  -fill both
  pack $pathName.xfcanvas.xfcanvas.xfcanvas  -side top  -fill both  -expand 1
  pack $pathName.xfcanvas.xfcanvas  -side top  -fill both  -padx 2  -pady 2  -expand 1
  pack $pathName.xfcanvas  -side top  -fill both  -expand 1

  # bindings
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  bind $pathName <Map> "# xf ignore me 8
    $pathName internal bind_map"

  bind $canvasPath <Configure> "# xf ignore me 8
    $pathName internal bind_configure"
  bind $canvasPath <Button-1> "# xf ignore me 8
    $pathName internal bind_item_select 0 %W %x %y %X %Y"
  bind $canvasPath <Shift-Button-1> "# xf ignore me 8
    $pathName internal bind_item_select 1 %W %x %y %X %Y"
  bind $canvasPath <Control-Button-1> "# xf ignore me 8
    $pathName internal bind_item_select 1 %W %x %y %X %Y"
  bind $canvasPath <Any-B1-Motion> "# xf ignore me 8
    $pathName internal bind_item_select 10 %W %x %y %X %Y"
  bind $canvasPath <Any-ButtonRelease-1> "# xf ignore me 8
    $pathName internal bind_item_select 11 %W %x %y %X %Y"
  bind $canvasPath <Button-2> "# xf ignore me 8
    $pathName internal bind_item_select 3 %W %x %y %X %Y"
  bind $canvasPath <Control-Button-2> "# xf ignore me 8
    $pathName internal bind_item_select 4 %W %x %y %X %Y"
  bind $canvasPath <Any-B2-Motion> "# xf ignore me 8
    $pathName internal bind_item_select 10 %W %x %y %X %Y"
  bind $canvasPath <Any-ButtonRelease-2> "# xf ignore me 8
    $pathName internal bind_item_select 11 %W %x %y %X %Y"
  bind $canvasPath <Button-3> "# xf ignore me 8
    $pathName internal bind_menu_post %x %y %X %Y 1"
  bind $canvasPath <Meta-Button-3> "# xf ignore me 8
    $pathName internal bind_menu_post %x %y %X %Y 2"
  bind $canvasPath <Control-Button-3> "# xf ignore me 8
    $pathName internal bind_menu_post %x %y %X %Y 3"

  $canvasPath bind all <Any-Enter> "# xf ignore me 8
    $pathName internal bind_item_enter current"
  $canvasPath bind all <Any-Leave> "# xf ignore me 8
    $pathName internal bind_item_enter"

  # initialize the data
  $ip_priv(mega)$pathName interpset  ip_priv(currentPane) $pathName
  $ip_priv(mega)$pathName config  -canvaspath $canvasPath

  if {![string compare "mega" $ip_priv(mega)]} {
    # make some shortcuts for often used commands.
    proc $pathName args "catch \{eval $ip_priv(mega)$pathName interpeval $pathName \$args\} result; return \$result"
    proc $pathName.xfcanvas.xfcanvas.xfcanvas args "catch \{eval $ip_priv(mega)$pathName interpeval $pathName.xfcanvas.xfcanvas.xfcanvas \$args\} result; return \$result"
  }
}


# Procedure: tkiconpane_createEdgeMenu
proc tkiconpane_createEdgeMenu { name} {
  menu .emenu-$name  -postcommand "tkiconpane_updateMenu .emenu-$name"
}


# Procedure: tkiconpane_createIconMenu
proc tkiconpane_createIconMenu { name} {
  menu .imenu-$name  -postcommand "tkiconpane_updateMenu .imenu-$name"
}


# Procedure: tkiconpane_createMenubutton
proc tkiconpane_createMenubutton { name args} {
  global ip_priv

  set pathName [winfo parent [winfo parent $ip_priv(menuBar)]]
  eval menubutton $ip_priv(menuBar).$name  -menu $ip_priv(menuBar).$name.m  $args
  menu $ip_priv(menuBar).$name.m  -postcommand "
      $pathName internal setselected
      tkiconpane_updateMenu $ip_priv(menuBar).$name.m"
}


# Procedure: tkiconpane_createToolbarButton
proc tkiconpane_createToolbarButton { name args} {
  global ip_priv

  set pathName [winfo parent [winfo parent $ip_priv(toolBar)]]
  set tmpArgs ""
  set dropCommand ""
  for {set counter 0} {$counter < [llength $args]} {incr counter} {
    if {![string compare "-command" [lindex $args $counter]]} {
      lappend tmpArgs [lindex $args $counter]
      incr counter
      lappend tmpArgs "$pathName internal setselected; [lindex $args $counter]"
    } {
      if {![string compare "-dropcommand" [lindex $args $counter]]} {
        incr counter
        set dropCommand "$pathName internal setselected; [lindex $args $counter]"
      } {
        lappend tmpArgs [lindex $args $counter]
        incr counter
        lappend tmpArgs [lindex $args $counter]
      }
    }
  }
  catch "button $ip_priv(toolBar).$name $tmpArgs" result
  if {[$ip_priv(mega)$pathName confvalue -dragdrop] &&
      [string compare "" $dropCommand]} {
    if {$ip_priv(drag&dropType)} {
      blt_drag&drop target $ip_priv(toolBar).$name handler  TkIconPaneIcon "$pathName internal drag_drop_receive_toolbar $ip_priv(toolBar).$name \{$dropCommand\}"
    } {
      drag&drop target $ip_priv(toolBar).$name handler  "TkIconPaneIcon \"$pathName internal drag_drop_receive_toolbar $ip_priv(toolBar).$name \\\{$dropCommand\\\}\""
    }
  }
  return $result
}


# Procedure: tkiconpane_createViewMenu
proc tkiconpane_createViewMenu { name} {
  menu .vmenu-$name  -postcommand "tkiconpane_updateMenu .vmenu-$name"
}


# Procedure: tkiconpane_dropPosition
proc tkiconpane_dropPosition { pathName} {
  global ip_priv

  if {![$pathName confvalue -dragdrop]} {
    return ""
  }
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {$ip_priv(drag&dropType)} {
    set tmpPosition [blt_drag&drop location]
  } {
    set tmpPosition [drag&drop location]
  }
  set tmpX [$canvasPath canvasx [expr [lindex $tmpPosition 0]-[winfo rootx $canvasPath]]]
  set tmpY [$canvasPath canvasy [expr [lindex $tmpPosition 1]-[winfo rooty $canvasPath]]]
  return [list $tmpX $tmpY]
}


# Procedure: tkiconpane_info
proc tkiconpane_info { {type "path"} args} {
  global ip_priv

  set pathName $ip_priv(currentPane)
  case $type {
    {tkiconpanename} {
      return [lindex [$pathName config -name] 4]
    }
    {canvaspath} {
      return [lindex [$pathName config -canvaspath] 4]
    }
    {edgeinfo} {
      return [eval $pathName edgeinfo $args]
    }
    {iconinfo} {
      return [eval $pathName iconinfo $args]
    }
    {default} {
      return $pathName
    }
  }
  return ""
}


# Procedure: tkiconpane_internalConf
proc tkiconpane_internalConf { pathName resource oldValue newValue} {
# xf ignore me 8
  global ip_priv

  case $resource {
    {-activebackground -activeforeground -cursor -font} {
      $pathName recursiveconf $resource $newValue
    }
    {-background} {
      $pathName recursiveconf $resource $newValue
      if {[string compare "" [$ip_priv(mega)$pathName confvalue -canvasboxtag]]} {
        catch "$pathName.xfcanvas.xfcanvas.xfcanvas itemconfig  [$ip_priv(mega)$pathName confvalue -canvasboxtag]  -fill \{$newValue\} -outline \{$newValue\}"
      }
      if {[string compare "" [$ip_priv(mega)$pathName confvalue -canvasboxtag]]} {
        catch "$pathName.xfcanvas.xfcanvas.xfcanvas itemconfig  [$ip_priv(mega)$pathName confvalue -canvasboxtag]  -fill \{$newValue\}"
      }
    }
    {-foreground} {
      $pathName recursiveconf $resource $newValue
      if {[string compare "" [$ip_priv(mega)$pathName confvalue -canvasboxtag]]} {
        catch "$pathName.xfcanvas.xfcanvas.xfcanvas itemconfig  [$ip_priv(mega)$pathName confvalue -canvasboxtag]  -fill \{$newValue\}"
      }
    }
    {-padx -pady} {
      if {[string compare "" [$ip_priv(mega)$pathName interpeval info commands $pathName.xfmenu]]} {
        pack $pathName.xfmenu.xfmenu.xffile  $resource $newValue
        pack $pathName.xfmenu.xfmenu.xfhelp  $resource $newValue
        pack $pathName.xfmenu.xficons.xfchange  $resource $newValue
      }
      pack $pathName.xfcanvas.xfcanvas  $resource $newValue
    }

    {-changed} {
      if {[string compare "" [$ip_priv(mega)$pathName interpeval info commands $pathName.xfmenu]]} {
        if {$newValue} {
          catch "$pathName.xfmenu.xficons.xfchange config  -activebackground \{[$ip_priv(mega)$pathName confvalue -activebackground]\}"
          catch "$pathName.xfmenu.xficons.xfchange config  -activeforeground \{[$ip_priv(mega)$pathName confvalue -activeforeground]\}"
          catch "$pathName.xfmenu.xficons.xfchange config  -foreground \{[$ip_priv(mega)$pathName confvalue -foreground]\}"
        } {
          catch "$pathName.xfmenu.xficons.xfchange config  -activebackground \{[$ip_priv(mega)$pathName confvalue -background]\}"
          catch "$pathName.xfmenu.xficons.xfchange config  -activeforeground \{[$ip_priv(mega)$pathName confvalue -background]\}"
          catch "$pathName.xfmenu.xficons.xfchange config  -foreground \{[$ip_priv(mega)$pathName confvalue -background]\}"
        }
      }
    }
    {-dragdrop} {
      if {$newValue == 0 ||
          (![string compare "" [$ip_priv(mega)$pathName interpeval info commands drag&drop]] &&
           ![string compare "" [$ip_priv(mega)$pathName interpeval info commands blt_drag&drop]])} {
        $ip_priv(mega)$pathName confinternal $resource 0
      } {
        if {"[$ip_priv(mega)$pathName interpeval info commands blt_drag&drop]" != ""} {
          set ip_priv(drag&dropType) 1
          $ip_priv(mega)$pathName interpset ip_priv(drag&dropType) 1
        } {
          set ip_priv(drag&dropType) 0
          $ip_priv(mega)$pathName interpset ip_priv(drag&dropType) 0
        }
        if {$ip_priv(drag&dropType)} {
          blt_drag&drop source $pathName.xfcanvas.xfcanvas.xfcanvas config  -button 0  -selftarget true  -packagecmd "$pathName internal drag_drop_token"  -send all  -tokenanchor nw  -tokenborderwidth 0
          blt_drag&drop source $pathName.xfcanvas.xfcanvas.xfcanvas handler  TkIconPaneIcon "$pathName internal drag_drop_send"
          blt_drag&drop target $pathName.xfcanvas.xfcanvas.xfcanvas handler  TkIconPaneIcon "$pathName internal drag_drop_receive_iconpane"
        } {
          drag&drop source $pathName.xfcanvas.xfcanvas.xfcanvas  -button -1  -sendcmd "$pathName internal drag_drop_send"  -tokencmd "$pathName internal drag_drop_token"  -tokenborderwidth 0
          drag&drop target $pathName.xfcanvas.xfcanvas.xfcanvas handler  "TkIconPaneIcon \"$pathName internal drag_drop_receive_iconpane\""
        }
      }
    }
    {-edgemenupath} {
      $ip_priv(mega)$pathName interpset  ip_priv($pathName.xfcanvas.xfcanvas.xfcanvas,edgemenupath) $newValue
    }
    {-iconheight -iconspaceh -iconspacev -iconwidth} {
      if {[$ip_priv(mega)$pathName confhidden -initialized]} {
        tkiconpane_minorLayout $pathName -force 0
      }
    }
    {-iconmenupath} {
      $ip_priv(mega)$pathName interpset  ip_priv($pathName.xfcanvas.xfcanvas.xfcanvas,iconmenupath) $newValue
    }
    {-iconpixmappath} {
      $ip_priv(mega)$pathName interpset  ip_priv($pathName.xfcanvas.xfcanvas.xfcanvas,iconpixmappath) $newValue
    }
    {-iconstatuspath} {
      $ip_priv(mega)$pathName interpset  ip_priv($pathName.xfcanvas.xfcanvas.xfcanvas,iconstatuspath) $newValue
    }
    {-layoutcommand} {
      if {[string compare "" $newValue]} {
        pack $pathName.xfcanvas.xfcanvas.xfscrollx  -side bottom  -fill both
        pack $pathName.xfcanvas.xfcanvas.xfscrolly.xfoffset  -side bottom
      } {
        catch "pack forget $pathName.xfcanvas.xfcanvas.xfscrollx"
        catch "pack forget $pathName.xfcanvas.xfcanvas.xfscrolly.xfoffset"
      }
    }
    {-menu?} {
      if {[string compare "" $newValue] &&
          [string compare "" [string index $newValue 0]] &&
          ![string compare "" [$ip_priv(mega)$pathName interpeval info commands .vmenu-$newValue]]} {
        foreach tmpElement [$ip_priv(mega)$pathName confvalue -menupath] {
          if {[file exists $tmpElement/$newValue.vmenu]} {
            catch "source $tmpElement/$newValue.vmenu"
            break
          }
        }
      }
    }
    {-menubar} {
      if {![string compare "" [$ip_priv(mega)$pathName interpeval info commands $pathName.xfcanvas]]} {
        return
      }
      if {[string compare "" [$ip_priv(mega)$pathName interpeval info commands $pathName.xfmenu]]} {
        foreach children [$ip_priv(mega)$pathName interpeval winfo children $pathName.xfmenu.xfmenu] {
          catch "destroy $children"
        }
      }
      if {[string compare "" $newValue]} {
        set menupath [$ip_priv(mega)$pathName conf -menupath]
        if {![string compare "" $menupath]} {
          return
        }
        set padx [$ip_priv(mega)$pathName confvalue -pady]
        set pady [$ip_priv(mega)$pathName confvalue -pady]
        if {![string compare "" [$ip_priv(mega)$pathName interpeval info commands $pathName.xfmenu]]} {
          frame $pathName.xfmenu  -borderwidth 0

          frame $pathName.xfmenu.xfmenu  -borderwidth 2  -relief groove
  
          frame $pathName.xfmenu.xficons  -borderwidth 2  -relief groove
  
          button $pathName.xfmenu.xficons.xfchange  -anchor c  -bitmap warning  -borderwidth 0  -command "$pathName config -changed 0"  -height 19  -width 19

          pack $pathName.xfmenu.xfmenu  -side left  -fill both  -expand 1
          pack $pathName.xfmenu.xficons.xfchange  -side left  -padx $padx  -pady $pady  -fill both
          pack $pathName.xfmenu.xficons  -side right  -fill both
        }
        set ip_priv(menuBar) $pathName.xfmenu.xfmenu
        foreach element $menupath {
          if {[file exists $element/$newValue.mbar]} {
            source $element/$newValue.mbar
            break
          }
        }
        set traversal "tk_menuBar $pathName.xfmenu.xfmenu "
        foreach children [winfo children $pathName.xfmenu.xfmenu] {
          append traversal "$children "
        }
        catch $traversal
        pack $pathName.xfmenu  -before $pathName.xfcanvas.xfcanvas  -side top  -fill both
      } {
        catch "pack forget $pathName.xfmenu"
      }
    }
    {-menupath} {
      $ip_priv(mega)$pathName conf  -menu1 [$ip_priv(mega)$pathName confvalue -menu1]
      $ip_priv(mega)$pathName conf  -menu2 [$ip_priv(mega)$pathName confvalue -menu2]
      $ip_priv(mega)$pathName conf  -menu3 [$ip_priv(mega)$pathName confvalue -menu3]
      $ip_priv(mega)$pathName conf  -menubar [$ip_priv(mega)$pathName confvalue -menubar]
      $ip_priv(mega)$pathName conf  -toolbarleft [$ip_priv(mega)$pathName confvalue -toolbarleft]
      $ip_priv(mega)$pathName conf  -toolbarright [$ip_priv(mega)$pathName confvalue -toolbarright]
      $ip_priv(mega)$pathName conf  -toolbartop [$ip_priv(mega)$pathName confvalue -toolbartop]
      $ip_priv(mega)$pathName conf  -toolbarbottom [$ip_priv(mega)$pathName confvalue -toolbarbottom]
    }
    {-scale} {
      if {"$oldValue" != "$newValue"} {
        tkiconpane_internalScale $pathName $oldValue
      }
    }
    {-scrollactiveforeground} {
      $pathName.xfcanvas.xfcanvas.xfscrolly.xfscrolly conf  -activeforeground $newValue
      $pathName.xfcanvas.xfcanvas.xfscrollx conf  -activeforeground $newValue
    }
    {-scrollside} {
      pack $pathName.xfcanvas.xfcanvas.xfscrolly  -side $newValue  -fill both
    }
    {-statusvariable} {
      if {[string compare "" $newValue]} {
        bind $pathName <Destroy> "# xf ignore me 9
          unset $newValue"
        catch "$ip_priv(mega)$pathName interpeval unset $oldValue"
        catch "$ip_priv(mega)$pathName interpset $newValue \"\""
        catch "$ip_priv(mega)$pathName interpeval trace vdelete $oldValue w \"$pathName internal showstatus \""
        catch "$ip_priv(mega)$pathName interpeval trace variable $newValue w \"$pathName internal showstatus\""
        catch "$ip_priv(mega)$pathName interpset $newValue \"\""
      }
    }
    {-title} {
      wm title [winfo toplevel $pathName] $newValue
    }
    {-toolbar*} {
      if {![string compare "" [$ip_priv(mega)$pathName interpeval info commands $pathName.xfcanvas]]} {
        return
      }
      set side [string range $resource 8 end]
      if {[string compare "" [$ip_priv(mega)$pathName interpeval info commands $pathName.xfcanvas.xftoolbar$side]]} {
        foreach children [winfo children $pathName.xfcanvas.xftoolbar$side] {
          catch "destroy $children"
        }
      }
      if {[string compare "" $newValue]} {
        set menupath [$ip_priv(mega)$pathName confvalue -menupath]
        if {![string compare "" $menupath]} {
          return
        }
        set padx [$ip_priv(mega)$pathName confvalue -pady]
        set pady [$ip_priv(mega)$pathName confvalue -pady]
        if {"$side" == "left" || "$side" == "right"} {
          set buttonside top
          set revbuttonside button
        } {
          set buttonside left
          set revbuttonside right
        }
        if {![string compare "" [$ip_priv(mega)$pathName interpeval info commands $pathName.xfcanvas.xftoolbar$side]]} {
          frame $pathName.xfcanvas.xftoolbar$side  -borderwidth 2  -relief groove
        }
        set ip_priv(toolBar) $pathName.xfcanvas.xftoolbar$side
        foreach element $menupath {
          if {[file exists $element/$newValue.tbar]} {
            source $element/$newValue.tbar
            break
          }
        }
        pack $pathName.xfcanvas.xftoolbar$side  -before $pathName.xfcanvas.xfcanvas  -side $side  -fill both
      } {
        catch "pack forget $pathName.xfcanvas.xftoolbar$side"
      }
    }
  }
  return ""
}


# Procedure: tkiconpane_internalDragDropReceiveIconPane
proc tkiconpane_internalDragDropReceiveIconPane { pathName} {
# xf ignore me 8
  global ip_priv

  if {![$ip_priv(mega)$pathName confvalue -dragdrop]} {
    return
  }
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  set dropCommand ""
  set targetId ""
  if {$ip_priv(drag&dropType)} {
    set tmpPosition [$ip_priv(mega)$pathName interpeval blt_drag&drop location]
  } {
    set tmpPosition [$ip_priv(mega)$pathName interpeval drag&drop location]
  }
  set tmpX [$canvasPath canvasx [expr [lindex $tmpPosition 0]-[winfo rootx $canvasPath]]]
  set tmpY [$canvasPath canvasy [expr [lindex $tmpPosition 1]-[winfo rooty $canvasPath]]]
  set targetId [$canvasPath find closest $tmpX $tmpY]

  if {[string compare "" $targetId]} {
    set tmpBbox [$canvasPath bbox $targetId]
    if {$tmpX < [lindex $tmpBbox 0] || $tmpX > [lindex $tmpBbox 2] ||
        $tmpY < [lindex $tmpBbox 1] || $tmpY > [lindex $tmpBbox 3]} {
      set targetId ""
    }
  }
  if {[string compare "" $targetId]} {
    if {![string compare "icon" [$canvasPath type $targetId]]} {
      set dropCommand [lindex [$canvasPath itemconfig $targetId -dropcommand] 4]
    } {
      set targetId ""
    }
  } {
    set dropCommand [$ip_priv(mega)$pathName confvalue -dropcommand]
  }

  set ip_priv(drag&dropIconId) [$ip_priv(mega)$pathName  interpset ip_priv(drag&dropIconId)]
  set ip_priv(drag&dropInterpreter) [$ip_priv(mega)$pathName  interpset ip_priv(drag&dropInterpreter)]
  set ip_priv(drag&dropPath) [$ip_priv(mega)$pathName  interpset ip_priv(drag&dropPath)]

  if {[string compare "" $dropCommand]} {
    if {[catch "$ip_priv(mega)$pathName interpeval $dropCommand \{$ip_priv(drag&dropPath)\} \{$ip_priv(drag&dropIconId)\} \{$pathName\} \{$targetId\}" result]} {
      error $result
    }
  } {
    if {![string compare $pathName $ip_priv(drag&dropPath)] &&
        ![string compare "" $targetId] &&
        [$ip_priv(mega)$pathName confvalue -placing]} {
      set tmpPos [tkiconpane_dropPosition $pathName]
      $ip_priv(mega)$pathName iconconfig $ip_priv(drag&dropIconId)  -x [lindex $tmpPos 0]  -y [lindex $tmpPos 1]
      if {[$ip_priv(mega)$pathName confvalue -updateedges]} {
        $canvasPath layout edges -edgeorder [$ip_priv(mega)$pathName confvalue -edgeorder] -graphorder [$ip_priv(mega)$pathName confvalue -graphorder]
      }
    }
  }
  return
}


# Procedure: tkiconpane_internalDragDropReceiveToolbar
proc tkiconpane_internalDragDropReceiveToolbar { pathName receivePath dropCommand} {
# xf ignore me 8
  global ip_priv

  if {![$ip_priv(mega)$pathName confvalue -dragdrop]} {
    return
  }
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas

  set ip_priv(drag&dropIconId) [$ip_priv(mega)$pathName  interpset ip_priv(drag&dropIconId)]
  set ip_priv(drag&dropInterpreter) [$ip_priv(mega)$pathName  interpset ip_priv(drag&dropInterpreter)]
  set ip_priv(drag&dropPath) [$ip_priv(mega)$pathName  interpset ip_priv(drag&dropPath)]

  if {[catch "$ip_priv(mega)$pathName interpeval $dropCommand \{$ip_priv(drag&dropPath)\} \{$ip_priv(drag&dropIconId)\} \{$receivePath\}" result]} {
    error $result
  }
  return
}


# Procedure: tkiconpane_internalDragDropSend
proc tkiconpane_internalDragDropSend { interp dragTarget token} {
# xf ignore me 8
  global ip_priv

  set pathName [lindex $token 0]
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {[catch "$ip_priv(mega)$pathName interpeval send \{$interp\} tkiconpane_receiveIcon \{[winfo name .]\} \{$token\}" result]} {
    error $result
  }
  if {$ip_priv(drag&dropType)} {
    if {[catch "$ip_priv(mega)$pathName interpeval send \{$interp\} blt_drag&drop target \{$dragTarget\} handle TkIconPaneIcon" result]} {
      error $result
    }
  } {
    if {[catch "$ip_priv(mega)$pathName interpeval send \{$interp\} drag&drop target \{$dragTarget\} handle TkIconPaneIcon" result]} {
      error $result
    }
  }
  return
}


# Procedure: tkiconpane_internalDragDropToken
proc tkiconpane_internalDragDropToken { pathName dragPathName} {
# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {[string compare "" [$ip_priv(mega)$pathName confhidden -selectedicon]]} {
    set tmpIcon [$ip_priv(mega)$pathName confhidden -selectedicon]
  } {
    set tmpIcon [$ip_priv(mega)$pathName confhidden -currentid]
  }
  if {[string compare "" $tmpIcon]} {
    if {![string compare "" [$ip_priv(mega)$pathName interpeval info commands $dragPathName.canvas]]} {
      canvas $dragPathName.canvas
      foreach option [$canvasPath config] {
        if {[llength $option] == 5 &&
            [string compare "-confine" [lindex $option 0]] &&
            [string compare "-width" [lindex $option 0]] &&
            [string compare "-height" [lindex $option 0]] &&
            [string compare "-scrollregion" [lindex $option 0]] &&
            [string compare "-xscrollcommand" [lindex $option 0]] &&
            [string compare "-yscrollcommand" [lindex $option 0]] &&
            [string compare [lindex $option 3] [lindex $option 4]]} {
          $dragPathName.canvas config [lindex $option 0] [lindex $option 4]
        }
      }
      $dragPathName.canvas config -borderwidth 0
      pack append $dragPathName $dragPathName.canvas {top fill expand}

      $ip_priv(mega)$pathName confhidden -dragdropicon  [$dragPathName.canvas create icon 0 0]
    }
    foreach option [$canvasPath itemconfig $tmpIcon] {
      if {[llength $option] == 5 &&
          (![string compare "-background" [lindex $option 0]] ||
           ![string compare "-borderwidth" [lindex $option 0]] ||
           ![string compare "-bitmap" [lindex $option 0]] ||
           ![string compare "-mask" [lindex $option 0]] ||
           ![string compare "-font" [lindex $option 0]] ||
           ![string compare "-foreground" [lindex $option 0]] ||
           ![string compare "-foreground" [lindex $option 0]] ||
           ![string compare "-relief" [lindex $option 0]] ||
           ![string compare "-state" [lindex $option 0]] ||
           ![string compare "-status" [lindex $option 0]] ||
           ![string compare "-statusbitmap" [lindex $option 0]] ||
           ![string compare "-statusmask" [lindex $option 0]] ||
           ![string compare "-textanchor" [lindex $option 0]] ||
           ![string compare "-text" [lindex $option 0]] ||
           ![string compare "-width" [lindex $option 0]])} {
        $dragPathName.canvas itemconfig [$ip_priv(mega)$pathName confhidden -dragdropicon]  [lindex $option 0] [lindex $option 4]
      }
    }
    set bbox [$canvasPath bbox $tmpIcon]
    $dragPathName.canvas config  -height [expr [lindex $bbox 3]-[lindex $bbox 1]]  -width [expr [lindex $bbox 2]-[lindex $bbox 0]]
    return [list $pathName $tmpIcon]
  } {
    error "No icon"
  }
}


# Procedure: tkiconpane_internalItemActivate
proc tkiconpane_internalItemActivate { pathName x y} {
# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {[string compare "" [$ip_priv(mega)$pathName confhidden -selectediconlist]] && [lsearch [$ip_priv(mega)$pathName confhidden -selectediconlist] [$ip_priv(mega)$pathName confhidden -currentid]] != -1} {
    foreach counter [$ip_priv(mega)$pathName confhidden -selectediconlist] {
      set tmpCommand [lindex [$canvasPath itemconfig $counter -command] 4]
      if {[string compare "" $tmpCommand]} {
        if {[catch "$tmpCommand $counter" result]} {
           puts stderr $result
        }
      }
    }
  } {
    set counter [$ip_priv(mega)$pathName confhidden -currentid]
    if {![string compare [$canvasPath type $counter] "icon"]} {
      set tmpCommand [lindex [$canvasPath itemconfig $counter -command] 4]
      if {[string compare "" $tmpCommand]} {
        if {[catch "$tmpCommand $counter" result]} {
          puts stderr $result
        }
      }      
    }
  }
}


# Procedure: tkiconpane_internalItemDeSelect
proc tkiconpane_internalItemDeSelect { pathName {canvasDesel "0"}} {
# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {!$canvasDesel ||
      ![string compare "" [$ip_priv(mega)$pathName confhidden -selectedid]]} {
    foreach counter [$ip_priv(mega)$pathName confhidden -selectediconlist] {
      $canvasPath itemconfig $counter -state normal
    }
    foreach counter [$ip_priv(mega)$pathName confhidden -selectededgelist] {
      $canvasPath itemconfig $counter -state normal
    }
    $ip_priv(mega)$pathName confhidden -selectediconlist ""
    $ip_priv(mega)$pathName confhidden -selectededgelist ""
  }
}


# Procedure: tkiconpane_internalItemMoveMove
proc tkiconpane_internalItemMoveMove { pathName w x y X Y} {
# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {[string compare "" [$ip_priv(mega)$pathName confhidden -moveitems]] &&
      [$ip_priv(mega)$pathName confhidden -eventtype] == 3} {
    if {[$ip_priv(mega)$pathName confvalue -dragdrop]} {
      if {$ip_priv(drag&dropType)} {
        $ip_priv(mega)$pathName interpeval blt_drag&drop drag $w $X $Y
      } {
        $ip_priv(mega)$pathName interpeval drag&drop drag $w $X $Y
      }
      return
    }
    if {[string compare "" [$ip_priv(mega)$pathName confhidden -moveitems]]} {
      foreach counter [$ip_priv(mega)$pathName confhidden -moveitems] {
        $canvasPath move $counter [expr [$canvasPath canvasx $x]-[$ip_priv(mega)$pathName confhidden -x]] [expr [$canvasPath canvasy $y]-[$ip_priv(mega)$pathName confhidden -y]]
        set newX [lindex [$canvasPath coords $counter] 0]
        if {$newX < 0} {
          set newX 0
        }
        set newY [lindex [$canvasPath coords $counter] 1]
        if {$newY < 0} {
          set newY 0
        }
        $canvasPath coords $counter $newX $newY
      }
    }
    $ip_priv(mega)$pathName confhidden  -x [$canvasPath canvasx $x]
    $ip_priv(mega)$pathName confhidden  -y [$canvasPath canvasy $y]
  } {
    if {([$ip_priv(mega)$pathName confhidden -eventtype] == 1 ||
         [$ip_priv(mega)$pathName confhidden -eventtype] == 2 ||
         [$ip_priv(mega)$pathName confhidden -eventtype] == 4)} {
      $ip_priv(mega)$pathName confhidden  -stretchx [$canvasPath canvasx $x]
      $ip_priv(mega)$pathName confhidden  -stretchy [$canvasPath canvasy $y]
      $canvasPath coords [$ip_priv(mega)$pathName confhidden -stretch] [$ip_priv(mega)$pathName confhidden -stretchxroot] [$ip_priv(mega)$pathName confhidden -stretchyroot] [$ip_priv(mega)$pathName confhidden -stretchx] [$ip_priv(mega)$pathName confhidden -stretchy]
    } {
      if {[$ip_priv(mega)$pathName confhidden -eventtype] == 3} {
        $canvasPath scan dragto $x $y
      }
    }
  }
}


# Procedure: tkiconpane_internalItemMoveStart
proc tkiconpane_internalItemMoveStart { pathName w x y X Y} {
# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {[string compare "" [$ip_priv(mega)$pathName confhidden -currentid]]} {
    if {![string compare "icon" [$canvasPath type [$ip_priv(mega)$pathName confhidden -currentid]]] &&
        [$ip_priv(mega)$pathName confhidden -eventtype] == 3} {
      if {[string compare "" [$ip_priv(mega)$pathName confhidden -selectedicon]] && [lsearch [$ip_priv(mega)$pathName confhidden -selectedicon] [$ip_priv(mega)$pathName confhidden -currentid]] != -1} {
        set tmpIcon [$ip_priv(mega)$pathName confhidden -selectedicon]
      } {
        set tmpIcon [$ip_priv(mega)$pathName confhidden -currentid]
      }
      if {[$ip_priv(mega)$pathName confvalue -dragdrop]} {
        $ip_priv(mega)$pathName confhidden -dragdrophideicon [list $tmpIcon [lindex [$canvasPath itemconfig $tmpIcon -x] 4] [lindex [$canvasPath itemconfig $tmpIcon -y] 4]]
        $canvasPath itemconfig $tmpIcon -x -1000 -y -1000
        if {$ip_priv(drag&dropType)} {
          $ip_priv(mega)$pathName interpeval blt_drag&drop drag $w $X $Y
        } {
          $ip_priv(mega)$pathName interpeval drag&drop drag $w $X $Y
        }
        $ip_priv(mega)$pathName confhidden  -moveitems $tmpIcon
        return
      }
      $ip_priv(mega)$pathName confhidden  -startx [$canvasPath canvasx $x]
      $ip_priv(mega)$pathName confhidden  -starty [$canvasPath canvasy $y]
      $ip_priv(mega)$pathName confhidden  -x [$canvasPath canvasx $x]
      $ip_priv(mega)$pathName confhidden  -y [$canvasPath canvasy $y]
      $ip_priv(mega)$pathName confhidden  -moveitems ""
      set tmpIds ""
      foreach counter [$ip_priv(mega)$pathName confhidden -selectediconlist] {
        if {![catch "$canvasPath itemconfig $counter -name"]} {
          $canvasPath raise $counter
          set tmpIds [$ip_priv(mega)$pathName confhidden -moveitems]
          lappend tmpIds $counter
          $ip_priv(mega)$pathName confhidden  -moveitems $tmpIds
        }
      }
      if {![string compare "" [$ip_priv(mega)$pathName confhidden -moveitems]] ||
          [lsearch $tmpIds [$ip_priv(mega)$pathName confhidden -currentid]] == -1} {
        $ip_priv(mega)$pathName confhidden -moveitems $tmpIcon
        $canvasPath raise $tmpIcon
      }
    }
  } {
    if {([$ip_priv(mega)$pathName confhidden -eventtype] == 1 ||
         [$ip_priv(mega)$pathName confhidden -eventtype] == 2 ||
         [$ip_priv(mega)$pathName confhidden -eventtype] == 4)} {
      if {[string compare "" [$ip_priv(mega)$pathName confhidden -stretch]]} {
        $canvasPath delete [$ip_priv(mega)$pathName confhidden -stretch]
      }
      $ip_priv(mega)$pathName confhidden  -stretchxroot [$canvasPath canvasx $x]
      $ip_priv(mega)$pathName confhidden  -stretchyroot [$canvasPath canvasy $y]
      $ip_priv(mega)$pathName confhidden  -stretchx [$canvasPath canvasx $x]
      $ip_priv(mega)$pathName confhidden  -stretchy [$canvasPath canvasy $y]
      $ip_priv(mega)$pathName confhidden  -stretch [$canvasPath create rectangle [$ip_priv(mega)$pathName confhidden -stretchxroot] [$ip_priv(mega)$pathName confhidden -stretchyroot] [$ip_priv(mega)$pathName confhidden -stretchx] [$ip_priv(mega)$pathName confhidden -stretchy]]
    } {
      if {[$ip_priv(mega)$pathName confhidden -eventtype] == 3} {
        $canvasPath scan mark $x $y
      }
    }
  }
}


# Procedure: tkiconpane_internalItemMoveStop
proc tkiconpane_internalItemMoveStop { pathName w x y X Y} {
# xf ignore me 8
  global ip_priv

  $ip_priv(mega)$pathName confhidden -iconsmoved 1
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {[string compare "" [$ip_priv(mega)$pathName confhidden -moveitems]] &&
      [$ip_priv(mega)$pathName confhidden -eventtype] == 3} {
    if {[$ip_priv(mega)$pathName confvalue -dragdrop]} {
      if {[string compare "" [$ip_priv(mega)$pathName confhidden -dragdrophideicon]]} {
        $canvasPath itemconfig [lindex [$ip_priv(mega)$pathName confhidden -dragdrophideicon] 0] -x [lindex [$ip_priv(mega)$pathName confhidden -dragdrophideicon] 1] -y [lindex [$ip_priv(mega)$pathName confhidden -dragdrophideicon] 2]
      }
      $ip_priv(mega)$pathName confhidden -dragdrophideicon ""
      if {$ip_priv(drag&dropType)} {
        $ip_priv(mega)$pathName interpeval blt_drag&drop drop $w $X $Y
      } {
        $ip_priv(mega)$pathName interpeval drag&drop drop $w $X $Y
      }
      $ip_priv(mega)$pathName confhidden -moveitems ""
      return
    }
    if {![$ip_priv(mega)$pathName confvalue -placing]} {
      if {[string compare "" [$ip_priv(mega)$pathName confhidden -moveitems]]} {
        foreach counter [$ip_priv(mega)$pathName confhidden -moveitems] {
          $canvasPath move $counter [expr [$canvasPath canvasx [$ip_priv(mega)$pathName confhidden -startx]]-[$ip_priv(mega)$pathName confhidden -x]] [expr [$canvasPath canvasy [$ip_priv(mega)$pathName confhidden -starty]]-[$ip_priv(mega)$pathName confhidden -y]]
          set newX [lindex [$canvasPath coords $counter] 0]
          if {$newX < 0} {
            set newX 0
          }
          set newY [lindex [$canvasPath coords $counter] 1]
          if {$newY < 0} {
            set newY 0
          }
          $canvasPath coords $counter $newX $newY
        }
      }
    } {
      if {[string compare "" [$ip_priv(mega)$pathName confhidden -moveitems]]} {
        set fuzzy [$ip_priv(mega)$pathName confvalue -movefuzzy]
        if {$fuzzy > 0 &&
            [expr abs(([$ip_priv(mega)$pathName confhidden -x]) -  abs([$ip_priv(mega)$pathName confhidden -startx]))] < $fuzzy &&
            [expr abs(abs([$ip_priv(mega)$pathName confhidden -y]) -  abs([$ip_priv(mega)$pathName confhidden -starty]))] < $fuzzy} {
          foreach counter [$ip_priv(mega)$pathName confhidden -moveitems] {
            $canvasPath move $counter [expr [$canvasPath canvasx [$ip_priv(mega)$pathName confhidden -startx]]-[$ip_priv(mega)$pathName confhidden -x]] [expr [$canvasPath canvasy [$ip_priv(mega)$pathName confhidden -starty]]-[$ip_priv(mega)$pathName confhidden -y]]
            set newX [lindex [$canvasPath coords $counter] 0]
            if {$newX < 0} {
              set newX 0
            }
            set newY [lindex [$canvasPath coords $counter] 1]
            if {$newY < 0} {
              set newY 0
            }
            $canvasPath coords $counter $newX $newY
          }
        }
        foreach counter [$ip_priv(mega)$pathName confhidden -moveitems] {
          foreach edge [lindex [$canvasPath itemconfig $counter -edges] 4] {
            if {![string compare $counter [lindex $edge 0]] ||
                ![string compare $counter [lindex $edge 1]]} {
              $canvasPath layout item -idlist [lindex $edge 2] -edgeorder [$ip_priv(mega)$pathName confvalue -edgeorder] -graphorder [$ip_priv(mega)$pathName confvalue -graphorder]
            }
          }
        }
      }
    }
    $ip_priv(mega)$pathName confhidden -moveitems ""
  } {
    if {[string compare "" [$ip_priv(mega)$pathName confhidden -stretch]]} {
      if {[$ip_priv(mega)$pathName confhidden -eventtype] == 4} {
        set oldscale [$ip_priv(mega)$pathName confvalue -scale]
        set canvasstatustag [$ip_priv(mega)$pathName confvalue -canvasstatustag] 
        set canvasboxtag [$ip_priv(mega)$pathName confvalue -canvasboxtag]
        $ip_priv(mega)$pathName confinternal  -canvasstatustag ""  -canvasboxtag ""
        if {"$canvasstatustag" != ""} {
          $canvasPath delete $canvasstatustag
        }
        if {"$canvasboxtag" != ""} {
          $canvasPath delete $canvasboxtag
        }
        set bbox1 [$canvasPath bbox [$ip_priv(mega)$pathName confhidden -stretch]]
        set bbox2 [$canvasPath bbox all]
        set xscale [expr ([lindex $bbox2 2]-[lindex $bbox2 0].0)/  ([lindex $bbox1 2]-[lindex $bbox1 0].0)]
        set yscale [expr ([lindex $bbox2 3]-[lindex $bbox2 1].0)/  ([lindex $bbox1 3]-[lindex $bbox1 1].0)]
        if {$xscale > $yscale} {
          set scale $yscale
        } {
          set scale $xscale
        }
        if {$scale <= 0} {
          set scale 1
        }
        $ip_priv(mega)$pathName confinternal -scale $scale
        set originX [$ip_priv(mega)$pathName confhidden -stretchxroot]
        set originY [$ip_priv(mega)$pathName confhidden -stretchyroot]
        set closest [$canvasPath find closest $originX $originY]
        tkiconpane_internalScale $pathName $oldscale
        set bbox1 [$canvasPath bbox $closest]
        $canvasPath xview [expr ([lindex $bbox1 0]/10)]
        $canvasPath yview [expr ([lindex $bbox1 1]/10)]
      } {
        if {[$ip_priv(mega)$pathName confhidden -eventtype] == 1 ||
            [$ip_priv(mega)$pathName confhidden -eventtype] == 2} {
          foreach counter [$canvasPath find enclosed [$ip_priv(mega)$pathName confhidden -stretchxroot] [$ip_priv(mega)$pathName confhidden -stretchyroot] [$ip_priv(mega)$pathName confhidden -stretchx] [$ip_priv(mega)$pathName confhidden -stretchy]] {
            if {![string compare "icon" [$canvasPath type $counter]]} {
              $canvasPath itemconfig $counter -state selected
              set tmpList [$ip_priv(mega)$pathName confhidden -selectediconlist]
              set tmpPosition [lsearch $tmpList $counter]
              if {$tmpPosition == -1} {
                lappend tmpList $counter
                $ip_priv(mega)$pathName confhidden -selectediconlist $tmpList
              }
            }
          }
        }
      }
      $canvasPath delete [$ip_priv(mega)$pathName confhidden -stretch]
      $ip_priv(mega)$pathName confhidden -stretch ""
    }
  }
}


# Procedure: tkiconpane_internalItemSelect
proc tkiconpane_internalItemSelect { pathName x y {keepSelection "0"}} {
# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {[string compare "" [$ip_priv(mega)$pathName confhidden -selectedid]]} {
    set tmpState [lindex [$canvasPath itemconfig [$ip_priv(mega)$pathName confhidden -selectedid] -state] 4]
    if {![string compare "selected" $tmpState] && !$keepSelection} {
      $canvasPath itemconfig [$ip_priv(mega)$pathName confhidden -selectedid] -state normal
      if {![string compare "icon" [$canvasPath type [$ip_priv(mega)$pathName confhidden -selectedid]]]} {
        set tmpList [$ip_priv(mega)$pathName confhidden -selectediconlist]
        set tmpPosition [lsearch $tmpList [$ip_priv(mega)$pathName confhidden -selectedid]]
        if {$tmpPosition != -1} {
          $ip_priv(mega)$pathName confhidden -selectediconlist [lreplace $tmpList $tmpPosition $tmpPosition]
        }
      } {
        if {![string compare "edge" [$canvasPath type [$ip_priv(mega)$pathName confhidden -selectedid]]]} {
          set tmpList [$ip_priv(mega)$pathName confhidden -selectededgelist]
          set tmpPosition [lsearch $tmpList [$ip_priv(mega)$pathName confhidden -selectedid]]
          if {$tmpPosition != -1} {
            $ip_priv(mega)$pathName confhidden -selectededgelist [lreplace $tmpList $tmpPosition $tmpPosition]
          }
        }
      }
    } {
      if {![string compare "selected" [lindex [$canvasPath itemconfig [$ip_priv(mega)$pathName confhidden -selectedid] -state] 4]]} {
        $canvasPath itemconfig [$ip_priv(mega)$pathName confhidden -selectedid] -state normal
        if {![string compare "icon" [$canvasPath type [$ip_priv(mega)$pathName confhidden -selectedid]]]} {
          set tmpList [$ip_priv(mega)$pathName confhidden -selectediconlist]
          set tmpPosition [lsearch $tmpList [$ip_priv(mega)$pathName confhidden -selectedid]]
          if {$tmpPosition != -1} {
            $ip_priv(mega)$pathName confhidden -selectediconlist [lreplace $tmpList $tmpPosition $tmpPosition]
          }
        } {
          if {![string compare "edge" [$canvasPath type [$ip_priv(mega)$pathName confhidden -selectedid]]]} {
            set tmpList [$ip_priv(mega)$pathName confhidden -selectededgelist]
            set tmpPosition [lsearch $tmpList [$ip_priv(mega)$pathName confhidden -selectedid]]
            if {$tmpPosition != -1} {
              $ip_priv(mega)$pathName confhidden -selectededgelist [lreplace $tmpList $tmpPosition $tmpPosition]
            }
          }
        }
      } {
        $canvasPath itemconfig [$ip_priv(mega)$pathName confhidden -selectedid] -state selected
        if {![string compare "icon" [$canvasPath type [$ip_priv(mega)$pathName confhidden -selectedid]]]} {
          set tmpList [$ip_priv(mega)$pathName confhidden -selectediconlist]
          set tmpPosition [lsearch $tmpList [$ip_priv(mega)$pathName confhidden -selectedid]]
          if {$tmpPosition == -1} {
            lappend tmpList [$ip_priv(mega)$pathName confhidden -selectedid]
            $ip_priv(mega)$pathName confhidden -selectediconlist $tmpList
          }
        } {
          if {![string compare "edge" [$canvasPath type [$ip_priv(mega)$pathName confhidden -selectedid]]]} {
            set tmpList [$ip_priv(mega)$pathName confhidden -selectededgelist]
            set tmpPosition [lsearch $tmpList [$ip_priv(mega)$pathName confhidden -selectedid]]
            if {$tmpPosition == -1} {
              lappend tmpList [$ip_priv(mega)$pathName confhidden -selectedid]
              $ip_priv(mega)$pathName confhidden -selectededgelist $tmpList
            }
          }
        }
      }
    }
  } {
    tkiconpane_internalItemDeSelect $pathName
  }
}


# Procedure: tkiconpane_internalItemSetSelected
proc tkiconpane_internalItemSetSelected { pathName {itemId ""}} {
# xf ignore me 8
  global ip_priv

  $ip_priv(mega)$pathName interpset ip_priv(currentPane) $pathName
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {![string compare "" $itemId]} {
    set itemId [$ip_priv(mega)$pathName confhidden -currentid]
  }
  if {[string compare "" $itemId] &&
      ![string compare "icon" [$canvasPath type $itemId]]} {
    $ip_priv(mega)$pathName confhidden -selectededge ""
    $ip_priv(mega)$pathName confhidden -selectedicon $itemId
    $ip_priv(mega)$pathName confhidden -selectedid $itemId
  } {
    if {[string compare "" $itemId] &&
        ![string compare "edge" [$canvasPath type $itemId]]} {
      $ip_priv(mega)$pathName confhidden -selectededge $itemId
      $ip_priv(mega)$pathName confhidden -selectedicon ""
      $ip_priv(mega)$pathName confhidden -selectedid $itemId
    } {
      $ip_priv(mega)$pathName confhidden -selectededge ""
      $ip_priv(mega)$pathName confhidden -selectedicon ""
      $ip_priv(mega)$pathName confhidden -selectedid ""
    }
  }
}


# Procedure: tkiconpane_internalMenuMove
proc tkiconpane_internalMenuMove { pathName menu rootX rootY} {
# xf ignore me 8
  global ip_priv

  if {[winfo exists $menu] && [winfo ismapped $menu] &&
      [string compare "" [$ip_priv(mega)$pathName confhidden -grab]]} {
    set popMinX [winfo rootx $menu]
    set popMaxX [expr $popMinX+[winfo width $menu]]
    if {$rootX >= $popMinX && $rootX <= $popMaxX} {
      catch "$menu activate @[expr $rootY-[winfo rooty $menu]]"
      if {![catch "$menu entryconfig @[expr $rootY-[winfo rooty $menu]] -menu" result]} {
        if {[string compare "" [lindex $result 4]]} {
          catch "[lindex $result 4] activate none"
          bind [lindex $result 4] <B3-Motion> "$pathName internal bind_menu_move %W %X %Y"
          bind [lindex $result 4] <ButtonRelease-3> "$pathName internal bind_menu_unpost %W"
          bind [lindex $result 4] <Meta-B3-Motion> "$pathName internal bind_menu_move %W %X %Y"
          bind [lindex $result 4] <Meta-ButtonRelease-3> "$pathName internal bind_menu_unpost %W"
        }
      }
    } {
      $menu activate none
    }
  }
}


# Procedure: tkiconpane_internalMenuPost
proc tkiconpane_internalMenuPost { pathName x y rootX rootY {menuNumber ""}} {
# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  set canvasItem [$ip_priv(mega)$pathName confhidden -currentid]
  set menu ""
  if {[string compare "" [$ip_priv(mega)$pathName confhidden -grab]]} {
    return
  }
  if {![string compare "current" $canvasItem]} {
    tkiconpane_internalItemSetSelected $pathName  [$ip_priv(mega)$pathName confhidden -currentid]
  } {
    tkiconpane_internalItemSetSelected $pathName
  }
  if {[string compare "" [$ip_priv(mega)$pathName confhidden -selectedid]]} {
    set menu [lindex [$canvasPath itemconfig [$ip_priv(mega)$pathName confhidden -selectedid] -menu$menuNumber] 4]
    if {[string compare "" $menu]} {
      if {[string compare "" [string index $menu 0]]} {
        if {![string compare "icon" [$canvasPath type [$ip_priv(mega)$pathName confhidden -selectedid]]]} {
          set menu .imenu-$menu
        } {
          set menu .emenu-$menu
        }
      }
    }
  } {
    set menu [$ip_priv(mega)$pathName confvalue -menu$menuNumber]
    if {[string compare "" $menu]} {
      if {[string compare "." [string index $menu 0]]} {
        set menu .vmenu-$menu
      }
    }
  }

  if {[string compare "" $menu]} {
    catch "$menu activate none"
    if {[string compare "" [$ip_priv(mega)$pathName interpeval info commands $menu]]} {
      if {![string compare "" [$ip_priv(mega)$pathName confhidden -focus]]} {
        $ip_priv(mega)$pathName confhidden -focus [focus]
      }
      $ip_priv(mega)$pathName confhidden -grab $menu

      bind $menu <B3-Motion> "$pathName internal bind_menu_move %W %X %Y"
      bind $menu <ButtonRelease-3> "$pathName internal bind_menu_unpost %W"
      bind $menu <Meta-B3-Motion> "$pathName internal bind_menu_move %W %X %Y"
      bind $menu <Meta-ButtonRelease-3> "$pathName internal bind_menu_unpost %W"

      catch "$menu post $rootX $rootY"
      catch "focus $menu"
      catch "grab -global $menu"
    }
  }
}


# Procedure: tkiconpane_internalMenuUnpost
proc tkiconpane_internalMenuUnpost { pathName menu} {
# xf ignore me 8
  global errorInfo
  global ip_priv

  set localErrorCode 0
  if {[winfo exists $menu] && [winfo ismapped $menu] &&
      [string compare "" [$ip_priv(mega)$pathName confhidden -grab]]} {
    set localErrorCode 0
    set result ""
    set tmpMenu [$ip_priv(mega)$pathName confhidden -grab]
    set index [$menu index active]
    $menu activate none
    if {[string compare "none" $index]} {
      catch "$tmpMenu unpost"
      update idletask
      set localErrorCode [catch "$menu invoke $index" result]
    }
  }
  catch "grab release [$ip_priv(mega)$pathName confhidden -grab]"
  catch "focus [$ip_priv(mega)$pathName confhidden -focus]"
  $ip_priv(mega)$pathName confhidden -focus ""
  $ip_priv(mega)$pathName confhidden -grab ""
  catch "$menu unpost"
  catch "$tmpMenu unpost"
  if {$localErrorCode} {
    error "$result"
  }
}


# Procedure: tkiconpane_internalScale
proc tkiconpane_internalScale { pathName {oldscale ""}} {
# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  set scale [$ip_priv(mega)$pathName confvalue -scale]
  set currentscale $oldscale
  if {[string compare "" $oldscale]} {
    set oldscale [expr 1/$oldscale]
    if {$oldscale <= 0} {
      set oldscale 1
    }
  } {
    set oldscale 1
    set scale -1
  }
  $canvasPath scale all 0 0 $oldscale $oldscale
  if {$scale == -1} {
    set bbox [$canvasPath bbox all]
    if {"$bbox" == ""} {
      return
    }
    set tmpX [expr ([lindex $bbox 0]*-1)+20]
    set tmpY [expr ([lindex $bbox 1]*-1)+20]
    foreach item [$canvasPath find all] {
      if {"[$canvasPath type $item]" == "icon"} {
        $canvasPath move $item $tmpX $tmpY
      }
    }
    set width [expr [winfo width $canvasPath]-20.0]
    set height [expr [winfo height $canvasPath]-20.0]
    set xscale [expr $width/(([lindex $bbox 2]-[lindex $bbox 0])+20.0)]
    set yscale [expr $height/(([lindex $bbox 3]-[lindex $bbox 1])+20.0)]
    if {$xscale > $yscale} {
      set scale $yscale
    } {
      set scale $xscale
    }
    $ip_priv(mega)$pathName confinternal -scale $scale
  }
  if {$scale <= 0} {
    if {[string compare "" $currentscale]} {
      set scale $currentscale
      $ip_priv(mega)$pathName confinternal -scale $scale
    } {
      set scale 1
      $ip_priv(mega)$pathName confinternal -scale $scale
    }
  }
  $canvasPath scale all 0 0 $scale $scale
  if {$scale < 1} {
    if {$scale < 0.5} {
      $ip_priv(mega)$pathName confhidden -iconfont  [$ip_priv(mega)$pathName confvalue -iconfont1]
      $ip_priv(mega)$pathName confhidden -edgefont  [$ip_priv(mega)$pathName confvalue -edgefont1]
    } {
      $ip_priv(mega)$pathName confhidden -iconfont  [$ip_priv(mega)$pathName confvalue -iconfont2]
      $ip_priv(mega)$pathName confhidden -edgefont  [$ip_priv(mega)$pathName confvalue -edgefont2]
    }
  } {
    if {$scale < 2} {
      $ip_priv(mega)$pathName confhidden -iconfont  [$ip_priv(mega)$pathName confvalue -iconfont3]
      $ip_priv(mega)$pathName confhidden -edgefont  [$ip_priv(mega)$pathName confvalue -edgefont3]
    } {
      if {$scale > 2 && $scale < 3} {
        $ip_priv(mega)$pathName confhidden -iconfont  [$ip_priv(mega)$pathName confvalue -iconfont4]
        $ip_priv(mega)$pathName confhidden -edgefont  [$ip_priv(mega)$pathName confvalue -edgefont4]
      } {
        $ip_priv(mega)$pathName confhidden -iconfont  [$ip_priv(mega)$pathName confvalue -iconfont5]
        $ip_priv(mega)$pathName confhidden -edgefont  [$ip_priv(mega)$pathName confvalue -edgefont5]
      }
    }
  }
  foreach items [$canvasPath find all] {
    if {![string compare "icon" [$canvasPath type $items]]} {
      $canvasPath itemconfig $items  -font [$ip_priv(mega)$pathName confhidden -iconfont]
    } {
      if {![string compare "edge" [$canvasPath type $items]]} {
        $canvasPath itemconfig $items  -font [$ip_priv(mega)$pathName confhidden -edgefont]
      }
    }
  }
  if {[$ip_priv(mega)$pathName confvalue -updateedges]} {
    $canvasPath layout edges -edgeorder [$ip_priv(mega)$pathName confvalue -edgeorder] -graphorder [$ip_priv(mega)$pathName confvalue -graphorder]
  }
}


# Procedure: tkiconpane_internal_bind_configure
proc tkiconpane_internal_bind_configure { pathName} {
# xf ignore me 8
  global ip_priv

  if {[$ip_priv(mega)$pathName confhidden -initialized] &&
      [$ip_priv(mega)$pathName confvalue -layoutupdate]} {
    $pathName layout -force 0
  }
}


# Procedure: tkiconpane_internal_bind_item_enter
proc tkiconpane_internal_bind_item_enter { pathName {type ""}} {
# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {![string compare $type "current"]} {
    set tmpId [$canvasPath find withtag current]
    set tmpType [$canvasPath type $tmpId] 
    if {![string compare $tmpType "icon"] ||
        ![string compare $tmpType "edge"]} {
      $ip_priv(mega)$pathName confhidden  -currentid [$canvasPath find withtag current]
    }
  } {
    $ip_priv(mega)$pathName confhidden  -currentid ""
  }
}


# Procedure: tkiconpane_internal_bind_item_move_move
proc tkiconpane_internal_bind_item_move_move { pathName canvasPath x y X Y} {
# xf ignore me 8
  global ip_priv

  tkiconpane_internalItemSetSelected $pathName
  tkiconpane_internalItemMoveMove $pathName $canvasPath $x $y $X $Y
}


# Procedure: tkiconpane_internal_bind_item_move_start
proc tkiconpane_internal_bind_item_move_start { pathName eventType canvasPath x y X Y} {
# xf ignore me 8
  global ip_priv

  if {[$ip_priv(mega)$pathName confhidden -eventtype] != 3 &&
      [$ip_priv(mega)$pathName confhidden -eventtype] != 4} {
    $ip_priv(mega)$pathName confhidden -eventtype $eventType
    tkiconpane_internalItemSetSelected $pathName
    if {$eventType == 1} {
      tkiconpane_internalItemDeSelect $pathName 1
    }
    tkiconpane_internalItemMoveStart $pathName $canvasPath $x $y $X $Y
  }
}


# Procedure: tkiconpane_internal_bind_item_move_stop
proc tkiconpane_internal_bind_item_move_stop { pathName canvasPath x y X Y} {
# xf ignore me 8
  global ip_priv

  $ip_priv(mega)$pathName confhidden -clickeval 0
  tkiconpane_internalItemSetSelected $pathName
  tkiconpane_internalItemMoveStop $pathName $canvasPath $x $y $X $Y
  $ip_priv(mega)$pathName confhidden -eventtype -1
}


# Procedure: tkiconpane_internal_bind_item_select
proc tkiconpane_internal_bind_item_select { pathName eventType canvasPath x y X Y} {
# xf ignore me 8
  global ip_priv

  if {![string compare "" [$ip_priv(mega)$pathName confhidden -currentid]]} {
    if {$eventType == 0} {
      $pathName internal bind_item_move_start 1 $canvasPath $x $y $X $Y
    } {
      if {$eventType == 1} {
        $pathName internal bind_item_move_start 2 $canvasPath $x $y $X $Y
      } {
        if {$eventType == 3} {
          $pathName internal bind_item_move_start 3 $canvasPath $x $y $X $Y
        } {
          if {$eventType == 4} {
            $pathName internal bind_item_move_start 4 $canvasPath $x $y $X $Y
          } {
            if {$eventType == 10} {
              $pathName internal bind_item_move_move $canvasPath $x $y $X $Y
            } {
              if {$eventType == 11} {
                $pathName internal bind_item_move_stop $canvasPath $x $y $X $Y
              }
            }
          }
        }
      }
    }
  } {
    if {$eventType == 0} {
      if {[$ip_priv(mega)$pathName confvalue -bindtype] == 1} {
        $ip_priv(mega)$pathName confhidden -clickeval 0
        $ip_priv(mega)$pathName interpset ip_priv(clickCounter) 2
        tkiconpane_internalItemActivate $pathName $x $y
      } {
        if {[$ip_priv(mega)$pathName interpset ip_priv(clickCounter)] == 1} {
          $ip_priv(mega)$pathName confhidden -clickeval 0
          $ip_priv(mega)$pathName interpset ip_priv(clickCounter) 2
          tkiconpane_internalItemActivate $pathName $x $y
        } {
          $ip_priv(mega)$pathName interpset ip_priv(clickCounter) 1
          $ip_priv(mega)$pathName confhidden -clickeval 1
          $ip_priv(mega)$pathName interpeval after  [$ip_priv(mega)$pathName confvalue -clickinterval]  "set ip_priv(clickCounter) 0"
          $ip_priv(mega)$pathName interpeval tkwait variable ip_priv(clickCounter)
          if {[$ip_priv(mega)$pathName interpset ip_priv(clickCounter)] == 0 && 
              [$ip_priv(mega)$pathName confhidden -clickeval]} {
            $ip_priv(mega)$pathName confhidden -eventtype -1
            tkiconpane_internalItemDeSelect $pathName
            tkiconpane_internalItemSetSelected $pathName
            tkiconpane_internalItemSelect $pathName $x $y
          }
        }
      }
    } {
      if {$eventType == 1} {
        if {[$ip_priv(mega)$pathName confvalue -bindtype] == 1} {
          $ip_priv(mega)$pathName confhidden -clickeval 0
          $ip_priv(mega)$pathName interpset ip_priv(clickCounter) 2
          tkiconpane_internalItemSetSelected $pathName
          tkiconpane_internalItemSelect $pathName $x $y 1
          tkiconpane_internalItemActivate $pathName $x $y
        } {
          if {[$ip_priv(mega)$pathName interpset ip_priv(clickCounter)] == 1} {
            $ip_priv(mega)$pathName confhidden -clickeval 0
            $ip_priv(mega)$pathName interpset ip_priv(clickCounter) 2
            tkiconpane_internalItemSetSelected $pathName
            tkiconpane_internalItemSelect $pathName $x $y 1
            tkiconpane_internalItemActivate $pathName $x $y
          } {
            $ip_priv(mega)$pathName interpset ip_priv(clickCounter) 1
            $ip_priv(mega)$pathName confhidden -clickeval 1
            $ip_priv(mega)$pathName interpeval after  [$ip_priv(mega)$pathName confvalue -clickinterval]  "set ip_priv(clickCounter) 0"
            $ip_priv(mega)$pathName interpeval tkwait variable ip_priv(clickCounter)
            if {[$ip_priv(mega)$pathName interpset ip_priv(clickCounter)] == 0 && 
                [$ip_priv(mega)$pathName confhidden -clickeval]} {
              $ip_priv(mega)$pathName confhidden -eventtype -1
              tkiconpane_internalItemSetSelected $pathName
              tkiconpane_internalItemSelect $pathName $x $y 1
            }
          }
        }
      } {
        if {$eventType == 3} {
          $ip_priv(mega)$pathName confhidden -eventtype 3
          tkiconpane_internalItemMoveStart $pathName $canvasPath $x $y $X $Y
        } {
          if {$eventType == 10} {
            tkiconpane_internalItemMoveMove $pathName $canvasPath $x $y $X $Y
          } {
            if {$eventType == 11} {
              tkiconpane_internalItemMoveStop $pathName $canvasPath $x $y $X $Y
              $ip_priv(mega)$pathName confhidden -eventtype -1
            }
          }
        }
      }
    }
  }
}


# Procedure: tkiconpane_internal_bind_map
proc tkiconpane_internal_bind_map { pathName} {
# xf ignore me 8
  global ip_priv

  if {[$ip_priv(mega)$pathName confhidden -initialized] ||
      "$pathName" == ""} {
    return
  }

  $ip_priv(mega)$pathName config  -changed 0
  $ip_priv(mega)$pathName confhidden  -initialized 1
}


# Procedure: tkiconpane_internal_bind_menu_move
proc tkiconpane_internal_bind_menu_move { pathName canvasPath X Y} {
# xf ignore me 8
  global ip_priv

  tkiconpane_internalMenuMove $pathName $canvasPath $X $Y
}


# Procedure: tkiconpane_internal_bind_menu_post
proc tkiconpane_internal_bind_menu_post { pathName x y X Y menuType} {
# xf ignore me 8
  global ip_priv

  tkiconpane_internalMenuPost $pathName $x $y $X $Y $menuType
}


# Procedure: tkiconpane_internal_bind_menu_unpost
proc tkiconpane_internal_bind_menu_unpost { pathName canvasPath} {
# xf ignore me 8
  global ip_priv

  tkiconpane_internalMenuUnpost $pathName $canvasPath
}


# Procedure: tkiconpane_internal_drag_drop_receive_iconpane
proc tkiconpane_internal_drag_drop_receive_iconpane { args} {
# xf ignore me 8

  eval tkiconpane_internalDragDropReceiveIconPane $args
}


# Procedure: tkiconpane_internal_drag_drop_receive_toolbar
proc tkiconpane_internal_drag_drop_receive_toolbar { args} {
# xf ignore me 8

  eval tkiconpane_internalDragDropReceiveToolbar $args
}


# Procedure: tkiconpane_internal_drag_drop_send
proc tkiconpane_internal_drag_drop_send { pathName args} {
# xf ignore me 8

  eval tkiconpane_internalDragDropSend $args
}


# Procedure: tkiconpane_internal_drag_drop_token
proc tkiconpane_internal_drag_drop_token { pathName args} {
# xf ignore me 8

  eval tkiconpane_internalDragDropToken $pathName $args
}


# Procedure: tkiconpane_internal_setselected
proc tkiconpane_internal_setselected { pathName} {

  tkiconpane_internalItemSetSelected $pathName
}


# Procedure: tkiconpane_internal_showstatus
proc tkiconpane_internal_showstatus { pathName name1 name2 op} {
# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  set tmpTag [$ip_priv(mega)$pathName confvalue -canvasstatustag]
  set tmpBoxTag [$ip_priv(mega)$pathName confvalue -canvasboxtag]
  set statusvariable [$ip_priv(mega)$pathName confvalue -statusvariable]
  set background [$ip_priv(mega)$pathName confvalue -background]
  set foreground [$ip_priv(mega)$pathName confvalue -foreground]
  set statusafter [$ip_priv(mega)$pathName confvalue -statusafter]

  if {![string compare "" $tmpTag]} {
    set tmpTag [$canvasPath create text 10 10 -anchor nw]
    $ip_priv(mega)$pathName config -canvasstatustag $tmpTag
    $canvasPath bind $tmpTag <Button-1> "$pathName status {}"
  }
  if {![string compare "" $tmpBoxTag]} {
    set tmpBoxTag [$canvasPath create rectangle 10 10 20 20]
    $ip_priv(mega)$pathName config -canvasboxtag $tmpBoxTag
    $canvasPath bind $tmpBoxTag <Button-1> "$pathName status {}"
  }

  set value [$ip_priv(mega)$pathName interpset $name1]
  if {[string compare "" [string trim $value]]} {
    catch "$canvasPath itemconfig $tmpTag  -fill \{$background\}"
    catch "$canvasPath itemconfig $tmpBoxTag  -fill \{$foreground\} -outline \{$foreground\} -width 5"
    $canvasPath raise $tmpBoxTag
    $canvasPath raise $tmpTag
  } {
    catch "$canvasPath itemconfig $tmpTag  -fill \{$background\}"
    catch "$canvasPath itemconfig $tmpBoxTag  -fill \{$background\} -outline \{$background\} -width 0"
    $canvasPath lower $tmpBoxTag
    $canvasPath lower $tmpTag
  }
  $canvasPath coords $tmpTag  [$canvasPath canvasx [expr [winfo x $canvasPath]+10]]  [$canvasPath canvasy [expr [winfo y $canvasPath]+10]]
  $canvasPath itemconfig $tmpTag  -text $value
  eval $canvasPath coords $tmpBoxTag [$canvasPath bbox $tmpTag]

  if {[string compare "" $value] && $statusafter > 0} {
    after $statusafter "$pathName status {}"
  }
}


# Procedure: tkiconpane_minorEdgeConfig
proc tkiconpane_minorEdgeConfig { pathName args} {
# xf ignore me 8
  global ip_priv

  set result ""
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {[llength $args] == 2} {
    if {![string compare [lindex [$canvasPath itemconfig [lindex $args 1] -graphname] 4] [lindex $args 0]]} {
      return [$canvasPath itemconfig [lindex $args 1]]
    }
  } {
    if {[llength $args] == 3} {
      if {[string match "-*" [lindex $args 1]]} {
        foreach counter [$canvasPath find all] {
          if {![string compare "edge" [$canvasPath type $counter]] &&
              ![string compare [lindex [$canvasPath itemconfig $counter -graphname] 4] [lindex $args 0]]} {
            $canvasPath itemconfig $counter [lindex $args 1] [lindex $args 2]
          }
        }
      } {
        if {![string compare [lindex [$canvasPath itemconfig [lindex $args 1] -graphname] 4] [lindex $args 0]]} {
          return [$canvasPath itemconfig [lindex $args 1] [lindex $args 2]]
        }
      }
    } {
      if {[llength $args] > 0} {
        if {![string compare [lindex [$canvasPath itemconfig [lindex $args 1] -graphname] 4] [lindex $args 0]]} {
          $canvasPath itemconfig [lindex $args 1] [lindex $args 2] [lindex $args 3]
        }
      }
    }
  }
  return ""
}


# Procedure: tkiconpane_minorEdgeCreate
proc tkiconpane_minorEdgeCreate { pathName args} {
# xf ignore me 8
  global ip_priv

  set result ""
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  set graphName [lindex $args 0]
  foreach edgeElement [lrange $args 1 end] {
    set from [lindex $edgeElement 0]
    set to [lindex $edgeElement 1]
    if {[catch "$canvasPath itemconfig $from -name"] ||
        [catch "$canvasPath itemconfig $to -name"]} {
      error "No -from and -to specified"
    }
    switch [lindex $edgeElement 2] {
      {1} {
        set arrowStyle last
      }
      {2} {
        set arrowStyle both
      }
      {3} {
        set arrowStyle first
      }
      {default} {
        set arrowStyle none
      }
    }
    if {[catch "$canvasPath create edge -10 -10 -10 -10  -graphname \{$graphName\} -arrow $arrowStyle  -from \{$from\} -to \{$to\}  -font \{[$ip_priv(mega)$pathName confhidden -edgefont]\}  [lrange $edgeElement 3 end]" edge]} {
      error $edge
    }
    if {[$ip_priv(mega)$pathName confhidden -initialized]} {
      if {[catch "$canvasPath layout item -idlist $edge -edgeorder [$ip_priv(mega)$pathName confvalue -edgeorder] -graphorder [$ip_priv(mega)$pathName confvalue -graphorder]" result]} {
        error $result
      }
    }
    $canvasPath lower $edge
    set currentEdges [lindex [$canvasPath itemconfig $from -edges] 4]
    lappend currentEdges [list $from $to $edge]
    $canvasPath itemconfig $from -edges $currentEdges
    set currentEdges [lindex [$canvasPath itemconfig $to -edges] 4]
    lappend currentEdges [list $from $to $edge]
    $canvasPath itemconfig $to -edges $currentEdges
    lappend result $edge
  }
  return $result
}


# Procedure: tkiconpane_minorEdgeDelete
proc tkiconpane_minorEdgeDelete { pathName args} {
# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {[llength $args] == 0} {
    foreach counter [$canvasPath find all] {
      if {![string compare "edge" [$canvasPath type $counter]]} {
        $canvasPath delete $counter
      }
      if {![string compare "icon" [$canvasPath type $counter]]} {
        $canvasPath itemconfig $counter -edges {}
      }
    }
  } {
    set from ""
    set to ""
    set graphName [lindex $args 0]
    if {[llength $args] == 2} {
      set from [lindex [$canvasPath itemconfig [lindex $args 1] -from] 4]
      set to [lindex [$canvasPath itemconfig [lindex $args 1] -to] 4]
    } {
      if {[llength $args] == 3} {
        set from [lindex $args 1]
        set to [lindex $args 2]
      }
    }
    if {![string compare "" $from] && ![string compare "" $to]} {
      foreach counter [$canvasPath find all] {
        if {![string compare "edge" [$canvasPath type $counter]] &&
            ![string compare $graphName [lindex [$canvasPath itemconfig $counter -graphname] 4]]} {
          set from [lindex [$canvasPath itemconfig $counter -from] 4]
          set to [lindex [$canvasPath itemconfig $counter -to] 4]
          set fromEdges [lindex [$canvasPath itemconfig $from -edges] 4]
          set newFromEdges ""
          set toEdges [lindex [$canvasPath itemconfig $to -edges] 4]
          set newToEdges ""
          foreach edge $fromEdges {
            if {([lindex $edge 0] == $from && [lindex $edge 1] == $to) ||
                ([lindex $edge 0] == $to && [lindex $edge 1] == $from) &&
                ![string compare $graphName [lindex [$canvasPath itemconfig [lindex $edge 2] -graphname] 4]]} {
              catch "$canvasPath delete [lindex $edge 2]"
            } {
              lappend newFromEdges $edge
            }
          }
          $canvasPath itemconfig $from -edges $newFromEdges
          foreach edge $toEdges {
            if {([lindex $edge 0] == $from && [lindex $edge 1] == $to) ||
                ([lindex $edge 0] == $to && [lindex $edge 1] == $from) &&
                ![string compare $graphName [lindex [$canvasPath itemconfig [lindex $edge 2] -graphname] 4]]} {
              catch "$canvasPath delete [lindex $edge 2]"
            } {
              lappend newToEdges $edge
            }
          }
          $canvasPath itemconfig $to -edges $newToEdges
          $canvasPath delete $counter
        }
      }
    } {
      if {[string compare "" $from] && [string compare "" $to]} {
        set fromEdges [lindex [$canvasPath itemconfig $from -edges] 4]
        set newFromEdges ""
        set toEdges [lindex [$canvasPath itemconfig $to -edges] 4]
        set newToEdges ""
        foreach edge $fromEdges {
          if {([lindex $edge 0] == $from && [lindex $edge 1] == $to) ||
              ([lindex $edge 0] == $to && [lindex $edge 1] == $from) &&
              ![string compare $graphName [lindex [$canvasPath itemconfig [lindex $edge 2] -graphname] 4]]} {
            catch "$canvasPath delete [lindex $edge 2]"
          } {
            lappend newFromEdges $edge
          }
        }
        $canvasPath itemconfig $from -edges $newFromEdges
        foreach edge $toEdges {
          if {([lindex $edge 0] == $from && [lindex $edge 1] == $to) ||
              ([lindex $edge 0] == $to && [lindex $edge 1] == $from) &&
              ![string compare $graphName [lindex [$canvasPath itemconfig [lindex $edge 2] -graphName] 4]]} {
            catch "$canvasPath delete [lindex $edge 2]"
          } {
            lappend newToEdges $edge
          }
        }
        $canvasPath itemconfig $to -edges $newToEdges
      }
    }
  }
  return ""
}


# Procedure: tkiconpane_minorEdgeInfo
proc tkiconpane_minorEdgeInfo { pathName args} {
# xf ignore me 8
  global ip_priv

  set result ""
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {[llength $args] == 1} {
    set selectedEdge [$ip_priv(mega)$pathName confhidden -selectededge]
    if {![string compare "graphs" [lindex $args 0]] ||
        ![string compare "ids" [lindex $args 0]] ||
        ![string compare "names" [lindex $args 0]]} {
      return [$canvasPath edgeinfo [lindex $args 0]]
    } {
      if {![string compare "id" [lindex $args 0]]} {
        return $selectedEdge
      } {
        if {![string compare "name" [lindex $args 0]]} {
          lappend result [lindex [$canvasPath itemconfig $selectedEdge -name] 4]
          return $result
        } {
          if {![string compare "fromtoid" [lindex $args 0]]} {
            foreach counter [$canvasPath iconinfo ids] {
              foreach edge [lindex [$canvasPath itemconfig $counter -edges] 4] {
                if {![string compare $selectedEdge [lindex $edge 2]]} {
                  return [list [lindex $edge 0] [lindex $edge 1]]
                }
              }
            }
          } {
            if {![string compare "fromtoname" [lindex $args 0]]} {
              foreach counter [$canvasPath iconinfo ids] {
                foreach edge [lindex [$canvasPath itemconfig $counter -edges] 4] {
                  if {![string compare $selectedEdge [lindex $edge 2]]} {
                    return [list [lindex [$canvasPath itemconf [lindex $edge 0] -name] 4] [lindex [$canvasPath itemconf [lindex $edge 1] -name] 4]]
                  }
                }
              }
            } {
              if {![string compare "fromtoids" [lindex $args 0]]} {
                foreach counter [$canvasPath find all] {
                  if {![string compare "icon" [$canvasPath type $counter]]} {
                    foreach edge [lindex [$canvasPath itemconfig $counter -edges] 4] {
                      if {[lsearch $result [list [lindex $edge 0] [lindex $edge 1]]] == -1} {
                        lappend result [list [lindex $edge 0] [lindex $edge 1]]
                      }
                    }
                  }
                }
                return $result
              } {
                if {![string compare "fromtonames" [lindex $args 0]]} {
                  foreach counter [$canvasPath find all] {
                    if {![string compare "icon" [$canvasPath type $counter]]} {
                      foreach edge [lindex [$canvasPath itemconfig $counter -edges] 4] {
                        if {[lsearch $result [list [lindex $edge 0] [lindex $edge 1]]] == -1} {
                          lappend result [list [lindex [$canvasPath itemconf [lindex $edge 0] -name] 4] [lindex [$canvasPath itemconf [lindex $edge 1] -name] 4]]
                        }
                      }
                    }
                  }
                  return $result
                }
              }
            }
          }
        }
      }
    }
  } {
    if {[llength $args] == 2} {
      set selectedEdge [$ip_priv(mega)$pathName confhidden -selectededge]
      if {![string compare "ids" [lindex $args 0]] ||
          ![string compare "names" [lindex $args 0]]} {
        return [$canvasPath edgeinfo [lindex $args 0] [lindex $args 1]]
      } {
        if {![string compare "id" [lindex $args 0]]} {
          if {![string compare [lindex [$canvasPath itemconfig $selectedEdge -graphname] 4] [lindex $args 1]]} {
            return $selectedEdge
          }
        } {
          if {![string compare "name" [lindex $args 0]]} {
            if {![string compare [lindex [$canvasPath itemconfig $selectedEdge -graphname] 4] [lindex $args 1]]} {
              lappend result [lindex [$canvasPath itemconfig $selectedEdge -name] 4]
              return $result
            }
          } {
            if {![string compare "fromtoid" [lindex $args 0]]} {
              foreach counter [$canvasPath iconinfo ids] {
                foreach edge [lindex [$canvasPath itemconfig $counter -edges] 4] {
                  if {![string compare [lindex [$canvasPath itemconfig $selectedEdge -graphname] 4] [lindex $args 1]]} {
                    if {![string compare $selectedEdge [lindex $edge 2]]} {
                      return [list [lindex $edge 0] [lindex $edge 1]]
                    }
                  }
                }
              }
            } {
              if {![string compare "fromtoname" [lindex $args 0]]} {
                foreach counter [$canvasPath iconinfo ids] {
                  foreach edge [lindex [$canvasPath itemconfig $counter -edges] 4] {
                    if {![string compare [lindex [$canvasPath itemconfig $selectedEdge -graphname] 4] [lindex $args 1]]} {
                      if {![string compare $selectedEdge [lindex $edge 2]]} {
                        return [list [lindex [$canvasPath itemconf [lindex $edge 0] -name] 4] [lindex [$canvasPath itemconf [lindex $edge 1] -name] 4]]
                      }
                    }
                  }
                }
              } {
                if {![string compare "fromtoids" [lindex $args 0]]} {
                  foreach counter [$canvasPath find all] {
                    if {![string compare "icon" [$canvasPath type $counter]]} {
                      foreach edge [lindex [$canvasPath itemconfig $counter -edges] 4] {
                        if {![string compare [lindex [$canvasPath itemconfig [lindex $edge 2] -graphname] 4] [lindex $args 1]]} {
                          if {[lsearch $result [list [lindex $edge 0] [lindex $edge 1]]] == -1} {
                            lappend result [list [lindex $edge 0] [lindex $edge 1]]
                          }
                        }
                      }
                    }
                  }
                  return $result
                } {
                  if {![string compare "fromtonames" [lindex $args 0]]} {
                    foreach counter [$canvasPath find all] {
                      if {![string compare "icon" [$canvasPath type $counter]]} {
                        foreach edge [lindex [$canvasPath itemconfig $counter -edges] 4] {
                          if {![string compare [lindex [$canvasPath itemconfig [lindex $edge 2] -graphname] 4] [lindex $args 1]]} {
                            if {[lsearch $result [list [lindex $edge 0] [lindex $edge 1]]] == -1} {
                              lappend result [list [lindex [$canvasPath itemconf [lindex $edge 0] -name] 4] [lindex [$canvasPath itemconf [lindex $edge 1] -name] 4]]
                            }
                          }
                        }
                      }
                    }
                    return $result
                  }
                }
              }
            }
          }
        }
      }
    } {
      if {[llength $args] == 3} {
        if {![string compare "id" [lindex $args 0]]} {
          return [$canvasPath edgeinfo [lindex $args 0] [lindex $args 1] [lindex $args 2]]
        } {
          if {![string compare "name" [lindex $args 0]]} {
            if {![string compare [lindex [$canvasPath itemconfig [lindex $args 2] -graphname] 4] [lindex $args 1]]} {
              lappend result [lindex [$canvasPath itemconfig [lindex $args 2] -name] 4]
              return $result
            }
          } {
            if {![string compare "fromtoid" [lindex $args 0]]} {
              foreach counter [$canvasPath iconinfo ids] {
                foreach edge [lindex [$canvasPath itemconfig $counter -edges] 4] {
                  if {![string compare [lindex [$canvasPath itemconfig [lindex $args 2] -graphname] 4] [lindex $args 1]]} {
                    if {![string compare [lindex $args 2] [lindex $edge 2]]} {
                      return [list [lindex $edge 0] [lindex $edge 1]]
                    }
                  }
                }
              }
            } {
              if {![string compare "fromtoname" [lindex $args 0]]} {
                foreach counter [$canvasPath iconinfo ids] {
                  foreach edge [lindex [$canvasPath itemconfig $counter -edges] 4] {
                    if {![string compare [lindex [$canvasPath itemconfig [lindex $args 2] -graphname] 4] [lindex $args 1]]} {
                      if {![string compare [lindex $args 2] [lindex $edge 2]]} {
                        return [list [lindex [$canvasPath itemconf [lindex $edge 0] -name] 4] [lindex [$canvasPath itemconf [lindex $edge 1] -name] 4]]
                      }
                    }
                  }
                }
              }
            }
          }
        }
      } {
        if {[llength $args] == 4} {
          if {![string compare "id" [lindex $args 0]]} {
            return [$canvasPath edgeinfo [lindex $args 0] [lindex $args 1] [lindex $args 2] [lindex $args 3]]
          }
        }
      }
    }
  }
  return ""
}


# Procedure: tkiconpane_minorIconConfig
proc tkiconpane_minorIconConfig { pathName args} {
# xf ignore me 8
  global ip_priv

  set result ""
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {[llength $args] == 1} {
    if {[$ip_priv(mega)$pathName confvalue -compressiconconf]} {
      set tmpResult ""
      lappend tmpResult [$canvasPath itemconfig [lindex $args 0] -name]
      lappend tmpResult [$canvasPath itemconfig [lindex $args 0] -status]
      lappend result $tmpResult
    } {
      lappend result [$canvasPath itemconfig [lindex $args 0]]
    }
    return $result
  } {
    if {[llength $args] == 2} {
      return [$canvasPath itemconfig [lindex $args 0] [lindex $args 1]]
    } {
      if {[llength $args] > 0} {
        eval $canvasPath itemconfig $args
      }
    }
  }
  return ""
}


# Procedure: tkiconpane_minorIconCreate
proc tkiconpane_minorIconCreate { pathName args} {
# xf ignore me 8
  global ip_priv

  set icon ""
  if {[llength $args] > 0} {
    set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
    set iconName [lindex $args 0]
    if {[llength $args] > 1} {
      set iconParams [lrange $args 1 end]
    } {
      set iconParams ""
    }
    if {[catch "$canvasPath create icon 10 10 -font \{[$ip_priv(mega)$pathName confhidden -iconfont]\} -name \{$iconName\} $iconParams" icon]} {
      error $icon
    }
    if {[$ip_priv(mega)$pathName confhidden -initialized]} {
      tkiconpane_minorLayout $pathName -force 0
    }
  }
  return $icon
}


# Procedure: tkiconpane_minorIconDelete
proc tkiconpane_minorIconDelete { pathName args} {
# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  set iconList [lindex $args 0]
  if {![string compare "" $iconList]} {
    foreach icon [$canvasPath find all] {
      if {![string compare "icon" [$canvasPath type $icon]] ||
          ![string compare "edge" [$canvasPath type $icon]]} {
        $canvasPath delete $icon
      }
    }
  } {
    foreach icon $iconList {
      foreach edge [lindex [$canvasPath itemconfig $icon -edges] 4] {
        $canvasPath delete [lindex $edge 2]
        set result ""
        if {![string compare $icon [lindex $edge 0]]} {
          foreach otherSide [lindex [$canvasPath itemconfig [lindex $edge 1] -edges] 4] {
            if {[string compare $icon [lindex $otherSide 0]] &&
                [string compare $icon [lindex $otherSide 1]]} {
              lappend result $otherSide
            }
          }
          $canvasPath itemconfig [lindex $edge 1] -edges $result
        } {
          if {![string compare $icon [lindex $edge 1]]} {
            foreach otherSide [lindex [$canvasPath itemconfig [lindex $edge 0] -edges] 4] {
              if {[string compare $icon [lindex $otherSide 0]] &&
                  [string compare $icon [lindex $otherSide 1]]} {
                lappend result $otherSide
              }
            }
            $canvasPath itemconfig [lindex $edge 0] -edges $result
          }
        }
      }
      $canvasPath delete $icon
    }
  }
  return ""
}


# Procedure: tkiconpane_minorIconInfo
proc tkiconpane_minorIconInfo { pathName args} {
# xf ignore me 8
  global ip_priv

  set result ""
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {[llength $args] == 1} {
    set selectedIcon [$ip_priv(mega)$pathName confhidden -selectedicon]
    set selectedIconList [$ip_priv(mega)$pathName confhidden -selectediconlist]
    if {![string compare "ids" [lindex $args 0]] ||
        ![string compare "names" [lindex $args 0]]} {
      return [$canvasPath iconinfo [lindex $args 0]]
    } {
      if {![string compare "id" [lindex $args 0]]} {
        return $selectedIcon
      } {
        if {![string compare "name" [lindex $args 0]]} {
          lappend result [lindex [$canvasPath itemconf $selectedIcon -name] 4]
          return $result
        } {
          if {![string compare "state" [lindex $args 0]]} {
            lappend result [lindex [$canvasPath itemconf $selectedIcon -state] 4]
            return $result
          } {
            if {![string compare "status" [lindex $args 0]]} {
              lappend result [lindex [$canvasPath itemconf $selectedIcon -status] 4]
              return $result
            } {
              if {![string compare "tags" [lindex $args 0]]} {
                lappend result [lindex [$canvasPath itemconf $selectedIcon -tags] 4]
                return $result
              } {
                if {![string compare "stateselect" [lindex $args 0]]} {
                  $canvasPath itemconfig $selectedIcon -state selected
                  set tmpList $selectedIconList
                  set tmpPosition [lsearch $tmpList $selectedIcon]
                  if {$tmpPosition == -1} {
                    lappend tmpList $selectedIcon
                    $ip_priv(mega)$pathName confhidden -selectediconlist $tmpList
                  }
                } {
                  if {![string compare "statedeselect" [lindex $args 0]]} {
                    $canvasPath itemconfig $selectedIcon -state normal
                    set tmpList $selectedIconList
                    set tmpPosition [lsearch $tmpList $selectedIcon]
                    if {$tmpPosition != -1} {
                      $ip_priv(mega)$pathName confhidden -selectediconlist [lreplace $tmpList $tmpPosition $tmpPosition]
                    }
                  } {
                    if {![string compare "statetoggle" [lindex $args 0]]} {
                      set tmpState [lindex [$canvasPath itemconfig $selectedIcon -state] 4]
                      set tmpList $selectedIconList
                      set tmpPosition [lsearch $tmpList $selectedIcon]
                      if {![string compare "selected" "$tmpState"]} {
                        $canvasPath itemconfig $selectedIcon -state normal
                        if {$tmpPosition != -1} {
                          $ip_priv(mega)$pathName confhidden -selectediconlist [lreplace $tmpList $tmpPosition $tmpPosition]
                        }
                      } {
                        $canvasPath itemconfig $selectedIcon -state selected
                        if {$tmpPosition == -1} {
                          lappend tmpList $selectedIcon
                          $ip_priv(mega)$pathName confhidden -selectediconlist $tmpList
                        }
                      }
                    } {
                      if {![string compare "selectedids" [lindex $args 0]]} {
                        set tmpIds ""
                        foreach counter $selectedIconList {
                          if {![catch "$canvasPath itemconfig $counter -name"]} {
                            lappend tmpIds $counter
                          }
                        }
                        return $tmpIds
                      } {
                        if {![string compare "selectednames" [lindex $args 0]]} {
                          set tmpNames ""
                          foreach counter $selectedIconList {
                            if {![catch "$canvasPath itemconfig $counter -name"]} {
                              lappend tmpNames [lindex [$canvasPath itemconf $counter -name] 4]
                            }
                          }
                          return $tmpNames
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  } {
    if {[llength $args] == 2} {
      if {![string compare "id" [lindex $args 0]]} {
        return [$canvasPath iconinfo id [lindex $args 1]]
      } {
        if {![string compare "name" [lindex $args 0]]} {
          lappend result [lindex [$canvasPath itemconf [lindex $args 1] -name] 4]
          return $result
        } {
          if {![string compare "state" [lindex $args 0]]} {
            lappend result [lindex [$canvasPath itemconf [lindex $args 1] -state] 4]
            return $result
          } {
            if {![string compare "status" [lindex $args 0]]} {
              lappend result [lindex [$canvasPath itemconf [lindex $args 1] -status] 4]
              return $result
            } {
              if {![string compare "tags" [lindex $args 0]]} {
                lappend result [lindex [$canvasPath itemconf [lindex $args 1] -tags] 4]
                return $result
              } {
                if {![string compare "stateselect" [lindex $args 0]]} {
                  $canvasPath itemconfig [lindex $args 1] -state selected
                  set tmpList [$ip_priv(mega)$pathName confhidden -selectediconlist]
                  set tmpPosition [lsearch $tmpList [$ip_priv(mega)$pathName confhidden -selectedicon]]
                  if {$tmpPosition == -1} {
                    lappend tmpList [lindex $args 1]
                    $ip_priv(mega)$pathName confhidden -selectediconlist $tmpList
                  }
                } {
                  if {![string compare "statedeselect" [lindex $args 0]]} {
                    $canvasPath itemconfig [lindex $args 1] -state normal
                    set tmpList [$ip_priv(mega)$pathName confhidden -selectediconlist]
                    set tmpPosition [lsearch $tmpList [$ip_priv(mega)$pathName confhidden -selectedicon]]
                    if {$tmpPosition != -1} {
                      $ip_priv(mega)$pathName confhidden -selectediconlist [lreplace $tmpList $tmpPosition $tmpPosition]
                    }
                  } {
                    if {![string compare "statetoggle" [lindex $args 0]]} {
                      set tmpState [lindex [$canvasPath itemconfig [lindex $args 1] -state] 4]
                      set tmpList [$ip_priv(mega)$pathName confhidden -selectediconlist]
                      set tmpPosition [lsearch $tmpList [lindex $args 1]]
                      if {"$tmpState" == "selected"} {
                        $canvasPath itemconfig [lindex $args 1] -state normal
                        if {$tmpPosition != -1} {
                          $ip_priv(mega)$pathName confhidden -selectediconlist [lreplace $tmpList $tmpPosition $tmpPosition]
                        }
                      } {
                        $canvasPath itemconfig [lindex $args 1] -state selected
                        if {$tmpPosition == -1} {
                          lappend tmpList [lindex $args 1]
                          $ip_priv(mega)$pathName confhidden -selectediconlist $tmpList
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return ""
}


# Procedure: tkiconpane_minorInternal
proc tkiconpane_minorInternal { pathName subCommand args} {
# xf ignore me 8

  eval tkiconpane_internal_$subCommand $pathName $args
}


# Procedure: tkiconpane_minorLayout
proc tkiconpane_minorLayout { pathName args} {
# xf ignore me 8
  global ip_priv

  set forceLayout 1
  if {![string compare [lindex $args 0] -force]} {
    if {![string compare [lindex $args 1] 0]} {
      set forceLayout 0
    }
    set args [lrange $args 2 end]
  }
  set partialRelayout 0
  set completeRelayout 0
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {![string compare "edges" [lindex $args 0]] ||
      ![string compare "2" [lindex $args 0]]} {
    if {[lsearch $args "edges"] != -1} {
      set args [lreplace $args [lsearch $args "edges"] [lsearch $args "edges"]]
    }
    if {[$ip_priv(mega)$pathName confvalue -updateedges]} {
      eval $canvasPath layout edges -edgeorder [$ip_priv(mega)$pathName confvalue -edgeorder] -graphorder [$ip_priv(mega)$pathName confvalue -graphorder] $args
    }
    return
  }
  if {(![$ip_priv(mega)$pathName confhidden -initialized] && !$forceLayout) ||
      ([$ip_priv(mega)$pathName confhidden -iconsmoved] && !$forceLayout) ||
      (![$ip_priv(mega)$pathName confvalue -layout] && !$forceLayout) ||
       ![string compare "" [$ip_priv(mega)$pathName interpeval info commands $canvasPath]]} {
    return
  }
  $ip_priv(mega)$pathName confhidden -iconsmoved 0
  set layoutCommand [$ip_priv(mega)$pathName confvalue -layoutcommand]
  if {![string compare "nolayout" $layoutCommand]} {
    if {[$ip_priv(mega)$pathName confvalue -updateedges]} {
      eval $canvasPath layout edges -edgeorder [$ip_priv(mega)$pathName confvalue -edgeorder] -graphorder [$ip_priv(mega)$pathName confvalue -graphorder] $args
    }
    return
  } {
    set currentScale [$ip_priv(mega)$pathName confvalue -scale]
    $ip_priv(mega)$pathName config -scale 1
    if {![string compare "" [lindex $layoutCommand 0]]} {
      set layoutCommand matrix
    }
    if {![string compare "matrix" [lindex $layoutCommand 0]] ||
        ![string compare "isi" [lindex $layoutCommand 0]] ||
        ![string compare "bary" [lindex $layoutCommand 0]] ||
        ![string compare "random" [lindex $layoutCommand 0]] ||
        ![string compare "tree" [lindex $layoutCommand 0]]} {
      set iconwidth [$ip_priv(mega)$pathName confvalue -iconwidth]
      set iconheight [$ip_priv(mega)$pathName confvalue -iconheight]
      set iconspaceh [$ip_priv(mega)$pathName confvalue -iconspaceh]
      set iconspacev [$ip_priv(mega)$pathName confvalue -iconspacev]
      set sortcommand [$ip_priv(mega)$pathName confvalue -sortcommand]
      set computeiconsize [$ip_priv(mega)$pathName confvalue -computeiconsize]
      set canvasstatustag [$ip_priv(mega)$pathName confvalue -canvasstatustag]
      set canvasboxtag [$ip_priv(mega)$pathName confvalue -canvasboxtag]
      if {[string compare "" $canvasstatustag]} {
        $canvasPath delete $canvasstatustag
      }
      if {[string compare "" $canvasboxtag]} {
        $canvasPath delete $canvasboxtag
      }
      $ip_priv(mega)$pathName confinternal  -canvasstatustag ""  -canvasboxtag ""

      if {[string compare "" $sortcommand] &&
          [string compare "" [$ip_priv(mega)$pathName interpeval info commands $sortcommand]]} {
        eval $canvasPath layout [lindex $layoutCommand 0]  -iconwidth $iconwidth -iconheight $iconheight  -iconspaceh $iconspaceh -iconspacev $iconspacev  -computeiconsize $computeiconsize  -sortcommand $sortcommand  -edgeorder [$ip_priv(mega)$pathName confvalue -edgeorder]  -graphorder [$ip_priv(mega)$pathName confvalue -graphorder]  [lrange $layoutCommand 1 end]
      } {
        eval $canvasPath layout [lindex $layoutCommand 0]  -iconwidth $iconwidth -iconheight $iconheight  -iconspaceh $iconspaceh -iconspacev $iconspacev  -computeiconsize $computeiconsize  -edgeorder [$ip_priv(mega)$pathName confvalue -edgeorder]  -graphorder [$ip_priv(mega)$pathName confvalue -graphorder]  [lrange $layoutCommand 1 end]
      }
    } {
      eval $layoutCommand $canvasPath $args
    }
    $ip_priv(mega)$pathName config -scale $currentScale
  }
  return ""
}


# Procedure: tkiconpane_minorStatus
proc tkiconpane_minorStatus { pathName args} {
# xf ignore me 8
  global ip_priv

  set statusvariable [$ip_priv(mega)$pathName confvalue -statusvariable]
  if {[string compare "" $statusvariable]} {
    if {[llength $args] == 0} {
      return [$ip_priv(mega)$pathName interpset $statusvariable]
    } {
      $ip_priv(mega)$pathName interpset $statusvariable [lindex $args 0]
    }
  }
  return ""
}


# Procedure: tkiconpane_receiveIcon
proc tkiconpane_receiveIcon { interp pathName iconId} {
  global ip_priv

  set ip_priv(drag&dropIconId) $iconId
  set ip_priv(drag&dropInterpreter) $interp
  set ip_priv(drag&dropPath) $pathName
}


# Procedure: tkiconpane_updateMenu
proc tkiconpane_updateMenu { {menuPath ""}} {
  if {[string compare "" $menuPath]} {
    set pathName [tkiconpane_info tkiconpane]
    $menuPath conf -activebackground  [lindex [$pathName config -activebackground] 4]
    $menuPath conf -activeforeground  [lindex [$pathName config -activeforeground] 4]
    $menuPath conf -background  [lindex [$pathName config -background] 4]
    $menuPath conf -foreground  [lindex [$pathName config -foreground] 4]
    $menuPath conf -font [lindex  [$pathName config -font] 4]
  }
}



# module load procedure
proc XFLocalIncludeModule {{moduleName ""}} {
  global env
  global xfLoadInfo
  global xfLoadPath
  global xfStatus

  foreach p [split $xfLoadPath :] {
    if {[file exists "$p/$moduleName"]} {
      if {![file readable "$p/$moduleName"]} {
        puts stderr "Cannot read $p/$moduleName (permission denied)"
        continue
      }
      if {$xfLoadInfo} {
        puts stdout "Loading $p/$moduleName..."
      }
      source "$p/$moduleName"
      return 1
    }
    # first see if we have a load command
    if {[info exists env(XF_VERSION_SHOW)]} {
      set xfCommand $env(XF_VERSION_SHOW)
      regsub -all {\$xfFileName} $xfCommand $p/$moduleName xfCommand
      if {$xfLoadInfo} {
        puts stdout "Loading $p/$moduleName...($xfCommand)"
      }
      if {[catch "exec $xfCommand" contents]} {
        continue
      } {
        eval $contents
        return 1
      }
    }
    # are we able to load versions from wish ?
    if {[catch "afbind $p/$moduleName" aso]} {
      # try to use xf version load command
      global xfVersion
      if {[info exists xfVersion(showDefault)]} {
        set xfCommand $xfVersion(showDefault)
      } {
	# our last hope
        set xfCommand "vcat -q $p/$moduleName"
      }
      regsub -all {\$xfFileName} $xfCommand $p/$moduleName xfCommand
      if {$xfLoadInfo} {
        puts stdout "Loading $p/$moduleName...($xfCommand)"
      }
      if {[catch "exec $xfCommand" contents]} {
        continue
      } {
        eval $contents
        return 1
      }
    } {
      # yes we can load versions directly
      if {[catch "$aso open r" inFile]} {
        puts stderr "Cannot open $p/[$aso attr af_bound] (permission denied)"
        continue
      }
      if {$xfLoadInfo} {
        puts stdout "Loading $p/[$aso attr af_bound]..."
      }
      if {[catch "read \{$inFile\}" contents]} {
        puts stderr "Cannot read $p/[$aso attr af_bound] (permission denied)"
        close $inFile
        continue
      }
      close $inFile
      eval $contents
      return 1
    }
  }
  puts stderr "Cannot load module $moduleName -- check your xf load path"
  puts stderr "Specify a xf load path with the environment variable:"
  puts stderr "  XF_LOAD_PATH (e.g \"export XF_LOAD_PATH=.\")"
  catch "destroy ."
  catch "exit 0"
}

# application parsing procedure
proc XFLocalParseAppDefs {xfAppDefFile} {
  global xfAppDefaults

  # basically from: Michael Moore
  if {[file exists $xfAppDefFile] &&
      [file readable $xfAppDefFile] &&
      "[file type $xfAppDefFile]" == "link"} {
    catch "file type $xfAppDefFile" xfType
    while {"$xfType" == "link"} {
      if {[catch "file readlink $xfAppDefFile" xfAppDefFile]} {
        return
      }
      catch "file type $xfAppDefFile" xfType
    }
  }
  if {!("$xfAppDefFile" != "" &&
        [file exists $xfAppDefFile] &&
        [file readable $xfAppDefFile] &&
        "[file type $xfAppDefFile]" == "file")} {
    return
  }
  if {![catch "open $xfAppDefFile r" xfResult]} {
    set xfAppFileContents [read $xfResult]
    close $xfResult
    foreach line [split $xfAppFileContents "\n"] {
      # backup indicates how far to backup.  It applies to the
      # situation where a resource name ends in . and when it
      # ends in *.  In the second case you want to keep the *
      # in the widget name for pattern matching, but you want
      # to get rid of the . if it is the end of the name. 
      set backup -2  
      set line [string trim $line]
      if {[string index $line 0] == "#" || "$line" == ""} {
        # skip comments and empty lines
        continue
      }
      set list [split $line ":"]
      set resource [string trim [lindex $list 0]]
      set i [string last "." $resource]
      set j [string last "*" $resource]
      if {$j > $i} { 
        set i $j
        set backup -1
      }
      incr i
      set name [string range $resource $i end]
      incr i $backup
      set widname [string range $resource 0 $i]
      set value [string trim [lindex $list 1]]
      if {"$widname" != "" && "$widname" != "*"} {
        # insert the widget and resourcename to the application
        # defaults list.
        if {![info exists xfAppDefaults]} {
          set xfAppDefaults ""
        }
        lappend xfAppDefaults [list $widname [string tolower $name] $value]
      }
    }
  }
}

# application loading procedure
proc XFLocalLoadAppDefs {{xfClasses ""} {xfPriority "startupFile"} {xfAppDefFile ""}} {
  global env

  if {"$xfAppDefFile" == ""} {
    set xfFileList ""
    if {[info exists env(XUSERFILESEARCHPATH)]} {
      append xfFileList [split $env(XUSERFILESEARCHPATH) :]
    }
    if {[info exists env(XAPPLRESDIR)]} {
      append xfFileList [split $env(XAPPLRESDIR) :]
    }
    if {[info exists env(XFILESEARCHPATH)]} {
      append xfFileList [split $env(XFILESEARCHPATH) :]
    }
    append xfFileList " /usr/lib/X11/app-defaults"
    append xfFileList " /usr/X11/lib/X11/app-defaults"

    foreach xfCounter1 $xfClasses {
      foreach xfCounter2 $xfFileList {
        set xfPathName $xfCounter2
        if {[regsub -all "%N" "$xfPathName" "$xfCounter1" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%T" "$xfPathName" "app-defaults" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%S" "$xfPathName" "" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%C" "$xfPathName" "" xfResult]} {
          set xfPathName $xfResult
        }
        if {[file exists $xfPathName] &&
            [file readable $xfPathName] &&
            ("[file type $xfPathName]" == "file" ||
             "[file type $xfPathName]" == "link")} {
          catch "option readfile $xfPathName $xfPriority"
          if {"[info commands XFParseAppDefs]" != ""} {
            XFParseAppDefs $xfPathName
          } {
            if {"[info commands XFLocalParseAppDefs]" != ""} {
              XFLocalParseAppDefs $xfPathName
            }
          }
        } {
          if {[file exists $xfCounter2/$xfCounter1] &&
              [file readable $xfCounter2/$xfCounter1] &&
              ("[file type $xfCounter2/$xfCounter1]" == "file" ||
               "[file type $xfCounter2/$xfCounter1]" == "link")} {
            catch "option readfile $xfCounter2/$xfCounter1 $xfPriority"
            if {"[info commands XFParseAppDefs]" != ""} {
              XFParseAppDefs $xfCounter2/$xfCounter1
            } {
              if {"[info commands XFLocalParseAppDefs]" != ""} {
                XFLocalParseAppDefs $xfCounter2/$xfCounter1
              }
            }
          }
        }
      }
    }
  } {
    # load a specific application defaults file
    if {[file exists $xfAppDefFile] &&
        [file readable $xfAppDefFile] &&
        ("[file type $xfAppDefFile]" == "file" ||
         "[file type $xfAppDefFile]" == "link")} {
      catch "option readfile $xfAppDefFile $xfPriority"
      if {"[info commands XFParseAppDefs]" != ""} {
        XFParseAppDefs $xfAppDefFile
      } {
        if {"[info commands XFLocalParseAppDefs]" != ""} {
          XFLocalParseAppDefs $xfAppDefFile
        }
      }
    }
  }
}

# application setting procedure
proc XFLocalSetAppDefs {{xfWidgetPath "."}} {
  global xfAppDefaults

  if {![info exists xfAppDefaults]} {
    return
  }
  foreach xfCounter $xfAppDefaults {
    if {"$xfCounter" == ""} {
      break
    }
    set widname [lindex $xfCounter 0]
    if {[string match $widname ${xfWidgetPath}] ||
        [string match "${xfWidgetPath}*" $widname]} {
      set name [string tolower [lindex $xfCounter 1]]
      set value [lindex $xfCounter 2]
      # Now lets see how many tcl commands match the name
      # pattern specified.
      set widlist [info command $widname]
      if {"$widlist" != ""} {
        foreach widget $widlist {
          # make sure this command is a widget.
          if {![catch "winfo id $widget"] &&
              [string match "${xfWidgetPath}*" $widget]} {
            catch "$widget configure -$name $value" 
          }
        }
      }
    }
  }
}

# class bindings
# bindings
bind Entry <Control-Key-a> {# xf ignore me 8
  %W icursor 0; %W view 0}
bind Entry <Control-Key-b> {# xf ignore me 8
  %W icursor [expr [%W index insert]-1]; tk_entrySeeCaret %W}
bind Entry <Control-Key-d> {# xf ignore me 8
  %W delete [%W index insert]; tk_entrySeeCaret %W }
bind Entry <Control-Key-e> {# xf ignore me 8
  %W icursor end; tk_entrySeeCaret %W}
bind Entry <Control-Key-f> {# xf ignore me 8
  %W icursor [expr [%W index insert]+1]; tk_entrySeeCaret %W}
bind Entry <Control-Key-h> {# xf ignore me 8
  tk_entryBackspace %W; tk_entrySeeCaret %W}
bind Entry <Control-Key-i> {# xf ignore me 8
  %W insert insert \t; tk_entrySeeCaret %W}
bind Entry <Control-Key-k> {# xf ignore me 8
  %W delete insert end; tk_entrySeeCaret %W}
bind Entry <Control-Key-l> {# xf ignore me 8
  tk_entrySeeCaret %W}
bind Entry <Control-Key-v> {# xf ignore me 8
  %W insert insert "[GetSelection]"; tk_entrySeeCaret %W}
bind Entry <Control-Key-w> {# xf ignore me 8
  catch "%W delete sel.first sel.last"; tk_entrySeeCaret %W}
bind Entry <Control-Key-y> {# xf ignore me 8
  %W insert insert "[GetSelection]"; tk_entrySeeCaret %W}
bind Entry <Key-Left> {# xf ignore me 8
  %W icursor [expr [%W index insert]-1]; tk_entrySeeCaret %W }
bind Entry <Key-Right> {# xf ignore me 8
  %W icursor [expr [%W index insert]+1]; tk_entrySeeCaret %W }
bind Entry <Mod1-Key-c> {# xf ignore me 8
  global tk_priv(xfEntryCutBuffer)
  if {![catch "%W index sel.first"]} {
    set select [string range [%W get] [%W index sel.first] [%W index sel.last]]
    if {"$select" != ""} {
      set tk_priv(xfEntryCutBuffer) $select
    }
  }
  tk_entrySeeCaret %W}
bind Entry <Mod1-Key-h> {# xf ignore me 8
  %W delete 0 insert; %W view insert}
bind Entry <Mod1-Key-v> {# xf ignore me 8
  global tk_priv(xfEntryCutBuffer)
  if {[info exists tk_priv(xfEntryCutBuffer)]} {
    if {![catch "%W index sel.first"]} {
      set index [%W index sel.first]
      %W delete sel.first sel.last
      %W insert $index "$tk_priv(xfEntryCutBuffer)"
    } {
      %W insert insert "$tk_priv(xfEntryCutBuffer)"
    }
  } {
    %W insert insert "[GetSelection]"
  }
  tk_entrySeeCaret %W}
bind Entry <Mod1-Key-x> {# xf ignore me 8
  global tk_priv(xfEntryCutBuffer)
  if {![catch "%W index sel.first"]} {
    set select [string range [%W get] [%W index sel.first] [%W index sel.last]]
    if {"$select" != ""} {
      set tk_priv(xfEntryCutBuffer) $select
    }
  }
  catch "%W delete sel.first sel.last"
  tk_entrySeeCaret %W}
# bindings
bind Scale + {# xf ignore me 8
  %W set [expr [%W get]+1]}
bind Scale - {# xf ignore me 8
  %W set [expr [%W get]-1]}
bind Scale <Any-Button> {# xf ignore me 8
  incr tk_priv(buttons)}
bind Scale <Any-ButtonRelease> {# xf ignore me 8
  incr tk_priv(buttons) -1}
bind Scale <Any-Enter> {# xf ignore me 8
    if $tk_strictMotif {
	set tk_priv(activeFg) [lindex [%W config -activeforeground] 4]
	%W config -activeforeground [lindex [%W config -sliderforeground] 4]
    } {
      global tk_xfScale
      set tk_xfScale(focus) [focus]
      focus %W
    }
}
bind Scale <Any-Leave> {# xf ignore me 8
    if {$tk_strictMotif && ($tk_priv(buttons) == 0)} {
	%W config -activeforeground $tk_priv(activeFg)
    } {
      global tk_xfScale
      catch "focus $tk_xfScale(focus)"
      set tk_xfScale(focus) ""
    }
}
bind Scale <Key-Down> {# xf ignore me 8
  %W set [expr [%W get]-1]}
bind Scale <Key-End> {# xf ignore me 8
  %W set [lindex [%W config -to] 4]}
bind Scale <Key-Home> {# xf ignore me 8
  %W set [lindex [%W config -from] 4]}
bind Scale <Key-Left> {# xf ignore me 8
  %W set [expr [%W get]-1]}
bind Scale <Key-Next> {# xf ignore me 8
  %W set [expr [%W get]+10]}
bind Scale <Key-Prior> {# xf ignore me 8
  %W set [expr [%W get]-10]}
bind Scale <Key-Right> {# xf ignore me 8
  %W set [expr [%W get]+1]}
bind Scale <Key-Up> {# xf ignore me 8
  %W set [expr [%W get]+1]}
# bindings
bind Text <Control-Key-a> {# xf ignore me 8
  %W mark set insert "insert linestart"; %W yview -pickplace insert}
bind Text <Control-Key-b> {# xf ignore me 8
  %W mark set insert insert-1c; %W yview -pickplace insert}
bind Text <Control-Key-d> {# xf ignore me 8
  %W delete insert insert+1c; %W yview -pickplace insert}
bind Text <Control-Key-e> {# xf ignore me 8
  %W mark set insert "insert lineend"; %W yview -pickplace insert}
bind Text <Control-Key-f> {# xf ignore me 8
  %W mark set insert insert+1c; %W yview -pickplace insert}
bind Text <Control-Key-i> {# xf ignore me 8
  %W inser insert \t; %W yview -pickplace insert}
bind Text <Control-Key-j> {# xf ignore me 8
  %W inser insert \n; %W yview -pickplace insert}
bind Text <Control-Key-k> {# xf ignore me 8
  if {[%W compare insert == "insert lineend"]} {
    %W delete insert "insert lineend +1c"
    %W yview -pickplace insert
  } {
    %W delete insert "insert lineend"
    %W yview -pickplace insert}}
bind Text <Control-Key-l> {# xf ignore me 8
  %W yview -pickplace insert}
bind Text <Control-Key-m> {# xf ignore me 8
  %W inser insert \n; %W yview -pickplace insert}
bind Text <Control-Key-n> {# xf ignore me 8
  %W mark set insert insert+1l; %W yview -pickplace insert}
bind Text <Control-Key-o> {# xf ignore me 8
  %W inser insert \n; %W yview -pickplace insert}
bind Text <Control-Key-p> {# xf ignore me 8
  %W mark set insert insert-1l; %W yview -pickplace insert}
bind Text <Control-Key-w> {# xf ignore me 8
  catch "%W delete sel.first sel.last"}
bind Text <Control-Key-y> {# xf ignore me 8
  %W insert insert "[GetSelection]"; %W yview -pickplace insert}
bind Text <Key-Delete> {# xf ignore me 8
  tk_textBackspace %W; %W yview -pickplace insert}
bind Text <Key-Down> {# xf ignore me 8
  %W mark set insert insert+1l; %W yview -pickplace insert}
bind Text <Key-End> {# xf ignore me 8
  %W mark set insert end; %W yview -pickplace insert}
bind Text <Key-Home> {# xf ignore me 8 
  %W mark set insert 1.0; %W yview -pickplace insert}
bind Text <Key-Left> {# xf ignore me 8
  %W mark set insert insert-1c; %W yview -pickplace insert}
bind Text <Key-Next> {# xf ignore me 8
  set xfCounter [lindex [%W config -height] 4]
  while {$xfCounter > 0} {
    %W mark set insert insert+1l
    incr xfCounter -1
  }
  %W yview -pickplace insert}
bind Text <Key-Prior> {# xf ignore me 8
  set xfCounter [lindex [%W config -height] 4]
  while {$xfCounter > 0} {
    %W mark set insert insert-1l
    incr xfCounter -1
  }
  %W yview -pickplace insert}
bind Text <Key-Right> {# xf ignore me 8
  %W mark set insert insert+1c; %W yview -pickplace insert}
bind Text <Key-Up> {# xf ignore me 8
  %W mark set insert insert-1l; %W yview -pickplace insert}
bind Text <Mod1-Key-c> {# xf ignore me 8
  global tk_priv(xfTextCutBuffer)
  if {![catch "%W get sel.first sel.last" select]} {
    if {"$select" != ""} {
      set tk_priv(xfTextCutBuffer) $select
    }
  }}
bind Text <Mod1-Key-h> {# xf ignore me 8
  %W delete "insert linestart" insert; %W yview -pickplace insert}
bind Text <Mod1-Key-v> {# xf ignore me 8
  global tk_priv(xfTextCutBuffer)
  if {[info exists tk_priv(xfTextCutBuffer)]} {
    if {![catch "%W get sel.first sel.last" select]} {
      set index [%W index sel.first]
      %W delete sel.first sel.last
      %W insert $index "$tk_priv(xfTextCutBuffer)"
    } {
      %W insert insert "$tk_priv(xfTextCutBuffer)"
    }
  } {
    %W insert insert "[GetSelection]"
  }
  %W yview -pickplace insert}
bind Text <Mod1-Key-x> {# xf ignore me 8
  global tk_priv(xfTextCutBuffer)
  if {![catch "%W get sel.first sel.last" select]} {
    if {"$select" != ""} {
      set tk_priv(xfTextCutBuffer) $select
    }
  }
  catch "%W delete sel.first sel.last"}

# form bindings
proc XFLocalFormBind {xfW xfPrevW xfNextW {xfCommand ""}} {

  if {"[info procs XFBindFocusIn]" != ""} {
    set xfFocusCmd XFBindFocusIn
  } {
    if {"[info procs XFLocalFocusIn]" != ""} {
      set xfFocusCmd XFLocalFocusIn
    } {
      return
    }
  }

  if {"$xfPrevW" != ""} {
    if {"[winfo class $xfW]" == "Entry"} {
      bind $xfW <Up> "$xfFocusCmd $xfPrevW"
      bind $xfW <Control-Up> "$xfFocusCmd $xfPrevW"
      bind $xfW <Meta-Up> "$xfFocusCmd $xfPrevW"
    } {
      if {"[winfo class $xfW]" == "Text"} {
        bind $xfW <Control-Up> "$xfFocusCmd $xfPrevW"
        bind $xfW <Meta-Up> "$xfFocusCmd $xfPrevW"
      } {
        if {"[winfo class $xfW]" == "TkEmacs"} {
          bind $xfW <Control-Up> "$xfFocusCmd $xfPrevW"
          bind $xfW <Meta-Up> "$xfFocusCmd $xfPrevW"
        }
      }
    }
  } {
    if {"[winfo class $xfW]" == "Entry"} {
      catch "bind $xfW <Up> {NoFunction}"
      catch "bind $xfW <Control-Up> {NoFunction}"
      catch "bind $xfW <Meta-Up> {NoFunction}"
    } {
      if {"[winfo class $xfW]" == "Text"} {
        catch "bind $xfW <Control-Up> {NoFunction}"
        catch "bind $xfW <Meta-Up> {NoFunction}"
      } {
        if {"[winfo class $xfW]" == "TkEmacs"} {
          catch "bind $xfW <Control-Up> {NoFunction}"
          catch "bind $xfW <Meta-Up> {NoFunction}"
        }
      }
    }
  }
  if {"$xfNextW" != ""} {
    if {"[winfo class $xfW]" == "Entry"} {
      bind $xfW <Down> "$xfFocusCmd $xfNextW"
      bind $xfW <Control-Down> "$xfFocusCmd $xfNextW"
      bind $xfW <Meta-Down> "$xfFocusCmd $xfNextW"
      bind $xfW <Return> "$xfCommand; $xfFocusCmd $xfNextW"
      bind $xfW <Control-Return> "$xfCommand; $xfFocusCmd $xfNextW"
      bind $xfW <Meta-Return> "$xfCommand; $xfFocusCmd $xfNextW"
    } {
      if {"[winfo class $xfW]" == "Text"} {
        bind $xfW <Control-Down> "$xfFocusCmd $xfNextW"
        bind $xfW <Meta-Down> "$xfFocusCmd $xfNextW"
        bind $xfW <Control-Return> "$xfCommand; $xfFocusCmd $xfNextW"
        bind $xfW <Meta-Return> "$xfCommand; $xfFocusCmd $xfNextW"
      } {
        if {"[winfo class $xfW]" == "TkEmacs"} {
          bind $xfW <Control-Down> "$xfFocusCmd $xfNextW"
          bind $xfW <Meta-Down> "$xfFocusCmd $xfNextW"
          bind $xfW <Control-Return> "$xfCommand; $xfFocusCmd $xfNextW"
          bind $xfW <Meta-Return> "$xfCommand; $xfFocusCmd $xfNextW"
        }
      }
    }
  } {
    if {"[winfo class $xfW]" == "Entry"} {
      catch "bind $xfW <Down> {NoFunction}"
      catch "bind $xfW <Control-Down> {NoFunction}"
      catch "bind $xfW <Meta-Down> {NoFunction}"
      catch "bind $xfW <Return> \"$xfCommand; NoFunction\""
      catch "bind $xfW <Control-Return> \"$xfCommand; NoFunction\""
      catch "bind $xfW <Meta-Return> \"$xfCommand; NoFunction\""
    } {
      if {"[winfo class $xfW]" == "Text"} {
        catch "bind $xfW <Control-Down> {NoFunction}"
        catch "bind $xfW <Meta-Down> {NoFunction}"
        catch "bind $xfW <Control-Return> \"$xfCommand; NoFunction\""
        catch "bind $xfW <Meta-Return> \"$xfCommand; NoFunction\""
      } {
        if {"[winfo class $xfW]" == "TkEmacs"} {
          catch "bind $xfW <Control-Down> {NoFunction}"
          catch "bind $xfW <Meta-Down> {NoFunction}"
          catch "bind $xfW <Control-Return> \"$xfCommand; NoFunction\""
          catch "bind $xfW <Meta-Return> \"$xfCommand; NoFunction\""
        }
      }
    }
  }
}

# focus in a text/entry widget
proc XFLocalFocusIn {xfW} {
  global tkVersion

  if {"[winfo class $xfW]" == "Entry"} {
    if {$tkVersion >= 3.0} {
      $xfW icursor 0
    } {
      $xfW cursor 0
    }
  } {
    if {"[winfo class $xfW]" == "Text"} {
      $xfW mark set insert 1.0
    } {
      if {"[winfo class $xfW]" == "TkEmacs"} {
        $xfW mark set insert 0.0
      }
    }
  }
  focus $xfW
}

# form support procedure
proc XFLocalFormConnect {xfWList {xfCommand ""} {xfInitial 1}} {

  set xfType 0
  set xfPackList ""
  foreach xfW $xfWList {
    if {("[winfo class $xfW]" == "Entry" ||
         "[winfo class $xfW]" == "Text" ||
         "[winfo class $xfW]" == "TkEmacs")} {
      lappend xfPackList $xfW
    }
    foreach xfElement [pack info $xfW] {
      if {$xfType == 0} {
        if {("[winfo class $xfElement]" == "Entry" ||
             "[winfo class $xfElement]" == "Text" ||
             "[winfo class $xfElement]" == "TkEmacs")} {
          eval lappend xfPackList $xfElement
        }
        if {"[pack info $xfElement]" != ""} {
          if {"[info procs XFBindFormConnect]" != ""} {
            set xfTmpPackList [XFBindFormConnect $xfElement $xfCommand 0]
          } {
            if {"[info procs XFLocalFormConnect]" != ""} {
              set xfTmpPackList [XFLocalFormConnect $xfElement $xfCommand 0]
            } {
              set xfTmpPackList ""
            }
          }
          if {"$xfTmpPackList" != ""} {
            eval lappend xfPackList $xfTmpPackList
          }
        }
        set xfType 1
      } {
        set xfType 0
      }
    }
  }
  if {$xfInitial} {
    set xfFromWidget ""
    set xfToWidget ""
    set xfCounter 1
    foreach xfElement $xfPackList {
      set xfToWidget [lindex $xfPackList $xfCounter]
      if {"[info procs XFBindForms]" != ""} {
        XFBindForms $xfElement $xfFromWidget $xfToWidget $xfCommand
      } {
        if {"[info procs XFLocalFormBind]" != ""} {
          XFLocalFormBind $xfElement $xfFromWidget $xfToWidget $xfCommand
        }
      }
      set xfFromWidget $xfElement
      incr xfCounter
    }
  } {
    return $xfPackList
  }
}



# end source
proc EndSrc {} {
  global argv
  global auto_path
  global env
  global fsBox
  global inputBox
  global mobal
  global mobalFile
  global mobalPath
  global mobalWindowCounters
  global mobalWindowPositions
  global mobalWindowTitles
  global mobalViewType

  # Initialize environment if neccessary.
  if {![info exists env(MOBALHOME)]} {
    set env(MOBALHOME) $env(HOME)/development
  }

  # This array contains the global mobal variables.

  # The current domain.
  set mobal(domain) ""
  # The current domain in short form.
  set mobal(domainShort) ""
  # The standard background color.
  set mobal(background) white
  # This variable is used to wait for the result
  # of a command evaluation in the prolog
  # interpreter. Take a look into PrologSend.
  set mobal(blocking) 0
  # This variable represents the display status
  # of the CKRL menubutton.
  set mobal(CKRL) 0
  # This variable is set to true if the current
  # display supports colors.
  set mobal(color) [regexp -nocase {color} [winfo screenvisual .]]
  # Debugging informations
  set mobal(debugging) 0
  set mobal(debuggingPrint) 0
  # The standard foreground color.
  set mobal(foreground) black
  # The graph view window counter
  set mobal(graphViewCounter) 0
  # The host which we want to connect to.
  set mobal(host) ""
  # This counter makes each input box unique.
  set mobal(inputCounter) 0
  # This variable contains the currently reviesed
  # knowledge items (if any).
  set mobal(knowledge) ""
  # This variable contains the last prolog listerner log.
  set mobal(lastLog) ""
  # This variable contains the last prolog listerner command.
  set mobal(lastProlog) ""
  # This variable contains the last scratchpad command.
  set mobal(lastScratch) ""
  # Layout informations
  set mobal(layout,method) Default
  set mobal(layout,order) 0
  # This variable is used to implement keyboard
  # focus management for listboxes.
  set mobal(listFocus) ""
  # This variable is used to implement keyboard
  # focus management for listboxes.
  set mobal(listSelection) ""
  # This variable contains the currently reviesed meta
  # predicate name (if any).
  set mobal(metaPred) ""
  # The global communication channel.
  set mobal(outFd) stdout
  # This variable contains the current parameter
  # changed status.
  set mobal(paramsChanged) 0
  # The parameter display level (basic or advanced).
  set mobal(paramsLevel) "basic"
  # The port which we want to connect to.
  set mobal(port) ""
  # This variable is used as a queue counter.
  set mobal(queueCounter) 0
  # This variable contains the recieved command.
  set mobal(request) ""
  # This variable contains the recieved result.
  # action).
  set mobal(result) ""
  # The command prefix used to prevent name clashes
  # among different TCP/IP packages and Tcl/Tk.
  set mobal(socketPrefix) ""
  # This variable contains a temporary result.
  set mobal(tmpResult) ""
  # This variable contains the temporary result from the
  # tcp connection reading.
  set mobal(tmpReadResult) ""
  # This is the current tool.
  set mobal(tool) "hci"
  # This list contains all external tool names.
  set mobal(toolList) ""

  # This array contains the configurated pathnames
  # used by TkMobal.

  # The pathname definitions for tkiconpane.
  set searchList ""
  if {[info exists env(XF_LOAD_PATH)]} {
    foreach dirName [split $env(XF_LOAD_PATH) :] {
      lappend searchList $dirName
    }
  }
  foreach dirName $auto_path {
    lappend searchList $dirName
  }
  foreach element {{env(MOBAL_LAYOUTDIR) mobalPath(layout) /lib/layout} {env(MOBAL_MENUDIR) mobalPath(menu) /lib/viewMenus} {env(MOBAL_EDGEMENUDIR) mobalPath(edgeMenu) /lib/menus} {env(MOBAL_ICONMENUDIR) mobalPath(iconMenu) /lib/menus} {env(MOBAL_PIXMAPDIR) mobalPath(iconPixmap) /lib/icons} {env(MOBAL_STATUSDIR) mobalPath(iconStatus) /lib/status} {env(MOBAL_TUTORIALFILE) mobalPath(tutorial) /doc/tutorial.ps} {env(MOBAL_TKINFOFILE) mobalPath(tkinfo) /doc/tkmobal.info}} {
    if {[info exists [lindex $element 0]]} {
      set [lindex $element 1] [MiscDirnamePrepare [set [lindex $element 0]]]
    } {
      if {[file exists $env(MOBALHOME)/TkMobal/[lindex $element 2]]} {
        set [lindex $element 1] [MiscDirnamePrepare $env(MOBALHOME)/TkMobal/[lindex $element 2]]
      } {
        foreach name $searchList {
          if {[file exists $name/[lindex $element 2]]} {
            set [lindex $element 1] [MiscDirnamePrepare $name/[lindex $element 2]]
          }
        }
      }
    }
  }

  # This array conatins all path names for the
  # various file selector boxes.
  set mobalFile(dumpPSPath) $env(MOBALHOME)
  set mobalFile(loadCKRL) $env(MOBALHOME)
  set mobalFile(loadTool) $env(MOBALHOME)
  set mobalFile(openDomain) $env(MOBALHOME)
  set mobalFile(readText) $env(MOBALHOME)

  # This array contains the definitions for all
  # known view types. First comes the title for
  # the view, and then the popup menu definition.
  set mobalViewType(agenda) {{Agenda} {Details Delete Handle}}
  set mobalViewType(tnode) {{Topology} {Details Delete Graphic {Learn About} {Add Predicate} {Remove Predicate} {Add Link} {Remove Link}}}
  set mobalViewType(sclass) {{Sorts} {Details Graphic}}
  set mobalViewType(pred) {{Predicates} {Details Delete Statistics Graphic {Binary Relation Graph} {Learn About} Rename}}
  set mobalViewType(fact) {{Facts} {Details Delete Statistics Graphic Derivation {Derivation Graph} {Knowledge Revision}}}
  set mobalViewType(rule) {{Rules} {Details Delete Statistics Graphic {Pretty Print} Reformulate {Generate Metapredicate}}}
  set mobalViewType(ic) {{Constraints} {Details Delete Check}}
  set mobalViewType(mpred) {{Metapredicates} {Details Delete {RDT Lattice} {CLT Lattice} Restrictions}}
  set mobalViewType(mfact) {{Metafacts} {Details Delete Derivation}}
  set mobalViewType(mrule) {{Metarules} {Details Delete}}
  set mobalViewType(mmpred) {{Metametapredicates} {Details Delete}}
  set mobalViewType(mmfact) {{Metametafacts} {Details Delete}}

  # This array contains the list of window counters
  # for all posssible view types (and other window types).
  set mobalWindowCounters(parameter) ""
  set mobalWindowCounters(settings) ""
  set mobalWindowCounters(scratchpad) ""
  set mobalWindowCounters(prologlistener) ""
  set mobalWindowCounters(graphic) ""
  set mobalWindowCounters(text) ""

  # This array contains all title strings for the
  # possible window types.
  set mobalWindowTitles(parameter) Parameter
  set mobalWindowTitles(settings) Settings
  set mobalWindowTitles(scratchpad) Scratchpad
  set mobalWindowTitles(prologlistener) Prologlistener
  set mobalWindowTitles(graphic) Graphic
  set mobalWindowTitles(text) Text

  # This array contains the last position of the windows
  # for all window types.
  set mobalWindowPositions(parameter) ""
  set mobalWindowPositions(settings) ""
  set mobalWindowPositions(scratchpad) ""
  set mobalWindowPositions(prologlistener) ""
  set mobalWindowPositions(graphic) ""
  set mobalWindowPositions(alert) ""
  set mobalWindowPositions(read) ""
  set mobalWindowPositions(button) ""
  set mobalWindowPositions(font) ""
  set mobalWindowPositions(fs) ""
  set mobalWindowPositions(input) ""
  set mobalWindowPositions(list) ""
  set mobalWindowPositions(parameter) ""
  set mobalWindowPositions(text) ""
  set mobalWindowPositions(yesno) ""

  # A list off all focus specifications attached
  # to the views.
  global mobalWindowFocus

  # A list off all sorting specifications attached
  # to the views.
  global mobalWindowSortings

  # A list where all topology views are mapped
  # to their correspinding topology type.
  global mobalTopology

  # All tool parameters are temporarily stored here.
  global mobalParameters

  # All tool parameter types are temporarily stored here.
  global mobalParameterTypes

  # This variable contains the current unrestricted selection
  # for the tool parameters.
  global mobalUnrestricted

  # This array contains the temporary informations related
  # to the meta predicate revision.
  global mobalRestrictions

  # This array contains the temporary informations related
  # to the knowledge revision.
  global mobalKnowledge

  # All graph nodes and edges are stored in this array.
  global mobalGraph
  set mobalGraph(init) ""

  # Initialize the mobal view parameters
  foreach element [array names mobalViewType] {
    set mobalWindowCounters($element) ""
    set mobalWindowPositions($element) ""
    set mobalWindowTitles($element) [lindex [set mobalViewType($element)] 0]
  }

  MiscSetStatus Ready

  # Initialize the CKRL menu displaying.
  MobalCallCKRL

  # Handle commandline parameters.
  if {[llength $argv] > 0} {
    for {set counter 0} {$counter < [llength $argv]} {incr counter} {
      case [lindex $argv $counter] {
        {-host} {
          incr counter
          set mobal(host) [lindex $argv $counter]
        }
        {-port} {
          incr counter
          set mobal(port) [lindex $argv $counter]
        }
      }
    }
  }

  # Do we want to commuinicate via sockets ?
  PrologSetReady
  if {"$mobal(host)" != "" && "$mobal(port)" != ""} {
    PrologInit $mobal(host) $mobal(port)
  }

  # Local initializations.
#  PrologSend mobal_prolog_listener [PrologAtom [PrologList [PrologAtom /home/spotzy/garfield/mobal/tcpmobal/tcl-interface]]]

  if {"$mobal(outFd)" != "stdout"} {
    set mobal(domain) [lindex [PrologSend mobal_current_domain] 0]
    set mobal(domainShort) [file tail $mobal(domain)]
    set mobalFile(openDomain) [lindex [PrologSend mobal_default_directory [PrologAtom domain]] 0]
    set mobalFile(loadTool) [lindex [PrologSend mobal_default_directory [PrologAtom tool]] 0]
    set mobalFile(loadCKRL) $mobalFile(openDomain)
    set mobalFile(readText) $mobalFile(openDomain)
  }

  # Initialize the file selector box (partially depending
  # on the communication style.
  set fsBox(path) $mobalFile(openDomain)
  set fsBox(internalPath) $mobalFile(openDomain)
  set fsBox(pattern) *
  set fsBox(block) 0
  set fsBox(checkCommand) ""
  set fsBox(clickCounter) 0
  set fsBox(clickEval) 0
  set fsBox(clickInterval) 300
  catch "exec hostname" tmpResult
  if {"$mobal(outFd)" == "stdout" || "$mobal(host)" == "$tmpResult"} {
    set mobal(localFS) 1
    set fsBox(list,0) {MiscFileList $fsBoxPath domain}
    set fsBox(list,1) {MiscFileList $fsBoxPath file}
    set fsBox(list,2) {MiscFileList $fsBoxPath tool}
  } {
    set mobal(localFS) 0
    set fsBox(list,0) {PrologSendForce domain_list [PrologAtom $fsBoxPath]}
    set fsBox(list,1) {PrologSendForce file_list [PrologAtom $fsBoxPath]}
    set fsBox(list,2) {PrologSendForce tool_list [PrologAtom $fsBoxPath]}
  }

  # Initialize the input box.
  set inputBox(checkCommand) ""

  # By default we do not debug.
  MiscSetDebugging 0

  # Load the layout algorithms.
  foreach fileName [glob -nocomplain $mobalPath(layout)/*.lay] {
    source $fileName
  }

  # set the main windows title
  if {"$mobal(host)" == ""} {
    wm title . "Mobal"
  } {
    wm title . "Mobal@$mobal(host)"
  }

  # Load the mobal lists.
  MobalUpdateLocalLists

  # Add the external tools.
  MobalAddTool

  puts stdout "Ready."	
  update idletask
}

# initialize global variables
global {alertBox}
set {alertBox(activeBackground)} {}
set {alertBox(activeForeground)} {}
set {alertBox(after)} {0}
set {alertBox(anchor)} {center}
set {alertBox(background)} {}
set {alertBox(button)} {0}
set {alertBox(font)} {*times-bold-r-normal*24*}
set {alertBox(foreground)} {}
set {alertBox(justify)} {center}
set {alertBox(toplevelName)} {.alertBox}
global {fontBox}
set {fontBox(activeBackground)} {}
set {fontBox(activeForeground)} {}
set {fontBox(background)} {}
set {fontBox(font)} {}
set {fontBox(font-demo)} {This text shows the results :-)}
set {fontBox(fontFamily)} {*}
set {fontBox(fontName)} {}
set {fontBox(fontPixels)} {*}
set {fontBox(fontSWidth)} {*}
set {fontBox(fontSlant)} {*}
set {fontBox(fontWeight)} {*}
set {fontBox(foreground)} {}
set {fontBox(kanjifont-demo)} {줬ΥեȤǤ}
set {fontBox(resource)} {font}
set {fontBox(scrollActiveForeground)} {}
set {fontBox(scrollBackground)} {}
set {fontBox(scrollForeground)} {}
set {fontBox(scrollSide)} {left}
global {fsBox}
set {fsBox(activeBackground)} {}
set {fsBox(activeForeground)} {}
set {fsBox(all)} {0}
set {fsBox(background)} {}
set {fsBox(block)} {0}
set {fsBox(button)} {0}
set {fsBox(checkCommand)} {}
set {fsBox(clickCounter)} {0}
set {fsBox(clickEval)} {0}
set {fsBox(clickInterval)} {300}
set {fsBox(extensions)} {0}
set {fsBox(font)} {}
set {fsBox(foreground)} {}
set {fsBox(internalPath)} {/home/garfield/development}
set {fsBox(list,0)} {MiscFileList $fsBoxPath domain}
set {fsBox(list,1)} {MiscFileList $fsBoxPath file}
set {fsBox(list,2)} {MiscFileList $fsBoxPath tool}
set {fsBox(name)} {}
set {fsBox(path)} {/home/garfield/development}
set {fsBox(pattern)} {*}
set {fsBox(scrollActiveForeground)} {}
set {fsBox(scrollBackground)} {}
set {fsBox(scrollForeground)} {}
set {fsBox(scrollSide)} {left}
set {fsBox(showPixmap)} {0}
global {inputBox}
set {inputBox(activeBackground)} {}
set {inputBox(activeForeground)} {}
set {inputBox(anchor)} {n}
set {inputBox(background)} {}
set {inputBox(cancel)} {1}
set {inputBox(checkCommand)} {}
set {inputBox(erase)} {1}
set {inputBox(font)} {}
set {inputBox(foreground)} {}
set {inputBox(justify)} {center}
set {inputBox(scrollActiveForeground)} {}
set {inputBox(scrollBackground)} {}
set {inputBox(scrollForeground)} {}
set {inputBox(scrollSide)} {left}
set {inputBox(toplevelName)} {.inputBox}
global {ip_priv}
set {ip_priv(drag&dropIconId)} {0}
set {ip_priv(drag&dropInterpreter)} {}
set {ip_priv(drag&dropPath)} {}
set {ip_priv(drag&dropType)} {0}
set {ip_priv(mega)} {mega}
set {ip_priv(menuBar)} {}
set {ip_priv(toolBar)} {}
global {mobal}
set {mobal(CKRL)} {0}
set {mobal(background)} {white}
set {mobal(blocking)} {1}
set {mobal(color)} {1}
set {mobal(debugging)} {0}
set {mobal(debuggingPrint)} {0}
set {mobal(domain)} {}
set {mobal(domainShort)} {}
set {mobal(foreground)} {black}
set {mobal(graphViewCounter)} {0}
set {mobal(host)} {}
set {mobal(inputCounter)} {0}
set {mobal(knowledge)} {}
set {mobal(lastLog)} {}
set {mobal(lastProlog)} {}
set {mobal(lastScratch)} {}
set {mobal(layout,method)} {Default}
set {mobal(layout,order)} {0}
set {mobal(listFocus)} {}
set {mobal(listSelection)} {}
set {mobal(localFS)} {1}
set {mobal(metaPred)} {}
set {mobal(outFd)} {stdout}
set {mobal(paramsChanged)} {0}
set {mobal(paramsLevel)} {basic}
set {mobal(port)} {}
set {mobal(queueCounter)} {0}
set {mobal(request)} {}
set {mobal(result)} {}
set {mobal(sendStatus)} {Ready}
set {mobal(socketPrefix)} {}
set {mobal(status)} {Ready}
set {mobal(tmpReadResult)} {}
set {mobal(tmpResult)} {}
set {mobal(tool)} {hci}
set {mobal(toolList)} {}
global {mobalFile}
set {mobalFile(dumpPSPath)} {/home/garfield/development}
set {mobalFile(loadCKRL)} {/home/garfield/development}
set {mobalFile(loadTool)} {/home/garfield/development}
set {mobalFile(openDomain)} {/home/garfield/development}
set {mobalFile(readText)} {/home/garfield/development}
global {mobalGraph}
set {mobalGraph(init)} {}
global {mobalPath}
set {mobalPath(edgeMenu)} {/home/garfield/development/TkMobal/lib/menus}
set {mobalPath(iconMenu)} {/home/garfield/development/TkMobal/lib/menus}
set {mobalPath(iconPixmap)} {/home/garfield/development/TkMobal/lib/icons}
set {mobalPath(iconStatus)} {/home/garfield/development/TkMobal/lib/status}
set {mobalPath(layout)} {/home/garfield/development/TkMobal/lib/layout}
set {mobalPath(menu)} {/home/garfield/development/TkMobal/lib/viewMenus}
set {mobalPath(tkinfo)} {/home/garfield/development/doc/tkmobal.info}
set {mobalPath(tutorial)} {/home/garfield/tmp/TkMobal/lib/doc/tutorial.ps}
global {mobalViewType}
set {mobalViewType(agenda)} {{Agenda} {Details Delete Handle}}
set {mobalViewType(fact)} {{Facts} {Details Delete Statistics Graphic Derivation {Derivation Graph} {Knowledge Revision}}}
set {mobalViewType(ic)} {{Constraints} {Details Delete Check}}
set {mobalViewType(mfact)} {{Metafacts} {Details Delete Derivation}}
set {mobalViewType(mmfact)} {{Metametafacts} {Details Delete}}
set {mobalViewType(mmpred)} {{Metametapredicates} {Details Delete}}
set {mobalViewType(mpred)} {{Metapredicates} {Details Delete {RDT Lattice} {CLT Lattice} Restrictions}}
set {mobalViewType(mrule)} {{Metarules} {Details Delete}}
set {mobalViewType(pred)} {{Predicates} {Details Delete Statistics Graphic {Binary Relation Graph} {Learn About} Rename}}
set {mobalViewType(rule)} {{Rules} {Details Delete Statistics Graphic {Pretty Print} Reformulate {Generate Metapredicate}}}
set {mobalViewType(sclass)} {{Sorts} {Details Graphic}}
set {mobalViewType(tnode)} {{Topology} {Details Delete Graphic {Learn About} {Add Predicate} {Remove Predicate} {Add Link} {Remove Link}}}
global {mobalWindowCounters}
set {mobalWindowCounters(agenda)} {}
set {mobalWindowCounters(fact)} {}
set {mobalWindowCounters(graphic)} {}
set {mobalWindowCounters(ic)} {}
set {mobalWindowCounters(mfact)} {}
set {mobalWindowCounters(mmfact)} {}
set {mobalWindowCounters(mmpred)} {}
set {mobalWindowCounters(mpred)} {}
set {mobalWindowCounters(mrule)} {}
set {mobalWindowCounters(parameter)} {}
set {mobalWindowCounters(pred)} {}
set {mobalWindowCounters(prologlistener)} {}
set {mobalWindowCounters(rule)} {}
set {mobalWindowCounters(sclass)} {}
set {mobalWindowCounters(scratchpad)} {}
set {mobalWindowCounters(settings)} {}
set {mobalWindowCounters(text)} {}
set {mobalWindowCounters(tnode)} {}
global {mobalWindowPositions}
set {mobalWindowPositions(agenda)} {}
set {mobalWindowPositions(alert)} {}
set {mobalWindowPositions(button)} {}
set {mobalWindowPositions(fact)} {}
set {mobalWindowPositions(font)} {}
set {mobalWindowPositions(fs)} {}
set {mobalWindowPositions(graphic)} {}
set {mobalWindowPositions(ic)} {}
set {mobalWindowPositions(input)} {}
set {mobalWindowPositions(list)} {}
set {mobalWindowPositions(mfact)} {}
set {mobalWindowPositions(mmfact)} {}
set {mobalWindowPositions(mmpred)} {}
set {mobalWindowPositions(mpred)} {}
set {mobalWindowPositions(mrule)} {}
set {mobalWindowPositions(parameter)} {}
set {mobalWindowPositions(pred)} {}
set {mobalWindowPositions(prologlistener)} {}
set {mobalWindowPositions(read)} {}
set {mobalWindowPositions(rule)} {}
set {mobalWindowPositions(sclass)} {}
set {mobalWindowPositions(scratchpad)} {}
set {mobalWindowPositions(settings)} {}
set {mobalWindowPositions(text)} {}
set {mobalWindowPositions(tnode)} {}
set {mobalWindowPositions(yesno)} {}
global {mobalWindowTitles}
set {mobalWindowTitles(agenda)} {Agenda}
set {mobalWindowTitles(fact)} {Facts}
set {mobalWindowTitles(graphic)} {Graphic}
set {mobalWindowTitles(ic)} {Constraints}
set {mobalWindowTitles(mfact)} {Metafacts}
set {mobalWindowTitles(mmfact)} {Metametafacts}
set {mobalWindowTitles(mmpred)} {Metametapredicates}
set {mobalWindowTitles(mpred)} {Metapredicates}
set {mobalWindowTitles(mrule)} {Metarules}
set {mobalWindowTitles(parameter)} {Parameter}
set {mobalWindowTitles(pred)} {Predicates}
set {mobalWindowTitles(prologlistener)} {Prologlistener}
set {mobalWindowTitles(rule)} {Rules}
set {mobalWindowTitles(sclass)} {Sorts}
set {mobalWindowTitles(scratchpad)} {Scratchpad}
set {mobalWindowTitles(settings)} {Settings}
set {mobalWindowTitles(text)} {Text}
set {mobalWindowTitles(tnode)} {Topology}
global {nearest}
set {nearest} {1}
global {prologListener}
set {prologListener(activeBackground)} {}
set {prologListener(activeForeground)} {}
set {prologListener(background)} {}
set {prologListener(font)} {}
set {prologListener(foreground)} {}
set {prologListener(scrollActiveForeground)} {}
set {prologListener(scrollBackground)} {}
set {prologListener(scrollForeground)} {}
set {prologListener(scrollSide)} {left}
global {readBox}
set {readBox(activeBackground)} {}
set {readBox(activeForeground)} {}
set {readBox(background)} {}
set {readBox(font)} {}
set {readBox(foreground)} {}
set {readBox(scrollActiveForeground)} {}
set {readBox(scrollBackground)} {}
set {readBox(scrollForeground)} {}
set {readBox(scrollSide)} {left}
global {result}
set {result} {}
global {scratchPad}
set {scratchPad(activeBackground)} {}
set {scratchPad(activeForeground)} {}
set {scratchPad(background)} {}
set {scratchPad(font)} {}
set {scratchPad(foreground)} {}
set {scratchPad(scrollActiveForeground)} {}
set {scratchPad(scrollBackground)} {}
set {scratchPad(scrollForeground)} {}
set {scratchPad(scrollSide)} {left}
global {textBox}
set {textBox(activeBackground)} {}
set {textBox(activeForeground)} {}
set {textBox(background)} {}
set {textBox(button)} {0}
set {textBox(contents)} {This is a text box!}
set {textBox(font)} {}
set {textBox(foreground)} {}
set {textBox(scrollActiveForeground)} {}
set {textBox(scrollBackground)} {}
set {textBox(scrollForeground)} {}
set {textBox(scrollSide)} {left}
set {textBox(state)} {disabled}
set {textBox(toplevelName)} {.xfmobalStacktext--1}
global {yesNoBox}
set {yesNoBox(activeBackground)} {}
set {yesNoBox(activeForeground)} {}
set {yesNoBox(afterNo)} {0}
set {yesNoBox(afterYes)} {0}
set {yesNoBox(anchor)} {center}
set {yesNoBox(background)} {}
set {yesNoBox(button)} {0}
set {yesNoBox(font)} {*times-bold-r-normal*24*}
set {yesNoBox(foreground)} {}
set {yesNoBox(justify)} {center}

# please don't modify the following
# variables. They are needed by xf.
global {autoLoadList}
set {autoLoadList(dialogAlert.tcl)} {0}
set {autoLoadList(dialogButtonChoose.tcl)} {0}
set {autoLoadList(dialogFileSelect.tcl)} {0}
set {autoLoadList(dialogFont.tcl)} {0}
set {autoLoadList(dialogGraph.tcl)} {0}
set {autoLoadList(dialogInput.tcl)} {0}
set {autoLoadList(dialogKnowledge.tcl)} {0}
set {autoLoadList(dialogListChoose.tcl)} {0}
set {autoLoadList(dialogListener.tcl)} {0}
set {autoLoadList(dialogMetaPred.tcl)} {0}
set {autoLoadList(dialogReadTCL.tcl)} {0}
set {autoLoadList(dialogScratch.tcl)} {0}
set {autoLoadList(dialogText.tcl)} {0}
set {autoLoadList(dialogView.tcl)} {0}
set {autoLoadList(dialogViewParams.tcl)} {0}
set {autoLoadList(dialogViewSetting.tcl)} {0}
set {autoLoadList(dialogYesNo.tcl)} {0}
set {autoLoadList(external.tcl)} {0}
set {autoLoadList(fnctsCKRL.tcl)} {0}
set {autoLoadList(fnctsCall.tcl)} {0}
set {autoLoadList(fnctsFile.tcl)} {0}
set {autoLoadList(fnctsView.tcl)} {0}
set {autoLoadList(fnctsWindows.tcl)} {0}
set {autoLoadList(interface.tcl)} {0}
set {autoLoadList(main.tcl)} {0}
set {autoLoadList(misc.tcl)} {0}
set {autoLoadList(mobal.tcl)} {0}
set {autoLoadList(prolog.tcl)} {0}
set {autoLoadList(tkIconPaneInt.tcl)} {0}
global {internalAliasList}
set {internalAliasList} {}
global {moduleList}
set {moduleList(dialogAlert.tcl)} { AlertBox}
set {moduleList(dialogButtonChoose.tcl)} { ButtonChoose}
set {moduleList(dialogFileSelect.tcl)} { FSBox FSBoxBindSelectOne FSBoxFSFileSelect FSBoxFSFileSelectDouble FSBoxFSInsertPath FSBoxFSShow}
set {moduleList(dialogFont.tcl)} { FontBox FontBoxComposeFont FontBoxSelectFont FontBoxSetFont}
set {moduleList(dialogGraph.tcl)} { GraphCreateWindow GraphExpandNode GraphLayoutMethod_Default GraphSelectNode GraphUpdateArrowDirection GraphUpdateEdgeMenu GraphUpdateNodeMenu}
set {moduleList(dialogInput.tcl)} { InputBoxMulti InputBoxOne InputBoxInternal}
set {moduleList(dialogKnowledge.tcl)} { .knowledge Knowledge KnowledgeAdd KnowledgeCancel KnowledgeDoIt KnowledgeFlipSign KnowledgeItemPopup KnowledgeRecompute KnowledgeRemove KnowledgeSelectItem KnowledgeSelectSet KnowledgeSelectSetItem}
set {moduleList(dialogListChoose.tcl)} { ListChoose}
set {moduleList(dialogListener.tcl)} { PrologListener}
set {moduleList(dialogMetaPred.tcl)} { .metaPred MetaPred MetaPredAdd MetaPredCancel MetaPredDoIt MetaPredRemove MetaPredSelectItem}
set {moduleList(dialogReadTCL.tcl)} { ReadBox}
set {moduleList(dialogScratch.tcl)} { InputScratchPad}
set {moduleList(dialogText.tcl)} { TextBox}
set {moduleList(dialogView.tcl)} { View ViewDestroy ViewMenuEditItem ViewMenuItemCommand ViewReadStack ViewUpdateStack}
set {moduleList(dialogViewParams.tcl)} { ViewParams ViewParamsChanged ViewParamsDisplayTools ViewParamsGet ViewParamsSet ViewParamsSetChanged}
set {moduleList(dialogViewSetting.tcl)} { ViewSettings}
set {moduleList(dialogYesNo.tcl)} { YesNoBox}
set {moduleList(external.tcl)} { Alias GetSelection MenuPopupAdd MenuPopupMotion MenuPopupPost MenuPopupRelease NoFunction SN SymbolicName Unalias}
set {moduleList(fnctsCKRL.tcl)} { MobalCKRLCKRLToMobal MobalCKRLClearKB MobalCKRLDeleteKB MobalCKRLLoadKB MobalCKRLMobalToCKRL MobalCKRLReadFile MobalCKRLSaveKBAs MobalCKRLShow MobalCKRLWriteFile}
set {moduleList(fnctsCall.tcl)} { MobalCallCKRL MobalCallCheckConstraints MobalCallCreateTopology MobalCallCustomInterface MobalCallGenerateTopology MobalCallKluster MobalCallLoadTool MobalCallProlog MobalCallQueryFact MobalCallQueryMFact MobalCallQueryMMFact MobalCallRecomputeWindows MobalCallTool MobalCallUpdateSorts}
set {moduleList(fnctsFile.tcl)} { MobalFileCloseWindows MobalFileDeleteDomain MobalFileHelp MobalFileNewDomain MobalFileOpenDomain MobalFilePrintDomain MobalFileQuit MobalFileReadDomain MobalFileSaveDomain MobalFileSaveDomainAs MobalFileUserGuide MobalFileWriteDomain}
set {moduleList(fnctsView.tcl)} { MobalViewInputScratchPad MobalViewKnowledge MobalViewMetaPredicate MobalViewParams MobalViewPrologListener MobalViewView MobalViewViewSettings}
set {moduleList(fnctsWindows.tcl)} { MobalWindowsUpdate}
set {moduleList(interface.tcl)} { .}
set {moduleList(main.tcl)} {}
set {moduleList(misc.tcl)} { MiscBell MiscCompare MiscDirnamePrepare MiscDomainNameUpdate MiscFileExecutable MiscFileExists MiscFileIsADir MiscFileIsAFile MiscFileIsASymlink MiscFileList MiscFileReadable MiscFileWritable MiscGetCurrentSelection MiscGetDebugging MiscPlaceWindow MiscMakeWindowName MiscPlaceWindowPrepare MiscPrologDeletable MiscPrologReadable MiscPrologSearchable MiscPrologWritable MiscReadAndPromptCheck MiscScaleEntry MiscSetDebugging MiscSetStatus MiscToggleParameterState MiscViewItemIds}
set {moduleList(mobal.tcl)} { MobalAddItem MobalAddTool MobalAddViewType MobalDeleteItem MobalGetAllItems MobalUpdateLocalLists}
set {moduleList(prolog.tcl)} { PrologInit PrologRead PrologSend PrologSendForce PrologSendInternal PrologSetQuerying PrologSetReady PrologSetRunning PrologWaitBeforeSend PrologAtom PrologAtomList PrologAtomPrepare PrologList PrologListPrepare PrologString PrologStringList PrologStringPrepare PrologStructure PrologStructureList}
set {moduleList(tkIconPaneInt.tcl)} { tkiconpane tkiconpane_create tkiconpane_createEdgeMenu tkiconpane_createIconMenu tkiconpane_createMenubutton tkiconpane_createToolbarButton tkiconpane_createViewMenu tkiconpane_dropPosition tkiconpane_info tkiconpane_internalConf tkiconpane_internalDragDropReceiveIconPane tkiconpane_internalDragDropReceiveToolbar tkiconpane_internalDragDropSend tkiconpane_internalDragDropToken tkiconpane_internalItemActivate tkiconpane_internalItemDeSelect tkiconpane_internalItemMoveMove tkiconpane_internalItemMoveStart tkiconpane_internalItemMoveStop tkiconpane_internalItemSelect tkiconpane_internalItemSetSelected tkiconpane_internalMenuMove tkiconpane_internalMenuPost tkiconpane_internalMenuUnpost tkiconpane_internalScale tkiconpane_internal_bind_configure tkiconpane_internal_bind_item_enter tkiconpane_internal_bind_item_move_move tkiconpane_internal_bind_item_move_start tkiconpane_internal_bind_item_move_stop tkiconpane_internal_bind_item_select tkiconpane_internal_bind_map tkiconpane_internal_bind_menu_move tkiconpane_internal_bind_menu_post tkiconpane_internal_bind_menu_unpost tkiconpane_internal_drag_drop_receive_iconpane tkiconpane_internal_drag_drop_receive_toolbar tkiconpane_internal_drag_drop_send tkiconpane_internal_drag_drop_token tkiconpane_internal_setselected tkiconpane_internal_showstatus tkiconpane_minorEdgeConfig tkiconpane_minorEdgeCreate tkiconpane_minorEdgeDelete tkiconpane_minorEdgeInfo tkiconpane_minorIconConfig tkiconpane_minorIconCreate tkiconpane_minorIconDelete tkiconpane_minorIconInfo tkiconpane_minorInternal tkiconpane_minorLayout tkiconpane_minorStatus tkiconpane_receiveIcon tkiconpane_updateMenu}
global {preloadList}
set {preloadList(xfInternal)} {}
global {symbolicName}
set {symbolicName(KnowledgeChi1)} {.knowledge.frame0.frame3.frame24.frame46.label50}
set {symbolicName(KnowledgeChi2)} {.knowledge.frame0.frame0.frame35.frame38.label43}
set {symbolicName(KnowledgeChosen)} {.knowledge.frame0.frame3.listbox1}
set {symbolicName(KnowledgeGraph)} {.knowledge.frame1}
set {symbolicName(KnowledgeInfo)} {.knowledge.frame0.frame0.listbox1}
set {symbolicName(KnowledgeItems)} {.knowledge.frame0.frame.listbox1}
set {symbolicName(KnowledgeKappa1)} {.knowledge.frame0.frame3.frame24.frame45.label48}
set {symbolicName(KnowledgeKappa2)} {.knowledge.frame0.frame0.frame35.frame37.label41}
set {symbolicName(KnowledgeN)} {.knowledge.frame0.frame3.frame24.frame26.label44}
set {symbolicName(KnowledgeSets)} {.knowledge.frame0.frame2.listbox1}
set {symbolicName(KnowledgeSetsLabel)} {.knowledge.frame0.frame2.frame1.label2}
set {symbolicName(MetaPredItems)} {.metaPred.frame52.frame.listbox1}
set {symbolicName(MetaPredPredicates)} {.metaPred.frame52.frame55.listbox1}
set {symbolicName(MetaPredRestrictions)} {.metaPred.frame52.frame54.listbox1}
set {symbolicName(root)} {.}
global {xfWmSetPosition}
set {xfWmSetPosition} {}
global {xfWmSetSize}
set {xfWmSetSize} {}
global {xfAppDefToplevels}
set {xfAppDefToplevels} {. }

# display/remove toplevel windows.
ShowWindow.

global xfShowWindow.knowledge
set xfShowWindow.knowledge 0

global xfShowWindow.metaPred
set xfShowWindow.metaPred 0

# load default bindings.
if {[info exists env(XF_BIND_FILE)] &&
    "[info procs XFShowHelp]" == ""} {
  source $env(XF_BIND_FILE)
}

# parse and apply application defaults.
XFLocalLoadAppDefs Main
XFLocalSetAppDefs

# end source
EndSrc

# eof
#

