(in-package :user)

;;;____________________________________________________________________________________
;;; pause-box
;;;
;;;  Displays *PAUSE-BOX* if *PAUSE-BOX* is nil a new one is created and displayed

(defun pause-box ()
  (unless (window-p *PAUSE-BOX*)
    (setf *backtrace-on-break* nil
          *PAUSE-BOX* 
          (make-instance 'windoid
                         :window-type :document
                         :close-box-p nil
                         :window-title "PAUSE"
                         :window-show t
                         :view-position '(:right 3)
                         :view-size #@(130 53)
                         :view-subviews
                         
                         (list
                          (make-dialog-item 'button-dialog-item #@(20 10) #@(90 20) " Break "
                                            #'(lambda (item)
                                                (declare (ignore item))
                                                (if (= CCL::*BREAK-LEVEL* 0)
                                                  (break)
                                                  (continue)))
                                            :default-button t
                                            :view-nick-name :button)
                          (make-dialog-item 'check-box-dialog-item #@(3 37) #@(65 16) 
                                            "clause"
                                            #'(lambda (item)
                                                (cond
                                                 ((check-box-checked-p item)
                                                  (setf *pause-after* :clause)
                                                  (check-box-uncheck (find-named-sibling item :literal)))
                                                 (t
                                                  (setf *pause-after* nil))))
                                            :check-box-checked-p (eql *pause-after* :clause)
                                            :view-nick-name :clause)
                          (make-dialog-item 'check-box-dialog-item #@(68 37) #@(65 16) 
                                            "literal"
                                            #'(lambda (item)
                                                (cond
                                                 ((check-box-checked-p item)
                                                  (setf *pause-after* :literal)
                                                  (check-box-uncheck (find-named-sibling item :clause)))
                                                 (t
                                                  (setf *pause-after* nil))))
                                            :check-box-checked-p (eql *pause-after* :literal)
                                            :view-nick-name :literal)))))

;  (setf (window-do-first-click *PAUSE-BOX*) t)
;  (window-select *PAUSE-BOX*)
  )

;;;____________________________________________________________________________________
;;;  redefine break and continue to use pause box

(let ((warn-if-redefine-kernel *warn-if-redefine-kernel*)
      (warn-if-redefine *warn-if-redefine*)
      (status nil))
  (setf *warn-if-redefine* nil
        *warn-if-redefine-kernel* nil)

  ;;;____________________________________________________________________________________
  ;;; break
  
  (unless (fboundp 'real-break)
    (setf (symbol-function 'real-break) (symbol-function 'break)))
  (defun break (&optional format-string &rest arguments)
    (pause-box)
    (setf status *status*)
    (change-status :paused)
    (set-dialog-item-text (view-named :button *PAUSE-BOX*) " Continue ")
    (apply #'real-break format-string arguments))

  ;;;____________________________________________________________________________________
  ;;; continue
  
  (unless (fboundp 'real-continue)
    (setf (symbol-function 'real-continue) (symbol-function 'continue)))
  (defun continue ()
    (when (window-p *PAUSE-BOX*)
      (cond
       ((= CCL::*BREAK-LEVEL* 1)
        (set-dialog-item-text (view-named :button *PAUSE-BOX*) " Break ")
        (change-status status)
        )
       (t
        (set-dialog-item-text (view-named :button *PAUSE-BOX*) " Continue "))))
    (real-continue))

  (when (and (boundp '*eval-menu*) (find-menu-item *eval-menu* "Continue"))
    (set-menu-item-action-function (find-menu-item *eval-menu* "Continue") #'continue))

  (setf *warn-if-redefine* warn-if-redefine
        *warn-if-redefine-kernel* warn-if-redefine-kernel))

;;;____________________________________________________________________________________
;;; close-pause-box

(defun close-pause-box ()
  (when (window-p *PAUSE-BOX*)
    (window-close *PAUSE-BOX*)))

(provide :pause)

